/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdlib.h>
#include "field.h"

realcktype(f,value) /* make sure value is a real number */
Field *f; char *value;
{
	void doalert();
	char msg[255];

	if (isreal(value)) return 0;

	sprintf(msg,"%s must be a real number.",f->f_name);
	doalert(msg);
	return 1;
}

realckmin(f,value) /* check real value against f_fmin */
Field *f; char *value;
{
	void doalert();

	double atof();

	if (atof(value) < atof(f->f_minv)) {
		char msg[255];
		sprintf(msg,"%s can't be less than %s",f->f_name,f->f_minv);
		doalert(msg);
		return 1;
	}

	return 0;
}

realckmax(f,value) /* check real value against f_maxv */
Field *f; char *value;
{
	void doalert();

	double atof();

	if (atof(value) > atof(f->f_maxv)) {
		char msg[255];
		sprintf(msg,"%s can't be greater than %s",f->f_name,f->f_maxv);
		doalert(msg);
		return 1;
	}

	return 0;
}
