/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* selectrd - read items from select command pipe and return nitems */
#include "field.h"
#include <ctype.h>
#include <malloc.h>

#define SUBST  '%'

extern char *strdup();
extern void alert();

int
selectrd (select, rc, mitems, item)
    char *select;
    int  *rc, mitems;
    char *item[];
{
        FILE *fd;
	char line[140];
        int  nitems;

	register int c, i, j, k;
	char *command;
        char tag[20];
        char *val2;
	extern char *findval();
	int cmdlen;

        i = 0;
	j = 0;
        nitems = 0;
	cmdlen = 1 + strlen(select);
	command = (char *)malloc(cmdlen);
	while (select[j]) {
	    if (select[j] != SUBST)
		command[i++] = select[j++];
	    else {
		j++;
		k = 0;
	        while (isalnum(c=select[j+k]) || c=='-' || c=='_')
			tag[k++]=c;
		tag[k] = '\0';
		j += k;
		val2 = findval(tag);
/* 	      printf ("tag= %s   val2=%s\n", tag, val2);  */
		if (val2) {
		   cmdlen += (1 + strlen(val2));
		   if ((command = (char *)realloc(command,cmdlen)) == NULL) {
			fprintf(stderr,"selectrd: out of memory!\n");
			abort();
		   }
	           for (k=0; val2[k]; k++)
			command[i++]=val2[k];
		} else {
		   sprintf (line, "please enter %s", tag);
		   alert (line);
		   return nitems;
	        }
	    }
	}

	command[i] = '\0';

/* 	printf ("selectrd select:%s\n", select);  */
/* 	printf ("selectrd command:%s\n", command);  */

        fd = popen (command, "r");
	while (fgets(line, 140, fd)) {
	    i = strlen(line) - 1;
	    if (line[i] == '\n') line[i] = '\0';
	    if (nitems < mitems) item[nitems++] = strdup(line);  
	}
	*rc = pclose (fd);

	free(command);
	
	return nitems;
}
