/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <ctype.h>
#include <stdlib.h>
#include "field.h"

/* extern void doalert (char *); */
extern void doalert ();

strcktype(f,value) /* make sure string contains only printable chars */
Field *f; char *value;
{
	register char *s;

	register int c;

	for (s = value; *s; s++)
		if (!isgraph(c = *s) && c != ' ' && c != '\t') {
			char msg[255];
			sprintf(msg,"%s contains an illegal character (%c).",
				f->f_name,c);
			doalert(msg);
			return 1;
		}

	return 0;

}

strckmin(f,value) /* check length of string against min */
Field *f; char *value;
{
	double atof();

	int len = strlen(value), minlen = atof(f->f_minv);

        if (len) for (;isspace((int)value[len-1]);len--) ;

	if (len < minlen) {
		char msg[255];
		sprintf(msg,"%s must be at least %d character%s.",
			f->f_name,minlen,(minlen == 1 ? "" : "s"));
		doalert(msg);
		return 1;
	}

	return 0;	
}

strckmax(f,value) /* check length of string against max */
Field *f; char *value;
{
	double atof();

	int len = strlen(value), maxlen = atof(f->f_maxv);

	if (len > maxlen) {
		char msg[255];
		sprintf(msg,"%s can not exceed %d characters.",
			f->f_name,maxlen);
		doalert(msg);
		return 1;
	}

	return 0;	
}

strcksufx(f,value) /* check for required suffix on string */
Field *f; char *value;
{

	if (!psuffix(value,f->f_suffix)) {
		char msg[255];
		sprintf(msg,"%s must end in '%s'",f->f_name,f->f_suffix);
		doalert(msg);
		return 1;
	}

	return 0;

}
