/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>

#define MAXTAG 256	/* maximum tag length */
#define MAXBUF 16384	/* maximum resulting command length */
#define DELIM '%'	/* replacement delimiter */

char buf[MAXBUF];
int nxtbuf = 0;

char *envfile = ".explenv";
char *prog;

main(argc,argv) /* expand and print values from environment file */
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind, opterr;
	char *strdup(), *basename();
	register int c;
	int errors = 0;
	int nonl = 0;
	int prnt = 0;
	int hush = 0;

	opterr = 0;

	prog = basename(argv[0]);

	while ((c = getopt(argc,argv,"e:nps")) != -1)
		if (c == '\?')
			break;
		else if (c == 'e')
			envfile = strdup(optarg);
		else if (c == 'n')
			nonl = 1;
		else if (c == 'p')
			prnt = 1;
		else if (c == 's')
			hush = 1;

	if (gettags(envfile) <= 0)
		exit(1);

	for ( ; optind < argc; optind++) {
		if (!expand(argv[optind]))
			errors++;
		if (!nonl)
			insertc('\n');
	}

	if (prnt) {
		printf("%s",buf);
		fflush(stdout);
	}

	if (hush)
		exit(errors != 0);

	if (errors) {
		fprintf(stderr,"%s: incomplete substitution\n",prog);
		exit(1);
	}

	exit(system(buf));
}

expand(s) /* expand tag references in string s */
register char *s;
{
	register int c, i;
	register char *vp;
	static char tag[MAXTAG];
	char *findval();
	int rtn = 1;

	for (c = *s; c != '\0'; )
		switch(c) {
		case DELIM:
			for (i = 0; !isterm(c=*++s); i++)
				if (i < MAXTAG-1)
					tag[i] = c;
			tag[i] = '\0';
			if (!(vp = findval(tag))) {
				insertc(DELIM);
				inserts(tag);
				if (i > 1) rtn = 0;
			}
			else
				inserts(vp);
			break;
		default:
			insertc(c);
			c = *++s;
			break;
		}

	return rtn;

}

isterm(c) /* return true if c a tag terminator */
register int c;
{
	return !(isalnum(c) || c == '-' || c == '_');

}

insertc(c) /* stick a character into the buffer */
register int c;
{
	if (nxtbuf >= MAXBUF) {
		fprintf(stderr,"%s: out of buffer space.\n", prog);
		exit(2);
	}

	buf[nxtbuf++] = c;

	buf[nxtbuf] = '\0';

}

inserts(s) /* stick a string into the buffer */
register char *s;
{
	register int i, j, c;

	for (i = 0, j = strlen(s); i < j; i++)
		insertc(c = *s++);

}
