/* sunsave.c:
 *
 * sun rasterfile image type
 *
 * 16sep91 by Phil Fincannnon
 *
 */

#include "copyright.h"
#include "image.h"
#include <signal.h>
#include <stdio.h>
/* #include "sunsave.h" */

void
*sunsave (image, printcmd)
  Image   *image;
  char    *printcmd;
{
#define RMAGICNUMBER 0x59a66a95 /* magic number of this file type */

    FILE           *stream, *popen();
    byte           *lineptr, *map, *mapred, *mapgreen, *mapblue;
    byte            fillchar=0;
    unsigned int    mapsize, mapsiz;
    unsigned int    linelen;   /* length of raster line in bytes */
    unsigned int    fill;      /* # of fill bytes per raster line */
    unsigned int    x, y;
    unsigned int    head[8];
    int             status;

    linelen = image->width * image->pixlen;
    if (image->depth==1) linelen = (image->width/8) + (image->width%8 ? 1:0);
    fill= (linelen % 2 ? 1 : 0);

    stream = popen (printcmd, "w");  
    if (stream==NULL) {
	fprintf (stderr, "can't open pipe for: %s\n", printcmd);
	return;
    }

    (void)signal(SIGPIPE,SIG_IGN);

/* write sunrasterfile header ...  */

    mapsize = image->rgb.used;
    mapsiz = mapsize;
    if (mapsiz%2) mapsiz++;
    map = lmalloc(mapsiz);
    mapred = map;
    for (y=0; y<mapsiz; y++) *mapred++ = 0;

    head[0] = RMAGICNUMBER;
    head[1] = image->width;
    head[2] = image->height;
    head[3] = image->depth;  
    head[3] = 8;          /* 5nov92 pf added to print gif images */
    head[4] = (image->width + fill) * image->height;
    head[5] = 1;
    head[6] = 1;
    head[7] = mapsiz*3;
    fwrite (head, 1, 32, stream);

/* write color map...  */

    mapred = map;
    for (y=0; y<mapsize; y++) *mapred++ = *(image->rgb.red + y) >> 8;
    fwrite (map, 1, mapsiz, stream);
    
    mapgreen = map;
    for (y=0; y<mapsize; y++) *mapgreen++ = *(image->rgb.green + y) >> 8;
    fwrite (map, 1, mapsiz, stream);
    
    mapblue = map;
    for (y=0; y<mapsize; y++) *mapblue++ = *(image->rgb.blue + y) >> 8;
    fwrite (map, 1, mapsiz, stream);

    lfree(map);

/* write image...  */

    lineptr = image->data;
    for (y= 0; y < image->height; y++) {
        fwrite (lineptr, 1, linelen, stream);
        if (fill) fwrite (&fillchar, 1, fill, stream);
        lineptr += linelen;
    }

    status = pclose (stream);
    (void)signal(SIGPIPE,SIG_DFL);

    return;
}
