/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
#include <errno.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>

static Widget parent = (Widget)0;
static String appname, appclass;

void alert_init(toplevel) /* remember top level widget for alerts */
Widget toplevel;
{
	parent = toplevel;

	XtGetApplicationNameAndClass(XtDisplay(parent),&appname,&appclass);
}

static void nodialog(dialog,client,call) /* destroy the alert box */
Widget dialog;
caddr_t client, call;
{
	XtDestroyWidget((Widget)client);
}

void alert(str) /* display an alert box */
char *str;
{
	Widget dialog;

	dialog = (Widget)XmCreateErrorDialog(parent,"alert",NULL,0);

	XtVaSetValues(dialog,XmNdialogStyle,XmDIALOG_SYSTEM_MODAL,
		XmNmessageString,XmStringCreate(str,XmSTRING_DEFAULT_CHARSET),
		XmNdialogTitle,XmStringCreate(appname,XmSTRING_DEFAULT_CHARSET),
		XmNnoResize,True,NULL);

	XtUnmanageChild(
	  (Widget) XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));

	XtUnmanageChild(
	  (Widget) XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));

	XtAddCallback(dialog,XmNokCallback,(XtCallbackProc) nodialog,
		(XtPointer) dialog);

	XtManageChild(dialog);

}
void syserr(msg, text) /* sort of a perror with windows */
char *msg, *text;
{
/* - Modified this to get rid of sys_nerr and sys_errlist dependency.
				- Joe M. Wade - 10/27/99

	extern int sys_nerr;
	extern char *sys_errlist[];
*/
	char buf[512];
	char *sys_text;

/*
	sprintf(buf,"%s%s%s", msg ? msg : "", msg ? ": " : "", 
	    errno > 0 && errno < sys_nerr ? sys_errlist[errno] : text);
*/
	sys_text = strerror(errno);
	sprintf(buf,"%s%s%s", msg ? msg : "", msg ? ": " : "", 
	    sys_text != NULL ? sys_text : text);

	alert(buf);
}

void doalert(str) /* old entry point name */
char *str;
{
	alert(str);
}
