/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* centermap - center the shell in the screen and map it */
/* written 26apr91 by Phil Fincannon                     */

/* you must add the following two statements around XtRealizeWidget */
/* so that centermap can determine the final size of the window */
/*     XtVaSetValues (toplevel, XmNmappedWhenManaged, FALSE, NULL); */
/*     XtRealizeWidget (toplevel);                                  */
/*     centermap (toplevel);                                        */ 

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <stdio.h>

void
centermap (toplevel)
   Widget toplevel;
{
   Window virtualRoot;
   Dimension width, height;
   Position xpos, ypos;
   Screen *scrn;
   XSizeHints hints;
   XWindowAttributes vRoot_attr;

/* get window position  */
	XtVaGetValues (toplevel, XmNx, &xpos, XmNy, &ypos,
		       XmNwidth, &width, XmNheight, &height, NULL);

/* center window if no position set */
	if (xpos == 0 && ypos == 0) {
	   scrn = XtScreen (toplevel);
	   xpos = (Position) ( WidthOfScreen(scrn) - width ) / 2;
	   ypos = (Position) ( HeightOfScreen(scrn) - height ) / 2;
	   virtualRoot = GetVRoot(XtDisplay(toplevel),
		DefaultScreen(XtDisplay(toplevel)));
	   if (XGetWindowAttributes(XtDisplay(toplevel),virtualRoot,
		&vRoot_attr)) {
	     xpos = xpos - vRoot_attr.x;
	     ypos = ypos - vRoot_attr.y;
	     }
	   if (xpos < 0) xpos = 10;
	   if (ypos < 0) ypos = 10;
	   XtVaSetValues (toplevel, XmNx, xpos, XmNy, ypos, NULL);
	   hints.flags = USPosition;
	   hints.x = xpos;
	   hints.y = ypos;
	   XSetWMNormalHints (XtDisplay(toplevel), XtWindow(toplevel), &hints);
	}

        XSync (XtDisplay(toplevel), FALSE);
	XtMapWidget (toplevel);
	return;
}
