/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
/* #include <strings.h> */

#define MAXTAGS	1024
#define MAXBUF  1024 

static char *tags[MAXTAGS];
static char *vals[MAXTAGS];

static int ntags;

gettags(path) /* fill the tags and vals arrays from the env file */
char *path;
{
	char buf[MAXBUF], tag[MAXBUF], val[MAXBUF];

	FILE *p;

	int ok;

	char *c, *strdup();

	ntags = 0;

	if ((p=fopen(path,"r"))==NULL) {
		fprintf(stderr,"gettags: ");
		perror(path);
		return(-1);
	}
	while (fgets(buf,MAXBUF,p) != NULL) {
		if (ntags >= MAXTAGS) {
			fprintf(stderr,"gettags: out of array space\n");
			return(-1);
		}
		strcpy(val," ");
		sscanf(buf,"%s %[^\n]",tag,val);
		if ((tags[ntags]=strdup(tag))==NULL ||
		    (vals[ntags]=strdup(val))==NULL) {
			fprintf(stderr,"gettags: out of memory\n");
			return(-1);
		}
		ntags++;
	}

	ok = !ferror(p);

	fclose(p);

	if (!ok) {
		fprintf(stderr,"gettags: i/o error\n");
		perror(path);
		return(-1);
	}

	return(ntags);

}

puttags(path) /* write tags and values arrays back to env file */
char *path;
{
	FILE *p;

	int ok, i;

	if ((p=fopen(path,"w"))==NULL) {
		fprintf(stderr,"puttags: ");
		perror(path);
		return(-1);
	}

	for (i = 0; i < ntags; i++)
		fprintf(p,"%s\t%s\n",tags[i],vals[i]);

        ok = 0;
	ok = ferror(p);

	fclose(p);

	if (ok) {
		fprintf(stderr,"puttags: i/o error %d\n",ok);
		perror(path);
	}

	return(ok);

}

static findtag(tag) /* find a tag and return its index or -1 on failure */
char *tag;
{
	register int i;

	for (i = 0; i < ntags; i++)
		if (strcmp(tags[i],tag) == 0)
			return(i);

	return(-1);

}

char *findval(tag) /* find val associated with tag */
char *tag;
{
	int i;

	if ((i = findtag(tag)) < 0) 
		return(NULL);

	return(vals[i]);

}

setval(tag,val)  /* change or add a new value associated with tag */   
char *tag, *val;
{
	char *strdup();

	int i;
	if ((i = findtag(tag)) >= 0)
		if (vals[i] != NULL) {     /* found, so replace it */
			free(vals[i]);
			if ((vals[i]=strdup(val))==NULL) {
				fprintf(stderr,"setval: out of memory\n");
				return(-1);
			}
			return(i);
		}

	/* not found - add new tag val pair */

	i = ntags;

	if (i < MAXTAGS) {
		if ((tags[i]=strdup(tag)) == NULL ||
		    (vals[i]=strdup(val)) == NULL) {
			fprintf(stderr,"setval: out of memory\n");
			return(-1);
		}
		ntags++;
		return(i);
	}

	fprintf(stderr,"setval: out of array space\n");

	return(-1);

}
