/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <signal.h>
#include <errno.h>
#include <stdio.h> /* debug */

/*--------------------------------------------------------------*/

int
execcmd (cmd) /* exec another command */
   char *cmd;
{
	extern int errno;
	int fd, fdlim;

/*	getdtablesize is pulled from ~trcgp libcu.a on systems where
        it is not in the system libraries
*/
	for (fd = 3, fdlim = getdtablesize() + 1; fd < fdlim; fd++)
	   if (close(fd) == -1 && errno != EBADF) perror ("execcmd (close)");

	execlp ("sh", "sh", "-c", cmd, (char *)0);	

	perror ("execcmd (execlp)");

	exit (127);
}

/*--------------------------------------------------------------*/

static int 
docmd (cmd) /* run cmd in 'background' */
   char *cmd;
{
	if ((int)signal(SIGTERM,SIG_IGN) < 0 ||
	    (int)signal(SIGINT,SIG_IGN)  < 0 ||
	    (int)signal(SIGQUIT,SIG_IGN) < 0 ||
	    (int)signal(SIGHUP,SIG_IGN)  < 0) perror( "docmd (signal)"); 
	execcmd (cmd);
        return;
}

/*--------------------------------------------------------------*/

int 
runcmd (cmd) /* run another command asynchronously */
   char *cmd;
{
	int pid;

	pid = fork();
	if (pid < 0) {
	   perror ("runcmd (fork)");
	   goto retn;
	} 
	
	if (pid == 0) { /* child */
	   docmd (cmd);
	}

        pid = 0;

retn:
	return (pid);
}

