/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "flatt2d.h"

#define SLOP 10

int USPOpenAndReadLineHeader(filename,luin,lhead,lhlen)
char *filename;
float *lhead;
int *lhlen,*luin;
{
  int error=0;

  lbopen(luin,filename,"r");
  if (*luin != -1) {
    sisabort(*luin,"off");
    *lhlen=0;
    rtape(*luin,lhead,lhlen);
    siserror(*luin,&error);
    sisabort(*luin,"on");
    if (error) {
      if (error==20)
        fprintf(stderr,"%s\ndoes not appear to be USP format\n",filename);
      else
        fprintf(stderr,"Error %d reading line header in\n%s\n",error,filename);
    }
  } else {
    fprintf(stderr,"Can't open file %s\n",filename);
    error=-1;
  }

  return(error);
}


int USPReadDataByRecord(luin,thead,data,ntr,nsamp)
float *thead,*data;
int *luin,*ntr,*nsamp;
{
  int i,nbytes,error=0,one=1,itrwrd=LNTRHD;
  float *rtr;

  i=(*nsamp+itrwrd+SLOP)*sizeof(float);
  rtr=(float *)malloc(i);

  if (rtr==NULL) {
    fprintf(stderr,"Memory allocation failed reading data\n");
    return (-1);
  } else {
    nbytes=1;
    for (i=0; nbytes&&(i<(*ntr)); i++) {
      nbytes=0;
      rtape(*luin,rtr,&nbytes);
      if (nbytes) {
        D_vmov(rtr,&one,thead+(i*itrwrd),&one,&itrwrd);
        D_vmov(rtr+LNTRHD,&one,data+(*nsamp*i),&one,nsamp);
      } else {
        if (rtr) free(rtr);
        fprintf(stderr,"Error reading traces\n");
        return (-1);
      }
    }
  }

  if (rtr) free(rtr);
  return(error);
}


int USPOpenAndWriteLineHeader(filename,luout,lhead,lhlen)
char *filename;
float *lhead;
int *luout,*lhlen;
{
  int error=0;

  lbopen(luout,filename,"w");
  if (*luout != -1)
    wrtape(*luout,lhead,*lhlen);
  else {
    fprintf(stderr,"Can't open file %s\n",filename);
    error=-1;
  }
  return(error);
}


int USPWriteDataByRecord(luout,thead,data,irec,ntr,nsamp)
float *thead,*data;
int *luout,*irec,*ntr,*nsamp;
{
  int i,j,error=0,one=1,itrwrd=LNTRHD,trclen;
  float *rtr;
 
  trclen=(*nsamp+itrwrd)*sizeof(float);

  rtr=(float *)malloc(trclen);
  if (rtr==NULL) {
    fprintf(stderr,"Memory allocation failed writing data\n");
    return(-1);
  }

  for (i=0; i<(*ntr); i++) {
    D_vmov(thead+(i*itrwrd),&one,rtr,&one,&itrwrd);
    D_vmov(data+(*nsamp*i),&one,rtr+itrwrd,&one,nsamp);
    if (*irec!=0) C_SAVEW(rtr,"RecNum",*irec,TRACEHEADER);
    C_SAVEW(rtr,"TrcNum",i+1,TRACEHEADER);
    wrtape(*luout,rtr,trclen);
  }

  if (rtr) free(rtr);
  return(error);
}
