/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	sisio.h
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Include file for the sisio library describing the file information
	table, error codes and functions.


	$Header: /m/m1/dmk/xlate/sisio/RCS/sisio.h,v 4.4 1992/05/08 13:29:39 dmk Exp $

	$Log: sisio.h,v $
	Revision 4.4  1992/05/08  13:29:39  dmk
	Sets the default buffer size to small on workstations.

	Revision 4.3  91/09/11  08:51:01  dmk
	MODSET: 4.3
	Added #define's for all entry point names to allow different names on
	different architectures; this was needed to accomodate the RS-6000.
	Added definitions for STRLEN_IS_ARG and NEVER_TRANSLATE.
	
	Revision 4.2  91/02/25  11:03:39  dmk
	MODSET: 4.2
	Increased small buffer size to 200000 to accomodate larger traces.
	
	Revision 4.1  90/07/13  09:25:01  dmk
	MODSET: 4.1
	Changed some constants, added new fields to the FIT, added new function
	declarations, added new error codes, etc.
	
	Revision 3.2  90/02/05  12:20:09  dmk
	MODSET: 3.2
	Added declarations for sisfdfit.
	
	Revision 3.1  89/09/27  10:00:52  dmk
	MODSET: 3.1
	Added C entry point declarations.  Incorporated logical.h, which is
	no longer used as a separate file.
	
	Revision 2.2  88/07/20  08:50:27  dmk
	MODSET: 2.2
	Added a .doio field to the fitentry typedef.  Added a CHECKDOIO macro.
	
	Revision 2.1  88/07/12  15:24:44  dmk
	MODSET: 2.1
	Added SUN block:  set WORDSIZE to 4, use lower case declarations of
	functions.  Deleted 'void exit();' from CHECKERROR.  Added L_NONE,
	E_NORMAL, E_NOUNITS.  Deleted E_STDOPEN, E_ISOPEN, E_LGOPER.
	
	Revision 1.1  88/06/27  12:19:48  dmk
	Initial revision
	
--------------------------------------------------------------------------- */

#include <localsys.h>

/*
	Miscellaneous.
*/


#ifdef	CRAY
#define	WORDSIZE	8
#define	HALFWORDSIZE	8
#undef	STRLEN_IS_ARG
#undef	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef  __convex__
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef  hpux
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef  sun
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	_IBMR2
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	sgi
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	__alpha
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#undef	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	__i486__
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	__i686__
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#undef	DEFAULT_SMALLBUF
#endif
#ifdef	__ppc__
#define	WORDSIZE	4
#define	HALFWORDSIZE	2
#define	STRLEN_IS_ARG
#define	NEVER_TRANSLATE
#undef	DEFAULT_SMALLBUF
#endif

#if (BYTE_ORDER == LITTLE_ENDIAN)
#undef NEVER_TRANSLATE
#endif

#define	CRAYFMTBYTE	113
#define	CRAYFMTSIZE	  8
#define	IEEEFMTBYTE	 65
#define	IEEEFMTSIZE	  2
#define	CRAYNRECBYTE	 17
#define	CRAYNRECSIZE	  8

#define	PREFIX_LEN	128


/*
	Logical type.
*/


typedef	unsigned int LOGICAL;

#define	TRUE	1
#define	FALSE	0
#define	YES	1
#define	NO	0


/*
	File information table.
*/


#define	MAXUNIT		102

#define	W_NEVER		0
#define	W_ALWAYS	1
#define	W_IFDISK	2

#define	SMBUFSIZE	200000
#define	LGBUFSIZE	500000

#define	L_NONE		0
#define	L_READ		1
#define	L_WRITE		2

typedef struct
{
	int	filedes;	/* file descriptor */
	LOGICAL	isopen;		/* true iff unit is open */
	LOGICAL	isdisk;		/* true iff unit is a disk file */
	LOGICAL	doio;		/* true iff i/o should actually be performed */
	int	trwhen;		/* tells if/when translation should occur */
	LOGICAL	dotraces;	/* true iff trace data should be translated */
	int	pointer;	/* trace number; trace 0 is line header */
	int	format;		/* format of trace records */
	int	hdrlen;		/* line header length */
	int	trclen;		/* trace length */
	int	cwlen;		/* control word length */
	LOGICAL	abort;		/* true iff error should cause an abort */
	int	error;		/* last error code */
	LOGICAL	largebuf;	/* true iff large buffering is enabled */
	int	bufsize;	/* actual buffer size */
	int	bfrbeg;		/* beginning of data in large buffer */
	int	bfrend;		/* end of data in large buffer */
	int	lgoper;		/* type of operation on large buffer */
	char *	buffer;		/* pointer to i/o buffer */
	int	headerat;	/* record number of next header, starts at 0 */
	char *	filename;	/* name of file */
}
	fitentry;

extern	fitentry	_sisfit[ ];

extern	LOGICAL		_sisinit;

extern	char		_msg_prefix[ ];


/*
	Macros.
*/


#define	INITIALIZE \
	if ( ! _sisinit ) _initialize()

#define	CHECKRANGE(module,unit) \
	if ( unit < 0 || unit > MAXUNIT ) \
	{ \
		_error( module, unit, E_BADUNIT ); \
		return; \
	}

#define	CHECKERROR(module,unit) \
	if ( unit >= 0 && unit <= MAXUNIT && _sisfit[ unit ].error ) \
	{ \
		_error( module, unit, _sisfit[ unit ].error ); \
		exit( E_SISIO + _sisfit[ unit ].error ); \
	}

#define	CHECKOPEN(module,unit) \
	if ( ! _sisfit[ unit ].isopen ) \
	{ \
		_error( module, unit, E_NOTOPEN ); \
		return; \
	}

#define	CHECKDOIO(module,unit) \
	if ( ! _sisfit[ unit ].doio ) \
		return;


/*
	Library functions.
*/


/*  Use the system definitions and cast where needed - 9/8/95 - jmw 

void	exit();
void	free();
long	lseek();
char *	malloc();
char *	memcpy();
void	perror();
char *	strcpy();
char *	strncpy();
*/


/*
	Internal functions.
*/


void	_error();
void	_fitinit();
int	_flushit();
void	_initialize();
int	_isdisk();
int	_readit();
int	_readpipe();
int	_readsb();
int	_strf2c();
void	_strlower();
int	_writeit();


/*
	Define the C entry point names.
*/

#undef HOST_FTN_FUNC
#undef USP_C_FUNC


#ifdef FTN_TO_C_NAME_COMPATABILITY
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: USP_C_FUNC(rtape)(lunit, buffer, length)           */
/***************************************************************/
#define USP_C_FUNC(name)   name ## _c

#define	C_BKSPT		bkspt_c
#define	C_LBCLOS	lbclos_c
#define	C_LBOPEN	lbopen_c
#define	C_RTAPE		rtape_c
#define	C_RWD		rwd_c
#define	C_SISABORT	sisabort_c
#define	C_SISB4MSG	sisb4msg_c
#define	C_SISERROR	siserror_c
#define	C_SISFDFIT	sisfdfit_c
#define	C_SISFMT	sisfmt_c
#define	C_SISINFO	sisinfo_c
#define	C_SISLGBUF	sislgbuf_c
#define	C_SISPRT	sisprt_c
#define	C_SISSEEK	sisseek_c
#define	C_SISTRACE	sistrace_c
#define	C_SISWHEN	siswhen_c
#define	C_SISVER	sisver_c
#define	C_SKIPT		skipt_c
#define	C_WRTAPE	wrtape_c
#else
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: USP_C_FUNC(rtape)(lunit, buffer, length)           */
/***************************************************************/
#define USP_C_FUNC(name)   name

#define	C_BKSPT		bkspt
#define	C_LBCLOS	lbclos
#define	C_LBOPEN	lbopen
#define	C_RTAPE		rtape
#define	C_RWD		rwd
#define	C_SISABORT	sisabort
#define	C_SISB4MSG	sisb4msg
#define	C_SISERROR	siserror
#define	C_SISFDFIT	sisfdfit
#define	C_SISFMT	sisfmt
#define	C_SISINFO	sisinfo
#define	C_SISLGBUF	sislgbuf
#define	C_SISPRT	sisprt
#define	C_SISSEEK	sisseek
#define	C_SISTRACE	sistrace
#define	C_SISWHEN	siswhen
#define	C_SISVER	sisver
#define	C_SKIPT		skipt
#define	C_WRTAPE	wrtape
#endif


/*
	Define the Fortran entry point names.
*/


#ifdef FTN_TO_C_UPPERCASE
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#define HOST_FTN_FUNC(lname, uname) uname

#define	F_BKSPT		BKSPT
#define	F_LBCLOS	LBCLOS
#define	F_LBOPEN	LBOPEN
#define	F_RTAPE		RTAPE
#define	F_RTAPE4	RTAPE4
#define	F_RWD		RWD
#define	F_SEEKT		SEEKT
#define	F_SISABORT	SISABORT
#define	F_SISB4MSG	SISB4MSG
#define	F_SISERROR	SISERROR
#define	F_SISFDFIT	SISFDFIT
#define	F_SISFMT	SISFMT
#define	F_SISINFO	SISINFO
#define	F_SISLGBUF	SISLGBUF
#define	F_SISPRT	SISPRT
#define	F_SISSEEK	SISSEEK
#define	F_SISTRACE	SISTRACE
#define	F_SISWHEN	SISWHEN
#define	F_SISVER	SISVER
#define	F_SKIPT		SKIPT
#define	F_WRTAPE	WRTAPE
#endif

#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#define HOST_FTN_FUNC(lname, uname) lname ## _

#define	F_BKSPT		bkspt_
#define	F_LBCLOS	lbclos_
#define	F_LBOPEN	lbopen_
#define	F_RTAPE		rtape_
#define	F_RTAPE4	rtape4_
#define	F_RWD		rwd_
#define	F_SEEKT		seekt_
#define	F_SISABORT	sisabort_
#define	F_SISB4MSG	sisb4msg_
#define	F_SISERROR	siserror_
#define	F_SISFDFIT	sisfdfit_
#define	F_SISFMT	sisfmt_
#define	F_SISINFO	sisinfo_
#define	F_SISLGBUF	sislgbuf_
#define	F_SISPRT	sisprt_
#define	F_SISSEEK	sisseek_
#define	F_SISTRACE	sistrace_
#define	F_SISWHEN	siswhen_
#define	F_SISVER	sisver_
#define	F_SKIPT		skipt_
#define	F_WRTAPE	wrtape_
#endif

#ifdef FTN_TO_C_NAME_COMPATABILITY
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#define HOST_FTN_FUNC(lname, uname) lname

#define	F_BKSPT		bkspt
#define	F_LBCLOS	lbclos
#define	F_LBOPEN	lbopen
#define	F_RTAPE		rtape
#define	F_RTAPE4	rtape4
#define	F_RWD		rwd
#define	F_SEEKT		seekt
#define	F_SISABORT	sisabort
#define	F_SISB4MSG	sisb4msg
#define	F_SISERROR	siserror
#define	F_SISFDFIT	sisfdfit
#define	F_SISFMT	sisfmt
#define	F_SISINFO	sisinfo
#define	F_SISLGBUF	sislgbuf
#define	F_SISPRT	sisprt
#define	F_SISSEEK	sisseek
#define	F_SISTRACE	sistrace
#define	F_SISWHEN	siswhen
#define	F_SISVER	sisver
#define	F_SKIPT		skipt
#define	F_WRTAPE	wrtape
#endif


/*
	External functions, C-callable.
*/


void	C_BKSPT();
void	C_LBCLOS();
void	C_LBOPEN();
void	C_RTAPE();
void	C_RWD();
void	C_SISABORT();
void	C_SISB4MSG();
void	C_SISERROR();
void	C_SISFDFIT();
void	C_SISFMT();
void	C_SISINFO();
void	C_SISLGBUF();
void	C_SISPRT();
void	C_SISSEEK();
void	C_SISTRACE();
void	C_SISWHEN();
void	C_SISVER();
void	C_SKIPT();
void	C_WRTAPE();


/*
	External functions, FORTRAN-callable.
*/


void	F_BKSPT();
void	F_LBCLOS();
void	F_LBOPEN();
void	F_RTAPE();
void	F_RTAPE4();
void	F_RWD();
void	F_SEEKT();
void	F_SISABORT();
void	F_SISB4MSG();
void	F_SISERROR();
void	F_SISFDFIT();
void	F_SISFMT();
void	F_SISINFO();
void	F_SISLGBUF();
void	F_SISPRT();
void	F_SISSEEK();
void	F_SISTRACE();
void	F_SISWHEN();
void	F_SISVER();
void	F_SKIPT();
void	F_WRTAPE();


/*
	Error codes.
*/

#define	E_SISIO		100	/* sisio error */

#define	E_NORMAL	0	/* no error */
#define	E_BADFMT	1	/* bad sis format code */
#define	E_BADMODE	2	/* access mode too long or invalid */
#define	E_BADNAME	3	/* name string too long or invalid */
#define	E_BADSWITCH	4	/* switch too long or invalid */
#define	E_BADUNIT	5	/* unit number out of range */
#define	E_CLOSE		6	/* close system call error */
#define	E_INTERNAL	7	/* internal error in function */
#define	E_LSEEK		8	/* lseek system call error */
#define	E_NEGREC	9	/* negative record count illegal */
#define	E_NEWLEN	10	/* record length has changed */
#define	E_NOBUFFER	11	/* unable to allocate buffer */
#define	E_NOFMT		12	/* sis format code unknown */
#define	E_NOTFILE	13	/* file is not a disk file or pipe */
#define	E_NOTOPEN	14	/* unit is not open */
#define	E_NOTRCLEN	15	/* trace length unknown */
#define	E_NOUNITS	16	/* no more units available */
#define	E_OPEN		17	/* open system call error */
#define	E_PASTEOF	18	/* attempt to skip past eof */
#define	E_READ		19	/* read system call error */
#define	E_RECLEN	20	/* wrong record length in file */
#define	E_WRITE		21	/* write system call error */
#define	E_NOTONL	22	/* operation not allowed on format L */
#define	E_BADPREFIX	23	/* message prefix too long or invalid */
