C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,wtap,atap,nsi,nsamp,ntrc,verbos,fill,
     :val,xmin,xmax,f1,f2,f3,f4,nlayers,nps)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), wtap*(*), atap*(*)
      integer    argis, nsi, nsamp, ntrc
      real       val
      logical    verbos, fill

            call argstr('-N',ntap,' ',' ')
            call argstr('-O',otap,' ',' ')
            call argstr('-W',wtap,' ',' ')
            call argstr('-A',atap,' ',' ')
            call argi4('-ns',nsamp,0,0)
            call argi4('-nt',ntrc,1,1)
            call argi4('-si',nsi,1,1)
            call argr4('-v',val,0.,0.)
            call argr4('-f1',f1,5.,5.)
            call argr4('-f2',f2,10.,10.)
            call argr4('-f3',f3,40.,40.)
            call argr4('-f4',f4,80.,80.)
            call argr4('-xmin',xmin,0.,0.)
            call argr4('-xmax',xmax,20000.,20000.)
            call argi4('-nint',nlayers,1,1)
            call argi4('-nps',nps,10,10)
            fill   = ( argis( '-F' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
