C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c     DCRAY - V1.0 <<Hakan Karazincir, June 3, 1997>>
c---

c---
c     DCRAY 2.0  <<Hakan Karazincir, January 16, 1998>> 
c     
c     This version of DCRAY uses dynamic memory allocation  and it is a robust version.
c---
      subroutine dcray(z,vp,vs,rho,nlayers,xminimum,xmaximum,nfolds,dt,
     :tmax,nres,nps,filt,swave,nw,itmx,xtout,N,xout,tout,tetha) 
      implicit double precision(A-H,O-Z)

      real*8 z(0:nlayers+2),vp(nlayers+1)
      real*8 vs(nlayers+1),rho(nlayers+1)
      real*4 swf,swfh,swf2,swfh2
      real*4 sfilt(4),sdt1
      complex r1fft,r2fft,wfft,whfft
      complex rtrace,rtraceh
      real*8 thwork,xt,xth,xwork,twork
      real*8 xtout(N*nfolds),filt(4)
      real*4 swave(nw)
      real*8 xout(nlayers*nfolds),tout(nlayers*nfolds)
      real*8 tetha(nlayers*nfolds)
     
      complex*8 RC,p
      real*4 v1,v2,w1,w2,Phi,d1,d2,x
      integer errcod,abort

      data abort / 1 / 
c---
c     define pointers for dynamic memory allocation
c---

c      pointer (p_xout, xout(1))
c      pointer (p_tout, tout(1))
c      pointer (p_tetha, tetha(1))
      pointer (p_thwork, thwork(1))
      pointer (p_xt, xt(1))
      pointer (p_xth,xth(1))
      pointer (p_xwork, xwork(1))
      pointer (p_twork, twork(1))
      pointer (p_swf, swf(1))
      pointer (p_swfh, swfh(1))
      pointer (p_swf2, swf2(1))
      pointer (p_swfh2, swfh2(1))
      pointer (p_r1fft, r1fft(1))
      pointer (p_r2fft, r2fft(1))
      pointer (p_rtrace, rtrace(1))
      pointer (p_rtraceh, rtraceh(1))
      pointer (p_wfft, wfft(1))
      pointer (p_whfft, whfft(1))

      Pi = dacos(-1.0d0)

c---
c     calculate a new dt for over-sampling
c---
      dt1 = dt/dfloat(nres)

c---
c     calculate the record length
c---
      N = dint(tmax/dt)
      rndim = dreal(nres*N)
      NP = 2**(idint(dlog10(rndim)/dlog10(2.0d0))+1)

c---
c     allocate memory just enough to operate
c---
c      call gcalloc(p_tout,nfolds*nlayers,8,errcod,abort)
c      call gcalloc(p_xout,nfolds*nlayers,8,errcod,abort)
c      call gcalloc(p_tetha,nfolds*nlayers,8,errcod,abort)
      call gcalloc(p_thwork,nfolds,8,errcod,abort)
      call gcalloc(p_xwork,nfolds,8,errcod,abort)
      call gcalloc(p_twork,nfolds,8,errcod,abort)
      call gcalloc(p_xt,nres*nfolds*N,8,errcod,abort)
      call gcalloc(p_xth,nres*nfolds*N,8,errcod,abort)


 

c---
c     call downward to calculate {x,t,theta}'s for all layers as vectors. In other words,
c     xout has x values for first for the first layer, then for the second layer and so on. These 
c     values make a long vector. Same thing applies to tout and  tetha vectors.
c     I made a mistake and called theta tetha and once I realized that it was spelled wrong, it was
c     too late to go and change all.
c--- 
      call downward(z,vp,nlayers,nps,xminimum,xmaximum,xout,tout,
     &tetha,nfolds)

c---
c     calculation of the source waveform
c---
      sfilt(1) = sngl(filt(1))
      sfilt(2) = sngl(filt(2))
      sfilt(3) = sngl(filt(3))
      sfilt(4) = sngl(filt(4))
      sdt1 = sngl(dt1)
      
      do il = 1, nlayers
         call PickAnEvent(xout,tout,tetha,xwork,twork,thwork,
     :      nfolds*nlayers,nfolds,il)
         v1 = sngl(vp(il))
         v2 = sngl(vp(il+1))
         w1 = sngl(vs(il))
         w2 = sngl(vs(il+1))
         d1 = sngl(rho(il))
         d2 = sngl(rho(il+1))
         do ix = 1,nfolds
            Phi = sngl(thwork(ix))
            x = sngl(xwork(ix))
            p = RC(v1,v2,w1,w2,Phi,d1,d2)
            phs = atan2(aimag(p),real(p))
            rr = dble(real(p)*cos(phs))
            ri = dble(aimag(p)*sin(phs))

            if (phs .eq. 0.0d0) then
               Tt = twork(ix)
               itt = dint(tt/dt1)
               k = (ix - 1)*N*nres+itt
               if (itt .le. nres*N) then
                  xt(k) = xt(k)+rr
               end if
            else 
               Tt = twork(ix)
               itt = dint(tt/dt1)
               k = (ix - 1)*N*nres+itt
               if (itt .le. nres*N) then
                  xt(k) = xt(k)+rr
                  xth(k) = xth(k)+ri
               end if 
            end if
         end do
      end do

c      call gfree(p_tout)
c      call gfree(p_xout)
c      call gfree(p_tetha)
      call gfree(p_thwork)
      call gfree(p_xwork)
      call gfree(p_twork)

      call gcalloc(p_swf,NP,4,errcod,abort)
      call gcalloc(p_swfh,NP,4,errcod,abort)
      call gcalloc(p_swf2,NP,4,errcod,abort)
      call gcalloc(p_swfh2,NP,4,errcod,abort)

      if (nw .le. 1) then
         call wavelet(swf,swfh,sdt1,1.e-03,21,nswf,sfilt)
         call wave2(swf,nswf,swf2,NP)
         call wave2sym(swfh,nswf,swfh2,NP)
      end if

      if (nw .gt. 1) then
         call strech(swave,nw,itmx,swf2,NP)
         call copy(swf2,swfh2,NP)
         call hilbertTrans(swfh2,NP)
      end if

      call gcalloc(p_wfft,NP,8,errcod,abort)
      call gcalloc(p_whfft,NP,8,errcod,abort)
        do k = 1,NP
         wfft(k) = cmplx(swf2(k),0.0)
         whfft(k) = cmplx(swfh2(k),0.0)
      end do
      call four1(wfft,NP,1)
      call four1(whfft,NP,1)

      it2 = 1
      do ix = 1,nfolds
         call gcalloc(p_r1fft,NP,8,errcod,abort)
         call gcalloc(p_r2fft,NP,8,errcod,abort)
         call gcalloc(p_rtrace,NP,8,errcod,abort)
         call gcalloc(p_rtraceh,NP,8,errcod,abort)

         j = 1
         do it = (ix-1)*N*nres+1,ix*N*nres
            r1fft(j) = cmplx(sngl(xt(it)),0.0)
            r2fft(j) = cmplx(sngl(xth(it)),0.0)
            j = j + 1
         end do
         
         call four1(r1fft,NP,1)
         call four1(r2fft,NP,1)

         do i = 1,NP
            rtrace(i) = r1fft(i) * wfft(i)
            rtraceh(i) = r2fft(i) * whfft(i)
         end do

         call four1(rtrace,NP,-1)
         call four1(rtraceh,NP,-1)

         do i = 1,nres*N,nres
            xtout(it2) = dble((real(rtrace(i))+
     &                       real(rtraceh(i)))/float(NP))
            it2 = it2 + 1
         end do
         
         call gfree(p_rtrace)
         call gfree(p_rtraceh)
         call gfree(p_r1fft)
         call gfree(p_r2fft)
      end do

      call gfree(p_xt)
      call gfree(p_xth)
      call gfree(p_swf2)
      call gfree(p_swfh2)
      call gfree(p_swf)
      call gfree(p_swfh)
      call gfree(p_wfft)
      call gfree(p_whfft)

      return
      end

