C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine downward(z,v,nlayers,nps,xminimum,xmaximum,xout,tout,
     :thout,nfolds)

      implicit double precision (A-H,O-Z)

      real*8 z(0:nlayers+2),v(nlayers+1)
      real*8 pmax,pc
      real*8 xs(256),ps(256),dp(256),a(256)
      real*8 t,x
      real*8 tetha,praw,xraw
      real*8 traw,tnew,xnew,pnew
      real*8 xwork,twork
      real*8 thwork,thout(nfolds*nlayers),dz1
      real*8 tout(nfolds*nlayers),xout(nfolds*nlayers),th

      integer errcod,abort

      data abort / 1 /

      pointer (p_pmax,pmax(1))
      pointer (p_pc,pc(1))
      pointer (p_t,t(1))
      pointer (p_x,x(1))
      pointer (p_tetha,tetha(1))
      pointer (p_praw,praw(1))
      pointer (p_xraw,xraw(1))
      pointer (p_traw,traw(1))
      pointer (p_tnew,tnew(1))
      pointer (p_xnew,xnew(1))
      pointer (p_pnew,pnew(1))
      pointer (p_xwork,xwork(1))
      pointer (p_twork,twork(1))
      pointer (p_thwork,thwork(1))
      pointer (p_th,th(1))

      call gcalloc(p_t,nps*nlayers,8,errcod,abort)
      call gcalloc(p_x,nps*nlayers,8,errcod,abort)
      call gcalloc(p_tetha,nlayers*nps,8,errcod,abort)
      call gcalloc(p_praw,nps,8,errcod,abort)
      call gcalloc(p_xraw,nps,8,errcod,abort)
      call gcalloc(p_traw,nps,8,errcod,abort)
      call gcalloc(p_tnew,nps,8,errcod,abort)
      call gcalloc(p_xnew,nps,8,errcod,abort)
      call gcalloc(p_pnew,nps,8,errcod,abort)
      call gcalloc(p_xwork,nfolds,8,errcod,abort)
      call gcalloc(p_twork,nfolds,8,errcod,abort)
      call gcalloc(p_thwork,nfolds,8,errcod,abort)
      call gcalloc(p_thout,nfolds*nlayers,8,errcod,abort)
      call gcalloc(p_tout,nfolds*nlayers,8,errcod,abort)
      call gcalloc(p_xout,nfolds*nlayers,8,errcod,abort)
      call gcalloc(p_th,nps*nlayers,8,errcod,abort)
      call gcalloc(p_pmax,(nlayers+1),8,errcod,abort)
      call gcalloc(p_pc,nlayers,8,errcod,abort)

      vmax = v(1)
      dx = xmaximum/dfloat(nfolds-1)
      xmax = xmaximum
      xacc = 1.0d-10
      c = 1.0d0/dfloat(nps-1)
c---
c     calculation of p criticals
c---

      call pcs(v,pc,nlayers)

      t0 = 2.0d0*z(1)/v(1)

      call dps(v(1),t0,xmax,xacc,c,nps,xs,ps,dp)
 
      pmax(1) = dsin(datan(xmax/(2.0d0* (z(1)-z(0)) ) ))/v(1)

      call zero(tnew,nps)
      call zero(xnew,nps)
      call zero(pnew,nps)
      call zero(a,nps)

      k = 1
      do il = 1,nlayers
         p  = 0.0d0 
         dz = z(il) - z(il-1)
         do ix = 1,nps
            if (il .eq. 1) then
               tetha(k) = dasin(v(il)*p)
               praw(ix) = p
            else
               tetha(k) = dasin(v(il)*pnew(ix))
               praw(ix) = pnew(ix)
            end if
            xi = 2.0d0 * dz * dtan(tetha(k))
            x(k) = xnew(ix) + xi
            t(k) = tnew(ix) + 2.0d0 * dsqrt((xi/2.0d0)**2+dz**2)/v(il)
            xraw(ix) = x(k)
            traw(ix) = t(k)
            a(ix) = p/pmax(il)
            p = p + dp(ix)
            th(k) = tetha(k)
            k = k + 1
         end do

         dz1 = z(il+1)-z(il)
         v1 = v(il+1)
         if (vmax .lt. v1) vmax = v1
         
         p1 = praw(1)
         p2 = dmin1(pc(il),praw(nps))

         pmax(il+1) = rtbis(p1,p2,xraw,praw,nps,
     &      xmax,v1,dz1,xacc)
         
         do ix = 1,nps-1
            dp(ix) = (a(ix+1)-a(ix))*pmax(il+1)
         end do
            
         p = 0.0d0
         do ix =1,nps
            call ratint(praw,xraw,nps,p,xx,dy)
            call ratint(xraw,traw,nps,xx,tt,dy)
            xnew(ix) = xx
            tnew(ix) = tt
            pnew(ix) = p
            p = p + dp(ix)
         end do
      end do 
  
      l = 1
      do il = 1,nlayers
         call PickAnEvent(x,t,th,xwork,twork,thwork,k-1,nps,il)      
         dist = xminimum
         xmaxp = xwork(nfolds)
         do ix = 1,nfolds
            if (xmaxp .le. xmaximum ) then 
               call ratint(xwork,twork,nps,dist,time,dy)
               call ratint(xwork,thwork,nps,dist,thx,dy)
               tout(l) = time
               thout(l) = thx
            else
               tout(l) = 0.0d0
               thout(l) = 0.0d0
            end if
            xout(l) = dist
            dist = dist + dx
            l = l + 1
         end do 
      end do

      call gfree(p_t)
      call gfree(p_x)
      call gfree(p_th)
      call gfree(p_tetha)
      call gfree(p_praw)
      call gfree(p_xraw)
      call gfree(p_traw)
      call gfree(p_tnew)
      call gfree(p_xnew)
      call gfree(p_pnew)
      call gfree(p_xwork)
      call gfree(p_twork)
      call gfree(p_thwork)
      call gfree(p_pmax)
      call gfree(p_pc)      

      return
      end
