C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dps(v,t0,xmax,acc,c,nps,xs,ps,dp)
      implicit double precision(A-H,O-Z)
      real*8 dp(256),xs(256),ps(256)
      logical flag
      flag = .true.

      a = 0.0d0
      b = 1.0d0
      x0 = 0.0d0
      p0 = 0.0d0
      
      xs(1) = 0.0d0
      ps(1) = 0.0d0
      

      i = 1
      
      do while(x1*xmax .le. xmax .and. flag)
         x1 = rtbis1(a,b,x0,c,v,t0,acc,xmax,flag)
         p1 = pest(p0,x0,x1,c)
         if (.not.flag) p1 = pxest(t0,xmax,v)*v
         xs(i+1) = x1*xmax
         ps(i+1) = p1/v
         dp(i) = (p1 - p0)/v
         a = x1
         x0 = x1
         p0 = p1
         i = i + 1
      end do
      Mout = i
      S = c*dfloat(Mout-2)+dsqrt(((xs(Mout)-xs(Mout-1))/xmax)**2+
     &    (dp(Mout-1)*v)**2)
      c = S/dfloat(nps-1)

      a = 0.0d0
      x0 = 0.0d0
      p0 = 0.0d0
      x1 = 0.0d0
      p1 = 0.0d0
      flag = .true.

      call zero(xs,Mout)
      call zero(ps,Mout)
      call zero(dp,Mout)
     
      i = 1
      do while(x1*xmax .le. xmax .and. flag)
         x1 = rtbis1(a,b,x0,c,v,t0,acc,xmax,flag)
         p1 = pest(p0,x0,x1,c)
         if (.not.flag) p1 = pxest(t0,xmax,v)*v
         xs(i+1) = x1*xmax
         ps(i+1) = p1/v
         dp(i) = (p1 - p0)/v
         a = x1
         x0 = x1
         p0 = p1
         i = i + 1
      end do
      return
      end
