C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine hilbertTrans(data,nsam)

       integer optn,j,sign,nfreq
       integer errcod,abort
       real   scale,data(nsam)
       complex cdata 

       pointer (p_cdata,cdata(1))
 
       optn = 2**(int(alog10(float(nsam))/alog10(2.0))+1)
       nfreq = optn/2+1

       call gcalloc(p_cdata,optn,8,errcod,abort)
 
       do j = 1,nsam
          cdata(j) = cmplx(data(j),0.0)
       end do
       do j = nsam+1,optn
          cdata(j) = cmplx(0.0,0.0)
       end do

       sign = -1
       call four1(cdata,optn,sign)
 
       do j = nfreq+1,optn
          cdata(j)= cmplx(0.0,0.0)
       end do
 
       sign = 1
       call four1(cdata,optn,sign)
 
       scale= 2.0/float(optn)
       do j = 1,nsam 
          data(j) = aimag(cdata(j))*scale
       end do
 
       call gfree(p_cdata)
 
       return
       end
 
