C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  dcray: Downward continuation based isotropic 
C                            ray tracing program
C     v2.0 -- October 10, 1997 -- Hakan Karazincir
C             The first robust DCRAY routine
C**********************************************************************C
C
C READ INPUT NUMBERS, ATTACH LINE & TRACE HEADER, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <localsys.h>

#define RESOLUTION 0.5d0

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      REAL        HEAD( SZLNHD )
      REAL       work
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN,LUINW,LUOUT,LBYTES,obytes
      integer     argis,nres

      real*8 z,vp
      real*8 vs,rho,xtout,xout,tout,tetha
      real*8 xminimum,xmaximum
      real*8 filt(4),tmax1,dt
      
      real wavelet(10000)

      real*8 time1,time2
c---
c      define pointers for dynamic memory allocation
c---
      pointer (p_z, z(0:0))
      pointer (p_vp, vp(1))
      pointer (p_vs, vs(1))
      pointer (p_rho, rho(1))
      pointer (p_xtout, xtout(1))
      pointer (p_work, work(1))
      pointer (p_xout, xout(1))
      pointer (p_tout, tout(1))
      pointer (p_tetha, tetha(1))

c      pointer (p_wavelet, wavelet(1))

#include <f77/pid.h>
      
      CHARACTER   NAME * 5, otap * 256, ntap * 256, wtap * 256
      CHARACTER   atap * 256
      character*1 flag
      logical     verbos, query, fill
      integer errcod,abort
 
      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )
      DATA NAME     /'DCRAY'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LUINW / 3 /, LBYTES / 0 /
      DATA  obytes / 0 /, LUOUTA / 4 /
      data verbos/.false./


#ifdef SUNSYSTEM
      character*1 IEEEMODE, IEEEIN, IEEEOUT
      integer*4 IEEER
#endif
      data abort / 1 /
c------------------------
c  open printout file
c------------------------
#include <f77/open.h>


C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,wtap,atap,nsi,nsamp,ntrc,verbos,fill,val,
     :xmin,xmax,f1,f2,f3,f4,nlayers,nps)

c---
c     allocate memory for z, vp, vs, rho, and output array xtout 
c---
      call galloc(p_z, 8*(nlayers+2),errcod,abort)
      call galloc(p_vp, 8*(nlayers+1),errcod,abort)
      call galloc(p_vs, 8*(nlayers+1),errcod,abort)
      call galloc(p_rho, 8*(nlayers+1),errcod,abort)
      call galloc(p_xtout, 8*nsamp*ntrc,errcod,abort)
      call gcalloc(p_tout,ntrc*nlayers,8,errcod,abort)
      call gcalloc(p_xout,ntrc*nlayers,8,errcod,abort)
      call gcalloc(p_tetha,ntrc*nlayers,8,errcod,abort)

c--------------------------------
c  get online help if necesssary
c--------------------------------
      query = ( argis( '-?' ) .gt. 0 .OR. argis( '-h' ) .gt. 0 .OR.
     1        argis( '-help' ) .gt. 0 )
      if ( query ) then
           call help()
           stop
      endif
     
      nfolds = ntrc
      dt = dfloat(nsi)/1000.d0      
      tmax1 = dfloat(nsamp)*dt
      nres = dint(1000.0d0*dt/RESOLUTION)
      
      eps = 1.0e-4
c---
c     read in model data 
c---
      open(luin,file=ntap,status='old')

c---
c     read the input wavelet if it exists
c---
      nwave = 1
      if (wtap .ne. ' ') then 
         open(luinw,file=wtap,status='old')
         i = 1
 1000    read(luinw,*,END=2000) wavelet(i),flag
         if (flag .eq. 'p') itmx = i
         i = i + 1
         go to 1000
 2000    call wavelet_trans(wavelet,i,itmx)
         nwave = i
      end if
c---
c     open angles file if -A flag exists
c---
      if (atap .ne. ' ') then
         open(luouta,file=atap,status='new')
      end if

C**********************************************************************C
C     open output data set; build line header
C**********************************************************************C
      call getln( luout, otap, 'w', 1)

      j = 1
      z(0) = 0.0d0
      read(luin,*) a,b,c,d
      do i = 1, nlayers
         read(luin,*) a1,b1,c1,d1
         if ((abs(b1-b) .gt. eps) .or.
     &      (abs(c1-c) .gt. eps) .or. (abs(d1-d) .gt. eps)) then
            z(j) = dble(a)
            vp(j) = dble(b)
            vs(j) = dble(c)
            rho(j) = dble(d)
            j = j + 1
         end if
         a = a1
         b = b1
         c = c1
         d = d1
      end do
      z(j) = dble(a)
      vp(j) = dble(b)
      vs(j) = dble(c)
      rho(j) = dble(d)
      nlayers1 = j - 1

      if (nlayers1 .le. 0) then
         print *, 'You must have at least one seismic'
         print *, 'interface to run this code.'
         print *, 'Check your input data!'
         print *, ''
         stop
      end if

c---
c     Set input parameters
c---
      xminimum = dble(xmin)
      xmaximum = dble(xmax)

      filt(1) = dble(f1)
      filt(2) = dble(f2)
      filt(3) = dble(f3)
      filt(4) = dble(f4)
      
      call timer(time1)
c---
c     call isotropic ray tracing code
c---
      call dcray(z,vp,vs,rho,nlayers1,xminimum,xmaximum,nfolds,dt,
     :tmax1,nres,nps,filt,wavelet,nwave,itmx,xtout,N,xout,tout,tetha) 
      
      call timer(time2)
      call gfree(p_z)
      call gfree(p_vp)
      call gfree(p_vs)
      call gfree(p_rho)

      piover2 = asin(1.0)
      if (atap .ne. ' ') then
         do i = 1, ntrc*nlayers
            tetha(i) = tetha(i)*90.0/piover2
            write(LUOUTA,*)sngl(xout(i)),sngl(tout(i)),sngl(tetha(i))
         end do
      end if

      print *,nlayers,ntrc,nsamp,time2-time1

      nsamp = N

      if (nsamp .eq. 0) nsamp = 2*SZLNHD
      nrec  = 1
      iform = 3

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)


      call savew( itr, 'NumTrc', ntrc  , LINHED)
      call savew( itr, 'NumRec', nrec  , LINHED)
      call savew( itr, 'SmpInt',  nsi  , LINHED)
      call savew( itr, 'NumSmp', nsamp , LINHED)
      call savew( itr, 'Format', iform , LINHED)
c-------------------------------------
c  update line header; historical LH
c-------------------------------------
      write(LERR,*)' '
      write(LERR,*)'Number samples      =  ',nsamp
      write(LERR,*)'Number traces       =  ',ntrc
      write(LERR,*)'Sample interval     =  ',nsi
      write(LERR,*)' '

      obytes = SZTRHD + SZSMPD*nsamp
      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew( itr, 'HlhEnt',  0   , LINHED)
      call savew( itr, 'HlhByt', nbyt , LINHED)
      call savhlh( itr, lbytes, lbyout )
c------------------------
c write line hdr, trace
c------------------------
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

      call galloc(p_work,nsamp*4,errcod,abort)

      DO  J = 1, ntrc

         call vclr (work, 1, nsamp)

         IF ( fill ) THEN

            do  i = 1, nsamp
                work (i) = val
            enddo
            nsampo = nsamp

         ELSE
            DO I = 1, nsamp
               k = (J-1)*nsamp+I
               work(i) = sngl(xtout(k))
            END DO
100         nsampo = i-1
            if (nsampo .eq. 0) then
               write(LERR,*)'WARNING from putsis:'
               write(LERR,*)'End of data sensed prematurely at trc= ',
     1                       J
               write(LERR,*)'Perhaps no problem; terminating execution'
               go to 999
            endif

         ENDIF

         if (verbos) then
            write(LERR,*)'Trc= ',J,' Number samples read= ',nsampo
            write(LERR,*)(work(i), i=1, nsampo)
         endif

         call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               1 , TRACEHEADER)
         call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               J , TRACEHEADER)


         call vmov (work, 1, lhed(ITHWP1), 1, nsamp)
         call wrtape(luout,itr,obytes)

      ENDDO
c------------------------

999   continue

      call lbclos(luout)

#ifdef SUNSYSTEM
        IEEER = IEEE_FLAGS('clearall', IEEEMODE, IEEEIN, IEEEOUT)
#endif

      END
