C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c     Heelan's Knott-Zoeppritz 
c---

      complex function RC(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,Phi,d1,d2
      complex D,D8
  
      RC = D8(v1,v2,w1,w2,Phi,d1,d2) / D(v1,v2,w1,w2,Phi,d1,d2)

      return
      end

      complex function D8(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,Phi,d1,d2,J4,J6
      complex J1,J2,J3,J5
  
      D8 = J1(v1,v2,w1,w2,Phi,d1,d2) -
     :   J2(v1,v2,w1,w2,Phi,d1,d2) -
     :   J3(v1,v2,w1,w2,Phi,d1,d2) +
     :   J5(v1,v2,w1,w2,Phi,d1,d2) +
     :   cmplx(J4(v1,w1,w2,d1,d2,Phi) - J6(v1,w1,w2,d1,d2,Phi))
 
      return
      end

      complex function D(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,Phi,d1,d2,J4,J6
      complex J1,J2,J3,J5
  
      D = J1(v1,v2,w1,w2,Phi,d1,d2) +
     :   J2(v1,v2,w1,w2,Phi,d1,d2) +
     :   J3(v1,v2,w1,w2,Phi,d1,d2) +
     :   J5(v1,v2,w1,w2,Phi,d1,d2) +
     :   cmplx(J4(v1,w1,w2,d1,d2,Phi) + J6(v1,w1,w2,d1,d2,Phi))
 
      return
      end

      real function J6(v1,w1,w2,d1,d2,Phi)
      real u1,x1,u,x,v1,w1,w2,d1,d2,Phi,s0

      J6 = s0(Phi)*(u1(d2,w2)*x1(v1,w2,Phi)-u(d1,w1)*x(v1,w1,Phi))**2
     
      return
      end

      complex function J5(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,Phi,u1,u,d1,d2,A
      complex B1
 
      J5 = B1(v1,w2,Phi)*
     :   cmplx(u(d1,w1)*u1(d2,w2)*h(v1,w1)**2*h1(v1,w2)**2*
     :   A(Phi)) 
     
      return
      end

      real function J4(v1,w1,w2,d1,d2,Phi)
      real v1,d1,d2,w1,w2,A,B,u1,u,x1,s0,Phi

      J4 = A(Phi)*B(v1,w1,Phi)*(u1(d2,w2)*x1(v1,w2,Phi)-2.0*
     :   u(d1,w1)*s0(Phi))**2
     
      return
      end

      complex function J3(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,Phi,u1,u,d1,d2
      complex A1
 
      J3 = A1(v1,v2,Phi)*
     :   cmplx(u(d1,w1)*u1(d2,w2)*h(v1,w1)**2*h1(v1,w2)**2*
     :   B(v1,w1,Phi)) 
     
      return
      end

      complex function J2(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,s0,Phi,two,u1,u,d1,d2,x
      complex A1,B1 

      two = 2.0
 
      J2 = A1(v1,v2,Phi)*B1(v1,w2,Phi)*
     :   cmplx(u(d1,w1)*x(v1,w1,Phi)-two*u1(d2,w2)*s0(Phi))**2
     
      return
      end

      complex function J1(v1,v2,w1,w2,Phi,d1,d2)
      real v1,v2,w1,w2,s0,Phi,four,u1,u,d1,d2
      complex A1,B1 

      four = 4.0
 
      J1 = A1(v1,v2,Phi)*B1(v1,w2,Phi)*
     :   cmplx(four*A(Phi)*B(v1,w1,Phi)*
     :   s0(Phi)*(u1(d2,w2)-u(d1,w1))**2)
     
      return
      end

      complex function B1(v1,w2,Phi)
      real v1,w2,s0,Phi
 
      B1 = csqrt(cmplx((v1/w2)**2-s0(Phi)))
     
      return
      end

      complex function A1(v1,v2,Phi)
      real v1,v2,s0,Phi
 
      A1 = csqrt(cmplx((v1/v2)**2-s0(Phi)))
     
      return
      end

      function u1(d2,w2)
      real d2,w2

      u1 = d2 * w2**2
     
      return
      end

      function u(d1,w1)
      real d1,w1

      u = d1 * w1**2
     
      return
      end

      function x1(v1,w2,Phi)
      real v1,w2,two,s0,h1,Phi

      two = 2.0

      x1 = two * s0(Phi) - h1(v1,w2)**2
     
      return
      end

      function x(v1,w1,Phi)
      real v1,w1,two,s0,h,Phi

      two = 2.0

      x = two * s0(Phi) - h(v1,w1)**2
     
      return
      end

      function h(v1,w1)
      real v1,w1

      h = v1/w1
     
      return
      end

      function h1(v1,w2)
      real v1,w2

      h1 = v1/w2
     
      return
      end

      function B(v1,w1,Phi)
      real Phi,s0,v1,w1

      B = sqrt(v1**2/w1**2-s0(Phi))
     
      return
      end

      function A(Phi)
      real Phi,s0,one

      one = 1.0
 
      A = sqrt(one-s0(Phi))
     
      return
      end

      function s0(Phi)
      real Phi
 
      s0 = sin(Phi)**2
     
      return
      end
