C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wavelet(wav,wavh,dt,thrsh,nwindow,m,filt)
      real wav(5001),wavh(5001),sinc,dt,thrsh,Pi,average
      real filt(4)
      external W,Wh
 
      Pi = 2.0*asin(1.0)
      t = 0.0
      i = 1
      f1 = filt(1)
      f2 = filt(2)
      f3 = filt(3)
      f4 = filt(4)
 
      scale = W(0.0,f1,f2,f3,f4,Pi)
      wav(1) = 1.0
100   sinc = W(t,f1,f2,f3,f4,Pi)
      sinch = Wh(t,f1,f2,f3,f4,Pi)
      wav(i) = sinc/scale
      wavh(i) = sinch/scale

      call avg(wav,i,21,average)
      t = t + dt
      i = i + 1
      if (average.gt.thrsh) goto 100
      if (mod(i-1,2).eq.0) goto 100
 
      TT = (nwindow-1)*dt
      tp  = dt
      M = i+nwindow-2
      do j = i,M
         wav(j) = W(t,f1,f2,f3,f4,Pi)/scale*window(tp,TT,Pi)
         wavh(j) = Wh(t,f1,f2,f3,f4,Pi)/scale*window(tp,TT,Pi)
         t = t + dt
         tp = tp + dt
      end do

      return
      end

      real function Wh(t,f1,f2,f3,f4,Pi)
      real t,f1,f2,f3,f4,Pi
 
      if (t .eq. 0.0) then
         Wh = 0.0
      else
         Wh = -(-(f3*sin(2.0*f1*Pi*t)) +
     :      f4*sin(2.0*f1*Pi*t) +
     :      f3*sin(2.0*f2*Pi*t) - f4*sin(2.0*f2*Pi*t) +
     :      f1*sin(2.0*f3*Pi*t) - f2*sin(2.0*f3*Pi*t) -
     :      f1*sin(2.0*f4*Pi*t) + f2*sin(2.0*f4*Pi*t))/
     :      (2.0*(f1 - f2)*(f3 - f4)*Pi**2*t**2)
      end if
      return
      end
 
      real function W(t,f1,f2,f3,f4,Pi)
      real t,f1,f2,f3,f4,Pi
 
      if(t .eq. 0.0) then
         W = (-f1-f2+f3+f4)
      else
         W = (-(f3*cos(2.0*f1*Pi*t)) + f4*cos(2.0*f1*Pi*t) +
     :      f3*cos(2.0*f2*Pi*t) - f4*cos(2.0*f2*Pi*t) +
     :      f1*cos(2.0*f3*Pi*t) - f2*cos(2.0*f3*Pi*t) -
     :      f1*cos(2.0*f4*Pi*t) + f2*cos(2.0*f4*Pi*t))/
     :      (2.0*(-f1 + f2)*(f3 - f4)*Pi**2*t**2)
      end if
      return
      end

      real function window(t,TT,Pi)
      real t,TT,Pi
 
      if (abs(t) .gt. TT) then
         window = 0.0
      else
         window = 0.5 * (1.0 + cos(Pi*t/TT))
      end if
 
      return
      end

      subroutine avg(wav,i,num,average)
      real*8 wav(5001),sum,average
      integer i,num,j
 
      sum = 0.0
      if (i-num.gt.0) then
         do j = i-num+1,i
            sum = sum + abs(wav(j))
         end do
         average = sum/float(num)
      else
         average = 1.0
      end if
 
      return
      end
