C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Edit Data Set
C
C Changes:
c
c Apr 16, 2001 - added dynamic memory allocation to the recnum file
c                so that very large lists of records can be accessed
c                at run time.  Also moved the 999 continue statement
c                up to allow the leftove record logic to function
c                in every case...Garossino
c
c Aug 13, 2001 - changed itr data storage to dynamic allocation and 
c                did away with references to lhed and head, both of
c                which were equivalenced to itr. - joe m. wade
c
C**********************************************************************C
C
C EDITT READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C rips off a specified portion of a data set, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR 
c     INTEGER     ITR ( 2*SZLNHD )
c     INTEGER     LHED( 2*SZLNHD )
c     REAL        HEAD( 2*SZLNHD )

      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis,tdel,rdel,sdel
      integer	  alloc_size,errcod

c     REAL        xtr ( SZLNHD ),work(SZLNHD), junk
      REAL        xtr, work, junk


      integer     ndelta
      integer     currec, curtrc

      real * 8    ztrec

      CHARACTER   NAME * 4,  ntap * 512, otap * 512, rfile * 512
      CHARACTER   hdrwrd * 6
      character*9 host

      logical     verbos,rnum,pass,large, IKP, match, EOF

c variables used in dynamic memory allocation

      integer     recnum, errcd1, abort, size_recnum
      pointer     (mem_recnum,recnum(2))
 
c     EQUIVALENCE ( ITR( 1), LHED(1), HEAD(1) )

      pointer     (mem_itr, itr(1))
      pointer     (mem_xtr,xtr(1))
      pointer     (mem_work,work(1))

      data     IKP / .false. /
      DATA     NAME /'EDIT'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, rnum /.false./
      data     host /'         '/
      data     abort / 0 /

c---------------------------------
c  get online help if necessary
c---------------------------------
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help ()
         stop 0
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,tdel,rdel,
     1           irst,new,rnum,verbos,rfile,pass,sdel,match,EOF,
     2           hdrwrd,inst,irsti,insti)
      
      call ikpchk(host)
      write(LERR,*)'host= ',host
      if (host .ne. '         ') IKP = .true.

c     call xtrarg(name,LER,.FALSE.,.FALSE.)
c     call xtrarg(name,LERR,.FALSE.,.TRUE.)

c - was converting to ikpchk from command line option when I noticed
c   this was overridden in cmdln previously. Am leaving override.
c   I think it will just small buffer all piped data.

      IKP = .false.

      if (rfile(1:1) .ne. ' ') then


         do while ( 1 .eq. 1 )
             read (ludisk, *, end=400) junk
             nreccr = nreccr + 1
          enddo

400      continue

         rewind(ludisk)

         size_recnum = nreccr + 1
	 errcd1 = 0
         call galloc(mem_recnum, size_recnum * SZSMPD, errcd1, abort )

         if ( errcd1 .ne. 0) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) size_recnum * SZSMPD, '  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) size_recnum * SZSMPD, '  bytes'
            write(LER,*)' '
            stop
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) size_recnum * SZSMPD, '  bytes'
            write(LERR,*)' '
         endif

         call vclr ( recnum, 1, size_recnum)

         do j = 1, nreccr
            read (ludisk, *) recnum(j)
         enddo
        
         recnum(nreccr+1) = 0
         write(LERR,*)' '
         write(LERR,*)'Record numbers read from file ',nreccr
           do  j = 1, nreccr
               write(LERR,*)'J= ',j,'  rec= ',recnum(j)
           enddo
         write(LERR,*)' '

         if (ntap(1:1) .eq. ' ' .OR. pass) then
         do  401  j = 2, nreccr
             if (recnum(j) .lt. recnum(j-1)) then
                write(LERR,*)'Using input pipe record numbers must'
                write(LERR,*)'be in ascending order.  Re-edit rec'
                write(LERR,*)'file to fix this.'
                call ccexit (666)
             endif
401      continue
         endif

      endif

      alloc_size = SZLNHD * SZSMPD
      errcod = 0
      call galloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'EDITT ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) alloc_size,' bytes requested '
      endif

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

c - we need to do this before calling rtape

      IF (luin .eq. 0) call sislgbuf(luin,'off')

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'EDIT: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>
      write(LERR,*)'ntrc,nrec= ',ntrc,nrec

      CALL HLHprt ( ITR , LBYTES, NAME, 4, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)


c---------------------------------------
c  check key values for reasonableness
c---------------------------------------
c     call cmdchk(nst,ned,nrst,nred,ntrc,nrec)

c     if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD

      if (nst .le. 0) nst = 1
      if (ned .eq. 0) ned = ntrc
      if (nrst .le. 1) nrst = 1
      if (nred .eq. 0) nred = nrec



c*****************
c  depending on defaults and function set large buffering on/off
c*****************
      large = .false.

c----
c   if input is pipe make sure large buffering OFF
c - did this up above before reading line header - jmw 11/05/92
c----
c     IF (luin .eq. 0) THEN

c        large = .false.
c----
c   if input is NOT pipe then...
c----

c     ELSE

c----
c      if not selecting traces then...
c----
         if (nst.eq.1 .AND. ned.eq.ntrc .AND. tdel.eq.1) then

            large = .true.
            if (ntrc .eq. 1 .and. rdel .ne. 1) then
               large = .false.
            endif

         else

            large = .false.

         endif
c  --  in ikp  we need to worry about buffering

      if (IKP .and. luin .eq. 0) large = .false.

c     ENDIF


c
c - turning large buffering on conflicts with compressed data input
c   It should automatically be set anyway.	- jmw - 2/27/98
c
c #ifndef CRAYSYSTEM - do this for all machines
c     if (luin .ne. 0) then
c      if (large) then
c        call sislgbuf (luin, 'on')
c        large = .true.
c      else
c        call sislgbuf( luin, 'off' )
c        large = .false.
c      endif
c     endif
c #endif

c-----------------
c output selected records only
c-----------------

      IF (.not.pass) THEN

         if (rfile(1:1) .eq. ' ') then
            write(LERR,*)'nred,nrst= ',nred,nrst
c            nrecd = 0
c            nend  = max (nrst,nred)
c            last  = min (nrst,nred)
c            do while (1 .eq. 1)
c               nrecd = nrecd + 1
c               last = last + iabs(rdel)
c               if (last .gt. nend) go to 9
c            enddo
c9           continue
c---
c  the above is pretty time consuming if nred happens to be very large
c  as in a bogus NumRec value.  Integer function ndelta uses the formula:

c  n = 1 + ifix[ (ne-ns)/ni ],  where ns, ne, ni are the start, end, and
c  increment
c---
            nrecc = ndelta (nrst, nred, rdel)

         else
            if (match) then
               nrst  = 1
               nred  = nrec
               rdel  = 1
               nrecc = nreccr
               nst   = 1
               ned   = ntrc
               tdel  = 1
            else
               nrst  = recnum(1)
               nred  = nrec
               rdel  = 1
               nrecc = nreccr
               nst   = 1
               ned   = ntrc
               tdel  = 1
            endif
         endif

c-----------------
c output everything other than selected records
c-----------------
      ELSE

         if (rfile(1:1) .eq. ' ') then
            write(LERR,*)'Currently cannot do a PASS on other than'
            write(LERR,*)'records specified in -F[rfile] -- FATAL'
            call ccexit(666)
         else
            nrst  = 1
            nred  = nrec
            nst   = 1
            ned   = ntrc
            nrecc = nrec - nreccr
         endif

      ENDIF

c      ntrd = 0
c      nend = max (nst,ned)
c      last = min (nst,ned)
c      do while (1 .eq. 1)
c         ntrd = ntrd + 1
c         last = last + iabs(tdel)
c         if (last .gt. nend) go to 11
c      enddo
c11    continue
c      ntr = ntrd

c---
c  the above is pretty time consuming if nred happens to be very large
c  as in a bogus NumRec value.  Integer function ndelta uses the formula:

c  n = 1 + ifix[ (ne-ns)/ni ],  where ns, ne, ni are the start, end, and
c  increment
c---
      ntr = ndelta (nst, ned, tdel)

      ioffset = tdel-nst


c------------------------------------------
c  figure out new (if changed) traces/rec)
c  NOTE:  if ntot goes negative we've exceeded
c  the 32 bit integer machine capacity. In that
c  case we have to set the output # recs to a
c  "big" number and hope for the best
c------------------------------------------
      new = iabs(new)
      IF (new .ne. 0) THEN
         ntot  = ntr*nrecc
         if (ntot .lt. 0) then
            ntr = new
            nrecc = 2000000000
         else
            ztrec = dfloat(ntot)/dfloat(new)
            ntrec = dnint (ztrec + .49d0)
            left  = ntrec*new - ntot
            write(LERR,*)'left= ',left,' ntot= ',ntot,' ntrec= ',ntrec,
     1       ' new= ',new,' ztrec= ',ztrec
            ntr   = new
            nrecc = ntrec
         endif
      ENDIF


C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
c     dt=nsi

      if (nsi .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR IN editt:'
         write(LERR,*)'Sample interval cannot be zero. Use utop ... -dt[
     1]'
         write(LER ,*)'to set it properly.'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR IN editt:'
         write(LER ,*)'Sample interval cannot be zero. Use utop ... -dt[
     1]'
         write(LER ,*)'to set it properly.'
         go to 9999
      endif

         dt = real (nsi) * unitsc

      if (iend .gt. 0) then
          iend = nint ( float(iend/nsi) ) + 1
      else
          iend = 0
      endif
     
      ist  = nint ( float(ist/nsi) ) + 1
      if(ist .le. 1) ist = 1


      if(iend .eq. 0) iend = nsamp
   

c Policman for user (jmg)

      if (iend  .gt.  nsamp) then
       
         iend=nsamp
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'End time (-e) exceeds the data limits.'
         write(LERR,*)'Resetting to end of data.'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'End time (-e) exceeds the data limits.'
         write(LER,*)'Resetting to end of data.'
      endif

c Policeman if command line times exceed the data (jmg)

      if ( ist .gt. nsamp .or. ist .lt. 0)then
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'start time (-s) exceeds the data limits'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'start time (-s) exceeds the data limits'
      endif

      nsampo = float(iend-ist+sdel) / float(sdel)
      nsi = nsi * sdel
c     if (nsampo .gt. 2*SZLNHD) then
c        write(LERR,*)'Warning:'
c        write(LERR,*)'editt is writing traces of length= ',nsampo
c        write(LERR,*)'which is longer than current max tr length= ',
c    1                 2*SZLNHD
c        write(LERR,*)'Execution proceding anyway'
c     endif

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' Output Samples/Trace  =  ', nsampo
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Traces per Record   =  ', ntr 
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Records per Line    =  ', nrecc
        write(LERR,*) ' Format of Data      =  ', iform
        if(rnum) then
        write(LERR,*) ' Number traces in padded last rec= ',left
        if(large) then
        write(LERR,*) ' Large buffering used'
        else
        write(LERR,*) ' Small buffering used'
        endif
        endif
        write(LERR,*) ' '
        write(LERR,*) ' Starting record number = ',irst
        write(LERR,*) ' Increment record number= ',irsti
        write(LERR,*) ' Starting trace number  = ',inst
        write(LERR,*) ' Increment trace number = ',insti
        write(LERR,*) ' Start record        =  ', nrst
        write(LERR,*) ' End record          =  ', nred
        write(LERR,*) ' get every ', rdel,'th  record'
        write(LERR,*) ' Start tracs         =  ', nst
        write(LERR,*) ' End trace           =  ', ned
        write(LERR,*) ' get every ', tdel,'th  trace '
        write(LERR,*) ' Total traces to be written =  ',ntot
        write(LERR,*) ' Start sample        =  ', ist
        write(LERR,*) ' End sample          =  ', ied
        write(LERR,*) ' get every ', sdel,'th sample '
        write(LERR,*) ' output sample interval = ',nsi
        write(LERR,*) ' Input on unit #            =  ',luin
        write(LERR,*) ' Output on unit #            =  ',luout
        write(LERR,*) ' Input Buffer Type Large(?) ',large
        write(LERR,*) ' Header word used if rec file supplied = ',hdrwrd
        write(LERR,*) ' '
c     endif

c Policeman for users (jmg)
      
        if (nst .gt. ntrc .or. nst .lt. 1) then
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'start trace (-ns) exceeds the data limits'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'start trace (-ns) exceeds the data limits'
        endif

        if (ned .gt. ntrc .or. ned .lt. 1) then
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'End trace (-ne) exceeds the data limits.'
         write(LERR,*)'Resetting to end of data.'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'End trace (-ne) exceeds the data limits.'
         write(LER,*)'Resetting to end of data.'
        endif

        if (nrst .gt. nrec .or. nrst .lt. 1) then
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'start record (-rs) exceeds the data limits'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'start record (-rs) exceeds the data limits'
        endif

        if (nred .gt. nrec .or. nred .lt. 1) then
         write(LERR,*)'program: editt  WARNING'
         write(LERR,*)'End record (-re) exceeds the data limits.'
         write(LERR,*)'Resetting to end of data.'
         write(LER,*)'program: editt  WARNING'
         write(LER,*)'End record (-re) exceeds the data limits.'
         write(LER,*)'Resetting to end of data.'
        endif


c------------------------------
c  save key line header values
c------------------------------
       iform = 3
       call savew( itr, 'NumTrc', ntr  , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)
       call savew( itr, 'SmpInt', nsi  , LINHED)
       call savew( itr, 'NumSmp', nsampo, LINHED)
       call savew( itr, 'Format', iform , LINHED)
       call savhlh( itr, lbytes, lbyout)

      obytes = SZTRHD + SZSMPD * nsampo
      CALL WRTAPE ( LUOUT, ITR, LBYout )

      alloc_size = obytes
      if (nsamp .gt. nsampo) alloc_size = SZTRHD + SZSMPD * nsamp
      errcod = 0
      call grealloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'EDITT ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 101
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) alloc_size,' bytes requested '
      endif

      alloc_size = obytes - SZTRHD
      call galloc(mem_xtr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'EDITT ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 101
      else
	write(LERR,*) alloc_size,' bytes requested '
      endif

      call galloc(mem_work,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'EDITT ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 101
      else
	write(LERR,*) alloc_size,' bytes requested '
      endif

C**********************************************************************C
C     select portion of data set & write out
C**********************************************************************C
      ktr = 0
      mtr = 0
      jtr = 0
      ic  = 0

      IF (.not.pass .AND. .not.match) THEN

c------------------------------------------
c  skip to just before desired record
c------------------------------------------
         if (rfile(1:1) .eq. ' ') then
             call recskp(1,nrst-1,luin,ntrc,itr)
         else
             call recskp(1,recnum(1)-1,luin,ntrc,itr)
         endif

      ENDIF

c*********************************************
c  this part of code assume we`re messing with
c  records ONLY and looking for specific
c RI numbers
c*********************************************

      IF (match) THEN

         line = 1
         if (.not. pass) then

           DO  JJ = 1, nrec
               do  kk = 1, ntrc

                     nbytes = 0
                     CALL RTAPE  ( LUIN , itr, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk
                        go to 999
                     endif
                     call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                           currec , TRACEHEADER)
                     call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           curtrc , TRACEHEADER)
c
c added this to allow original "-F" file to be used on partial dataset
c
		     if (kk .eq. 1) then
		       do while ((currec .ge. recnum(line+1)) .and. 
     1  			(recnum(line+1) .ne. 0))
		         line = line + 1
		       enddo
		     endif

                     if (currec .eq. recnum(line)) then
                        if (kk .eq. ntrc) line = line + 1
                        if( rnum ) then
                            jtr = jtr + insti
                            mtr = mtr + 1
                            if(mtr .gt. ntr) then
                                ktr = ktr + irsti
                                jtr = insti
                                mtr = 1
                            endif
                            call savew2(itr,ifmt_RecNum,l_RecNum,
     1                                  ln_RecNum,ktr+irst, TRACEHEADER)
                            call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                  ln_TrcNum,jtr+inst, TRACEHEADER)
                        endif
                        call wrtape (luout, itr, nbytes)
                     endif
               enddo
           ENDDO

         else

           DO  JJ = 1, nrec
               do  kk = 1, ntrc

                     nbytes = 0
                     CALL RTAPE  ( LUIN , itr, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk
                        go to 999
                     endif
                     call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                           currec , TRACEHEADER)
                     call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           curtrc , TRACEHEADER)
c
c added this to allow original "-F" file to be used on partial dataset
c
		     if (kk .eq. 1) then
		       do while ((currec .ge. recnum(line+1)) .and. 
     1  			(recnum(line+1) .ne. 0))
		         line = line + 1
		       enddo
		     endif

                     if (currec .ne. recnum(line)) then
                        if( rnum ) then
                            jtr = jtr + insti
                            mtr = mtr + 1
                            if(mtr .gt. ntr) then
                                ktr = ktr + irsti
                                jtr = insti
                                mtr = 1
                            endif
                            call savew2(itr,ifmt_RecNum,l_RecNum,
     1                                  ln_RecNum,ktr+irst, TRACEHEADER)
                            call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                  ln_TrcNum,jtr+inst, TRACEHEADER)
                        endif
                        call wrtape (luout, itr, nbytes)
                     elseif (currec .eq. recnum(line)) then
                        if (kk .eq. ntrc) line = line + 1
                     endif
               enddo
           ENDDO

         endif

             
         go to 999
      ENDIF
c*********************************************
c  this part of code assume we`re messing with
c  records ONLY.
c*********************************************

      IF (large) THEN

         irn = 1
         
         DO  JR = NRST, NRED, rdel

             IF (.not.pass) THEN
                if (rfile(1:1) .eq. ' ') then
                    JJ = JR
                else
                    JJ = recnum(irn)
                    if (JJ .eq. 0) go to 999
                endif
             ELSE
                    JJ = JR
             ENDIF
             jjl = JJ

             do  KK = 1, ntrc

                   nbytes = 0
                   CALL RTAPE  ( LUIN , itr, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                         currec , TRACEHEADER)
                   call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         curtrc , TRACEHEADER)
 
                        krec = currec
                        call vmov(itr(ITHWP1+ist-1),sdel,work,1,nsampo)
                        call vmov(work,1,itr(ITHWP1),1,nsampo)
                        if(verbos) then
                           write(LERR,*)'JJ= ',jj,' kk= ',kk,
     1                                '  Input Record ',currec,
     2                                ' Trace ',curtrc
                        endif
 
                        IF (pass) THEN
                           if (JR .eq. recnum(irn)) then
                              write(LERR,*)'Skipping record ',JR,
     1                                     ' trace ',KK
                              if (KK .eq. ntrc) then
                                 irn = irn + 1
                              endif
                           else
                              if( rnum ) then
                                  jtr = jtr + insti
                                  mtr = mtr + 1
                                  if(mtr .gt. ntr) then
                                      ktr = ktr + irsti
                                      jtr = insti
                                      mtr = 1
                                  endif
                                  call savew2(itr,ifmt_RecNum,l_RecNum,
     1                                        ln_RecNum,ktr+irst, 1)
                                  call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                        ln_TrcNum,jtr+inst, 1)
                              endif
                              call wrtape(luout,itr,obytes)
                           endif
                        ELSE
                           if (rfile(1:1) .eq. ' ') then
                              if( rnum ) then
                                  jtr = jtr + insti
                                  mtr = mtr + 1
                                  if(mtr .gt. ntr) then
                                      ktr = ktr + irsti
                                      jtr = insti
                                      mtr = 1
                                  endif
                                  call savew2(itr,ifmt_RecNum,l_RecNum,
     1                                        ln_RecNum,ktr+irst, 1)
                                  call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                        ln_TrcNum,jtr+inst, 1)
                              endif
                              call wrtape(luout,itr,obytes)
                           else
c                             if (JR .eq. recnum(irn)) then
                                 if (KK .eq. ntrc) then
                                    irn = irn + 1
                                 endif
                                 if (verbos)
     1                           write(LERR,*)'Writing record ',JR,
     2                                     currec,' trace ',KK,
     3                                     ' irn= ',irn,recnum(irn)
                                 if( rnum ) then
                                     jtr = jtr + insti
                                     mtr = mtr + 1
                                     if(mtr .gt. ntr) then
                                         ktr = ktr + irsti
                                         jtr = insti
                                         mtr = 1
                                     endif
                                     call savew2(itr,ifmt_RecNum,
     1                               l_RecNum,ln_RecNum,ktr+irst, 1)
                                     call savew2(itr,ifmt_TrcNum,
     1                               l_TrcNum,ln_TrcNum,jtr+inst, 1)
                                 endif
                                 call wrtape(luout,itr,obytes)
                                 if (irn .gt. nreccr) go to 999
c                             endif
                           endif
                        ENDIF

             enddo

c------------------------------------
c  skip every rdel-1 records
c  but only if we're SELECTing records    '
c------------------------------------
             IF (.not. pass) THEN

                IF (rfile(1:1) .eq. ' ') THEN
                   jjn = jj + rdel
                   ioff = (jjn - 1) * ntrc + 1

                   if(rdel.gt.0.and.rdel.ne.1)then

                      call recskp(jjl+1,jjn-1,luin,ntrc,itr)

                   elseif(rdel.lt.0)then

                      call recskp(jjl+1,jjn,luin,ntrc,itr)

                   endif

                ELSE
                   jjn  = recnum(irn)
                   ioff = (jjn - 1) * ntrc + 1

c
c ----- do not skip on input if next record required is next sequential record ----
c

               if(((jjl+1)-(jjn-1)).gt.0.and.((jjl+1)-(jjn-1)).ne.1)then

                      call recskp(jjl+1,jjn,luin,ntrc,itr)

                   elseif(((jjl+1)-(jjn-1)).le.0)then

                      call recskp(jjl+1,jjn-1,luin,ntrc,itr)
                      
                   endif

                ENDIF

             ENDIF

         ENDDO

         go to 999

      ENDIF

c*********************************************
c  this part of code assumes SMALL buffering
c  on input, i.e. this is the general trace
c  selection option - anything goes
c*********************************************

      irn = 1

      DO 100 JR = NRST, NRED, rdel

                if (rfile(1:1) .eq. ' ') then
                    JJ = JR
                else
                    if (pass) then
                       if (recnum(irn) .ne. 0)  then
                          JJ = recnum(irn)
                       else
                          JJ = JR
                       endif
                    else
                       JJ =  recnum(irn)
                       if (JJ .eq. 0) go to 999
                    endif
                endif
                
c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,nst-1,luin,ntrc,itr)

             DO 99 KK = NST, NED, tdel
 
                   nbytes = 0
                   CALL RTAPE  ( LUIN , itr, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                         currec , TRACEHEADER)
                   call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         curtrc , TRACEHEADER)
 

                        call saver2(itr,ifmt_hdrwrd,l_hdrwrd,
     1                              ln_hdrwrd, krec   , TRACEHEADER)
                        call vmov(itr(ITHWP1+ist-1),sdel,work,1,nsampo)
                        call vmov(work,1,itr(ITHWP1),1,nsampo)
                        if(verbos) then
                           write(LERR,*)'JJ= ',jj,' kk= ',kk,
     1                                '  Input Record ',currec,
     2                                ' Trace ',curtrc
                        endif

                        IF (pass) THEN
                           if (JR .eq. recnum(irn)) then
                              write(LERR,*)'Skipping record ',JR,
     1                                     ' trace ',KK
                              if (KK .eq. ned) irn = irn + 1
                           else
                                 if( rnum ) then
                                     jtr = jtr + insti
                                     mtr = mtr + 1
                                     if(mtr .gt. ntr) then
                                         ktr = ktr + irsti
                                         jtr = insti
                                         mtr = 1
                                     endif
                                     call savew2(itr,ifmt_RecNum,
     1                               l_RecNum,ln_RecNum,ktr+irst, 1)
                                     call savew2(itr,ifmt_TrcNum,
     1                               l_TrcNum,ln_TrcNum,jtr+inst, 1)
                                 endif
                              call wrtape(luout,itr,obytes)
                           endif
                        ELSE
                           if (rfile(1:1) .eq. ' ') then
                              if( rnum ) then
                                  jtr = jtr + insti
                                  mtr = mtr + 1
                                  if(mtr .gt. ntr) then
                                      ktr = ktr + irsti
                                      jtr = insti
                                      mtr = 1
                                  endif
                                  call savew2(itr,ifmt_RecNum,l_RecNum,
     1                                        ln_RecNum,ktr+irst, 1)
                                  call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                                        ln_TrcNum,jtr+inst, 1)
                              endif
                              call wrtape(luout,itr,obytes)
                           else
                              if (JR .eq. recnum(irn)) then
                                 if (KK .eq. ned) irn = irn + 1
                                 if (verbos)
     1                           write(LERR,*)'Writing record ',JR,
     2                                     itr(l_RecNum),' trace ',KK,
     3                                     ' irn= ',irn
                                 if( rnum ) then
                                     jtr = jtr + insti
                                     mtr = mtr + 1
                                     if(mtr .gt. ntr) then
                                         ktr = ktr + irsti
                                         jtr = insti
                                         mtr = 1
                                     endif
                                     call savew2(itr,ifmt_RecNum,
     1                               l_RecNum,ln_RecNum,ktr+irst, 1)
                                     call savew2(itr,ifmt_TrcNum,
     1                               l_TrcNum,ln_TrcNum,jtr+inst, 1)
                                 endif
                                 call wrtape(luout,itr,obytes)
                                 if (irn .gt. nreccr) go to 999
                              endif
                           endif
                        ENDIF

c------------------------------------
c  skip every tdel-1 traces
c------------------------------------
               if (tdel .gt. 0) then
                  ks = kk
                  ke = kk + tdel - 1
                  if (ke .gt. ned) ke = ned
                  call trcskp(jj,ks+1,ke,luin,ntrc,itr)
               else
                  ks = kk
                  ke = kk + tdel - 1
                  if (ke .lt. 0) ke = 0
                  call trcskp(jj,ks-1,ke,luin,ntrc,itr)
               endif

   99        CONTINUE

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,ke+1,ntrc,luin,ntrc,itr)

c------------------------------------
c  skip every rdel-1 records
c------------------------------------
             IF (rfile(1:1) .eq. ' ') THEN
                if (rdel .gt. 0) then
                    call recskp(jj+1,jj+rdel-1,luin,ntrc,itr)
                else
                    call recskp(jj+1,jj+rdel,  luin,ntrc,itr)
                endif
             ENDIF

  100 CONTINUE


  999 continue

      if(left .ne. 0) then
c------------------------------------------------------
c  after renumbering there may be an incomplete record
c------------------------------------------------------

          call vclr(xtr,1,nsampo)
          call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                krec   , TRACEHEADER)
          call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                30000  , TRACEHEADER)
          do j=1,left
              jtr = jtr + insti
              call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    jtr    , TRACEHEADER)
              if(verbos) then
                 write(LERR,*)'Output Record ',currec,
     1            ' Null Trace ',curtrc
              endif
              call wrtape(luout,itr,obytes)
          enddo
      endif

      IF (EOF) THEN
c if -EOF is flagged then make sure to run through to end of 
c input data which is mainly for IKP compatibility
          do  i = 1, ntrc*nrec
              call rtape (luin, itr, nbytes)
              if (nbytes .eq. 0) go to 9999
          enddo
      ENDIF
9999  continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for EDITT: data set edit'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- start time                   (0 ms)'
        write(LER,*)'-S0[sdel]  -- grab every sdel samples       ( 1 )'
        write(LER,*)'-e[iend]   -- end time                (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
        write(LER,*)'-T0[tdel]  -- do every tdel trace           ( 1 )'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-R0[rdel]  -- do every rdel records         ( 1 )'
        write(LER,*)'-t[irst]   -- starting output rec #         ( 1 )'
        write(LER,*)'-ti[irsti] -- increment output rec #        ( 1 )'
        write(LER,*)'-u[inst]   -- starting output trc #         ( 1 )'
        write(LER,*)'-ui[insti] -- increment output trc #        ( 1 )'
        write(LER,*)'-l[new]    -- new output traces/recorde   ( old )'
        write(LER,*)'-F[rfile]  -- optional file of rec numbers to get'
        write(LER,*)'-hw[hdrwd] -- header word to use in rfile (RecNum)'
        write(LER,*)'-match     -- match recs in [rfile] with trc hdrs'
        write(LER,*)'              i.e. actual rec# not sequential'
        write(LER,*)'-U         -- if present, renumber trcs & recs'
        write(LER,*)'-P         -- pass all recs except in -F[rfile]'
        write(LER,*)'-EOF       -- force editt to read to end of data'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)'editt -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
        write(LER,*)'      -re[] -T0[] -R0[] -t[] -u[] -ui[] -l[] ili[]'
        write(LER,*)'      -F[] [-match -F[] -hw[] -U -P -EOF -V]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                  tdel,rdel,irst,new,rnum,verbos,rfile,pass,
     2                  sdel,match,EOF,hdrwrd,inst,irsti,insti)
c-----
c     get command arguments
c
c     ntap  - C*512     input file name
c     otap  - C*512     output file name
c      ist  - I         start time 
c     iend  - I         end time 
c      nst  - I         start trace
c      ned  - I         end trace
c     nrst  - I         start record
c     nred  - I         end record
c     tdel  - I         do every tdel trace
c     rdel  - I         do every rdel record
c     irst  - I         start renumbering at...
c     rnum  - L         if true, rnumber recs & traces
c     pass  - L         pass all recs except in rfile
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), rfile*(*), hdrwrd * 6
      integer   argis,ist,iend,nst,ned,nrst,nred,irst,new,rdel,tdel
      integer   sdel, inst
      logical   rnum,verbos,pass, match, EOF

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argstr('-F',rfile,' ',' ')
           call argstr('-hw',hdrwrd,'RecNum','RecNum')
           call argi4('-s',ist,0,0) 
           call argi4('-e',iend,0,0) 
           call argi4('-ns',nst,0,0)
           call argi4('-ne',ned,0,0)
           call argi4('-T0',tdel,1,1)
           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)
           call argi4('-R0',rdel,1,1)
           call argi4('-ti',irsti,1,1)
           call argi4('-t',irst,1,1)
           call argi4('-ui',insti,1,1)
           call argi4('-u',inst,1,1)
           inst = inst - insti
           call argi4('-l',new,0,0)
           call argi4('-S0',sdel,1,1)
           match  = ( argis( '-match' ) .gt. 0 )
           rnum   = ( argis( '-U' ) .gt. 0 )
           pass   = ( argis( '-P' ) .gt. 0 )
           EOF    = ( argis( '-EOF' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

           if (match .AND. rfile(1:1) .eq. ' ') then
                 write(LERR,*)'FATAL HEART ATTACK in editt:'
                 write(LERR,*)'must have a file of rec #s for -match'
                 write(LER ,*)'FATAL HEART ATTACK in editt:'
                 write(LER ,*)'must have a file of rec #s for -match'
              stop
           endif

           if (ntap(1:1) .eq. ' ') then
              if ( tdel .lt. 0) then
                 write(LERR,*)'FATAL HEART ATTACK in editt:'
                 write(LERR,*)'Cannot access traces backwards in pipe'
                 write(LERR,*)'Output input data onto a disk file &'
                 write(LERR,*)'rerun with named input file, -N[]'
                 stop
              endif
              if ( rdel .lt. 0) then
                 write(LERR,*)'FATAL HEART ATTACK in editt:'
                 write(LERR,*)'Cannot access records backwards in pipe'
                 write(LERR,*)'Output input data onto a disk file &'
                 write(LERR,*)'rerun with named input file, -N[]'
                 stop
              endif
           endif

           if (pass) then
              if (rfile(1:1) .eq. ' ') then
                 write(LERR,*)'For pass option you must specify file of'
                 write(LERR,*)'sequential record numbers using -F[] cmd'
                 write(LERR,*)'line argument.  Re-run using this'
                 stop
              endif
           endif

           if (rfile(1:1) .ne. ' ') then
             open(unit=ludisk, file=rfile, status='old', iostat=ierr)
             if(ierr .ne. 0) then
                write(LERR,*)'Could not open record numbers file'
                write(LERR,*)'Check existence'
                stop
             endif
           endif
c-----
      return
      end

