C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c routine to retrieve and verify XSD header and segment info.
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
      subroutine XSDInit ( ptap, lupick, verbose,
     :     XSDSampleUnits, XSDTraceUnits, XSDRecordUnits,
     :     XSDSampleOffset, XSDTraceOffset, XSDRecordOffset,
     :     XSDnsmp, XSDntrc, XSDnrec, XSDNumSeg, XSDMaxPicks, errcd)
 
#include <f77/iounit.h>
 
c arguments from calling routine
      integer   lupick, errcd
      integer   XSDnsmp, XSDntrc, XSDnrec, XSDNumSeg, XSDMaxPicks
 
      real      XSDSampleUnits, XSDTraceUnits, XSDRecordUnits
      real      XSDSampleOffset, XSDTraceOffset, XSDRecordOffset
 
      logical   verbose
 
      character ptap*(*)
 
 
c internal subroutine variables
      integer   LineCount, PickCount, MaxPickCount, SegmentCount
      integer   SegHdrLine
      integer   SegNum, SegColor, SegPicks
      integer   NewSegNum, NewSegColor, NewSegPicks
 
      character SegName*21, NewSegName*21, card*80
 
 
c initialize a few variables
      LineCount    = 0
      PickCount    = 0
      MaxPickCount = 0
      SegmentCount = 0
      SegHdrLine   = 2
 
 
c define xsd formats
 100  format ( 6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :         8x,f12.6,1x,f12.6,1x,f12.6,7x,i5,1x,i5 )
 101  format ( 10x,i5,6x,a21,8x,i5,9x,i5 )
 102  format ( f12.6,1x,f12.6,1x,f12.6 )
 
 
c read pick file header.
      read ( lupick, 100, err = 910 , end = 920 )
     :       XSDRecordUnits, XSDTraceUnits, XSDSampleUnits,
     :       XSDnrec, XSDntrc, XSDnsmp,
     :       XSDRecordOffset, XSDTraceOffset, XSDSampleOffset,
     :       XSDNumSeg, XSDMaxPicks
      LineCount = LineCount + 1

 
c Scan to verify XSDNumSeg, XSDMaxPicks and picks per seg
      do while (1 .eq. 1)
 
        read(lupick, '(a80)', err=930, end = 900) card
        LineCount = LineCount + 1
        PickCount = LineCount-SegHdrLine
 
        if ( card(1:1) .eq. 'S' ) then
 
          SegmentCount = SegmentCount + 1
          PickCount = PickCount-1
 
          read(card, 101, err=940, end = 900)
     :       NewSegNum,NewSegName,NewSegColor,NewSegPicks
 
          if (verbose .and. SegHdrLine .eq. 2) then
            write(LERR,*)
     :      'Segment ',SegNum,' reports ',SegPicks,
     :      ' picks.  Count is ',PickCount
          endif
 
          SegNum   = NewSegNum
          SegName  = NewSegName
          SegColor = NewSegColor
          SegPicks = NewSegPicks
 
          SegHdrLine   = Linecount
          MaxPickCount = max(MaxPickCount,PickCount)
 
        endif
 
      enddo
 
c***********************************************************************
c Stopping conditions
c***********************************************************************
 900  continue
      errcd=0
 
      if (verbose) then
        write(LERR,*)'  '
        write(LERR,*)
     :     'File ',ptap(1:nblen(ptap)),' reports: '
        write(LERR,*)'     ',
     :     XSDNumSeg,' segments.  Count is ',SementCount
        write(LERR,*)'     ',
     :     XSDMaxPicks,' Max picks per segment.  Count is ',MaxPickCount
        write(LERR,*)'  '
      endif
 
      MaxPickCount = max(MaxPickCount,PickCount)
      XSDMaxPicks  = MaxPickCount
      XSDNumSeg    = SegmentCount
 
      rewind (lupick)
      return
 
 910  continue
      errcd=1
      write(LER,*)'FATAL error reading XSD header from file ',ptap
      return
 
 920  continue
      errcd=2
      write(LER,*)
     :   'XsdInit: End of file encountered in XSD file ',ptap,
     :   ' while trying to read header card.  --  FATAL.'
      return
 
 930  continue
      errcd=3
      write(LER,*)
     :   'Error reading XSD file ',ptap,
     :   ' at line ', LineCount+1
      return
 
 940  continue
      errcd=4
      write(LER,*)
     :   'Error interpreting line ',LineCount,' in XSD file ',ptap
      return
      end
