C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c Determines the maximum number of traces traversed by any segment
c in an XSD pick file.
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
      subroutine XsdPolyLength( ptap, luptap, Max_X_Length )
 
#include <f77/iounit.h>
 
c arguments from calling routine
      integer   luptap
      real      Max_X_Length
 
      character ptap*(*)
 
c internal subroutine variables
      integer   nsmp, ntrc, nrec, LineCount, PickCount
      real      Sunits, Tunits, Runits
      real      Soffset, Toffset, Roffset
      real      rec, trc, smp, trc_hold, FirstX
      real      Seg_X_Length
 
      character card*80
 
c define xsd formats
 100  format ( 6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :         8x,f12.6,1x,f12.6,1x,f12.6,7x,i5,1x,i5 )
 101  format ( 10x,i5,6x,a21,8x,i5,9x,i5 )
 102  format ( f12.6,1x,f12.6,1x,f12.6 )

c assign some initial values
      LineCount = 0
      PickCount = 0
      Max_X_Length = 0.0
      Seg_X_Length = 0.0
      trc_hold = 0.0
      FirstX   = 0.0
 
c read pick file header.
      read ( luptap, 100, err=910, end=920 )
     :       Runits, Tunits, Sunits,
     :       nrec, ntrc, nsmp,
     :       Roffset, Toffset, Soffset,
     :       NumSeg, MaxPicks
      LineCount = LineCount + 1


c Read the segment(s) and accumulate the trace traverse distance
      do while (1 .eq. 1)
 
        read(luptap, '(a80)', err=930, end=900) card
        LineCount = LineCount + 1

        if ( card(1:1) .eq. 'S' ) then
          Seg_X_Length = Seg_X_Length + abs (trc_hold-FirstX)
          Max_X_Length = max(Max_X_Length,Seg_X_Length)
          Seg_X_Length = 0.0
          PickCount = 0
        else
          read( card, 102, err=940) rec,trc,smp
          PickCount = PickCount + 1
          if (PickCount .eq. 1) FirstX = trc
          if (PickCount .gt. 1) then
            Seg_X_Length = Seg_X_Length + abs (trc_hold-trc)
          endif
          trc_hold = trc
        endif
 
      enddo
 
 
c***********************************************************************
c Stopping conditions
c***********************************************************************
 900  continue
      errcd = 0
      Seg_X_Length = Seg_X_Length + abs (trc_hold-FirstX)
      Max_X_Length = max(Max_X_Length,Seg_X_Length)
      rewind (luptap)
      return
 
 910  continue
      errcd = 1
      write(LER,*)'FATAL error reading XSD header from file ',ptap
      return
 
 920  continue
      errcd = 2
      write(LER,*)
     :   'XsdReadPicks: End of file encountered in XSD file ',ptap,
     :   ' while trying to read header card.  --  FATAL.'
      return
 
 930  continue
      errcd = 3
      write(LER,*)
     :   'Error reading XSD file ',ptap,
     :   ' at line ', LineCount+1
      return
 
 940  continue
      errcd = 1
      write(LER,*)
     :   'Error interpreting line ',LineCount,' in XSD file ',ptap
      return
      end
