C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c Read XSD pick file into 3 vectors whose size is already known
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
      subroutine XsdReadPicks( ptap, luptap, rec, trc, smp,
     :                         NumSegs, MaxPicks, Flag, errcd)
 
 
c#include <f77/iounit.h>
 
c arguments from calling routine
      integer   luptap, NumSeg, MaxPicks, errcd
 
      real      rec(MaxPicks,NumSegs)
      real      trc(MaxPicks,NumSegs)
      real      smp(MaxPicks,NumSegs)
      real      Flag
 
      character ptap*(*)
 
 
c internal subroutine variables
      integer   nsmp, ntrc, nrec
      real      Sunits, Tunits, Runits
      real      Soffset, Toffset, Roffset
 
      integer   PickNum, SegNum, LineCount, XSDMaxPicks
 
      character card*80
 
 
c define xsd formats
 100  format ( 6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :         8x,f12.6,1x,f12.6,1x,f12.6,7x,i5,1x,i5 )
 101  format ( 10x,i5,6x,a21,8x,i5,9x,i5 )
 102  format ( f12.6,1x,f12.6,1x,f12.6 )
 
 
c initialize rec(), trc(), smp() and LineCount
      LineCount = 0
      do j=1,NumSegs
        do i= 1,MaxPicks
          rec(i,j) = Flag
          trc(i,j) = Flag
          smp(i,j) = Flag
        enddo
      enddo
 
 
c read pick file header.
      read ( luptap, 100, err=910, end=920 )
     :       Runits, Tunits, Sunits,
     :       nrec, ntrc, nsmp,
     :       Roffset, Toffset, Soffset,
     :       NumSeg, XSDMaxPicks
      LineCount = LineCount + 1

c      write(LERR,*)' '
c      write(LERR,*)'XSD PICK FILE:'
c      write(LERR,*)' '
c      write(LERR,100)
c     :       Runits, Tunits, Sunits,
c     :       nrec, ntrc, nsmp,
c     :       Roffset, Toffset, Soffset,
c     :       NumSeg, MaxPicks

 
 
c Read the segment(s) into the appropriate vectors
      SegNum  = 0
      do while (1 .eq. 1)
 
        read(luptap, '(a80)', err=930, end=900) card
c        write(LERR,'(a80)')card
        LineCount = LineCount + 1
        PickNum = PickNum + 1
 
        if ( card(1:1) .eq. 'S' ) then
 
          SegNum  = SegNum + 1
          PickNum = 0
 
        else
 
          read( card, 102, err=940) rec(PickNum,SegNum),
     :      trc(PickNum,SegNum), smp(PickNum,SegNum)
 
        endif
 
      enddo
 
 
c***********************************************************************
c Stopping conditions
c***********************************************************************
 900  continue
      errcd = 0
      rewind (luptap)
      return
 
 910  continue
      errcd = 1
      write(LER,*)'FATAL error reading XSD header from file ',ptap
      return
 
 920  continue
      errcd = 2
      write(LER,*)
     :   'XsdReadPicks: End of file encountered in XSD file ',ptap,
     :   ' while trying to read header card.  --  FATAL.'
      return
 
 930  continue
      errcd = 3
      write(LER,*)
     :   'Error reading XSD file ',ptap,
     :   ' at line ', LineCount+1
      return
 
 940  continue
      errcd = 1
      write(LER,*)
     :   'Error interpreting line ',LineCount,' in XSD file ',ptap
      return
      end
