C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c Resample XSD picks with linear interpolation
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c      call XsdRsampPicks
c     :       ( XSD_smp, XSD_trc, Segz_tmp, Segx_tmp,
c     :         XSD_NumSegs, XSD_MaxPicks, nxt_seg, Flag,
c     :         XSD_SmpOffset, XSD_nsmp, XSD_SmpUnits,
c     :         XSD_TrcOffset, XSD_ntrc, XSD_TrcUnits,
c     :         0.0, nzt, dzt, 0.0, nxt, dxt)

      subroutine XsdRsampPicks(
     :               z, x, z_out, x_out,
     :               nseg, maxpicks, nx_seg, Flag,
     :               z1i,nzi,dzi,
     :               x1i,nxi,dxi,
     :               z1o,nzo,dzo, x1o,nxo,dxo)
 
 
c declare variables passed from calling routine
      integer   nseg, maxpicks, nzi, nzo, nxi, nxo, nx_seg
      real      z1i, dzi, z1o, dzo, x1i, dxi, x1o, dxo
      real      z(maxpicks,nseg), x(maxpicks,nseg)
      real      z_out(nx_seg,nseg), x_out(nx_seg,nseg)
      real      Flag
 
c declare local variables
      integer   icount
      real      delta_z, delta_x, dx_interp, x_step, slope, bias
      real      z_last, z_here, z_next, x_last, x_here, x_next
 
c first fill the output vectors with the value Flag
      call vfill (Flag,z_out,1,nx_seg*nseg)
      call vfill (Flag,x_out,1,nx_seg*nseg)

c next convert the XSD z and x values (sample and trace values) to the
c output coordinate system by shifting the origin and translating to
c output index
      do j = 1,nseg
        do i = 1,maxpicks
          if (z(i,j) .ne. Flag) then
            z(i,j) = (((( z(i,j)-z1i )/dzi -1.) * dzi) / dzo) +1.
            x(i,j) = (((( x(i,j)-x1i )/dxi -1.) * dxi) / dxo) +1.
          endif
        enddo
      enddo
 
c Loop over segments
      do j = 1, nseg
        icount = 0 
 
c     Loop over input points
        do i = 1, maxpicks-1
 
c       only interpolate if this value and next are live
          if( z(i,j) .ne. Flag .and. z(i+1,j) .ne. Flag ) then
 
c         setup local variables
            z_last = z(i,j)
            z_next = z(i+1,j)
            x_last = x(i,j)
            x_next = x(i+1,j)
 
c         get the line parameters
            delta_x= x_next - x_last
            delta_z= z_next - z_last

c         watch out for delta_z = 0.
            if ( delta_z .ne. 0. ) then
              slope = delta_x/delta_z
              bias  = x_last - slope*z_last
 
c           find the first x value for interpolation and the x step
              x_here = float(nint(x_last))
              x_step = sign(1.,delta_x)
              dx_interp = float(nint(x_here - x_last))
 
c           interpolate
              do while ( abs(dx_interp) .lt. abs(delta_x) )
                x_here = x_here + x_step
                z_here = (x_here - bias) / slope
                icount = icount + 1
 
                z_out(icount,j) = z_here
                x_out(icount,j) = x_here
 
                dx_interp = float(nint(x_here - x_last))
              enddo

c         special case when delta_z = 0.
            else
c           find the first x value for interpolation and the x step
              x_here = nint(x_last)
              x_step = sign(1.,delta_x)
              dx_interp = x_here - x_last
 
c           interpolate
              do while ( abs(dx_interp) .lt. abs(delta_x) )
                x_here = x_here + x_step
                z_here = z_last
                icount = icount + 1
 
                z_out(icount,j) = z_here
                x_out(icount,j) = x_here
 
                dx_interp = float(nint(x_here - x_last))
              enddo

            endif
 
          endif
 
        enddo
      enddo
 
      return
      end
