c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c    etch2d A 'etch' xsd horizons into a velocity grid by locally
c             altering the velocities in the neighborhood of the
c             horizons. This is useful for adding reflecting horizons
c             to a finite-difference velocity grid.
c
c    Execute "etch2d -h" for self documentation.
c
c  Program History:
c    Sep 17, 2003 - Changed UsrFlag to emask, removed -noflag stuff,
c                   cleaned up for FreeUSP release, added man page.
c    Prior to 2003 - Unknown
c
c***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
#include "fdds.h"
 
c  Line header declarations
      integer     llhed ( SZLNHD )
      integer * 2 ilhed ( SZLNHD*2 )
      real        rlhed ( SZLNHD )
      equivalence ( ilhed(1), llhed (1), rlhed(1) )
 
c  Trace header declarations
      integer     lthed_in(2), lthed_out(2)
      integer * 2 ithed_in(2), ithed_out(2)
      real        rthed_in(2), rthed_out(2)
 
      pointer     (wk_thed_in,  lthed_in)
      pointer     (wk_thed_in,  ithed_in)
      pointer     (wk_thed_in,  rthed_in)
      pointer     (wk_thed_out, lthed_out)
      pointer     (wk_thed_out, ithed_out)
      pointer     (wk_thed_out, rthed_out)
 
c  Trace header and data declarations
      integer     itr_in, itr_out
      real        Samples_in, Samples_out
 
      pointer     (wk_itr_in,      itr_in(2))
      pointer     (wk_itr_out,     itr_out(2))
      pointer     (wk_Samples_in,  Samples_in(2))
      pointer     (wk_Samples_out, Samples_out(2))
 
c  2D grid array declarations
      real      Record_in(2), Record_out(2)
      real      Record_tmp1(2), Record_tmp2(2)
      real      Record_smth(2), Record_mask(2)
 
      pointer     (wk_Record_in,   Record_in)
      pointer     (wk_Record_out,  Record_out)
      pointer     (wk_Record_tmp1, Record_tmp1)
      pointer     (wk_Record_tmp2, Record_tmp2)
      pointer     (wk_Record_smth, Record_smth)
      pointer     (wk_Record_mask, Record_mask)
 
c  XSD segment vector declarations
      real      XSD_rec(2), XSD_trc(2), XSD_smp(2)
      real      Segx_tmp(2), Segz_tmp(2)
 
      pointer     (wk_XSD_rec,  XSD_rec)
      pointer     (wk_XSD_trc,  XSD_trc)
      pointer     (wk_XSD_smp,  XSD_smp)
      pointer     (wk_Segx_tmp, Segx_tmp)
      pointer     (wk_Segz_tmp, Segz_tmp)
 
c  Miscelaneous variables
      integer   argis, luin, luout, luptap, lhbytes, nbytes, obytes
      integer   iabort, ierr1, ierr2, ierr3, ierr4, ierr5, ierr6, ierr7
      integer   ierr8, ierr9, ierra, ierrb, ierrc, ierrd, ierre, ierrf
      integer   ierrg, ierrh, ierri, ierrj, ierrk, ierrl
      integer   nsmp, nsi, ntrc, nrec, iform, dz1000, dx1000, dy1000
      integer   nsmptmp, ntrctmp, nsmpout, ntrcout, nrecout
      integer   recnum, trcnum, srcloc, recind, dphind, dstsgn, stacor
      integer   XSD_size, XSD_tmp_size
      integer   Trace_in_size, Trace_out_size, WorkSpace
      integer   Record_in_size, Record_out_size
      integer   Record_tmp1_size, Record_tmp2_size
      integer   nseg, ist1, ist2
      integer   nzi, nzo, nzt, nxi, nxo, nxt, nyi, nyo, nyt, nxt_seg
 
      real      dzi, dzo, dzt, dxi, dxo, dxt, dyi, dyo, dyt
      real      Flag, emask, thckns, scale, bias, zmin, zmax
 
      logical   verbose, lpoly, lmask, average
 
      character ntap*256, otap*256, ptap*256, name*100, getname*100
 
c  XSD variables
      integer   XSD_nsmp, XSD_ntrc, XSD_nrec, XSD_NumSegs, XSD_MaxPicks
      real      XSD_SmpUnits,  XSD_TrcUnits,  XSD_RecUnits
      real      XSD_SmpOffset, XSD_TrcOffset, XSD_RecOffset
      real      MaxSeg_X_Length
 
 
c  Assignments
      data lhbytes /0/, nbytes /0/, Flag /-1.0e+37/
 
 
c***********************************************************************
c
c  EXECUTABLE CODE BEGINS HERE
c
c***********************************************************************
 
      name = getname()
 
c Determine if this run is just for self documentation
      if (argis('-h').gt.0 .or. argis('-?').gt.0 ) then
        call help(name(1:nblen(name)))
        stop
      endif
 
 
c Not just for self-doc, so open printout files in preparation
#include <f77/open.h>
 
c Scan the command line for arguments
      call gcmdln(name(1:nblen(name)),ntap,otap,ptap,dzi,dxi,dzo,dxo,
     :                 emask,scale,bias,thckns,zmin,zmax,
     :                 lmask,lpoly,average,verbose)
 
c Get logical unit numbers for i/o and open them
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      call alloclun(luptap)
      length = lenth(ptap)
      open ( luptap, file=ptap(1:length), status='old', err=991 )
 
c get pickfile coordinate and unit info.
      call XSDInit ( ptap, luptap, verbose,
     :     XSD_SmpUnits,  XSD_TrcUnits,  XSD_RecUnits,
     :     XSD_SmpOffset, XSD_TrcOffset, XSD_RecOffset,
     :     XSD_nsmp, XSD_ntrc, XSD_nrec, XSD_NumSegs, XSD_MaxPicks,
     :     ierr1)
      if (ierr1 .ne. 0) goto 991

c we will need to know the max x distance traversed by any segment
      if (lpoly) then
        XSD_MaxPicks = XSD_MaxPicks + 1
        call XsdPolyLength ( ptap, luptap, MaxSeg_X_Length )
      else
        call XsdLength ( ptap, luptap, MaxSeg_X_Length )
      endif

c convert from xsd file units to 'real world' units
      MaxSeg_X_Length = (MaxSeg_X_Length/XSD_TrcUnits) * dxi
 
c Read the line header from the input grid and get and units info.
      call rtape  (luin, ilhed, lhbytes)
 
c Complain if we can't read the line header.
      if(lhbytes .eq. 0) then
         write(LER ,*) name(1:nblen(name)),
     :   ': no line header read from unit ', luin
         write(LERR,*) name(1:nblen(name)),
     :   ': no line header read from unit ', luin
         write(LER ,*) name(1:nblen(name)), ' FATAL'
         stop
      endif
 
c Extract a few variables from the line header
      call saver(ilhed, 'NumSmp', nsmp , LINEHEADER)
      call saver(ilhed, 'SmpInt', nsi  , LINEHEADER)
      call saver(ilhed, 'NumTrc', ntrc , LINEHEADER)
      call saver(ilhed, 'NumRec', nrec , LINEHEADER)
      call saver(ilhed, 'Format', iform, LINEHEADER)
      call saver(ilhed, 'Dz1000', dz1000, LINEHEADER)
      call saver(ilhed, 'Dx1000', dx1000, LINEHEADER)
      call saver(ilhed, 'Dy1000', dy1000, LINEHEADER)
 
c Compare pickfile values with grid dimensions and report discrepancies
      if (XSD_nsmp .ne. nsmp .or.
     :    XSD_ntrc .ne. ntrc .or.
     :    XSD_nrec .ne. nrec )then
        write(LER ,*) name(1:nblen(name)),
     :   ': Warning - Dimensions of PTAP and NTAP do not agree.'
      endif
 
c Update the historical part of the line header.
      call hlhprt (ilhed, lhbytes, name, nblen(name), LERR)
 
c Inject the current command line into the historical line header
      call savhlh(ilhed,lhbytes,lhbytes)
 
c Modify the line header to be consistent with the number of
c traces that will be output.
      nsmpout = int((float(nsmp)-1.)*dzi / dzo) + 1
      ntrcout = int((float(ntrc)-1.)*dxi / dxo) + 1
      nrecout = nrec
      nsmptmp = nsmpout*3
      ntrctmp = ntrcout*3
      call savew(ilhed, 'NumRec', nrecout , LINEHEADER)
      call savew(ilhed, 'NumTrc', ntrcout , LINEHEADER)
      call savew(ilhed, 'NumSmp', nsmpout , LINEHEADER)
 
c set up internal index variables
      nzi=nsmp
      nxi=ntrc
      nyi=nrec
 
      nzo=nsmpout
      nxo=ntrcout
      nyo=nrecout
 
      nzt=3*nzo - 2
      nxt=3*nxo - 2
      nyt=3*nyo - 2
      dzt=dzo/3.
      dxt=dxo/3.
      dyt=1.

      nxt_seg = int(MaxSeg_X_Length/dxt) + 1
 
c Recalculate the number of output bytes in a trace.
      obytes = SZTRHD + nsmpout * SZSMPD
 
c We've finished modifying the line header; write it out.
      call wrtape ( luout, ilhed, lhbytes  )
 
c Here is an example of how to use savelu to find out the
c offsets of various trace header parameters.
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
 
 
c We have all the info necessary to allocate memory so lets do it
      iabort = 0
      XSD_size       = XSD_NumSegs*XSD_MaxPicks*SZSMPD
      XSD_tmp_size   = XSD_NumSegs*nxt_seg*SZSMPD
      Trace_in_size  = nzi*SZSMPD
      Trace_out_size = nzo*SZSMPD
      Record_in_size  = nzi*nxi*SZSMPD
      Record_out_size = nzo*nxo*SZSMPD
      Record_tmp1_size = nzt*nxi*SZSMPD
      Record_tmp2_size = nzt*nxt*SZSMPD
      WorkSpace =
     :          + 2*XSD_tmp_size + 3*XSD_size
     :          + Record_tmp1_size + 3*Record_tmp2_size
     :          + Record_out_size + Record_in_size
     :          + Trace_out_size + Trace_in_size
     :          + SZTRHD*(Trace_out_size + Trace_in_size)
     :          + SZTRHD*(nxo + nxi)
 
c Allocate space for input and output trace headers.
      call galloc(wk_thed_in, SZTRHD*nxi,ierr1,iabort)
      call galloc(wk_thed_out,SZTRHD*nxo,ierr2,iabort)
 
c Allocate space for input and output traces with a header attached
      call galloc(wk_itr_in, SZTRHD+Trace_in_size ,ierr3,iabort)
      call galloc(wk_itr_out,SZTRHD+Trace_out_size,ierr4,iabort)
 
c Allocate space for input and output data traces, no header
      call galloc(wk_Samples_in, Trace_in_size ,ierr5,iabort)
      call galloc(wk_Samples_out,Trace_out_size,ierr6,iabort)
 
c Allocate space for input, output and tmp records
      call galloc(wk_Record_in,  Record_in_size  ,ierr7,iabort)
      call galloc(wk_Record_out, Record_out_size ,ierr8,iabort)
      call galloc(wk_Record_tmp1,Record_tmp1_size,ierr9,iabort)
      call galloc(wk_Record_tmp2,Record_tmp2_size,ierra,iabort)
      call galloc(wk_Record_smth,Record_tmp2_size,ierrb,iabort)
      call galloc(wk_Record_mask,Record_tmp2_size,ierrc,iabort)
 
c Allocate space for segments
      call galloc(wk_XSD_rec, XSD_size,ierrd,iabort)
      call galloc(wk_XSD_trc, XSD_size,ierre,iabort)
      call galloc(wk_XSD_smp, XSD_size,ierrf,iabort)
      call galloc(wk_Segx_tmp, XSD_tmp_size,ierrg,iabort)
      call galloc(wk_Segz_tmp, XSD_tmp_size,ierrh,iabort)
c      XSD_tmp_size   = XSD_NumSegs*nxt_seg
c      wk_Segx_tmp=fdds_calloc(XSD_tmp_size,SIZEOF_REAL)
c      wk_Segz_tmp=fdds_calloc(XSD_tmp_size,SIZEOF_REAL)
 
      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     :    ierr4 .ne. 0 .or. ierr5 .ne. 0 .or. ierr6 .ne. 0 .or.
     :    ierr7 .ne. 0 .or. ierr8 .ne. 0 .or. ierr9 .ne. 0 .or.
     :    ierra .ne. 0 .or. ierrb .ne. 0 .or. ierrc .ne. 0 .or.
     :    ierrd .ne. 0 .or. ierre .ne. 0 .or. ierrf .ne. 0 .or.
     :    ierrg .ne. 0 .or. ierrh) then
         write(LERR,*)' '
         write(LERR,*) name(1:nblen(name)),
     :   ': Unable to allocate workspace.'
         write(LERR,*) name(1:nblen(name)),': ',WorkSpace,' bytes.'
         write(LER ,*) name(1:nblen(name)),
     :   ': Unable to allocate workspace.'
         write(LER ,*) name(1:nblen(name)),': ',WorkSpace,' bytes.'
         write(LERR,*)' '
         stop
      else
         write(LERR,*)' '
         write(LERR,*) name(1:nblen(name)),': Allocated ',WorkSpace,
     :   ' bytes for workspace.'
         write(LERR,*)' '
      endif
 
 
c initialize all the segment vectors to begin with
      call vfill (Flag,XSD_rec,1,XSD_NumSegs*XSD_MaxPicks)
      call vfill (Flag,XSD_trc,1,XSD_NumSegs*XSD_MaxPicks)
      call vfill (Flag,XSD_smp,1,XSD_NumSegs*XSD_MaxPicks)
      call vfill (Flag,Segx_tmp,1,XSD_NumSegs*nxt_seg)
      call vfill (Flag,Segz_tmp,1,XSD_NumSegs*nxt_seg)
c***********************************************************************
c
c Now we're ready to do some processing
c
c***********************************************************************
 
c First read in the XSD segments
      call XsdReadPicks ( ptap, luptap, XSD_rec, XSD_trc, XSD_smp,
     :         XSD_NumSegs, XSD_MaxPicks, Flag, ierr1)
      if (ierr1 .ne. 0) goto 991
 
c Fix up xsd boundary picks
      call extend_xsd_boundary
     :       (XSD_trc,XSD_smp, XSD_NumSegs,XSD_MaxPicks,
     :        XSD_SmpUnits,XSD_TrcUnits,XSD_SmpOffset,XSD_TrcOffset,
     :        XSD_nsmp,XSD_ntrc, Flag)

c Convert picks to ploygons if requested
      if (lpoly) call XsdToPoly ( XSD_rec, XSD_trc, XSD_smp,
     :                  XSD_NumSegs, XSD_MaxPicks, Flag, ierr1 )
 
 
c Resample the XSD picks onto a regular grid (the tmp grid for now)
      call XsdRsampPicks
     :       ( XSD_smp, XSD_trc, Segz_tmp, Segx_tmp,
     :         XSD_NumSegs, XSD_MaxPicks, nxt_seg, Flag,
     :         XSD_SmpOffset, XSD_nsmp, XSD_SmpUnits,
     :         XSD_TrcOffset, XSD_ntrc, XSD_TrcUnits,
     :         0.0, nzt, XSD_SmpUnits/(dzi/dzt),
     :         0.0, nxt, XSD_TrcUnits/(dxi/dxt))
 

c All done preparing the horizons, move on the the input grid
c loop over input records
      do irecord = 1, nrec
 
c load a record into memory
        itrcount = 0
        do itrace = 1, ntrc
 
          nbytes = 0
          call rtape( luin, itr_in, nbytes)
 
          if(nbytes .eq. 0) then
            write(LERR,*) name(1:nblen(name)),
     :                   ': Unexpected End of file on input,'
            write(LERR,*)'  rec= ',irecord,'  trace= ',itrace
            goto 991
          else
            itrcount = itrcount + 1
          endif
 
          istrc = (itrcount-1) * nsmp
          ishdr = (itrcount-1) * ITRWRD
          call vmov (itr_in(ITHWP1), 1, Record_in(istrc+1), 1, nsmp)
          call vmov (itr_in(1),      1, lthed_in(ishdr+1),  1, ITRWRD)
 
        enddo
 
c resample the input record to the temporary sample increment
        if (lmask) then
          call interp_1d_mask (Record_in,   nzi, nxi, nyi,
     :                         Record_tmp1, nzt, nxi, nyi,
     :                         dzi,dxi,dyi, dzt,dxi,dyi, emask, 'z')
 
          call interp_1d_mask (Record_tmp1, nzt, nxi, nyi,
     :                         Record_tmp2, nzt, nxt, nyt,
     :                         dzt,dxi,dyi, dzt,dxt,dyt, emask, 'x')
        else
          call interp_1d_nomask (Record_in,   nzi, nxi, nyi,
     :                           Record_tmp1, nzt, nxi, nyi,
     :                           dzi,dxi,dyi, dzt,dxi,dyi, 'z')
 
          call interp_1d_nomask (Record_tmp1, nzt, nxi, nyi,
     :                           Record_tmp2, nzt, nxt, nyt,
     :                           dzt,dxi,dyi, dzt,dxt,dyt, 'x')
        endif
 
        if (scale .ne. 1.) then
c make a scale mask from the segments or polygons
          call mask_makr
     :            ('scale', lpoly, Record_mask, nzt,nxt, 1.,1.,1.,1.,
     :             Segz_tmp, Segx_tmp, nxt_seg, XSD_NumSegs,
     :             zmin/dzt, zmax/dzt, scale, bias, thckns/dzt, Flag)
 
c multiply the resampled input record by the mask
          call vmul(Record_tmp2,1,Record_mask,1,Record_tmp2,1,nzt*nxt)

        endif
 
        if (bias .ne. 0.0) then
c make a bias mask from the segments or polygons
          call mask_makr
     :            ('bias', lpoly, Record_mask, nzt,nxt, 1.,1.,1.,1.,
     :             Segz_tmp, Segx_tmp, nxt_seg, XSD_NumSegs,
     :             zmin/dzt, zmax/dzt, scale, bias, thckns/dzt, Flag)
 
c add the mask to the resampled input record
          call vadd(Record_tmp2,1,Record_mask,1,Record_tmp2,1,nzt*nxt)
 
        endif

c average values within polygons if requested
        if (average) then
          call mask_makr
     :            ('bias', lpoly, Record_mask, nzt,nxt, 1.,1.,1.,1.,
     :             Segz_tmp, Segx_tmp, nxt_seg, XSD_NumSegs,
     :             zmin/dzt, zmax/dzt, scale, 1.0, thckns/dzt, Flag)

          call maskave ( Record_mask, nzt*nxt, Record_tmp2 )

        endif
 
c smooth the etched plane
        if ( scale.ne.1.0 .or. bias.ne.0.0 .or. average ) then
          call vrecip(Record_tmp2,1,Record_tmp2,1,nzt*nxt)
          call vsq(Record_tmp2,1,Record_tmp2,1,nzt*nxt)

          call SmoothNF (Record_tmp2, Record_smth, 3,3,1, nzt,nxt,1)

          call vsqrtz(Record_smth,1,0.0,Record_smth,1,nzt*nxt)
          call vrecip(Record_smth,1,Record_smth,1,nzt*nxt)

        else
          call vmov (Record_tmp2, 1, Record_smth, 1, nzt*nxt)

        endif

 
c extract output values from the temp plane
        call decimate ( Record_smth,nzt,nxt,1,
     :                  Record_out,nzo,nxo,1,
     :                  1,1,1, 3,3,1 )
 

c*********************************************************************
c    Now extract single traces from the 2-D output array and
c    write out the data.
c*********************************************************************
        do itrace = 1, ntrcout
 
          istrc = (itrace-1) * nsmpout
          ishdr = (1) * ITRWRD
 
          call savew2(itrhdr,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                irecord,TRACEHEADER)
          call savew2(itrhdr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                itrace,TRACEHEADER)
 
          call vmov (lthed_out(ishdr+1), 1,itr_out(1),     1, ITRWRD)
          call vmov (Record_out(istrc+1),1,itr_out(ITHWP1),1,nsmpout)
 
          call wrtape (luout, itr_out, obytes)
 
        enddo
 
c
c------
 
c------
c
c    End of the loop over gathers (records).
 
      enddo
 
c------
 
  999 continue
 
      call lbclos ( luin )
      call lbclos ( luout )
      close (luptap)
 
      write(LERR,*) name(1:nblen(name)),': Normal  Completion.'
      write(LER ,*) name(1:nblen(name)),': Normal  Completion.'
 
      stop
c
c-----
c
c    A place to jump when bailing out prematurely...

  991 continue
      call lbclos ( luin )
      call lbclos ( luout )
      close (luptap)
 
      write(LERR,*) name(1:nblen(name)),': ABORTED !!'
      write(LER ,*) name(1:nblen(name)),': ABORTED !!'
 
      stop
      end
 

c***********************************************************************
      subroutine help(name)
      character * (*)  name
#include <f77/iounit.h>
 
 
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :name,': program to etch xsd horizons into a 2D velocity grid by'
        write(LER,*)
     :'locally altering the velocities in the neighborhood of the'
        write(LER,*)
     :'horizons. This is useful for adding reflecting horizons to a'
        write(LER,*)
     :'smooth finite-difference velocity grid.'
        write(LER,*)' '
        write(LER,*)
     :'Users can enter the following parameters or let them default.'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]   (default: stdin)  : input data file name'
        write(LER,*)
     :' -O [otap]   (default: stdout) : output data file name'
        write(LER,*)
     :' -P [ptap]   (No default)      : XSD segment file'
        write(LER,*) ' '
        write(LER,*)
     :' -dzi[dzi]   (No default)      : Input sample increment'
        write(LER,*)
     :' -dxi[dxi]   (No default)      : Input trace spacing'
        write(LER,*)
     :' -dzo[dzo]   (default: dzi)    : Output sample incremet'
        write(LER,*)
     :' -dxo[dxo]   (default: dxi)    : Output trace spacing'
        write(LER,*) ' '
        write(LER,*)
     :' -S[scale]   (default:  1.0)   : input velocities are multiplied'
        write(LER,*)
     :'                               : by this scale factor in the'
        write(LER,*)
     :'                               : neighborhood of the xsd segs'
        write(LER,*)
     :' -B[bias]    (default:  0.0)   : this value is added after'
        write(LER,*)
     :'                               : scaling'
        write(LER,*) ' '
        write(LER,*)
     :' -H[thckns]  (default: 25.0)   : vertical thickness of etched'
        write(LER,*)
     :'                               : horizons.'
        write(LER,*) ' '
        write(LER,*)
     :' -zmin[zmin] (default: First)  : Min and Max depths for changes.'
        write(LER,*)
     :' -zmax[zmax] (default: Last)   : Will make horizontal contacts.'
        write(LER,*) ' '
        write(LER,*)
     :' -emask[emask] (default: none) : value of embedded mask - while'
        write(LER,*)
     :'                               : reampling and smoothing, etch2d'
        write(LER,*)
     :'                               : uses operators that avoid grids'
        write(LER,*)
     :'                               : with value emask'
c        write(LER,*)
c     :' -poly                         : xsd segments are really'
c        write(LER,*)
c     :'                               : polygons bounding the regions'
c        write(LER,*)
c     :'                               : regions to be changed'
        write(LER,*) ' '
        write(LER,*)
     :' -V                            : verbose printout'
        write(LER,*) ' '
        write(LER,*)
     :'usage:    etch2d -N[ntap] -O[otap] -P[ptap]'
        write(LER,*)
     :'                 [ -dzi[dzi] -dxi[dxi] -dzo[dzo] -dxo[dxo]'
        write(LER,*)
     :'                   -S[scale] -B[bias] -H[thckns] -emask[emask]'
        write(LER,*)
     :'                   -zmin[zmin] -zmax[zmax] -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
      return
      end
 

c***********************************************************************
      subroutine gcmdln(name,ntap,otap,ptap,dzi,dxi,dzo,dxo,
     :                  emask,scale,bias,thckns,zmin,zmax,
     :                  lmask,lpoly,average,verbose)
c-----
c    Set the following variables:
c
c     ntap       - C*100    input file name
c     otap       - C*100    output file name
c     ptap       - C*100    name of input xsd segment file
c     dzi        - R*4      distance between input traces
c     dxi        - R*4      distance between input samples
c     dzo        - R*4      distance between output traces
c     dxo        - R*4      distance between output samples
c     scale      - R*4      scale value for etching horizons
c     bias       - R*4      add this amount after scaling
c     thckns     - R*4      thickness of horizons to be etched
c     lmask      - L        flag for an imbedded mask in the input grid
c     emask      - R*4      The value of the embedded mask
c     lpoly      - L        xsd segments are closed polygons
c     verbose    - L        verbose output or not
c
c-----
      integer     argis, argfre
      real        dzi, dxi, dzo, dxo, emask, scale, bias
      real        thckns, zmin, zmax
      logical     verbose, lpoly, lmask, average
      character   ntap*(*), otap*(*), ptap*(*), name*(*)
      character   sargvv * 100, args * 100
#include <f77/iounit.h>
 
 
      verbose =   (argis('-V') .gt. 0)
      lpoly   =   (argis('-poly') .gt. 0)
      average =   (argis('-ave') .gt. 0)

      lmask = .false.
      if (findarg('-emask') .gt. 0) then
         lmask = .true.
         call argr4 ('-emask',emask, 4500., 4500.)
      endif
 
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argstr( '-P', ptap, ' ', ' ' )
      call argr4 ( '-dzi', dzi, 0.,  0. )
      call argr4 ( '-dxi', dxi, 0.,  0. )
      call argr4 ( '-dzo', dzo, dzi,  dzi )
      call argr4 ( '-dxo', dxo, dxi,  dxi )
      call argr4 ( '-S', scale, 1., 1. )
      call argr4 ( '-B', bias , 0., 0. )
      call argr4 ( '-H', thckns, 25., 25. )
      call argr4 ( '-zmin', zmin, -1.0e+37, -1.0e+37 )
      call argr4 ( '-zmax', zmax,  1.0e+37,  1.0e+37 )
c
c   Make sure deltas were given.
c
      if (dzi.eq.0. .or. dxi.eq.0. .or.
     :    dzo.eq.0. .or. dxo.eq.0.) then
        write(LER ,*) name,
     :     ': cannot continue without dzi, dxi, dzo, and dxo.'
        write(LER ,*) ' '
        stop
      endif
c
c   PTAP is needed, otherwise this is a no-op.
c
      if (PTAP(1:1) .eq. ' ') then
        write(LER ,*) name,
     :     ': Pickfile name not supplied on the command line.'
        write(LER ,*) name,
     :     ': cannot continue.'
        stop
      endif
c
c
c    It's a good idea to warn the user that arguments they've
c    taken the trouble to list are actually being ignored.
c
 
 50   narg = argfre(0)
      if (narg .gt. 0) then
        args = sargvv(narg)
        write(LER ,*) name,
     :  ': unknown argument "', args(1:nblen(args)),
     :  '" ignored.'
        write(LERR,*) name,
     :  ': unknown argument "', args(1:nblen(args)),
     :  '" ignored.'
        call argeat (narg)
        goto 50
      endif

c
c-----
 
      return
      end
 

c***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,verbose)
c
c-----
c
c     nsamp      - I*4     number of samples in trace
c     nsi        - I*4     sample interval in ms
c     ntrc       - I*4     traces per record
c     nrec       - I*4     number of records per line
c     iform      - I*4     format of data
c     ntap       - C*100   input file name
c     otap       - C*100   output file name
c
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
      logical     verbose
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
            write(LERR,*) ' Verbal  =  ', verbose
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
