C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c If a pick is on the boundary, move it to be 1 delta outside of the
c boundary
c***********************************************************************
      subroutine extend_xsd_boundary
     :       (Segx,Segz, NumSegs,MaxPicks,
     :        dz,dx,offset_z,offset_x,
     :        nz,nx, Flag)
c
      implicit none
c
      integer   NumSegs,MaxPicks,nz,nx
      real      Segx(MaxPicks,NumSegs),Segz(MaxPicks,NumSegs)
      real      dx,dz,offset_x,offset_z, Flag

      integer   iseg,ipik
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------

      do iseg = 1,NumSegs
        do ipik = 1,MaxPicks

          if (Segx(ipik,iseg) .ne. Flag) then
            if (Segx(ipik,iseg) .eq. offset_x+dx ) then
              Segx(ipik,iseg) = offset_x
            elseif (Segx(ipik,iseg) .eq. offset_x+float(nx)*dx) then
              Segx(ipik,iseg) = offset_x + float(nx)*dx + dx
            endif
          endif

          if (Segz(ipik,iseg) .ne. Flag) then
            if (Segz(ipik,iseg) .eq. offset_z+dz ) then
              Segz(ipik,iseg) = offset_z
            elseif (Segz(ipik,iseg) .eq. offset_z+float(nz)*dz) then
              Segz(ipik,iseg) = offset_z + float(nz)*dz + dz
            endif
          endif

        enddo
      enddo

c All done
      return
      end

