C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c
c    This routine does linear interpolation of a course input grid onto
c    a fine output grid. It works on either the z, x or y axis and
c    honors the boundaries of regions filled with an embedded mask.
c
c***********************************************************************
 
      subroutine interp_1d_mask (inrec,nzi,nxi,nyi, outrec,nzo,nxo,nyo,
     :                           dzi,dxi,dyi,dzo,dxo,dyo, emask, axis)
 
      integer   nzi, nxi, nyi, nzo, nxo, nyo
      real      inrec(nzi,nxi,nyi), outrec(nzo,nxo,nyo)
      real      dzi, dxi, dyi, dzo, dxo, dyo
      real      emask
      character axis*(*)
 
      real      work1(50000), work2(50000)

      call vfill ( 999999., work1, 1, 50000 )
      call vfill ( 999999., work2, 1, 50000 )
 
 
c  Select an axis and send pieces to the interpolation subroutine
 
      if (axis .eq. 'z') then
        do k = 1, nyi
          do j = 1, nxi
            call vmov (inrec(1,j,k), 1, work1, 1, nzi)
            call interp_mask (work1, nzi, dzi, work2, nzo, dzo, emask)
            call vmov (work2, 1, outrec(1,j,k), 1, nzo)
          enddo
        enddo
 
      else if (axis .eq. 'x') then
        do k = 1, nyi
          do i = 1, nzi
            call vmov (inrec(i,1,k), nzi, work1, 1, nxi)
            call interp_mask (work1, nxi, dxi, work2, nxo, dxo, emask)
            call vmov (work2, 1, outrec(i,1,k), nzo, nxo)
          enddo
        enddo
 
      else if (axis .eq. 'y') then
        do j = 1, nxi
          do i = 1, nzi
            call vmov (inrec(i,j,1), nzi*nxi, work1, 1, nyi)
            call interp_mask (work1, nyi, dyi, work2, nyo, dyo, emask)
            call vmov (work2, 1, outrec(i,j,1), nzo*nxo, nyo)
          enddo
        enddo
 
      endif
 
      return
      end
 
 
c**********************************************************************
c
c  subroutine for linear interpolation while honoring an embedded mask
c
c**********************************************************************
 
      subroutine interp_mask ( in, nzi, dzi, out, nzo, dzo, emask )
 
      integer nzi, nzo
      real    in(nzi), out(nzo)
      real    dzi, dzo, emask
      integer iz1, iz2
      real    zin1, zin2, zout, w1, w2
 
      zin1 = 0.
      zin2 = dzi
      do i = 1, nzo
        zout = float(i-1) * dzo
        dowhile(zout .gt. zin2)
          zin1 = zin2
          zin2 = zin2 + dzi
        enddo
        iz1 = max( 1, nint(zin1/dzi)+1 )
        iz2 = min( nzi, iz1+1 )
        if ( iz1 .gt. iz2 ) iz1 = iz2
        if ( iz2 .lt. iz1 ) iz2 = iz1
        w1 = abs((zout-zin2)/dzi)
        w2 = abs((zout-zin1)/dzi)
 
        if ( iz1 .eq. iz2 ) then
          out(i) = in(iz1)
        else if ( in(iz1).ne.emask .and. in(iz2).ne.emask ) then
          out(i) = w1*in(iz1) + w2*in(iz2)
        else if ( in(iz1).eq.emask .and. in(iz2).eq.emask ) then
          out(i) = emask
        else if ( in(iz1).ne.emask .and. in(iz2).eq.emask ) then
          if ( w2 .ge. 0.5 ) then
            out(i) = emask
          else
            if ( iz1.gt.1 .and. in(iz1-1).ne.emask ) then
              out(i)=in(iz1)+(in(iz1)-in(iz1-1))
            else
              out(i)=in(iz1)
            endif
          endif
        else if ( in(iz1) .eq. emask .and. in(iz2) .ne. emask ) then
          if ( w1 .gt. 0.5 ) then
            out(i) = emask
          else
            if ( iz2.lt.nzi .and. in(iz2+1).ne.emask ) then
              out(i)=in(iz2)-(in(iz2+1)-in(iz2))
            else
              out(i)=in(iz2)
            endif
          endif
        endif
      enddo
 
      return
      end
