C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c**********************************************************************
c This subroutine makes a mask based on resampled xsd segments.
c**********************************************************************
        subroutine mask_makr
     :             ( mode, lpoly, Mask, nz,nx, dz,dx, z0,x0,
     :               Segz, Segx, nx_seg, NumSegs,
     :               zmin, zmax, scale, bias, thckns, Flag )
 
 
      integer   nz, nx, nx_seg, NumSegs
      real      Mask(nz,nx), Segx(nx_seg,NumSegs), Segz(nx_seg,NumSegs)
      real      dz,dx, z0,x0, zmin,zmax, scale,bias, thckns, Flag

      logical   lpoly
      character*5 mode
 
c Local variables
      integer   izmin, izmax
      real      fill, nofill, chng_sign
 
      logical   no_union
 
      no_union = .true.

 
c fill the mask with 1. or 0.
      if (mode(1:1) .eq. 's') call vfill ( 1.0, Mask, 1, nz*nx )
      if (mode(1:1) .eq. 'b') call vfill ( 0.0, Mask, 1, nz*nx )

c Send the mask to the appropriate mask builder
      if (lpoly) then
        call poly_mask (mode, Mask, nz,nx, dz,dx, z0,x0,
     :                  Segz, Segx, nx_seg, NumSegs,
     :                  scale, bias, Flag )
      else
        call etch_mask (mode, Mask, nz,nx, dz,dx, z0,x0,
     :                  Segz, Segx, nx_seg, NumSegs,
     :                  scale, bias, thckns, Flag )
      endif


c get the proper values for cleaning up the mask
      if (mode(1:1) .eq. 's') then
        fill   = scale
        nofill = 1.0
        chng_sign = sign( 1.,(scale-1.) )
      endif

      if (mode(1:1) .eq. 'b') then
        fill   = bias
        nofill = 0.0
        chng_sign = sign( 1.,bias )
      endif


c Apply depth range limits to the mask
      izmin = nint(max( 1.,zmin/dz ))
      izmax = nint(min( float(nz),zmax/dz ))
      do j = 1,nx
        do i = 1,izmin
          Mask(i,j) = nofill
        enddo
        do i = izmax,nz
          Mask(i,j) = nofill
        enddo
      enddo
 

c limit either max or min value of mask
      if (no_union) then
        if ( chng_sign .lt. 1. ) then
          do j = 1,nx
            do i= 1,nz
              Mask(i,j) = max( Mask(i,j),fill )
            enddo
          enddo
        else if ( chng_sign .gt. 1. ) then
          do j = 1,nx
            do i= 1,nz
              Mask(i,j) = min( Mask(i,j),fill )
            enddo
          enddo
        endif

      endif
 
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c This subroutine makes a mask to etch segments into background field.
c***********************************************************************
      subroutine etch_mask (mode, Mask, nz,nx, dz,dx, z0,x0,
     :               Segz, Segx, nx_seg, NumSegs,
     :               scale, bias, thckns, Flag )
 
 
      integer   nz, nx, nx_seg, NumSegs
      real      Mask(nz,nx), Segx(nx_seg,NumSegs), Segz(nx_seg,NumSegs)
      real      dz,dx, z0,x0, scale,bias, thckns, Flag

      character*5 mode
 
      integer   ix, iz1, iz2, ithckns
      real      fill
 

c First set up the fill value
      if (mode(1:1) .eq. 's') fill = scale
      if (mode(1:1) .eq. 'b') fill = bias

c get horizon thickness in number of samples
      ithckns = nint ( thckns/dz )
 
c loop over segments to insert either the scale factor or the bias
      do k = 1, NumSegs
        do j = 1, nx_seg
          if ( Segx(j,k) .ne. Flag .and.
     :         Segx(j,k) .ge.    1 .and.
     :         Segx(j,k) .le.   nx) then

            ix  = nint( (Segx(j,k)-x0)/dx + 1.)
            iz1 = nint( (Segz(j,k)-z0)/dz + 1.)
            iz2 = iz1+ithckns
            if(iz1 .lt.  1) iz1 = 1
            if(iz2 .gt. nz) iz2 = nz
            if(iz1 .gt. nz) Segz(j,k) = Flag
            if(iz2 .lt.  1) Segz(j,k) = Flag
 
            if(Segz(j,k) .ne. Flag) then
              do iz = iz1,iz2
                Mask(iz,ix) = fill
              enddo
            endif

          endif
 
        enddo
      enddo

      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c This subroutine makes a mask of polygonal regions on a grid.
c***********************************************************************
      subroutine poly_mask (mode, Mask, nz,nx, dz,dx, z0,x0,
     :               Segz, Segx, nx_seg, NumSegs,
     :               scale, bias, Flag )
 
 
      integer   nz, nx, nx_seg, NumSegs
      real      Mask(nz,nx), Segx(nx_seg,NumSegs), Segz(nx_seg,NumSegs)
      real      dz,dx, z0,x0, scale,bias, Flag

      character*5 mode
 
      integer   ix, iz1, iz2, iloc
      real      xmin,xmax,zmin,zmax
      real      fill
 

c First set up the fill value
      if (mode(1:1) .eq. 's') fill = scale
      if (mode(1:1) .eq. 'b') fill = bias

c loop over segments to insert either the scale factor or the bias

c for first cut at this algorithm just do the easy thing:
c   Flag the mask everywhere the polygon touches it
c   Scan the z axis for 1st and 2nd encounter
c   Fill from iz1 to iz2 with mask value
c   Continue scanning at iz2+1

      do k = 1, NumSegs

c   Flag the mask everywhere the polygon touches it
        do j = 1, nx_seg
          if ( Segx(j,k) .ne. Flag ) then
            ix = nint( (Segx(j,k)-x0)/dx + 1.)
            iz = nint( (Segz(j,k)-z0)/dz + 1.)
            iz = min(iz,nz)
            iz = max(iz, 1)
            Mask(iz,ix) = fill
          endif
        enddo

c   Scan the z axis for 1st and 2nd encounter
        call get_index_range (Segz(1,k),izmin,izmax,nx_seg,Flag)
        call get_index_range (Segx(1,k),ixmin,ixmax,nx_seg,Flag)
        do ix = ixmin-1,ixmax+1
          iz1 = 0
          iz2 = 0
          do iz = izmin-1,izmax+1
            if (Mask(iz,ix) .eq. fill) then
              if(iz1 .eq. 0) then
                iz1 = iz
              else
                iz2 = iz
              endif
            endif

c   Fill from iz1 to iz2 with mask value
            if (iz2 .ne. 0) then
              do iiz = iz1+1,iz2-1
                Mask(iiz,ix) = fill
              enddo

c   Reset pointers for continued scanning
              iz1 = 0
              iz2 = 0
            endif

          enddo
        enddo

c Move on to next segment
      enddo

      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c Subroutine to get indices for loops when input vector contains a flag
c***********************************************************************
      subroutine get_index_range (in,imin,imax,nx,Flag)

      integer nx,imin,imax
      real    in(nx), Flag
      real    rmin, rmax

      rmin = 1.0e+37
      rmax = 1.0e-37

      do i = 1,nx
        if ( in(i) .ne. Flag) then
          rmin = min(in(i),rmin)
          rmax = max(in(i),rmax)
        endif
      enddo

      imin = nint(rmin)
      imax = nint(rmax)

      return
      end
