/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

extern void cnt_highlight(Connector *,int);
extern void cnt_drawgrnd(Process *,Connector *);
extern void prc_erase(Process *);
extern void prc_draw(Process *);

void cntedit_setup(Process *p,Connector *c);
void cntedit_setupCB(Widget,XtPointer,XmSelectionBoxCallbackStruct *);
void cntedit_cancelCB(Widget,XtPointer,XtPointer);

Connector *cnt_sel1, *cnt_sel2;
static Connector *c_edit;
static Process *p_edit;

cntlnk_select(XEvent *event)
{
  Connector *c;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  x= evt->x;
  y= evt->y;
  if ((c= cnt_locate(x, y)) == (Connector *) NULL) {
    XDefineCursor(display,top_window,
		  get_cursor(LXC_CCURSOR));
    ikp_err("No connector selected.", NONFATAL);
    if (cnt_sel1 != (Connector *) NULL)
      cnt_highlight(cnt_sel1,1);
    net_op= MAIN_MENU;
    return;
  }
  p= (Process *) c->cnt_process;
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    XDefineCursor(display,top_window,
		  get_cursor(LXC_CCURSOR));
    ikp_err("Cannot link connectors within a running net.", NONFATAL);
    if (cnt_sel1 != (Connector *) NULL)
      cnt_highlight(cnt_sel1,1);
    net_op= MAIN_MENU;
    return;
  }
  if (c->cnt_flags & CNT_FILE) {
    XDefineCursor(display,top_window,
		  get_cursor(LXC_CCURSOR));
    ikp_err("Connector already grounded.", NONFATAL);
    if (cnt_sel1 != (Connector *) NULL)
      cnt_highlight(cnt_sel1,1);
    net_op= MAIN_MENU;
    return;
  }
  if (c->cnt_conn != (Connector *) NULL) {
    XDefineCursor(display,top_window,
		  get_cursor(LXC_CCURSOR));
    ikp_err("Connector already connected.", NONFATAL);
    if (cnt_sel1 != (Connector *) NULL)
      cnt_highlight(cnt_sel1,1);
    net_op= MAIN_MENU;
    return;
  }
  
  if (cnt_sel1 == (Connector *) NULL) {
    cnt_sel1= c;
    cnt_highlight(cnt_sel1,1);
  } else 
    if (cnt_sel2 == (Connector *) NULL) {
      XDefineCursor(display,top_window,
		    get_cursor(LXC_CCURSOR));
      cnt_sel2= c;
      cnt_highlight(cnt_sel1,1);
      cnt_link(cnt_sel1, cnt_sel2);
      net_op= MAIN_MENU;
  }
  return;
}

cntgrnd_select(XEvent *event)
{
  Connector *c;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  void cnt_drawgrnd();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor(LXC_CCURSOR));

  x= evt->x;
  y= evt->y;
  if ((c= cnt_locate(x, y)) == (Connector *) NULL) {
    ikp_err("No connector selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  p= (Process *) c->cnt_process;
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot ground a connector within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (p->prc_flags & PRC_EDITOPEN) {
    ikp_err("Connector process is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  /* connector already grounded or connected to a file */
  if (c->cnt_flags & CNT_FILE) {
    if (net_op == CNT_GRNDNULL) {
      if ((c->cnt_filename != (char *) NULL) && !strcmp(c->cnt_filename, "/dev/null"))
	ikp_err("Connector already grounded.", NONFATAL);
      else {
	cnt_drawgrnd(p, c);
	if (c->cnt_filename != (char *) NULL)
	  free(c->cnt_filename);
	if ((c->cnt_filename= calloc((unsigned) (strlen("/dev/null")+1), sizeof(char))) == (char *) NULL)
	  ikp_err("Memory allocation error.", FATAL);
	(void) strcpy(c->cnt_filename, "/dev/null");
	cnt_drawgrnd(p, c);
      }
    }
    else {
      if ((c->cnt_filename != (char *) NULL) && !strcmp(c->cnt_filename, "/dev/null")) {
	cnt_drawgrnd(p, c);
	free(c->cnt_filename);
	c->cnt_filename= (char *) NULL;
	cnt_drawgrnd(p, c);
	cnt_ground(c);
      }
      else
	ikp_err("Connector already connected to file.", NONFATAL);
    }
    net_op= MAIN_MENU;
    return;
  }
  
  if (c->cnt_conn != (Connector *) NULL) {
    ikp_err("Connector already connected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  cnt_ground(c);
  net_op= MAIN_MENU;
  return;
}

cntulnk_select(XEvent *event)
{
  Connector *c;
  Process *p;
  Net *n;
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor(LXC_CCURSOR));
  x= evt->x;
  y= evt->y;
  if ((c= cnt_locate(x, y)) == (Connector *) NULL) {
    ikp_err("No connector selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  p= (Process *) c->cnt_process;
  n= (Net *) p->prc_net;
  if ((run_net != (Net *) NULL) && (n == run_net)) {
    ikp_err("Cannot unlink connector within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (!(c->cnt_flags & CNT_FILE) && (c->cnt_conn == (Connector *) NULL)) {
    ikp_err("Connector not connected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  cnt_unlink(c);
  if (net_split(n) > 0)
    curr_net= (Net *) NULL;
  else
    curr_net= n;
  net_op= MAIN_MENU;
  return;
}

cntedit_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor(LXC_CCURSOR));

  x= evt->x;
  y= evt->y;
  if ((c_edit= cnt_locate(x, y)) == (Connector *) NULL) {
    ikp_err("No connector selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  p_edit= (Process *) c_edit->cnt_process;
  if ((p_edit->prc_type != PRC_CUSTOM) && !(c_edit->cnt_flags & CNT_FILE)) {
    ikp_err("Only custom or grounded connectors may be edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((run_net != (Net *) NULL) && ((Net *) p_edit->prc_net == run_net)) {
    ikp_err("Cannot edit a connector within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (p_edit->prc_flags & PRC_EDITOPEN) {
    ikp_err("Connector process is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  cntedit_setup(p_edit, c_edit);
  
  return;
}

void cntedit_setup(Process *p,
		   Connector *c)
{
  int val;
  void cnt_drawgrnd();
  
  c_edit=c;
  p_edit=p;

  cnt_highlight(c_edit,0);
  
				/* ungrounded custom connector */
  if ((p_edit->prc_type == PRC_CUSTOM) && !(c_edit->cnt_flags & CNT_FILE)) {
    sprintf(buf1, "%0d", c->cnt_desc);
    XtVaSetValues(prompt,
		  XmNselectionLabelString,XMstr("File descriptor:"),
		  XmNtextString,XMstr(buf1),
		  XmNokCallback,CBl(cntedit_setupCB,0),
		  XmNcancelCallback,CBl(cntedit_cancelCB,0),
		  NULL);
    XtManageChild(prompt);
  } else {
    /* any grounded connector */
    cnt_adjgrnd(c);
  }
}
  
void cntedit_cancelCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  cnt_highlight(c_edit,1);

  net_op= MAIN_MENU;
  return;
}

void cntedit_setupCB(Widget w,
		     XtPointer client_data,
		     XmSelectionBoxCallbackStruct *call_data)
{
  Connector *d;
  int newfd;
  char *descptr,*str;

  cnt_highlight(c_edit,0);

  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);

  descptr=str;
  if (sscanf(descptr, "%d", &newfd) != 1) {
    ikp_err("Unspecified descriptor value.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((newfd < 0) || (newfd >= getdtablesize())) {
    ikp_err("Invalid descriptor value.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  for (d= p_edit->prc_input; d != (Connector *) NULL; d= d->cnt_next) {
    if ((c_edit != d) && (newfd == d->cnt_desc)) {
      ikp_err("Duplicate connector descriptor.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
  }
  for (d= p_edit->prc_output; d != (Connector *) NULL; d= d->cnt_next) {
    if ((c_edit != d) && (newfd == d->cnt_desc)) {
      ikp_err("Duplicate connector descriptor.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
  }
  for (d= p_edit->prc_diag; d != (Connector *) NULL; d= d->cnt_next) {
    if ((c_edit != d) && (newfd == d->cnt_desc)) {
      ikp_err("Duplicate connector descriptor.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
  }
  
  prc_erase(p_edit);
  c_edit->cnt_desc= newfd;
  prc_draw(p_edit);

  curr_net= (Net *) p_edit->prc_net;
  
  net_op= MAIN_MENU;
  return;
}

cntmv_select(XEvent *event)
{
  XButtonEvent *b_evt;
  XMotionEvent *m_evt;
  int x, y;
  Process *p;
  
  if ((cnt_sel1 == (Connector *) NULL) && (event->type != ButtonPress))
    return;
  
  
  switch (event->type) {
  case ButtonPress:
    XDefineCursor(display,top_window,
 		  get_cursor(LXC_CCURSOR));
    b_evt= (XButtonEvent *) event;
    if (b_evt->button == Button3) {
      if (cnt_sel1 != (Connector *) NULL)
	return;
      else {
	net_op= MAIN_MENU;
	return;
      }
    }
    
    x= b_evt->x;
    y= b_evt->y;
    if (cnt_sel1 == (Connector *) NULL) {
      if ((cnt_sel1= cnt_locate(x, y)) == (Connector *) NULL) {
	ikp_err("No connector selected.", NONFATAL);
	net_op= MAIN_MENU;
	return;
      }
      p= (Process *) cnt_sel1->cnt_process;
      if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
	ikp_err("Cannot move a connector within a running net.", NONFATAL);
	net_op= MAIN_MENU;
	return;
      }
      if (p->prc_flags & PRC_EDITOPEN) {
	ikp_err("Connector process is being edited.", NONFATAL);
	net_op= MAIN_MENU;
	return;
      }
      cnt_highlight(cnt_sel1,1);
    }
    else {
      cnt_highlight(cnt_sel1,1);
      p= (Process *) cnt_sel1->cnt_process;
      prc_erase(p);
      if (cnt_sel1->cnt_conn != (Connector *) NULL)
	seg_freepath(cnt_sel1);
      cnt_adjust(p, cnt_sel1, x-p->prc_x, y-p->prc_y);
      if (cnt_sel1->cnt_conn != (Connector *) NULL)
	seg_bldpath(cnt_sel1, cnt_sel1->cnt_conn);
      prc_draw(p);
      cnt_highlight(cnt_sel1,1);
    }
    break;
    
  case MotionNotify:
    m_evt= (XMotionEvent *) event;
    if (m_evt->state & Button3Mask)
      return;
    
    x= (float)m_evt->x/net_scale;
    y= (float)m_evt->y/net_scale;
    cnt_highlight(cnt_sel1,1);
    p= (Process *) cnt_sel1->cnt_process;
    prc_erase(p);
    if (cnt_sel1->cnt_conn != (Connector *) NULL)
      seg_freepath(cnt_sel1);
    cnt_adjust(p, cnt_sel1, x-p->prc_x, y-p->prc_y);
    if (cnt_sel1->cnt_conn != (Connector *) NULL)
      seg_bldpath(cnt_sel1, cnt_sel1->cnt_conn);
    prc_draw(p);
    cnt_highlight(cnt_sel1,1);
    break;
    
  case ButtonRelease:
    b_evt= (XButtonEvent *) event;
    if (b_evt->button == 3) {
      cnt_highlight(cnt_sel1,1);
      p= (Process *) cnt_sel1->cnt_process;
      curr_net= (Net *) p->prc_net;
      net_op= MAIN_MENU;
    }
    break;
  default:
    break;
  }
  return;
}
