/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

extern void cntedit_setup(Process *,Connector *);
extern void cnt_drawgrnd(Process *,Connector *);
extern void prcedit_setup(Process *);

extern boolean prc_editdone;
extern Connector *cnt_sel1, *cnt_sel2;

void ikp_callback_event(Widget w,XtPointer client_data,XEvent *call_data)
{
  ikp_event(call_data);
}
 

Bool ikp_anyevt(Display *dpy,XEvent *evt,char *arg)
{
  return(True);
}

ikp_event(XEvent *event)
{
  switch (net_op) {
  case NULL_OP:
    break;
  case MAIN_MENU:
    main_select(event);
    break;
  case NET_SELECT:
    netsel_select(event,0);
    break;
  case NET_RUN:
    netsel_select(event,1);
    break;
  case NET_NAME:
    netname_select(event);
    break;
  case NET_DESTROY:
    netdst_select(event);
    break;
  case NET_READ:
    netrd_select(event);
    break;
  case NET_WRITE:
    netwr_select(event);
    break;
  case NET_APPEND:
    netappend_select(event);
    break;
  case NET_COPY:
    netcp_select(event);
    break;
  case PRC_CREATE:
    prccr_select(event);
    break;
  case PRC_EDIT:
    prcedit_select(event);
    break;
  case PRC_COPY:
    prccp_select(event);
    break;
  case PRC_MOVE:
    prcmv_select(event);
    break;
  case PRC_STOP:
    prcstop_select(event);
    break;
  case PRC_RESTART:
    prcrestart_select(event);
    break;
  case PRC_ABORT:
    prcabort_select(event);
    break;
  case PRC_DESTROY:
    prcdst_select(event);
    break;
  case CNT_LINK:
    cntlnk_select(event);
    break;
  case CNT_GRNDFILE:
  case CNT_GRNDNULL:
    cntgrnd_select(event);
    break;
  case CNT_UNLINK:
    cntulnk_select(event);
    break;
  case CNT_EDIT:
    cntedit_select(event);
    break;
  case CNT_MOVE:
    cntmv_select(event);
    break;
  }
}

main_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  void main_lbp_select();
  void main_mbp_select(), main_mbps_select(), main_mbpc_select();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  switch (evt->button) {
  case Button1:
    main_lbp_select(evt);
    break;
  case Button2:
    if (evt->state & ShiftMask)
      main_mbps_select(evt);
    else if (evt->state & ControlMask)
      main_mbpc_select(evt);
    else
      main_mbp_select(evt);
    break;
  case Button3:
/*    menu_show(main_menu, evt); */
    break;
  }
}

/*
   Accelerators for CNT_EDIT and PRC_EDIT.
   */
void main_lbp_select(XButtonPressedEvent *evt)
{
  Process *p;
  Connector *c;
  int x, y;
  
  x= evt->x;
  y= evt->y;
  
  if ((c= cnt_locate(x, y)) != (Connector *) NULL) {
    p= (Process *) c->cnt_process;
    if ((p->prc_type != PRC_CUSTOM) && !(c->cnt_flags & CNT_FILE)) {
      ikp_err("Only custom or grounded connectors may be edited.", NONFATAL);
      return;
    }
    if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
      ikp_err("Cannot edit a connector within a running net.", NONFATAL);
      return;
    }
    if (p->prc_flags & PRC_EDITOPEN) {
      ikp_err("Connector process is being edited.", NONFATAL);
      return;
    }
    net_op= CNT_EDIT;
    cntedit_setup(p, c);
    return;
  }
  
  if ((p= prc_locate(x, y)) == (Process *) NULL)
    return;
  
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot edit a process within a running net.", NONFATAL);
    return;
  }
  if (p->prc_flags & PRC_EDITOPEN) {
    ikp_err("Selected process is already being edited.", NONFATAL);
    return;
  }
  
  prcedit_setup(p);
  return;
  
}

/*
   Accelerator for CNT_LINK.
*/
void main_mbp_select(XButtonPressedEvent *evt)
{
  Connector *c;
  Process *p;
  int x, y;
  
  x= evt->x;
  y= evt->y;
  
  if ((c= cnt_locate(x, y)) == (Connector *) NULL)
    return;
  p= (Process *) c->cnt_process;
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot link connectors within a running net.", NONFATAL);
    return;
  }
  if (c->cnt_flags & CNT_FILE) {
    ikp_err("Connector already grounded.", NONFATAL);
    return;
  }
  if (c->cnt_conn != (Connector *) NULL) {
    ikp_err("Connector already connected.", NONFATAL);
    return;
  }
  
  cnt_sel1= c;
  cnt_sel2= (Connector *) NULL;
  cnt_highlight(cnt_sel1);
  net_op= CNT_LINK;
  return;
}

/*
   Accelerator for CNT_GRNDFILE.
   */
void main_mbps_select(XButtonPressedEvent *evt)
{
  Connector *c;
  Process *p;
  int x, y;

  x= evt->x;
  y= evt->y;
  
  if ((c= cnt_locate(x, y)) == (Connector *) NULL)
    return;
  p= (Process *) c->cnt_process;
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot link connectors within a running net.", NONFATAL);
    return;
  }
  if (p->prc_flags & PRC_EDITOPEN) {
    ikp_err("Connector process is being edited.", NONFATAL);
    return;
  }
  if (c->cnt_conn != (Connector *) NULL) {
    ikp_err("Connector already connected.", NONFATAL);
    return;
  }
  if (c->cnt_flags & CNT_FILE) {
    if ((c->cnt_filename != (char *) NULL) && !strcmp(c->cnt_filename, "/dev/null")) {
      cnt_drawgrnd(p, c);
      free(c->cnt_filename);
      c->cnt_filename= (char *) NULL;
      cnt_drawgrnd(p, c);
      net_op= CNT_GRNDFILE;
      cnt_ground(c);
    }
    else
      ikp_err("Connector already grounded.", NONFATAL);
    return;
  }
  
  net_op= CNT_GRNDFILE;
  cnt_ground(c);
  net_op= MAIN_MENU;
  return;
}

/*
   Accelerator for CNT_UNLINK.
   */
void main_mbpc_select(XButtonPressedEvent *evt)
{
  Connector *c;
  Process *p;
  Net *n;
  int x, y;
  
  x= evt->x;
  y= evt->y;
  
  if ((c= cnt_locate(x, y)) == (Connector *) NULL)
    return;
  p= (Process *) c->cnt_process;
  n= (Net *) p->prc_net;
  if ((run_net != (Net *) NULL) && (n == run_net)) {
    ikp_err("Cannot link connectors within a running net.", NONFATAL);
    return;
  }
  if (!(c->cnt_flags & CNT_FILE) && (c->cnt_conn == (Connector *) NULL)) {
    ikp_err("Connector not connected.", NONFATAL);
    return;
  }
  cnt_unlink(c);
  if (net_split(n) > 0)
    curr_net= (Net *) NULL;
  else
    curr_net= n;
  return;
}

