/*
 *	Copyright (c) 1990 by Columbia University.
 */

/*
 *	Modified this routine to go along with the changes 
 *	in token.c which enable the input of options which
 *	have embedded character strings which should be 
 *	considered as one command line argument to be passed
 *	to execvp
 *					- j.m.wade - 92083
 */
/*
	changed all calls to free() to free() calls. The damn convex
	had a different syntax than the rest of the free world.
					- j.m.wade - 1/19/96
*/
/*
 *	Modified to change the default file descriptors that
 *      are assigned on custom processing boxes. Previously,
 *      they were assigned sequentially starting with fd 3.
 *      This has been changed so that input descriptors start
 *      with 0 and then fd 3 on up sequentially are assigned.
 *      Similarly, the output descriptors begin with 1 and the
 *      first available number > 3 that hasn't been used for
 *      input. Finally, the diagnostic descriptors are 2 and
 *      the next descriptor >3 that hasn't been used for input
 *      or output. Primary purpose for doing this is convention.
 *      Most of our codes are written in Fortran, which always
 *      has file descriptors 0,1,2 hooked to stdin, stdout,
 *      and stderr, which are associated with the Fortran
 *      input, output, and error logical units.
 *	
 *					- j.m.wade - 10/29/97
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

#define MAGIC_SPACING 18     /* Spacing of widget for label next to text. */

extern char xui_path[1024];
extern int custom_x,custom_y;
extern FILE *yyin,*yyout;

extern void cnt_draw(Process *,Connector *);
extern void cnt_erase(Process *,Connector *);
extern Module *mdl_copy(Module *);
     
void prc_create_custom_okCB(Widget,XtPointer,XtPointer);

void prc_drawstd(Process *);
void prc_draw(Process *);
void prc_get_panel(Process *,char **);

static char *prc_argvec[MAXEXECARGS+1];
static char prc_currarg[MAXARGSZ+1];

static Widget form=NULL;
static Widget input_text=NULL;
static Widget output_text=NULL;
static Widget diag_text=NULL;

int xui_trace_flag_internal;

void prc_create_panel_lib(Process *p)
{
  Widget label;
  Widget label1;
  Widget dialog;
  Module *m;

  m=p->prc_module;

  sprintf(buf1,"Module: %s",m->mdl_label);
  p->prc_window=XmCreateFormDialogVa(top_level,"form",
				     XmNdialogTitle,XMstr(buf1),
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XtNmanageChild,False,
				     XmNautoUnmanage,False,
				     NULL);

  sprintf(buf1,"Path Prefix:");
  label1=XmCreateLabelVa(p->prc_window,buf1,
			 XmNtopAttachment,XmATTACH_FORM,
			 XmNtopOffset,16,
			 XmNleftAttachment,XmATTACH_FORM,
			 NULL);

  if (m->mdl_path==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",m->mdl_path);
  m->mdl_path_text=XmCreateTextVa(p->prc_window,"text",
				  XmNvalue,buf1,
				  XmNcolumns,30,
				  XmNtopAttachment,XmATTACH_FORM,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label1,
				  NULL);

  sprintf(buf1,"Directory:  ");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,m->mdl_path_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (m->mdl_dir==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",m->mdl_dir);
  m->mdl_dir_text=XmCreateTextVa(p->prc_window,"text",
				 XmNcolumns,30,
				 XmNvalue,buf1,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,m->mdl_path_text,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
				 NULL);
  
  sprintf(buf1,"Remote Host:");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,m->mdl_dir_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_host==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_host);
  p->prc_host_text=XmCreateTextVa(p->prc_window,"text",
				  XmNvalue,buf1,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,m->mdl_dir_text,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label,
				  NULL);

  sprintf(buf1,"Remote User:");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_host_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_user==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_user);
  p->prc_user_text=XmCreateTextVa(p->prc_window,"text",
				   XmNvalue,buf1,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,p->prc_host_text,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label,
				  NULL);

  sprintf(buf1,"Label:      ");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_user_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_label==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_label);
  p->prc_label_text=XmCreateTextVa(p->prc_window,"text",
				   XmNvalue,buf1,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,p->prc_user_text,
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,label,
				   NULL);

  dialog=XmCreateFormVa(p->prc_window,"form",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_label_text,
			XmNtopOffset,10,
			XmNbottomAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNautoUnmanage,False,
			NULL);

  p->prc_panel=init_panel(p->prc_window);
  create_panel(dialog,0,0);
  socket_file_off();
  
  strcpy(buf1,xui_path);
  strcat(buf1,m->mdl_label);
  strcat(buf1,".pattern");
  yyin=fopen(buf1,"r");
  if (yyin==NULL) {
    fprintf(stderr,"Can't not open %s\n",buf1);
    exit(1);
  }
  yyout=fopen("/dev/null","w");
  if (yyparse()==1) {
    sprintf(buf2,"Error parsing %s.\n",buf1);
    ikp_err(buf2, FATAL);
  }    
  fclose(yyout);
  fclose(yyin);

  ok_help_cancel_panel(p->prc_panel,(XtPointer)p);

}

void prc_set_panel(Process *p)
{
  Module *m;

  m=p->prc_module;

  if (m->mdl_path==NULL)
    strcpy(buf1,"");
  else 
    strcpy(buf1,m->mdl_path);
  XtVaSetValues(m->mdl_path_text,
		XmNvalue,buf1,
		NULL);
    
  if (m->mdl_dir==NULL)
    strcpy(buf1,"");
  else 
    strcpy(buf1,m->mdl_dir);
  XtVaSetValues(m->mdl_dir_text,
		XmNvalue,buf1,
		NULL);

  if (p->prc_host==NULL)
    strcpy(buf1,"");
  else 
    strcpy(buf1,p->prc_host);
  XtVaSetValues(p->prc_host_text,
		XmNvalue,buf1,
		NULL);

  if (p->prc_label==NULL)
    strcpy(buf1,m->mdl_label);
  else 
    strcpy(buf1,p->prc_label);
  XtVaSetValues(p->prc_label_text,
		XmNvalue,buf1,
		NULL);

  if (p->prc_user==NULL)
    strcpy(buf1,"");
  else 
    strcpy(buf1,p->prc_user);
  XtVaSetValues(p->prc_user_text,
		XmNvalue,buf1,
		NULL);
  
  if (p->prc_comm!=NULL)
    if (strlen(p->prc_comm)>0) {
      sscanf(p->prc_comm,"%s",buf1);
      strcpy(buf2,strstr(p->prc_comm,buf1)+strlen(buf1));
      set_panel(p->prc_panel,buf2);
    }
  
}


void prc_create_panel(Process *p)
{
  Widget label;
  Widget label1;

  sprintf(buf1,"Command");
  p->prc_window=XmCreateFormDialogVa(top_level,"form",
				     XmNdialogTitle,XMstr(buf1),
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XtNmanageChild,False,
				     XmNautoUnmanage,False,
				     NULL);

  sprintf(buf1,"Command:    ");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_FORM,
			XmNtopOffset,16,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_comm==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_comm);
  p->prc_comm_text=XmCreateTextVa(p->prc_window,"text",
				 XmNcolumns,30,
				 XmNvalue,buf1,
				 XmNtopAttachment,XmATTACH_FORM,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
				 NULL);

  sprintf(buf1,"Directory:  ");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_comm_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);

  if (p->prc_dir==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_dir);
  p->prc_dir_text=XmCreateTextVa(p->prc_window,"text",
				 XmNcolumns,30,
				 XmNvalue,buf1,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,p->prc_comm_text,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
				 NULL);
  
  sprintf(buf1,"Remote Host:");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_dir_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_host==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_host);
  p->prc_host_text=XmCreateTextVa(p->prc_window,"text",
				  XmNvalue,buf1,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,p->prc_dir_text,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label,
				  NULL);

  sprintf(buf1,"Remote User:");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_host_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_user==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_user);
  p->prc_user_text=XmCreateTextVa(p->prc_window,"text",
				  XmNvalue,buf1,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,p->prc_host_text,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label,
				  NULL);

  sprintf(buf1,"Label:      ");
  label=XmCreateLabelVa(p->prc_window,buf1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,p->prc_user_text,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);


  if (p->prc_label==NULL) 
    strcpy(buf1,"");
  else
    sprintf(buf1,"%s",p->prc_label);
  p->prc_label_text=XmCreateTextVa(p->prc_window,"text",
				   XmNvalue,buf1,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,p->prc_user_text,
				   XmNbottomAttachment,XmATTACH_FORM,
				   XmNbottomOffset,40,
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,label,
				   NULL);

  p->prc_panel=init_panel(p->prc_window);
  
  ok_help_cancel_panel(p->prc_panel,(XtPointer)p);

}

void prc_get_panel(Process *p,char **values)
{
  Module *m;
  char command[1024],keyword[1024],*str;
  int i,value_count=0,start_flag=False;
  
  if (p->prc_type == PRC_LIBRARY) {
    m=p->prc_module;

    XtVaGetValues(m->mdl_path_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (m->mdl_path!=NULL)
	free(m->mdl_path);
      m->mdl_path=NULL;
    } else {
      m->mdl_path=strdup(str);
    }
    
    XtVaGetValues(m->mdl_dir_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (m->mdl_dir!=NULL)
	free(m->mdl_dir);
      m->mdl_dir=NULL;
    } else {
      m->mdl_dir=strdup(str);
    }
    
    XtVaGetValues(p->prc_host_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_host!=NULL)
	free(p->prc_host);
      p->prc_host=NULL;
      if (p->prc_tmp_host!=NULL)
	free(p->prc_tmp_host);
      p->prc_tmp_host=NULL;

    } else {
      p->prc_host=strdup(str);
    }
    
    XtVaGetValues(p->prc_label_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_label!=NULL)
	free(p->prc_label);
      p->prc_label=NULL;
    } else {
      p->prc_label=strdup(str);
    }
    
    XtVaGetValues(p->prc_user_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_user!=NULL)
	free(p->prc_user);
      p->prc_user=NULL;
    } else {
      p->prc_user=strdup(str);
    }
    
    
    while (values[value_count]!=NULL) {
      strcpy(buf1,values[value_count]);
      if (verbose)
	fprintf(stderr,"%s \n",buf1);
      strcpy(keyword,"");
      sscanf(buf1,"%s",keyword);
      
      if (start_flag) {
	strcat(command,buf1);
      }
      
      if (strcmp(keyword,"program_exec:")==0) {
	sscanf(buf1,"%s %s",keyword,buf2);
	strcpy(command,"");
	if ((m->mdl_path!=NULL)&&(strlen(m->mdl_path)>0)) {
	  strcat(command,m->mdl_path);
	  if (m->mdl_path[strlen(m->mdl_path)-1]!='/')
	    strcat(command,"/");
	}
	strcat(command,strstr(buf1+strlen(keyword),buf2));
	start_flag=True;
      }
      value_count++;
      if (value_count>1000) {
	fprintf(stderr,"Internal error (value_count too large)\n");
	exit(1);
      }
    }
    if (p->prc_comm!=NULL)
      free(p->prc_comm);
    p->prc_comm=strdup(command);

  } else {
    XtVaGetValues(p->prc_dir_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_dir!=NULL)
	free(p->prc_dir);
      p->prc_dir=NULL;
    } else {
      p->prc_dir=strdup(str);
    }
    
    XtVaGetValues(p->prc_host_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_host!=NULL)
	free(p->prc_host);
      p->prc_host=NULL;
      if (p->prc_tmp_host!=NULL)
	free(p->prc_tmp_host);
      p->prc_tmp_host=NULL;
    } else {
      p->prc_host=strdup(str);
    }
    
    XtVaGetValues(p->prc_label_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_label!=NULL)
	free(p->prc_label);
      p->prc_label=NULL;
    } else {
      p->prc_label=strdup(str);
    }
    
    XtVaGetValues(p->prc_user_text,
		  XmNvalue,&str,
		  NULL);
    if (str==NULL) {
      if (p->prc_user!=NULL)
	free(p->prc_user);
      p->prc_user=NULL;
    } else {
      p->prc_user=strdup(str);
    }
    
    XtVaGetValues(p->prc_comm_text,
		  XmNvalue,&str,
		  NULL);
    if (p->prc_comm!=NULL)
      free(p->prc_comm);
    if (str==NULL) {
      p->prc_comm=NULL;
    } else {
      p->prc_comm=strdup(str);
    }
    
    strcpy(command,p->prc_comm);
  }
/* Old location ********** */
}

Process *prc_create(int type)
{
  Net *nt;
  Process *p;
  Connector *c;
  int root_x,root_y;
  static int init=1;
  static Widget button;
  Widget label,separator;
  
  if ((p= (Process *) calloc(1, sizeof(Process))) == (Process *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  p->prc_host= (char *) NULL;
  p->prc_tmp_host= (char *) NULL;
  p->prc_user= (char *) NULL;
  p->prc_comm= (char *) NULL;
  p->prc_argv= (char **) NULL;
  p->prc_dir= (char *) NULL;
  p->prc_label= (char *) NULL;
  p->prc_type= type;
  p->prc_flags= 0;
  p->prc_input= p->prc_output= p->prc_diag= (Connector *) NULL;
  p->prc_image= (XImage *) NULL;
  p->prc_imagefile= (char *) NULL;
  p->prc_module= (Module *) NULL;
  p->prc_next= (Process *) NULL;
  p->prc_panel=(Panel *)NULL;
  p->prc_window=(Widget)NULL;
  
  /* each new Process starts out in its own Net */
  if ((nt= net_create()) == (Net *) NULL) {
    free((char *) p);
    return((Process *) NULL);
  }
  nt->net_prclist= p;
  nt->net_next= nets;
  nets= curr_net= nt;
  p->prc_net= (caddr_t) nt;
  
  switch (type) {
  case PRC_SOURCE:
    p->prc_w= PRCSSF_WIDTH;
    p->prc_h= PRCSSF_HEIGHT;
    p->prc_flags|= PRC_VARPROC;
    if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, 1)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH-1;
    c->cnt_y= PRCSSF_HEIGHT/2;
    c->cnt_orient= RIGHT;
    if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, 2)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH/2;
    c->cnt_y= PRCSSF_HEIGHT-1;
    c->cnt_orient= DOWN;
    break;
  case PRC_SINK:
    p->prc_w= PRCSSF_WIDTH;
    p->prc_h= PRCSSF_HEIGHT;
    p->prc_flags|= PRC_VARPROC;
    if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, 0)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= 0;
    c->cnt_y= PRCSSF_HEIGHT/2;
    c->cnt_orient= LEFT;
    if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, 2)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH/2;
    c->cnt_y= PRCSSF_HEIGHT-1;
    c->cnt_orient= DOWN;
    break;
  case PRC_SCRIPT:
    p->prc_w= PRCSSF_WIDTH;
    p->prc_h= PRCSSF_HEIGHT;
    p->prc_flags|= PRC_VARPROC;
    if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, 0)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH/2;
    c->cnt_y= 0;
    c->cnt_orient= UP;
    if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, 1)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH/8;
    c->cnt_y= PRCSSF_HEIGHT-1;
    c->cnt_orient= DOWN;

    if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, 2)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x=7* PRCSSF_WIDTH/8;
    c->cnt_y= PRCSSF_HEIGHT-1;
    c->cnt_orient= DOWN;
    break;
  case PRC_FILTER:
    p->prc_w= PRCSSF_WIDTH;
    p->prc_h= PRCSSF_HEIGHT;
		p->prc_flags|= PRC_VARPROC;
    if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, 0)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= 0;
    c->cnt_y= PRCSSF_HEIGHT/2;
    c->cnt_orient= LEFT;
    if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, 1)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH-1;
    c->cnt_y= PRCSSF_HEIGHT/2;
    c->cnt_orient= RIGHT;
    if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, 2)) == (Connector *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    c->cnt_x= PRCSSF_WIDTH/2;
    c->cnt_y= PRCSSF_HEIGHT-1;
    c->cnt_orient= DOWN;
    break;
  case PRC_CUSTOM:
    if (init) {
      init=0;
      form=XmCreateFormDialogVa(top_level,"custom",
				XmNmarginWidth,10,
				XmNmarginHeight,10,
				XmNdefaultPosition,False,
				XmNdialogTitle,XMstr("Custom Process"),
				XtNmanageChild,False,
				NULL);
      label=XmCreateLabelVa(form,"Number of input connectors:",
			    XmNtopAttachment,XmATTACH_FORM,
			    XmNtopOffset,MAGIC_SPACING,
			    XmNleftAttachment,XmATTACH_FORM,
			    NULL);
      input_text=XmCreateTextVa(form,"text",
				XmNcolumns,3,
/*
				XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNtopWidget,label,
*/
				XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNbottomWidget,label,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,label,
				NULL);
      label=XmCreateLabelVa(form,"Number of output connectors:",
			    XmNleftAttachment,XmATTACH_FORM,
			    XmNtopAttachment,XmATTACH_WIDGET,
			    XmNtopWidget,label,
			    XmNtopOffset,MAGIC_SPACING,
			    NULL);
      output_text=XmCreateTextVa(form,"text",
				 XmNcolumns,3,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
/*
				 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				 XmNtopWidget,label,
*/
				 XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
				 XmNbottomWidget,label,
				 NULL);
      label=XmCreateLabelVa(form,"Number of diagnostic connectors:",
			    XmNleftAttachment,XmATTACH_FORM,
			    XmNtopAttachment,XmATTACH_WIDGET,
			    XmNtopWidget,label,
			    XmNtopOffset,MAGIC_SPACING,
			    NULL);
      diag_text=XmCreateTextVa(form,"text",
			       XmNcolumns,3,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,label,
/*
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,label,
*/
			       XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNbottomWidget,label,
			       NULL);

      separator=XmCreateSeparatorVa(form,"separator",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,diag_text,
				XmNtopOffset,10,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
				
      button=XmCreatePushButtonVa(form,"  OK  ",
				  XmNleftAttachment,XmATTACH_POSITION,
				  XmNleftPosition, 40,
				  XmNrightAttachment,XmATTACH_POSITION,
				  XmNrightPosition, 60,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,separator,
				  XmNtopOffset,10,
				  XmNbottomAttachment,XmATTACH_FORM,
				  NULL);
    }
    locate_cursor(&root_x,&root_y);
    XBell(display,100);
    XtVaSetValues(button,
		  XmNactivateCallback,
		  CBl(prc_create_custom_okCB,p),
		  NULL);
    XtVaSetValues(form,
                  XmNx,root_x,
                  XmNy,root_y,
                  NULL);
    XtManageChild(form);
    return((Process *) NULL);
    break;
  case PRC_LIBRARY:
    if ((p->prc_module= mdl_copy(prccr_module)) == (Module *) NULL) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    p->prc_module->mdl_process= (caddr_t) p;
    if (prc_libcntconf(p) != IKP_SUCCESS) {
      prc_free(p, PRC_FREENET);
      return((Process *) NULL);
    }
    break;
  default:
    break;
  }
  
  return(p);
}


void prc_create_custom_okCB(Widget w,
			    XtPointer client_data,
			    XtPointer call_data)
{
  Process *p=(Process *)client_data;
  Mdlitem *mi;
  int val, cstin, cstout, cstd;
  char *str;

  XtUnmanageChild(form);

  XtVaGetValues(input_text,
	       XmNvalue,&str,
	       NULL);
  
  if (sscanf(str, "%d", &cstin) != 1) {
    ikp_err("Unspecified number of input connectors.", NONFATAL);
    return;
  }
  if (cstin < 0) {
    ikp_err("Number of input connectors must be greater than or equal to 0.", NONFATAL);
    return;
  }

  XtVaGetValues(output_text,
	       XmNvalue,&str,
	       NULL);
  if (sscanf(str, "%d", &cstout) != 1) {
    ikp_err("Unspecified number of output connectors.", NONFATAL);
    return;
  }
  if (cstout < 0) {
    ikp_err("Number of output connectors must be greater than or equal to 0.", NONFATAL);
    return;
  }

  XtVaGetValues(diag_text,
	       XmNvalue,&str,
	       NULL);
  if (sscanf(str, "%d", &cstd) != 1) {
    ikp_err("Unspecified number of diagnostic connectors.", NONFATAL);
    return;
  }
  if (cstd < 0) {
    ikp_err("Number of diagnostic connectors must be greater than or equal to 0.", NONFATAL);
    return;
  }

  if (cstin+cstout+cstd > getdtablesize()-RESERVED_FDS) {
    ikp_err("Too many connectors.", NONFATAL);
    return;
  }
  
  p->prc_flags|= PRC_VARPROC;
  if (prc_cstcntconf(p, cstin, cstout, cstd) != IKP_SUCCESS) {
    prc_free(p, PRC_FREENET);
    net_op= MAIN_MENU;
    return;
  }

  p->prc_x=custom_x;
  p->prc_y=custom_y;
  
  prc_draw(p);
  
  net_op= MAIN_MENU;
  return;
}


/*
   Unlink a Process and its Connectors.
   */
int prc_unlink(Process *p)
{
  Net *n;
  Process *q;
  Connector *c;
  
  if (p == (Process *) NULL)
    return(IKP_FAILURE);
  
  for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next)
    cnt_unlink(c);
  for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next)
    cnt_unlink(c);
  for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
    cnt_unlink(c);
  
  if ((n= (Net *) p->prc_net) != (Net *) NULL) {
    if (p == n->net_prclist)
      n->net_prclist= p->prc_next;
    else {
      for (q= n->net_prclist; q->prc_next != (Process *) NULL; q= q->prc_next) {
	if (p == q->prc_next)
	  break;
      }
      if (p == q->prc_next)
				q->prc_next= p->prc_next;
    }
  }
  return(IKP_SUCCESS);
}

/*
   Destroy a Process and free all associated memory.
   If it is the only Process in its Net and mode is
   PRC_FREENET, unlink and free the Net. The Process and
   all its Connectors must already be unlinked from Net.
   */
int prc_free(Process *p,int mode)
{
  Net *nt;
  Connector *c, *d;
  char **cp;
  
  for (c= p->prc_input; c != (Connector *) NULL; c= d) {
    d= c->cnt_next;
    free((char *) c);
  }
  for (c= p->prc_output; c != (Connector *) NULL; c= d) {
    d= c->cnt_next;
    free((char *) c);
  }
  for (c= p->prc_diag; c != (Connector *) NULL; c= d) {
    d= c->cnt_next;
    free((char *) c);
  }
  
  /* unlink and free Net if no more Processes */
  if ((mode == PRC_FREENET) && ((nt= (Net *) p->prc_net) != (Net *) NULL)) {
    if (nt->net_prclist == (Process *) NULL) {
      net_unlink((Net *) p->prc_net);
      net_free((Net *) p->prc_net);
    }
  }

  if (p->prc_panel!=NULL)
    delete_panel(p->prc_panel);

  if (p->prc_host != (char *) NULL)
    free(p->prc_host);
  if (p->prc_user != (char *) NULL)
    free(p->prc_user);
  if (p->prc_comm != (char *) NULL)
    free(p->prc_comm);
  if (p->prc_label != (char *) NULL)
    free(p->prc_label);
  if (p->prc_argv != (char **) NULL) {
    for (cp= p->prc_argv; *cp != (char *) NULL; cp++)
      free(*cp);
    free((char *) p->prc_argv);
  }
  if (p->prc_dir != (char *) NULL)
    free(p->prc_dir);
  if (p->prc_imagefile != (char *) NULL)
    free(p->prc_imagefile);
  if (p->prc_module != (Module *) NULL)
    mdl_free(p->prc_module);
  free((char *) p);
  
  return(IKP_SUCCESS);
}

/*
   Create argument list for future execvp.
   */
int prc_bldargv(Process *p)
{
  int i,n_args;
  char **values;
  char *c,*d,**cp;
  boolean found;
  boolean inquote = FALSE;	/* added - j.m.wade - 92083 */

  
  if (p == (Process *) NULL) {
    ikp_err("Null process.", NONFATAL);
    return(IKP_FAILURE);
  }

  if (p->prc_comm==NULL) {
    if (usage_mode==INTERACTIVE) {
      if (p->prc_window==NULL) {
	if (p->prc_type == PRC_LIBRARY)
	  prc_create_panel_lib(p);
	else 
	  prc_create_panel(p);
	values=get_panel_defaults(p->prc_panel);
	prc_get_panel(p,values);
      }
    }
  }

				/* free any existing arg vectors */
  if (p->prc_argv != (char **) NULL) {
    for (cp= p->prc_argv; *cp != (char *) NULL; cp++)
      free(*cp);
    free((char *) p->prc_argv);
  }

  memset((char *) prc_argvec, (int) 0, (MAXEXECARGS+1)*sizeof(char *));

  if (p->prc_comm==NULL) {
    fprintf(stderr,"Null: process %s %s\n",p->prc_label,p->prc_module);
    ikp_err("Null command.", NONFATAL);
    return(IKP_FAILURE);
  }
				     /* count number of args */
  for (n_args= 0, c= p->prc_comm;;) {
    found= FALSE;
    memset(prc_currarg, (int) 0, MAXARGSZ+1);
    for (d= prc_currarg;; c++) {
      if (isgraph(*c)) {
	if (*c == '"') {
	  inquote = !inquote;
	} else {
	  *d++= *c;
	}
	found= TRUE;
      } else 
	if (isspace(*c)) {
	  if (inquote) {
	    *d++ = *c;
	    found= TRUE;
	  } else {
	    c++;
	    break;
	  }
	} else 
	  if (*c == '\0')
	    break;
    }
    if (found) {
      if ((prc_argvec[n_args]= calloc((unsigned) (strlen(prc_currarg)+1), sizeof(char))) == (char *) NULL)
	ikp_err("Memory allocation error.", FATAL);
      (void) strcpy(prc_argvec[n_args], prc_currarg);
      n_args++;
    }
    if (*c == '\0')
      break;
  }
  
  if (verbose >= 5)
    fprintf(stderr, "nargs = %d\n", n_args);
  
  if ((p->prc_argv= (char **) calloc((unsigned) (n_args+1), sizeof(char *))) == (char **) NULL)
    ikp_err("Memory allocation error.", FATAL);
  for (i= 0; i < n_args; i++) {
    p->prc_argv[i]= prc_argvec[i];
    if (verbose >= 5)
      fprintf(stderr, "%d = :%s:\n", i, p->prc_argv[i]);
  }
  p->prc_argv[i]= (char *) NULL;

  if (strlen(p->prc_comm) == 0) {
    ikp_err("Empty process command.", NONFATAL);
    return(IKP_FAILURE);
  }
  
  return(IKP_SUCCESS);
}

void prc_draw(Process *p)
{
  if (p == (Process *) NULL)
    return;
  
  prc_drawstd(p);

  return;
}

void prc_drawstd(Process *p)
{
  int x, y, w, h, tw, label_sz;
  int asc;
  Connector *c;
  char label[60];
  
  draw_fill_rectangle(net_cgc, p->prc_x, p->prc_y, p->prc_w, p->prc_h);
  if (p->prc_image != (XImage *) NULL)
    XPutImage(display, net_cpm, net_gc, p->prc_image, 0, 0, p->prc_x, p->prc_y, p->prc_w, p->prc_h);
  
  x= p->prc_x;
  y= p->prc_y;
  w= p->prc_w;
  h= p->prc_h;
  
  draw_line(net_gc, x, y, x+w-1, y);
  draw_line(net_gc, x+w-1, y, x+w-1, y+h-1);
  draw_line(net_gc, x, y+h-1, x+w-1, y+h-1);
  draw_line(net_gc, x, y, x, y+h-1);

/* 

   Make thick line boxes.

  draw_line(net_gc, x, y+1, x+w-1, y+1);
  draw_line(net_gc, x+w-2, y, x+w-2, y+h-1);
  draw_line(net_gc, x, y+h-2, x+w-1, y+h-2);
  draw_line(net_gc, x+1, y, x+1, y+h-1);
*/
  label_sz= (p->prc_w/reg_charwd)-2;
  if (label_sz > 59)
    label_sz= 59;
  if (label_sz > 0) {
    if (prc_bldlabel(p, label, label_sz) > 0) {
      asc= reg_font->max_bounds.ascent;
      tw= XTextWidth(reg_font, label, strlen(label));
      x=(float)x*net_scale;
      y=(float)y*net_scale;
      w=(float)w*net_scale;
      h=(float)h*net_scale;
      XDrawString(display,net_cpm,net_gc,
		  x+(w/2)-(tw/2), y+(h/2)+(asc/4),
		  label, strlen(label));
    }
  }

  for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next)
    cnt_draw(p, c);
  for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next)
    cnt_draw(p, c);
  for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
    cnt_draw(p, c);
  
  return;
}

void prc_erase(Process *p)
{
  Connector *c;

  if (p == (Process *) NULL)
    return;
  
  for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next)
    cnt_erase(p, c);
  for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next)
    cnt_erase(p, c);
  for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
    cnt_erase(p, c);
  
  draw_fill_rectangle(net_cgc, p->prc_x, p->prc_y, p->prc_w+1, p->prc_h+1);
  
  return;
}

/*
   Build label for Process icon by using either p->prc_label,
   the module name or the last path component of p->prc_comm.
   */
int prc_bldlabel(Process *p,char *str,int max)
{
  char *c, tmp[120];
  int i;
  
  /* label present */
  if ((p->prc_label != (char *) NULL) && (strlen(p->prc_label) > 0)) {
    (void) strncpy(str, p->prc_label, max);
    if (strlen(p->prc_label) < max)
      i= strlen(p->prc_label);
    else
      i= max;
    str[i]= '\0';
    return(i);
  }
  
  /* use module name or extract label from command */
  switch (p->prc_type) {
  case PRC_LIBRARY:
    (void) strncpy(str, p->prc_module->mdl_label, max);
    if (strlen(p->prc_module->mdl_label) < max)
      i= strlen(p->prc_module->mdl_label);
    else
      i= max;
    str[i]= '\0';
    break;
  default:
    if (p->prc_comm == (char *) NULL)
      return(0);
    if (strlen(p->prc_comm) == 0)
      return(0);
    
    for (i= 0, c= p->prc_comm; *c != '\0'; i++, c++) {
      if (isgraph(*c))
	tmp[i]= *c;
      else
	break;
    }
    tmp[i]= '\0';
    if ((c= strrchr(tmp, '/')) == (char *) NULL)
      c= tmp;
    else
      c++;
    for (i= 0; (*c != '\0') && (i < max); i++, c++)
      str[i]= *c;
    str[i]= '\0';
    break;
	}
  return(i);
}

/*
   Locate a Process in virtual canvas coordinate space.
*/
Process *prc_locate(int x,int y)
{
  Net *n;
  Process *p;
  boolean found;

  x=(float)x/net_scale;
  y=(float)y/net_scale;
  
  found= FALSE;
  p= (Process *) NULL;
  for (n= nets; n != (Net *) NULL; n= n->net_next) {
    for (p= n->net_prclist; p != (Process *) NULL; p= p->prc_next) {
      if ((p->prc_x <= x) && (p->prc_x+p->prc_w >= x) &&
	 		    (p->prc_y <= y) && (p->prc_y+p->prc_h >= y)) {
	found= TRUE;
	break;
      }
    }
    if (found)
      break;
  }
  return(p);
}

prc_showactive(Process *p)
{
  int label_sz, asc, tw;
  int x, y, w, h;
  char label[60];
  GC gc;
  
  if (p == (Process *) NULL)
    return;
  
  x= p->prc_x;
  y= p->prc_y;
  w= p->prc_w;
  h= p->prc_h;
  
  if (p->prc_flags & PRC_RUNNING)
    gc= net_rpgc;
  else if (p->prc_flags & PRC_STOPPED)
    gc= net_spgc;
  
  draw_fill_rectangle(gc, x+2, y+2, w-(2*2), h-(2*2));
  label_sz= (p->prc_w/reg_charwd)-2;
  if (label_sz > 59)
    label_sz= 59;
  if (label_sz > 0) {
    if (prc_bldlabel(p, label, label_sz) > 0) {
      asc= reg_font->max_bounds.ascent;
      tw= XTextWidth(reg_font, label, strlen(label));
      draw_fill_rectangle(gc, x+(w/2)-(tw/2)-5, y+(h/2)-asc+(asc/4)-2, tw+(2*5), reg_fontht+(2*2));
    }
  }

  XSync(display, False);
  return;
}

/*
   Many of the file descriptors opened by the parent
   before a child Process is forked may not be bound to
   any Connector of that Process. These should be closed
   just before the exec() to conserve child file descriptors.
   */
void prc_closechldfds(Process *p)
{
  Connector *c;
  int nfds, i;
  fd_set prc_fds;
  struct stat stbuf;
  
  nfds = getdtablesize();
  
  FD_ZERO(&prc_fds);
  for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next)
    FD_SET(c->cnt_desc, &prc_fds);
  for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next)
    FD_SET(c->cnt_desc, &prc_fds);
  for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
    FD_SET(c->cnt_desc, &prc_fds);

  for (i= 0; i < nfds; i++) {
    if (fstat(i, &stbuf) == 0) {
      if (!FD_ISSET(i, &prc_fds))
	(void) close(i);
    }
  }
  return;
}

/*
   Configure connectors for a custom process.
   */
int prc_cstcntconf(Process *p,int in,int out,int diag)
{
  Connector *c;
  int i, fd, x, xincr;
  
  if (in < out+diag)
    i= out+diag;
  else
    i= in;
  p->prc_w= (i*CNT_WIDTH)+((i-1)*CNT_WIDTH)+(CNT_WIDTH*2);
  if (p->prc_w < PRCSSF_WIDTH)
    p->prc_w= PRCSSF_WIDTH;
  p->prc_h= PRCSSF_HEIGHT+(2*small_fontht);
  
  fd= 3;
  if (in > 0) {
    if (in > 1) {
      xincr= ((p->prc_w-(in*CNT_WIDTH)-(CNT_WIDTH*2))/(in-1))+CNT_WIDTH;
      x= CNT_WIDTH+(CNT_WIDTH/2);
    }
    else
      x= p->prc_w/2;
    for (i= 0; i < in; i++, x+= xincr, fd++) {
/*
   We always want to use descriptor 1 for the first output
*/
      if (i == 0) {
        if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, 0)) == (Connector *) NULL)
	  return(IKP_FAILURE);
	fd--;
        }
      else {
        if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, fd)) == (Connector *) NULL)
	  return(IKP_FAILURE);
        }
      c->cnt_x= x;
      c->cnt_y= 0;
      c->cnt_orient= UP;
    }
  }
  if (out+diag > 0) {
    if (out+diag > 1) {
      xincr= ((p->prc_w-((out+diag)*CNT_WIDTH)-(CNT_WIDTH*2))/(out+diag-1))+CNT_WIDTH;
      x= CNT_WIDTH+(CNT_WIDTH/2);
    }
    else
      x= p->prc_w/2;
    for (i= 0; i < out; i++, x+= xincr, fd++) {
/*
   We always want to use descriptor 1 for the first output
*/
      if (i == 0) {
        if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, 1)) == (Connector *) NULL)
	  return(IKP_FAILURE);
	fd--;
        }
      else {
        if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, fd)) == (Connector *) NULL)
	  return(IKP_FAILURE);
        }
      c->cnt_x= x;
      c->cnt_y= p->prc_h-1;
      c->cnt_orient= DOWN;
    }
    for (i= 0; i < diag; i++, x+= xincr, fd++) {
/*
   We always want to use descriptor 2 for the first output
*/
      if (i == 0) {
        if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, 2)) == (Connector *) NULL)
	  return(IKP_FAILURE);
	fd--;
        }
      else {
        if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, fd)) == (Connector *) NULL)
	  return(IKP_FAILURE);
        }
      c->cnt_x= x;
      c->cnt_y= p->prc_h-1;
      c->cnt_orient= DOWN;
    }
  }
  return(IKP_SUCCESS);
}

/*
   Configure connectors for a library process.
   */
int prc_libcntconf(Process *p)
{
  Connector *c;
  int in, out, diag;
  int i, x, xincr;
  Mdlio *mio;
  
  for (mio= p->prc_module->mdl_input, in= 0; mio != (Mdlio *) NULL; mio= mio->mdlio_next, in++);
  for (mio= p->prc_module->mdl_output, out= 0; mio != (Mdlio *) NULL; mio= mio->mdlio_next, out++);
  for (mio= p->prc_module->mdl_diag, diag= 0; mio != (Mdlio *) NULL; mio= mio->mdlio_next, diag++);
  if (in < out+diag)
    i= out+diag;
  else
    i= in;
  p->prc_w= (i*CNT_WIDTH)+((i-1)*CNT_WIDTH)+(CNT_WIDTH*2);
  if (p->prc_w < PRCSSF_WIDTH)
    p->prc_w= PRCSSF_WIDTH;
  p->prc_h= PRCSSF_HEIGHT+(2*small_fontht);
  
  if (in > 0) {
    if (in > 1) {
      xincr= ((p->prc_w-(in*CNT_WIDTH)-(CNT_WIDTH*2))/(in-1))+CNT_WIDTH;
      x= CNT_WIDTH+(CNT_WIDTH/2);
    }
    else
      x= p->prc_w/2;
    for (mio= p->prc_module->mdl_input; mio != (Mdlio *) NULL; mio= mio->mdlio_next, x+= xincr) {
      if ((c= cnt_create(p, CNT_INPUT, CNT_ALL, mio->mdlio_fd)) == (Connector *) NULL)
	return(IKP_FAILURE);
      c->cnt_x= x;
      c->cnt_y= 0;
      c->cnt_orient= UP;
    }
  }
  if (out+diag > 0) {
    if (out+diag > 1) {
      xincr= ((p->prc_w-((out+diag)*CNT_WIDTH)-(CNT_WIDTH*2))/(out+diag-1))+CNT_WIDTH;
      x= CNT_WIDTH+(CNT_WIDTH/2);
    }
    else
      x= p->prc_w/2;
    for (mio= p->prc_module->mdl_output; mio != (Mdlio *) NULL; mio= mio->mdlio_next, x+= xincr) {
      if ((c= cnt_create(p, CNT_OUTPUT, CNT_ALL, mio->mdlio_fd)) == (Connector *) NULL)
	return(IKP_FAILURE);
      c->cnt_x= x;
      c->cnt_y= p->prc_h-1;
      c->cnt_orient= DOWN;
    }
    for (mio= p->prc_module->mdl_diag; mio != (Mdlio *) NULL; mio= mio->mdlio_next, x+= xincr) {
      if ((c= cnt_create(p, CNT_DIAG, CNT_ALL, mio->mdlio_fd)) == (Connector *) NULL)
	return(IKP_FAILURE);
      c->cnt_x= x;
      c->cnt_y= p->prc_h-1;
      c->cnt_orient= DOWN;
    }
  }
  return(IKP_SUCCESS);
}

Process *prc_copy(Process *p,int x,int y,int mode)
{
  Process *new;
  Net *nt;
  Connector *c, *d;
  int freemode;
  Mdlitem *mi;
  
  if ((new= (Process *) calloc(1, sizeof(Process))) == (Process *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  
  new->prc_type= p->prc_type;
  new->prc_x= x;
  new->prc_y= y;
  new->prc_w= p->prc_w;
  new->prc_h= p->prc_h;
  new->prc_argv= (char **) NULL;
  new->prc_input= new->prc_output= new->prc_diag= (Connector *) NULL;
  new->prc_flags= 0;
  new->prc_image= (XImage *) NULL;
  new->prc_module= (Module *) NULL;
  new->prc_next= (Process *) NULL;
  new->prc_tmp_host=NULL;
  if (p->prc_host == (char *) NULL)
    new->prc_host= (char *) NULL;
  else 
    if (strlen(p->prc_host) == 0)
      new->prc_host= (char *) NULL;
    else {
      if ((new->prc_host= calloc((unsigned) (strlen(p->prc_host)+1), sizeof(char))) == (char *) NULL)
	ikp_err("Memory allocation error.", FATAL);
      (void) strcpy(new->prc_host, p->prc_host);
    }
  if (p->prc_user == (char *) NULL)
    new->prc_user= (char *) NULL;
  else if (strlen(p->prc_user) == 0)
    new->prc_user= (char *) NULL;
  else {
    if ((new->prc_user= calloc((unsigned) (strlen(p->prc_user)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->prc_user, p->prc_user);
  }
  if (p->prc_comm == (char *) NULL)
    new->prc_comm= (char *) NULL;
  else if (strlen(p->prc_comm) == 0)
		new->prc_comm= (char *) NULL;
  else {
    if ((new->prc_comm= calloc((unsigned) (strlen(p->prc_comm)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->prc_comm, p->prc_comm);
  }
  if (p->prc_dir == (char *) NULL)
    new->prc_dir= (char *) NULL;
  else if (strlen(p->prc_dir) == 0)
    new->prc_dir= (char *) NULL;
  else {
    if ((new->prc_dir= calloc((unsigned) (strlen(p->prc_dir)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->prc_dir, p->prc_dir);
  }
  if (p->prc_label == (char *) NULL)
    new->prc_label= (char *) NULL;
  else if (strlen(p->prc_label) == 0)
    new->prc_label= (char *) NULL;
  else {
    if ((new->prc_label= calloc((unsigned) (strlen(p->prc_label)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->prc_label, p->prc_label);
  }
  if (p->prc_imagefile == (char *) NULL)
    new->prc_imagefile= (char *) NULL;
  else if (strlen(p->prc_imagefile) == 0)
    new->prc_imagefile= (char *) NULL;
  else {
    if ((new->prc_imagefile= calloc((unsigned) (strlen(p->prc_imagefile)+1), sizeof(char))) == (char *) NULL)
			ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->prc_imagefile, p->prc_imagefile);
  }
  
  if (mode == PRC_STANDALONE) {
    if ((nt= net_create()) == (Net *) NULL) {
      free((char *) new);
      return((Process *) NULL);
    }
    nt->net_prclist= new;
    nt->net_next= nets;
    nets= curr_net= nt;
    new->prc_net= (caddr_t) nt;
		freemode= PRC_FREENET;
  }
  else {
    new->prc_net= (caddr_t) NULL;
    freemode= PRC_RETAINNET;
  }
  
  for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next) {
    if ((d= cnt_create(new, c->cnt_iodir, c->cnt_class, c->cnt_desc)) == (Connector *) NULL) {
      prc_free(new, freemode);
      return((Process *) NULL);
    }
    d->cnt_orient= c->cnt_orient;
    d->cnt_x= c->cnt_x;
    d->cnt_y= c->cnt_y;
    if (mode == PRC_NETCONNECT) {
      d->cnt_tag= c->cnt_tag;
      d->cnt_conntag= c->cnt_conntag;
      d->cnt_flags= c->cnt_flags & ~CNT_GRNDDRAWN;
      if (c->cnt_filename == (char *) NULL)
	d->cnt_filename= (char *) NULL;
      else if (strlen(c->cnt_filename) == 0)
	d->cnt_filename= (char *) NULL;
      else {
	if ((d->cnt_filename= calloc((unsigned) (strlen(c->cnt_filename)+1), sizeof(char))) == (char *) NULL)
	  ikp_err("Memory allocation error.", FATAL);
	(void) strcpy(d->cnt_filename, c->cnt_filename);
      }
    }
  }
  for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next) {
    if ((d= cnt_create(new, c->cnt_iodir, c->cnt_class, c->cnt_desc)) == (Connector *) NULL) {
      prc_free(new, freemode);
      return((Process *) NULL);
    }
    d->cnt_orient= c->cnt_orient;
    d->cnt_x= c->cnt_x;
    d->cnt_y= c->cnt_y;
    if (mode == PRC_NETCONNECT) {
      d->cnt_tag= c->cnt_tag;
      d->cnt_conntag= c->cnt_conntag;
      d->cnt_flags= c->cnt_flags & ~CNT_GRNDDRAWN;
      if (c->cnt_filename == (char *) NULL)
	d->cnt_filename= (char *) NULL;
      else if (strlen(c->cnt_filename) == 0)
	d->cnt_filename= (char *) NULL;
      else {
	if ((d->cnt_filename= calloc((unsigned) (strlen(c->cnt_filename)+1), sizeof(char))) == (char *) NULL)
	  ikp_err("Memory allocation error.", FATAL);
	(void) strcpy(d->cnt_filename, c->cnt_filename);
      }
    }
  }
  for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next) {
    if ((d= cnt_create(new, c->cnt_iodir, c->cnt_class, c->cnt_desc)) == (Connector *) NULL) {
      prc_free(new, freemode);
      return((Process *) NULL);
    }
    d->cnt_orient= c->cnt_orient;
    d->cnt_x= c->cnt_x;
    d->cnt_y= c->cnt_y;
    if (mode == PRC_NETCONNECT) {
      d->cnt_tag= c->cnt_tag;
      d->cnt_conntag= c->cnt_conntag;
      d->cnt_flags= c->cnt_flags & ~CNT_GRNDDRAWN;
      if (c->cnt_filename == (char *) NULL)
	d->cnt_filename= (char *) NULL;
      else if (strlen(c->cnt_filename) == 0)
	d->cnt_filename= (char *) NULL;
      else {
	if ((d->cnt_filename= calloc((unsigned) (strlen(c->cnt_filename)+1), sizeof(char))) == (char *) NULL)
	  ikp_err("Memory allocation error.", FATAL);
			  (void) strcpy(d->cnt_filename, c->cnt_filename);
      }
    }
  }
  
  switch (new->prc_type) {
  case PRC_SOURCE:
  case PRC_SINK:
  case PRC_SCRIPT:
  case PRC_FILTER:
  case PRC_CUSTOM:
    new->prc_flags|= PRC_VARPROC;
    break;
  case PRC_LIBRARY:
    if ((new->prc_module= mdl_copy(p->prc_module)) == (Module *) NULL) {
      prc_free(new, freemode);
      return((Process *) NULL);
    }
    new->prc_module->mdl_process= (caddr_t) new;
    break;
  default:
    break;
  }
  
  return(new);
}


