/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <ctype.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

void seg_erasepath(Connector *);
void seg_draw(Segment *);
void seg_erase(Segment *);

Segment *seg_create()
{
  Segment *s;
  
  if ((s= (Segment *) calloc(1, sizeof(Segment))) == (Segment *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  s->seg_flags= 0;
  s->seg_prev= s->seg_next= (Segment *) NULL;
  return(s);
}

seg_freepath(Connector *c)
{
  Segment *s, *t;
  
  for (s= c->cnt_seglist; s != (Segment *) NULL; s= t) {
    t= s->seg_next;
    free((char *) s);
  }
  c->cnt_seglist= (Segment *) NULL;
  if (c->cnt_conn != (Connector *) NULL)
    c->cnt_conn->cnt_seglist= (Segment *) NULL;
  return;
}

seg_bldpath(Connector *c1,Connector *c2)
{
  Segment *s;
  Process *p1, *p2;
  
  if ((c1 == (Connector *) NULL) || (c2 == (Connector *) NULL))
    return;
  
  if ((s= seg_create()) == (Segment *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  p1= (Process *) c1->cnt_process;
  p2= (Process *) c2->cnt_process;
  c1->cnt_seglist= c2->cnt_seglist= s;
  
  s->seg_x= p1->prc_x+c1->cnt_x;
  s->seg_y= p1->prc_y+c1->cnt_y;
  switch (c1->cnt_orient) {
  case UP:
    s->seg_y-=20;
    break;
  case DOWN:
    s->seg_y+=20;
    break;
  case LEFT:
    s->seg_x-=20;
    break;
  case RIGHT:
    s->seg_x+=20;
    break;
  }
  
  s->seg_x1= p2->prc_x+c2->cnt_x;
  s->seg_y1= p2->prc_y+c2->cnt_y;
  switch (c2->cnt_orient) {
  case UP:
    s->seg_y1-=20;
    break;
  case DOWN:
    s->seg_y1+=20;
    break;
  case LEFT:
    s->seg_x1-=20;
    break;
  case RIGHT:
    s->seg_x1+=20;
    break;
  }
}

void seg_drawpath(Connector *c)
{
  Segment *s;
  
  for (s= c->cnt_seglist; s != (Segment *) NULL; s= s->seg_next) {
    if (!(s->seg_flags & SEG_DRAWN))
      seg_draw(s);
  }
  
  return;
}

void seg_draw(Segment *s)
{
  
  draw_line(net_gc, s->seg_x, s->seg_y, s->seg_x1, s->seg_y1);
  draw_line(net_xgc, s->seg_x, s->seg_y, s->seg_x1, s->seg_y1);
  draw_line(net_xgc, s->seg_x, s->seg_y, s->seg_x1, s->seg_y1);
  s->seg_flags|= SEG_DRAWN;
  return;
}

void seg_erasepath(Connector *c)
{
  Segment *s;
  
  for (s= c->cnt_seglist; s != (Segment *) NULL; s= s->seg_next) {
    if (s->seg_flags & SEG_DRAWN)
      seg_erase(s);
  }
  return;
}

void seg_erase(Segment *s)
{
  
  draw_line(net_xgc, s->seg_x, s->seg_y, s->seg_x1, s->seg_y1);
  s->seg_flags&= ~SEG_DRAWN;
  return;
}
