/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

/*
   Maintain a list of processes which we have terminated
   but not yet wait()ed for.
*/

wtp_add(int pid)
{
  Waitproc *w;
  
  if ((w= (Waitproc *) calloc(1, sizeof(Waitproc))) == (Waitproc *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  
  w->wtp_pid= pid;
  w->wtp_next= waitlist;
  waitlist= w;
  return;
}

int wtp_delete(int pid)
{
  Waitproc *w, *x;
  
  for (w= waitlist; w != (Waitproc *) NULL; w= w->wtp_next) {
    if (w->wtp_pid == pid)
      break;
  }
  if (w == (Waitproc *) NULL)
    return(IKP_FAILURE);
  if (w == waitlist)
    waitlist= w->wtp_next;
  else {
    for (x= waitlist; x->wtp_next != w; x= x->wtp_next);
    x->wtp_next= w->wtp_next;
  }
  free((char *) w);
  return(IKP_SUCCESS);
}
