/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "ikp_defines.h"
#include "ikp_externs.h"

void get_xdefaults(char *name)
{
  char *g, *f, *bw, *fgc, *bgc, *bdrc;
  int screen;
  XColor fg, bg, bdr;
  
  /* geometry */
  net_width= NETFRAME_WIDTH;
  net_height= NETFRAME_HEIGHT;
  net_left= net_top= 100;
  if ((g= XGetDefault(display, name, "Geometry")) == (char *) NULL)
    strcpy(geometry, GEOMETRY);
  else
    strncpy(geometry, g, MAX_GEOM_LEN);
  
  /* font */
  if ((f= XGetDefault(display, name, "Font")) == (char *) NULL)
    strcpy(reg_fontnm, REG_FONT);
  else
    strncpy(reg_fontnm, f, MAXFILENMSZ);
  if ((reg_font= XLoadQueryFont(display, reg_fontnm)) == NULL) {
/*
    fprintf(stderr, "%s: cannot load font %s\n", progname, DisplayString(display), reg_fontnm);
*/
    fprintf(stderr, "%s: cannot load font %s\n", progname, reg_fontnm);
    exit(-1);
  }
  reg_fontht= reg_font->max_bounds.ascent+reg_font->max_bounds.descent;
  reg_charwd= XTextWidth(reg_font, "X", strlen("X"));
  
  /* border width */
  if ((bw= XGetDefault(display, name, "BorderWidth")) == (char *) NULL)
    border_wd= BORDER_WIDTH;
  else {
    border_wd= atoi(bw);
    if (border_wd <= 0)
      border_wd= BORDER_WIDTH;
  }
  
  /* foreground, background and border colors */
  screen= DefaultScreen(display);
  fg_pixel= bdr_pixel= BlackPixel(display, screen);
  bg_pixel= WhitePixel(display, screen);
  fgc= XGetDefault(display, name, "Foreground");
  bgc= XGetDefault(display, name, "Background");
  bdrc= XGetDefault(display, name, "Border");
  switch (DefaultDepth(display, screen)) {
  case 1:
    if (fgc) {
      if (!strncmp(fgc, "w", 1) || !strncmp(fgc, "W", 1)) {
	fg_pixel= WhitePixel(display, screen);
	bg_pixel= BlackPixel(display, screen);
      }
      else {
	fg_pixel= BlackPixel(display, screen);
	bg_pixel= WhitePixel(display, screen);
      }
    }
    else if (bgc) {
      if (!strncmp(bgc, "w", 1) || !strncmp(bgc, "W", 1)) {
	bg_pixel= WhitePixel(display, screen);
	fg_pixel= BlackPixel(display, screen);
      }
      else {
	bg_pixel= BlackPixel(display, screen);
	fg_pixel= WhitePixel(display, screen);
      }
    }
    if (bdrc) {
      if (!strncmp(bdrc, "w", 1) ||  !strncmp(bdrc, "W", 1))
	bdr_pixel= WhitePixel(display, screen);
      else
	bdr_pixel= BlackPixel(display, screen);
    }
    break;
    
  case 8:
    if (fgc && XParseColor(display, cmap, fgc, &fg) && XAllocColor(display, cmap, &fg))
      fg_pixel= fg.pixel;
    if (bgc && XParseColor(display, cmap, bgc, &bg) && XAllocColor(display, cmap, &bg))
      bg_pixel= bg.pixel;
    if (bdrc && XParseColor(display, cmap, bdrc, &bdr) && XAllocColor(display, cmap, &bdr))
      bdr_pixel= bdr.pixel;
    break;
  default:
    break;
  }
  
  return;
}
