/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "ikp_defines.h"
#include "ikp_remote.h"

#ifdef SOLARIS
#include <fcntl.h>
#include <sys/socket.h>
#include <netdb.h>
void chkfds();
#endif
extern char **environ;

/* extern char *strcpy(), *strcat(); */
/*#ifndef SOLARIS*/
/*extern char *calloc();*/
/*#endif*/

extern char *progname;
extern int verbose;
extern struct sockaddr_in client_addr;
extern int control_pid, proc_pid;
extern int server, control;
extern Ioc *iolist;
extern Diag *diaglist;
extern char *user_name;
extern char *remuser_name;
extern int remuser_id, remgroup_id;
extern char **proc_argv;
extern char **proc_envv;
extern char hostname[];
extern int mode;
extern char chld_state;
extern int sig_type, exit_code;
extern char diagbuf[];
extern char *diagrdptr, *diagwrptr;
extern int diagbuflen;
extern int errfd;
extern FILE *errfp;
extern char *logfile;

extern char *arch, home[];

void
ikpd_success()
{
	char success;

	success= IKPRP_SUCCESS;
	if (buf_write(control, &success, sizeof(char)) != sizeof(char))
		exit(-1);
	return;
}

void
ikpd_failure(code)
int code;
{
	char failure;
	u_long ul;

	failure= IKPRP_FAILURE;
	(void) buf_write(control, &failure, sizeof(char));
	ul= htonl((u_long) code);
	(void) buf_write(control, (char *) &ul, sizeof(u_long));
	ul= htonl((u_long) errno);
	if (verbose)
		(void) fprintf(errfp, "errno = %d\n", errno);
	(void) buf_write(control, (char *) &ul, sizeof(u_long));
	exit(-1);
}

void
ikpd_status()
{
	u_long ul;
	void ikpd_wrdiag();

	if (diagbuflen > 0)
		ikpd_wrdiag();

	if (buf_write(control, &chld_state, sizeof(char)) != sizeof(char))
		exit(-1);

	switch (chld_state) {
	case IKPRP_SETUP:
	case IKPRP_RUNNING:
		break;
	case IKPRP_EXITED:
		ul= htonl((u_long) exit_code);
		if (buf_write(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
			exit(-1);
		break;
	case IKPRP_STOPPED:
	case IKPRP_KILLED:
		ul= htonl((u_long) sig_type);
		if (buf_write(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
			exit(-1);
		break;
	}
	return;
}

Ioc *
ioc_create(fd, type)
int fd, type;
{
	Ioc *i, *j;
	void ikpd_failure();

	if ((i= (Ioc *) calloc(1, sizeof(Ioc))) == (Ioc *) NULL)
		ikpd_failure(IKP_MEMALLOC);

	i->ioc_fd= fd;
	i->ioc_flags= type;
	i->ioc_port= 0;
	i->ioc_next= (Ioc *) NULL;

	if (iolist == (Ioc *) NULL)
		iolist= i;
	else {
		for (j= iolist; j->ioc_next != (Ioc *) NULL; j= j->ioc_next);
		j->ioc_next= i;
	}
	return(i);
}

Diag *
diag_create(fd)
int fd;
{
	Diag *d, *e;
	void ikpd_failure();

	if ((d= (Diag *) calloc(1, sizeof(Diag))) == (Diag *) NULL)
		ikpd_failure(IKP_MEMALLOC);

	d->diag_fd= fd;
	d->diag_next= (Diag *) NULL;

	if (diaglist == (Diag *) NULL)
		diaglist= d;
	else {
		for (e= diaglist; e->diag_next != (Diag *) NULL; e= e->diag_next);
		e->diag_next= d;
	}
	return(d);
}

void
ikpd_hostname()
{
	char *log_flag = ":debug";
	int len;
	u_long ul;
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	if (len <= 0)
		ikpd_failure(IKP_PERMISSION);
	if (buf_read(control, hostname, len) != len)
		ikpd_failure(IKP_READ);
	hostname[len] = '\0';
  
/* this is a backdoor debugging mechanism. If the hostname in the remote
   process box is entered as "host:debug", turn on verbose mode if it is
   not already on and open the log file. This log file will later be 
   chown'ed to the user's id and group. 	- joe m. wade 1/19/96
*/
	if (strstr(hostname,log_flag) != NULL) {
	  if (verbose == 0) verbose = 5;
	  if (errfp == stderr) { 	/* may be already opened */
	    fclose(errfp);
	    }
	  logfile = (char *) malloc(256*sizeof(char));
	  sprintf(logfile,"/tmp/ikpd.log.%d",getpid());

	  if ((errfd= open(logfile, O_WRONLY | O_TRUNC | O_CREAT, 0644)) < 0) {
		(void) fprintf(errfp, "%s: logfile open error\n", progname);
		exit(-1);
		}
	  if (dup2(errfd, 30) < 0) {
		(void) fprintf(errfp, "%s: logfile dup2 error\n", progname);
		exit(-1);
		}
	  (void) close(errfd);
	  errfd= 30;
	  if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL) {
		(void) fprintf(errfp, "%s: logfile fdopen error\n", progname);
		exit(-1);
		}
	  setbuf(errfp,NULL);
	  hostname[strlen(hostname)-strlen(log_flag)] = '\0';
	  }

	if (verbose)
	  fprintf(errfp,"HOSTNAME %s\n",hostname);
	ikpd_success();
	return;
}

void
ikpd_username()
{
	int len;
	u_long ul;
	struct passwd *pw;
	struct hostent *hp;
	FILE *fp;
	struct passwd *getpwnam();
	struct hostent *gethostbyaddr();
	boolean ikpd_authuser();
	FILE *fopen();
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	if (len <= 0)
		ikpd_failure(IKP_PERMISSION);
	if ((user_name= calloc((unsigned) (len+1), sizeof(char))) == (char *) NULL)
		ikpd_failure(IKP_MEMALLOC);
	if (buf_read(control, user_name, len) != len)
		ikpd_failure(IKP_READ);
	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	if (len <= 0)
		ikpd_failure(IKP_PERMISSION);
	if ((remuser_name= calloc((unsigned) (len+1), sizeof(char))) == (char *) NULL)
		ikpd_failure(IKP_MEMALLOC);
	if (buf_read(control, remuser_name, len) != len)
		ikpd_failure(IKP_READ);

	if (verbose)
		(void) fprintf(errfp, "USERNAME '%s' -> '%s'\n", user_name, remuser_name);
	if ((pw= getpwnam(remuser_name)) == (struct passwd *) NULL) {
	        if (verbose)
		  (void) fprintf(errfp,
			"FAILURE unable to perform getpwnam on %s\n",
			remuser_name);
		ikpd_failure(IKP_PERMISSION);
		}
	remuser_id= pw->pw_uid;
	remgroup_id= pw->pw_gid;
	(void) strcpy(home, pw->pw_dir);
	if (remuser_id < 10) {
		if (verbose)
		  (void) fprintf(errfp, "remuserid = %d  < 10\n", remuser_id);
		ikpd_failure(IKP_PERMISSION);
		}

	/* find out what host the client is coming in from,
	   and make sure that there is a corresponding entry
	   in the stated user's .rhosts file */

	if ((hp= gethostbyaddr((char *) &(client_addr.sin_addr.s_addr), (int) sizeof(client_addr.sin_addr.s_addr), AF_INET)) == (struct hostent *) NULL) {
		if (verbose)
		  (void) fprintf(errfp, "gethostbyaddr failure\n");
		ikpd_failure(IKP_GETHOSTBYADDR);
		}
	if (chdir(pw->pw_dir) < 0)
		ikpd_failure(IKP_CHDIR);
	if ((fp= fopen(".rhosts", "r")) == (FILE *) NULL)
		ikpd_failure(IKP_PERMISSION);
	if (ikpd_authuser(hp->h_name, fp) == FALSE)
		ikpd_failure(IKP_PERMISSION);
	if (fclose(fp) != 0)
		ikpd_failure(IKP_CLOSE);

/* - old sun stuff - not portable
	if (setregid(remgroup_id, remgroup_id) < 0)
		ikpd_failure(IKP_SETUID);
	if (setreuid(remuser_id, remuser_id) < 0)
		ikpd_failure(IKP_SETUID);
*/
/* change ownership of the log file to the user  - joe m. wade  - 1/19/95 */

	if ((verbose != 0)  && (logfile != NULL))
	   chown(logfile,remuser_id,remgroup_id);

	if (setgid(remgroup_id) < 0)
		ikpd_failure(IKP_SETUID);
	if (setuid(remuser_id) < 0)
		ikpd_failure(IKP_SETUID);

	ikpd_success();
	return;
}

boolean
ikpd_authuser(host, fp)
char *host;
FILE *fp;
{
	boolean found;
	char buf[256];
	char hname[MAXTOKENSZ+1], uname[MAXTOKENSZ+1];
	int utoken;

	for (found= FALSE; fgets(buf, 256, fp) != (char *) NULL; ) {
		if (ikp_gettoken(buf, 0, hname, MAXTOKENSZ) != IKP_SUCCESS)
			continue;
		if (strcmp(hname, host))
			continue;

		/* hostname matched */

		utoken= ikp_gettoken(buf, 1, uname, MAXTOKENSZ);

		if (!strcmp(user_name, remuser_name)) {
			if (utoken == IKP_FAILURE) {
				if (verbose)
					(void) fprintf(errfp, "AUTHENTICATED '%s:%s'\n", hname, user_name);
				found= TRUE;
				break;
			}
			else if (!strcmp(uname, user_name)) {
				if (verbose)
					(void) fprintf(errfp, "AUTHENTICATED '%s:%s'\n", hname, user_name);
				found= TRUE;
				break;
			}
		}
		else {
			if ((utoken == IKP_SUCCESS) && !strcmp(uname, user_name)) {
				if (verbose)
					(void) fprintf(errfp, "AUTHENTICATED '%s:%s'\n", hname, user_name);
				found= TRUE;
				break;
			}
		}
	}
	return(found);
}

void
ikpd_dir()
{
	int len;
	u_long ul;
	char *dir;
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	if (len <= 0)
		ikpd_failure(IKP_CHDIR);
	if ((dir= calloc((unsigned) (len+1), sizeof(char))) == (char *) NULL)
		ikpd_failure(IKP_MEMALLOC);
	if (buf_read(control, dir, len) != len)
		ikpd_failure(IKP_READ);
	if (verbose)
		(void) fprintf(errfp, "DIR '%s'\n", dir);
	if (chdir(dir) < 0) {
/*
   - changed directory change to be non-fatal. User's home directory will
     be used.						- joe m. wade 1/19/96
		ikpd_failure(IKP_CHDIR);
*/
		dir = getcwd(dir,len+1);
		if (verbose) {
		  (void) fprintf(errfp, "CHDIR FAILED; ");
		  (void) fprintf(errfp, "CURRENT DIR '%s'\n", dir);
		  }
		}
	free(dir);

	ikpd_success();
	return;
}

void
ikpd_argv()
{
	int count, len;
	u_long ul;
	char **c;
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	count= (int) ntohl(ul);
	if (count <= 0)
		ikpd_failure(IKP_BADPRCARGV);
	if ((proc_argv= (char **) calloc((unsigned) (count+1), sizeof(char *))) == (char **) NULL)
		ikpd_failure(IKP_MEMALLOC);

	if (verbose)
		(void) fprintf(errfp, "ARGV '");
	for (c= proc_argv; count > 0; c++, count--) {
		if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
			ikpd_failure(IKP_READ);
		len= (int) ntohl(ul);
		if ((*c= calloc((unsigned) (len+1), sizeof(char))) == (char *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		if (buf_read(control, *c, len) != len)
			ikpd_failure(IKP_READ);
		(*c)[len]= '\0';
		if (verbose)
			(void) fprintf(errfp, "%s ", *c);
	}
	if (verbose)
		(void) fprintf(errfp, "'\n");
	*c= (char *) NULL;

	ikpd_success();
	return;
}

void
ikpd_envv()
{
	int i, count, len;
	u_long ul;
	char **c;
	void ikpd_success(), ikpd_failure();
	void ikpd_adjarch(), ikpd_adjhome(), ikpd_adjpath();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	count= (int) ntohl(ul);
	if (count <= 0)
		ikpd_failure(IKP_BADPRCARGV);

	if (verbose)
		(void) fprintf(errfp, "ENVV %d\n", count);

	/* save one slot each for ARCH, HOME and terminating NULL */
	if ((proc_envv= (char **) calloc((unsigned) (count+3), sizeof(char *))) == (char **) NULL)
		ikpd_failure(IKP_MEMALLOC);

	for (i= 0, c= proc_envv; i < count; i++, c++) {
		if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
			ikpd_failure(IKP_READ);
		len= (int) ntohl(ul);
		if ((*c= calloc((unsigned) (len+1), sizeof(char))) == (char *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		if (buf_read(control, *c, len) != len)
			ikpd_failure(IKP_READ);
		(*c)[len]= '\0';
		if (verbose >= 5) {
			(void) fprintf(errfp, "%s\n", *c);
			}
	}

	/* this slot to be used for ARCH
	   if it is not passed from the client */
	*c++= (char *) NULL;

	/* this slot to be used for HOME
	   if it is not passed from the client */
	*c++= (char *) NULL;

	/* this slot for the terminating NULL */
	*c= (char *) NULL;

	ikpd_adjarch();
	ikpd_adjhome();
	ikpd_adjpath();
	environ= proc_envv;

	ikpd_success();
	return;
}

void
ikpd_adjarch()
/*
   replace all instances of ARCHPATTERN
   in process environment variables
*/
{
	char **ev;
	char *newev;
	int matchlen, replen;
	char *c, *d;
	boolean arch_set;

	arch_set= FALSE;
	matchlen= strlen(ARCHPATTERN);
	replen= strlen(arch);
	for (ev= proc_envv; *ev != (char *) NULL; ev++) {

		if (!strncmp(*ev, "ARCH=", 5)) {
			if ((newev= calloc((unsigned) (strlen("ARCH=")+strlen(arch)+1), sizeof(char))) == (char *) NULL)
				ikpd_failure(IKP_MEMALLOC);
			(void) strcpy(newev, "ARCH=");
			(void) strcat(newev, arch);
			free(*ev);
			*ev= newev;
			arch_set= TRUE;
		}
		else {
			for (c= *ev; c != (char *) NULL; ) {
				if (strlen(c) < matchlen)
					break;
				if (!strncmp(c, ARCHPATTERN, matchlen)) {
					d= c+matchlen;
					if ((newev= calloc((unsigned) (c-(*ev)+replen+strlen(d)+1), sizeof(char))) == (char *) NULL)
						ikpd_failure(IKP_MEMALLOC);
					(void) strncpy(newev, *ev, c-(*ev));
					(void) strcat(newev, arch);
					(void) strcat(newev, d);
					c= (char *) (newev+(c-(*ev))+replen);
					free(*ev);
					*ev= newev;
				}
				else
					c++;
			}
		}
	}
	if (!arch_set) {
		if ((newev= calloc((unsigned) (strlen("ARCH=")+strlen(arch)+1), sizeof(char))) == (char *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		(void) strcpy(newev, "ARCH=");
		(void) strcat(newev, arch);
		*ev= newev;
	}
	return;
}

void
ikpd_adjhome()
/*
   replace all instances of HOMEPATTERN
   in process environment variables
*/
{
	char **ev;
	char *newev;
	int matchlen, replen;
	char *c, *d;
	boolean home_set;

	home_set= FALSE;
	matchlen= strlen(HOMEPATTERN);
	replen= strlen(home);
	for (ev= proc_envv; *ev != (char *) NULL; ev++) {

		if (!strncmp(*ev, "HOME=", 5)) {
			if ((newev= calloc((unsigned) (strlen("HOME=")+strlen(home)+1), sizeof(char))) == (char *) NULL)
				ikpd_failure(IKP_MEMALLOC);
			(void) strcpy(newev, "HOME=");
			(void) strcat(newev, home);
			free(*ev);
			*ev= newev;
			home_set= TRUE;
		}
		else {
			for (c= *ev; c != (char *) NULL; ) {
				if (strlen(c) < matchlen)
					break;
				if (!strncmp(c, HOMEPATTERN, matchlen)) {
					d= c+matchlen;
					if ((newev= calloc((unsigned) (c-(*ev)+replen+strlen(d)+1), sizeof(char))) == (char *) NULL)
						ikpd_failure(IKP_MEMALLOC);
					(void) strncpy(newev, *ev, c-(*ev));
					(void) strcat(newev, home);
					(void) strcat(newev, d);
					c= (char *) (newev+(c-(*ev))+replen);
					free(*ev);
					*ev= newev;
				}
				else
					c++;
			}
		}
	}
	if (!home_set) {
		if ((newev= calloc((unsigned) (strlen("HOME=")+strlen(home)+1), sizeof(char))) == (char *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		(void) strcpy(newev, "HOME=");
		(void) strcat(newev, home);
		*ev= newev;
	}
	return;
}

void
ikpd_adjpath()
/*
   set PATH to the value passed as IKPRPATH
*/
{
	char **ev, **ikppathev, **pathev;
	char *ikppath, *newpath;

	/* locate IKPRPATH */
	for (ev= proc_envv; *ev != (char *) NULL; ev++) {
		if (!strncmp(*ev, "IKPRPATH=", strlen("IKPRPATH=")))
			break;
	}

	/* not found, so use existing PATH */
	if (*ev == (char *) NULL)
		return;

	ikppathev= ev;

	/* locate existing PATH */
	for (ev= proc_envv; *ev != (char *) NULL; ev++) {
		if (!strncmp(*ev, "PATH=", strlen("PATH=")))
			break;
	}
	pathev= ev;

	/* build new PATH */
	ikppath= (*ikppathev)+strlen("IKPRPATH=");
	if ((newpath= calloc((unsigned) (strlen("PATH=")+strlen(ikppath)+1), sizeof(char))) == (char *) NULL)
		ikpd_failure(IKP_MEMALLOC);
	(void) strcpy(newpath, "PATH=");
	(void) strcat(newpath, ikppath);

	/* reset old PATH to new, if found */
	if (*pathev != (char *) NULL) {
		free(*pathev);
		*pathev= newpath;
	}

	/* if not, store PATH in IKPRPATH slot */
	else {
		free(*ikppathev);
		*ikppathev= newpath;
	}

	if (verbose >= 5)
		(void) fprintf(errfp, "%s\n", newpath);
	return;
}

void
ikpd_fileopen(mode)
char mode;
{
	int fd, len;
	u_long ul;
	char filenm[MAXFILENMSZ+1];
	Ioc *ioc;
	Ioc *ioc_create();
	FILE *fdopen();
	void ikpd_success(), ikpd_failure();
#ifdef SOLARIS
	int newfd;
	struct stat stbuf;
#endif

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	fd= (int) ntohl(ul);
	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	bzero(filenm, MAXFILENMSZ+1);
	if (buf_read(control, filenm, len) != len)
		ikpd_failure(IKP_READ);

	switch (mode) {
	case IKPRP_FILERD:
		if ((ioc= ioc_create(fd, IOC_FILERD)) == (Ioc *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		if ((fd= open(filenm, O_RDONLY)) < 0)
			ikpd_failure(IKP_OPEN);
		break;
	case IKPRP_FILEWRTRUNC:
		if ((ioc= ioc_create(fd, IOC_FILEWR)) == (Ioc *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		if ((fd= open(filenm, O_WRONLY | O_CREAT | O_TRUNC, 0644)) < 0)
			ikpd_failure(IKP_OPEN);
		break;
	case IKPRP_FILEWRAPP:
		if ((ioc= ioc_create(fd, IOC_FILEWR)) == (Ioc *) NULL)
			ikpd_failure(IKP_MEMALLOC);
		if ((fd= open(filenm, O_WRONLY | O_CREAT, 0644)) < 0)
			ikpd_failure(IKP_OPEN);
/*
		if (lseek(fd, 0L, L_XTND) < 0)
*/
		if (lseek(fd, 0L, SEEK_END) < 0)
			ikpd_failure(IKP_SEEK);
		break;
	}
	if (verbose) {
		(void) fprintf(errfp, "FILEOPEN %d %s\n", ioc->ioc_fd, filenm);
		fflush(errfp);
		}

	if (control == ioc->ioc_fd) {
		int newcontrol;

		if ((newcontrol= dup(control)) < 0)
			ikpd_failure(IKP_DUP);
		(void) close(control);
		control= newcontrol;
	}
	if (verbose && (errfd == ioc->ioc_fd)) {
		int newerrfd;

		if ((newerrfd= dup(errfd)) < 0)
			ikpd_failure(IKP_DUP);
		(void) fflush(errfp);
		(void) close(errfd);
		errfd= newerrfd;
		if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL)
			ikpd_failure(IKP_OPEN);
	}
#ifdef SOLARIS
	if (fstat(ioc->ioc_fd, &stbuf) == 0) {
		newfd = dup(ioc->ioc_fd);
		(void) fflush(errfp);
		(void) close(ioc->ioc_fd);
	}
#endif
	if (fd != ioc->ioc_fd) {
		if (dup2(fd, ioc->ioc_fd) < 0)
			ikpd_failure(IKP_DUP2);
		(void) close(fd);
	}

	ikpd_success();
	return;
}

void
ikpd_diag()
{
	int fd;
	u_long ul;
	Diag *d;
	Diag *diag_create();
	FILE *fdopen();
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	fd= (int) ntohl(ul);

	if ((d= diag_create(fd)) == (Diag *) NULL)
		ikpd_failure(IKP_MEMALLOC);
	if (pipe(d->diag_pipe) < 0)
		ikpd_failure(IKP_OPEN);
	if (verbose)
		(void) fprintf(errfp, "DIAG %d\n", fd);

	if (control == d->diag_fd) {
		int newcontrol;

		if ((newcontrol= dup(control)) < 0)
			ikpd_failure(IKP_DUP);
		(void) close(control);
		control= newcontrol;
	}
	if (verbose && (errfd == d->diag_fd)) {
		int newerrfd;

		if ((newerrfd= dup(errfd)) < 0)
			ikpd_failure(IKP_DUP);
		(void) fflush(errfp);
		(void) close(errfd);
		errfd= newerrfd;
		if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL)
			ikpd_failure(IKP_OPEN);
	}
	if (d->diag_fd != d->diag_pipe[1]) {
		if (dup2(d->diag_pipe[1], d->diag_fd) < 0)
			ikpd_failure(IKP_DUP2);
		(void) close(d->diag_pipe[1]);
	}

	ikpd_success();
	return;
}

void
ikpd_lockfd()
{
	int fd, len, tmp, lock;
	u_long ul;
	struct stat stbuf;
	void ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	fd= (int) ntohl(ul);
	if (fstat(fd, &stbuf) == 0) {
		ikpd_success();
		return;
	}
	if (errno != EBADF)
		ikpd_failure(IKP_FSTAT);
	if ((tmp= open("/dev/null", O_RDONLY)) < 0)
		ikpd_failure(IKP_OPEN);
	if (tmp != fd) {
		if ((lock= dup2(tmp, fd)) < 0)
			ikpd_failure(IKP_DUP2);
		if (close(tmp) < 0)
			ikpd_failure(IKP_CLOSE);
	}

	ikpd_success();
	return;
}

void
ikpd_serversock()
{
	int fd, len;
	u_long ul;
	char *tmp_addr;
	Ioc *ioc;
	char command;
	struct sockaddr_in saddr;
	struct hostent *hp;
	struct hostent *gethostbyname();
	Ioc *ioc_create();
	void ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	fd= (int) ntohl(ul);
	if ((ioc= ioc_create(fd, IOC_SOCKET)) == (Ioc *) NULL)
		ikpd_failure(IKP_MEMALLOC);

	saddr.sin_family= AF_INET;
	saddr.sin_addr.s_addr= INADDR_ANY;
	saddr.sin_port= 0;

	if ((ioc->ioc_socket= socket(AF_INET, SOCK_STREAM, 0)) < 0)
		ikpd_failure(IKP_SOCKET);

	{  /* added this to set traffic size - 3/15/96 - joe m. wade */
	int optval;
	int optval_length;
	char *streamsize;
	optval = 1;
	streamsize = getenv("IKP_SOCKETSIZE");
	if (streamsize != NULL) {
	  sscanf(streamsize,"%d",&optval);
          setsockopt(ioc->ioc_socket,SOL_SOCKET,SO_SNDBUF,(char *)&optval,sizeof(int));
          setsockopt(ioc->ioc_socket,SOL_SOCKET,SO_RCVBUF,(char *)&optval,sizeof(int));
	  }
	if (verbose) {
	  optval_length = sizeof(int);
	  getsockopt(ioc->ioc_socket,SOL_SOCKET,SO_SNDBUF,(char *)&optval,&optval_length);
	  fprintf(errfp,"SO_SNDBUF = %d on socket %d\n",optval,ioc->ioc_socket);
	  optval_length = sizeof(int);
	  getsockopt(ioc->ioc_socket,SOL_SOCKET,SO_RCVBUF,(char *)&optval,&optval_length);
	  fprintf(errfp,"SO_RCVBUF = %d on socket %d\n",optval,ioc->ioc_socket);
	  }
	}

	if (bind(ioc->ioc_socket, (struct sockaddr *) &saddr, sizeof(saddr)) < 0)
		ikpd_failure(IKP_BINDSOCK);

	if (listen(ioc->ioc_socket, 1) < 0)
		ikpd_failure(IKP_LISTEN);

	command= IKPRP_SOCKADDR;
	if (buf_write(control, &command, sizeof(char)) != sizeof(char))
		exit(-1);
	if ((hp= gethostbyname(hostname)) == (struct hostent *) NULL)
		ikpd_failure(IKP_GETHOSTBYNAME);
	ul= htonl((u_long) hp->h_length);
	if (buf_write(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		exit(-1);
	if (buf_write(control, hp->h_addr, hp->h_length) != hp->h_length)
		exit(-1);

	len= sizeof(saddr);
	if (getsockname(ioc->ioc_socket, (struct sockaddr *) &saddr, &len) < 0)
		ikpd_failure(IKP_GETSOCKNAME);
	ioc->ioc_port= saddr.sin_port;
	if (buf_write(control, (char *) &(saddr.sin_port), sizeof(u_short)) != sizeof(u_short))
		exit(-1);

	if (verbose) {
/*
		bcopy(hp->h_addr, (char *) &ul, sizeof(u_long));
*/
		tmp_addr = (char *) malloc(sizeof(u_long));
		memcpy(tmp_addr, hp->h_addr, sizeof(u_long));
		memcpy((char *)&ul, tmp_addr, sizeof(u_long));
/*
		bcopy(hp->h_addr, (char *) &ul, sizeof(u_long));
*/
		(void) fprintf(errfp, "SERVERSOCK %d at %1d", fd, (int) ((ntohl(ul) >> 24) & 0377));
		(void) fprintf(errfp, ":%1d", (int) ((ntohl(ul) >> 16) & 0377));
		(void) fprintf(errfp, ":%1d", (int) ((ntohl(ul) >> 8) & 0377));
		(void) fprintf(errfp, ":%1d-%1d\n", (int) (ntohl(ul) & 0377), ntohs(saddr.sin_port));
	}
	return;
}

void
ikpd_clientsock()
{
	int fd, len;
	u_long ul;
	Ioc *ioc;
	struct sockaddr_in saddr;
	Ioc *ioc_create();
	FILE *fdopen();
	void ikpd_success(), ikpd_failure();

	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	fd= (int) ntohl(ul);
	if ((ioc= ioc_create(fd, IOC_SOCKET)) == (Ioc *) NULL)
		ikpd_failure(IKP_MEMALLOC);

	if ((ioc->ioc_socket= socket(AF_INET, SOCK_STREAM, 0)) < 0)
		ikpd_failure(IKP_SOCKET);

	saddr.sin_family= AF_INET;
	if (buf_read(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		ikpd_failure(IKP_READ);
	len= (int) ntohl(ul);
	if (buf_read(control, (char *) &(saddr.sin_addr.s_addr), len) != len)
		ikpd_failure(IKP_READ);
	if (buf_read(control, (char *) &(saddr.sin_port), sizeof(u_short)) != sizeof(u_short))
		ikpd_failure(IKP_READ);

	if (connect(ioc->ioc_socket, (struct sockaddr *) &saddr, sizeof(saddr)) < 0)
		ikpd_failure(IKP_BINDSOCK);
	ioc->ioc_flags|= IOC_CONNECTED;

	if (control == ioc->ioc_fd) {
		int newcontrol;

		if ((newcontrol= dup(control)) < 0)
			ikpd_failure(IKP_DUP);
		(void) close(control);
		control= newcontrol;
	}
	if (verbose && (errfd == ioc->ioc_fd)) {
		int newerrfd;

		if ((newerrfd= dup(errfd)) < 0)
			ikpd_failure(IKP_DUP);
		(void) fflush(errfp);
		(void) close(errfd);
		errfd= newerrfd;
		if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL)
			ikpd_failure(IKP_OPEN);
	}
	if (ioc->ioc_socket != ioc->ioc_fd) {
		if (dup2(ioc->ioc_socket, ioc->ioc_fd) < 0)
			ikpd_failure(IKP_DUP2);
		(void) close(ioc->ioc_socket);
	}

	if (verbose) {
		bcopy((char *) &(saddr.sin_addr.s_addr), (char *) &ul, sizeof(u_long));
		(void) fprintf(errfp, "CLIENTSOCK %d at %1d", fd, (int) ((ntohl(ul) >> 24) & 0377));
		(void) fprintf(errfp, ":%1d", (int) ((ntohl(ul) >> 16) & 0377));
		(void) fprintf(errfp, ":%1d", (int) ((ntohl(ul) >> 8) & 0377));
		(void) fprintf(errfp, ":%1d-%1d\n", (int) (ntohl(ul) & 0377), ntohs(saddr.sin_port));
	}

	ikpd_success();
	return;
}

void
ikpd_rddiag(fd)
/*
   Attempt to read DIAGBUFSZ bytes worth of child
   diagnostic messages into diagbuf, a circular buffer
   whose head and tail is at diagwrptr and diagrdptr.
*/
int fd;
{
	int count, nread;

	/* circular buffer empty */
	if (diagbuflen == 0) {
		nread= read(fd, diagrdptr, DIAGBUFSZ);
		if (nread < 0) {
			switch (errno) {
			case EWOULDBLOCK:
				break;
			default:
				ikpd_failure(IKP_READ);
				break;
			}
		}
		else if (nread < DIAGBUFSZ) {
			diagrdptr= diagbuf+nread;
			diagbuflen= nread;
		}
	}

	/* circular buffer partially filled */
	else if (diagbuflen < DIAGBUFSZ) {
		count= DIAGBUFSZ-(diagrdptr-diagbuf);
		nread= read(fd, diagrdptr, count);
		if (nread < 0) {
			switch (errno) {
			case EWOULDBLOCK:
				break;
			default:
				ikpd_failure(IKP_READ);
				break;
			}
		}
		else if (nread < count) {
			diagrdptr+= nread;
			diagbuflen+= nread;
		}
		else {
			diagrdptr= diagbuf;
			diagbuflen= DIAGBUFSZ;
			count= DIAGBUFSZ-nread;
			nread= read(fd, diagrdptr, count);
			if (nread < 0) {
				switch (errno) {
				case EWOULDBLOCK:
					break;
				default:
					ikpd_failure(IKP_READ);
					break;
				}
			}
			else
				diagrdptr= diagwrptr= diagbuf+nread;
		}
	}

	/* circular buffer filled but not wrapped around
	   to a point in the interior of the buffer array */
	else if (diagwrptr == diagbuf) {
		nread= read(fd, diagrdptr, DIAGBUFSZ);
		if (nread < 0) {
			switch (errno) {
			case EWOULDBLOCK:
				break;
			default:
				ikpd_failure(IKP_READ);
				break;
			}
		}
		else if (nread < DIAGBUFSZ)
			diagrdptr= diagwrptr= diagbuf+nread;
	}

	/* circular buffer filled and wrapped around
	   to a point in the interior of the buffer array */
	else {
		count= DIAGBUFSZ-(diagrdptr-diagbuf);
		nread= read(fd, diagrdptr, count);
		if (nread < 0) {
			switch (errno) {
			case EWOULDBLOCK:
				break;
			default:
				ikpd_failure(IKP_READ);
				break;
			}
		}
		else if (nread < count) {
			diagrdptr+= nread;
			diagwrptr= diagrdptr;
		}
		else {
			diagrdptr= diagwrptr= diagbuf;
			count= DIAGBUFSZ-nread;
			nread= read(fd, diagrdptr, count);
			if (nread < 0) {
				switch (errno) {
				case EWOULDBLOCK:
					break;
				default:
					ikpd_failure(IKP_READ);
					break;
				}
			}
			else
				diagrdptr= diagwrptr= diagbuf+nread;
		}
	}
	return;
}

void
ikpd_wrdiag()
/*
   Write any diagnostic messages read from child
   and stored in diagbuf onto control socket.
*/
{
	int count;
	u_long ul;
	char command;

	command= IKPRP_DIAGMSG;
	if (buf_write(control, &command, sizeof(char)) != sizeof(char))
		exit(-1);
	ul= htonl((u_long) diagbuflen);
	if (buf_write(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		exit(-1);

	/* circular buffer not yet filled, or filled but not yet wrapped
	   around to a point in the interior of the buffer array */
	if ((diagbuflen < DIAGBUFSZ) || (diagwrptr == diagbuf)) {
		if (buf_write(control, diagwrptr, diagbuflen) != diagbuflen)
			exit(-1);
	}

	/* circular buffer is filled and wrapped around to
	   some point in the interior of the buffer array */
	else {

		/* write out tail of buffer array, which is
		   actually the head of the circular buffer */
		count= DIAGBUFSZ-(diagwrptr-diagbuf);
		if (buf_write(control, diagwrptr, count) != count)
			exit(-1);

		/* write out head of buffer array, which is
		   actually the tail of the circular buffer */
		diagbuflen-= count;
		if (buf_write(control, diagbuf, diagbuflen) != diagbuflen)
			exit(-1);
	}

	diagrdptr= diagwrptr= diagbuf;
	diagbuflen= 0;
	return;
}
