C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine chkindex(isrcloc,irecind,disttest,lerr)
c
      parameter (base=.1*(2.**16))
c___________________________________________________________
c     routine to check and if possible correct the source
c     location index 'SrcLoc'.
c     ancient sis header convention defines srcloc to be the
c     the position of the shot point measured in units of 
c     station number * 10. thus, if a shot is located half way
c     between station numbers (RecInd) 2014 and 2015, 
c     SrcLoc=10.*2014.5=20145
c    
c     unfortunately, this index is limited to be an integer*2
c     or 16 bit word. SrcLoc indices above 2*15=32768 will
c     'wrap around', the next number being -32767. This program
c     attempts to undo this wrap around effect using a simple
c     heuristic (that the distance calculated between the
c     SrcLoc and RecInd is less than a test distance calculated
c     from the header word 'DstSgn'.
c___________________________________________________________
      srcloc=.1*isrcloc
      recind=irecind
      distcalc=abs(srcloc-recind)
c
      if(distcalc .lt. disttest) then 
c___________________________________________________________
c        srcloc ndices lie within a disttest length.
c___________________________________________________________
         return
      else
         write(lerr,*) 'srcloc looks bad!'
         write(lerr,*) 'try to add/subtract 2**16'
c___________________________________________________________
c        add 2**16 to isrcloc.
c___________________________________________________________
         ntry=recind/base+1
         do 10000 itry=1,ntry          
          srcloc=srcloc+base
          distcalc=abs(srcloc-recind)
          if(distcalc .lt. disttest) then
            go to 10001
          endif
10000    continue
      endif
c
10001 continue
      isrcloc=10.*srcloc
c
      return
      end
         
