C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine crkindx(xs,ys,zs,xr,yr,zr,xg,yg,zg,zw,
     1                   xtopo,ytopo,ztopo,zwgather,lrecind,
     2                   recind,srcloc,live,nlive,minrecind,maxrecind,
     3                   xbeginprime,dsta,nshot,ntrace,undefined,
     4                   stderr,lerr,mingroup,maxgroup,
     5                   mincmp,maxcmp,mintopo,maxtopo)
c
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      real    zwgather(ntrace,nshot)
      logical live(ntrace,nshot)
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer srcloc(nshot)
 
      integer nlive(nshot)
c
      real    xg(minrecind:maxrecind)
      real    yg(minrecind:maxrecind)
      real    zg(minrecind:maxrecind)
      integer lrecind(minrecind:maxrecind)
      real    xtopo(minrecind:maxrecind)
      real    ytopo(minrecind:maxrecind)
      real    ztopo(minrecind:maxrecind)
      real    zw(minrecind:maxrecind)
      integer stderr
C__________________________________________________________________
c     loop over all the common shot records.
C__________________________________________________________________
      do 40000 ishot=1,nshot
       if(nlive(ishot) .gt. 0) then
       igx=nint((xs(ishot)-xbeginprime)/dsta)
       if(igx .lt. minrecind) then
          write(lerr,*) 'calculated crooked line shot index igx = '
     1                 ,igx, ' less than minrecind = ',minrecind
          go to 99991
       endif
       if(igx .gt. maxrecind) then
          write(lerr,*) 'calculated crooked line shot index igx = ',
     1                 igx, ' greater than maxrecind = ',maxrecind
          go to 99992
       endif
c__________________________________________________________________
c      initial calculation of topography is determined by shots.
c__________________________________________________________________
       xtopo(igx)=xs(ishot)
       ytopo(igx)=ys(ishot)
       ztopo(igx)=zs(ishot)
       mintopo=min(igx,mintopo)
       maxtopo=max(igx,maxtopo)
c__________________________________________________________________
c      look for minimum and maximum source receiver offset.               
c      calculate an effective receiver index from absolute values.
c__________________________________________________________________
       do 20000 itrace=1,ntrace
        if(live(itrace,ishot)) then
           ig=nint((xr(itrace,ishot)-xbeginprime)/dsta)      
           if(ig .lt. minrecind) then
              write(lerr,*) 'trace group index (RecInd) = ',ig,
     1                      ' less than minrecind = ',minrecind
              go to 99991
           endif
           if(ig .gt. maxrecind) then
              write(lerr,*) 'trace group index (RecInd) = ',ig
              write(lerr,*) 'greater than dimensioned value'//
     1                      ' maxrecind = ',maxrecind
              go to 99992
           endif
c
           lrecind(ig)=recind(itrace,ishot)
           xg(ig)=xr(itrace,ishot)
           yg(ig)=yr(itrace,ishot)
           zg(ig)=zr(itrace,ishot)
           offset=xr(itrace,ishot)-xs(ishot)
           icmp=nint(.1*srcloc(ishot)+.5*offset/dsta)                       
           if(icmp .lt. minrecind) then
              write(lerr,*) 'Water depth cmp index icmp = ',icmp,
     1                      ' less than minrecind = ',minrecind
              write(lerr,*) 
     1          'itrace,ishot,xr(itrace,ishot),xs(ishot),dsta',
     2          itrace,ishot,xr(itrace,ishot),xs(ishot),dsta
              call exitfu(666)
           endif
           if(icmp .gt. maxrecind) then
              write(lerr,*) 'Water depth cmp index icmp = ',icmp,
     1                      ' greater than maxrecind = ',maxrecind
              write(lerr,*) 
     1          'itrace,ishot,xr(itrace,ishot),xs(ishot),dsta',
     2          itrace,ishot,xr(itrace,ishot),xs(ishot),dsta
              call exitfu(666)
           endif
           zw(icmp)=zwgather(itrace,ishot)
c
           mincmp=min(icmp,mincmp)
           maxcmp=max(icmp,maxcmp)
           mingroup=min(ig,mingroup)
           maxgroup=max(ig,maxgroup)
        endif
20000  continue
c
       endif
40000 continue      
c__________________________________________________________________
c     update topography estimate using the group locations.
c     z axis is positive DOWN.
c___________________________________________________________________
      do 65500 ig=mingroup,maxgroup 
       if(ztopo(ig) .eq. undefined) then
          xtopo(ig)=xg(ig)
          ytopo(ig)=yg(ig)
          ztopo(ig)=zg(ig)
       else
          ztopo(ig)=min(ztopo(ig),zg(ig))
       endif
65500 continue
c
      return
c
99991 write(lerr,*) 'WARNING!'
      write(lerr,*) 'negative indices may have been caused'
     1             //' by indexing RecInd or SrcLoc > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' smaller value after -ming option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99991)
c
99992 write(lerr,*) 'WARNING!'
      write(lerr,*) 'bogus indices may have been caused'
     1             //' by indexing RecInd > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' larger value after -maxg option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99992)
c
      return
      end
