C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine interph(zhorizon,minx,maxx,
     1                   undefined,extrapleft,extrapright)
c
      real    zhorizon(minx:maxx)
      logical extrapleft,extrapright
C__________________________________________________________________
c     check/fill in the pick at every point.
C___________________________________________________________________
      do 66500 ix=minx,maxx
       if(zhorizon(ix) .ne. undefined) then
          if(extrapleft) then
C__________________________________________________________________
c            extrapolate (copy) last pick to the left  
C___________________________________________________________________
              do 66400 kx=minx,ix-1 
               zhorizon(kx)=zhorizon(ix)
66400         continue
          endif
          go to 66501
       endif
66500 continue
66501 continue
      istart=ix
c
      do 67000 ix=istart,maxx
       if(zhorizon(ix) .eq. undefined) then
C__________________________________________________________________
c         look for the next defined pick.
C___________________________________________________________________
          do 62000 lx=ix+1,maxx
           if(zhorizon(lx) .ne. undefined) go to 62001
62000     continue
          go to 67000
62001     continue
C__________________________________________________________________
c         interpolate.
C___________________________________________________________________
          do 63000 kx=ix,lx-1
           ixm1=ix-1
           wgt2=float(kx-ixm1)/(lx-ixm1)
           wgt1=1.-wgt2
           zhorizon(kx)=wgt1*zhorizon(ixm1)+wgt2*zhorizon(lx)
63000     continue
       endif
67000 continue
      if(extrapright) then
C__________________________________________________________________
c        extrapolate (copy) last pick to the right.
C___________________________________________________________________
         do 67500 ix=maxx,minx,-1 
          if(zhorizon(ix) .ne. undefined) then
             do 67400 kx=maxx,ix+1,-1
              zhorizon(kx)=zhorizon(ix)
67400        continue
             go to 67501
          endif
67500    continue
67501    continue
      endif
c
      return
      end
