C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine prepsub(buffer2,buffer4,srcloc,soptnm,
     1                   xs,ys,zs,isrcloc,isrptel,
     2                   xr,yr,zr,recind,live,
     3                   xg,yg,zg,zw,nlive,
     4                   xtopo,ytopo,ztopo,zwgather,
     5                   lrecind,xstemp,ystemp,
     6                   xdistmin,xdistmax,
     7                   zdistmin,zdistmax,
     8                   dsta,zdatum,fix_zdatum,nshot,ntrace,tol,
     9                   luin,lugeom,nbytes_hdr,cputim,waltim,
     a                   lutopo,luwater,lucmp,wrtopo,wrwater,wrcmp,
     b                   zvo,dz,xy_indexed,model,stacked,
     c                   minrecind,maxrecind,verbose,
     d                   use_dphind,vsp,azim,stderr,lerr,undefined,
     e                   use_sgrdat)
c
      integer   buffer2(*)
      integer   buffer4(*)
c
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      real    zwgather(ntrace,nshot)
      logical live(ntrace,nshot)
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer soptnm(nshot)
      integer srcloc(nshot)

      real    xdistmin(nshot),xdistmax(nshot)
      real    zdistmin(nshot),zdistmax(nshot)
      integer nlive(nshot)
c
      real    xg(minrecind:maxrecind)
      real    yg(minrecind:maxrecind)
      real    zg(minrecind:maxrecind)
      real    xtopo(minrecind:maxrecind)
      real    ytopo(minrecind:maxrecind)
      real    ztopo(minrecind:maxrecind)
      real    zw(minrecind:maxrecind)
      integer lrecind(minrecind:maxrecind)
C__________________________________________________________________
c     arrays used to check consistency of indices within a common
c     shot gather.
C__________________________________________________________________
      integer isrcloc(ntrace)
      integer isrptel(ntrace)
      real    xstemp(ntrace),ystemp(ntrace)
c
      real    cputim(*),waltim(*)
c
      integer stderr
c
      logical fix_zdatum
      logical xy_indexed
      logical model
      logical wrtopo,wrwater,wrcmp
      logical stacked,use_dphind,use_sgrdat
      logical vsp,verbose
C__________________________________________________________________
c     initialize.                
C__________________________________________________________________
      topomin=+1.e+32
      topomax=-1.e+32
      xdatamin=+1.e+32
      xdatamax=-1.e+32
      zdatamin=+1.e+32
      zdatamax=-1.e+32
      gdistmin=+1.e+32
      gdistmax=-1.e+32
      mingroup=maxrecind
      maxgroup=minrecind
      mintopo=maxrecind
      maxtopo=minrecind
      mincmp=maxrecind
      maxcmp=minrecind
      do 10000 k=minrecind,maxrecind
       lrecind(k)=0
       xg(k)=undefined
       yg(k)=undefined
       zg(k)=undefined
       xtopo(k)=undefined
       ytopo(k)=undefined
       ztopo(k)=undefined
       zw(k)=undefined
10000 continue
C__________________________________________________________________
c     read in appropriate header information.           
C__________________________________________________________________
      call timstr(v1,w1)
      call rdheader(buffer2,buffer4,nshot,ntrace,nlive,
     1              xs,ys,zs, xr,yr,zr,zwgather,xy_indexed,
     2              isrcloc,isrptel,recind,live,srcloc,soptnm,
     3              luin,use_dphind,stacked,stderr,lerr,
     4              xstemp,ystemp,nbytes_hdr,tol,use_sgrdat)
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
      if(verbose) then
         write(lerr,*) 'after rdheader'
         write(lerr,'(5a12)') 'ishot','SrcLoc','xs','ys','zs','nlive'
         write(lerr,'(2i12,3f12.1,i12)') (ishot,srcloc(ishot),
     1     xs(ishot),ys(ishot),zs(ishot),nlive(ishot),ishot=1,nshot)
      endif
      call timstr(v1,w1)
      if(wrcmp) then
c__________________________________________________________________
c        write out all cmp points (useful for crooked line migration.
c__________________________________________________________________
         do 13000 ishot=1,nshot
          do 12000 itrace=1,ntrace
           if(live(itrace,ishot)) then
              xcmp=.5*(xs(ishot)+xr(itrace,ishot))
              ycmp=.5*(ys(ishot)+yr(itrace,ishot))
              write(lucmp,'(2f20.3)') xcmp,ycmp
           endif
12000     continue
13000    continue
      endif
      if(fix_zdatum) then
c__________________________________________________________________
c        sources and receivers are corrected to a fixed datum.
c        override elevations in trace headers.
c__________________________________________________________________
         do 20000 ishot=1,nshot
          zs(ishot)=-zdatum
          do 15000 itrace=1,ntrace
           zr(itrace,ishot)=-zdatum
15000     continue
20000    continue
      endif
c__________________________________________________________________
c     determine min and max live shot.
c     these may be used to reproject the data onto a reference line.
c__________________________________________________________________
      minshot=nshot
      maxshot=1
      do 11000 ishot=1,nshot
       if(nlive(ishot) .gt. 0) then
          minshot=min(minshot,ishot)
          maxshot=max(maxshot,ishot)
       endif
11000 continue
c
      if(xy_indexed) then
c__________________________________________________________________
c        reproject the data along some new azimuth.
c__________________________________________________________________
         call reproject(xs,ys,zs,xr,yr,zr,live,nlive,
     1                  minshot,maxshot,srcloc,
     2                  xbegin,ybegin,xbeginprime,
     3                  minrecind,maxrecind,dsta,nshot,ntrace,
     4                  vsp,azim,theta,stderr,lerr,undefined)
         if(verbose) then
            write(lerr,*) 'after reproject'
            write(lerr,'(5a12)') 'ishot','SrcLoc','xs','ys','zs',
     1                   'nlive'
            write(lerr,'(2i12,3f12.1,i12)') (ishot,srcloc(ishot),
     1        xs(ishot),ys(ishot),zs(ishot),nlive(ishot),ishot=1,nshot)
      endif
      endif
c
      if(vsp) then        
c__________________________________________________________________
c        walk away vsp data
c        (xr,yr,zr) and (xs,ys,zs) read directly from headers.
c__________________________________________________________________
         call vspindx(xs,ys,zs,xr,yr,zr,xg,yg,zg,zw,
     1                xtopo,ytopo,ztopo,zwgather,lrecind,
     2                recind,srcloc,live,nlive,minrecind,maxrecind,
     3                xbeginprime,dsta,nshot,ntrace,stderr,lerr,
     4                mingroup,maxgroup,mincmp,maxcmp,mintopo,maxtopo)

      elseif(xy_indexed .and. .not. vsp) then
c__________________________________________________________________
c        surface, crooked line data.
c        (xr,yr,zr) and (xs,ys,zs) read directly from headers.
c__________________________________________________________________
         call crkindx(xs,ys,zs,xr,yr,zr,xg,yg,zg,zw,
     1                xtopo,ytopo,ztopo,zwgather,lrecind,
     2                recind,srcloc,live,nlive,minrecind,maxrecind,
     3                xbeginprime,dsta,nshot,ntrace,undefined,
     4                stderr,lerr,mingroup,maxgroup,
     5                mincmp,maxcmp,mintopo,maxtopo)
         if(verbose) then
            write(lerr,*) 'after crkindx'
            write(lerr,'(5a12)') 'ishot','SrcLoc','xs','ys','zs',
     1                   'nlive'
            write(lerr,'(2i12,3f12.1,i12)') (ishot,srcloc(ishot),
     1        xs(ishot),ys(ishot),zs(ishot),nlive(ishot),ishot=1,nshot)
         endif
      else
C__________________________________________________________________
c        surface, regularly indexed data.
c        (xr,yr,zr) and (xs,ys,zs) calculated from source and receiver
c        indices, and station interval, dsta.
C__________________________________________________________________
         call regindx(xs,ys,zs,xr,yr,zr,xg,yg,zg,zw,
     1                xtopo,ytopo,ztopo,zwgather,lrecind,
     2                recind,srcloc,live,nlive,minrecind,maxrecind,
     3                dsta,nshot,ntrace,stderr,lerr,stacked,
     4                mingroup,maxgroup,mincmp,maxcmp,
     5                mintopo,maxtopo,undefined,model)
      endif 
c
      call timstr(v1,w1)
c
      dshotsum=0.
      ncount=0
      do 45000 ishot=2,nshot
       if(nlive(ishot) .gt. 0. .and.
     1    nlive(ishot-1) .gt. 0.) then
          dshotsum=dshotsum+xs(ishot)-xs(ishot-1)
          ncount=ncount+1
       endif
45000 continue
C__________________________________________________________________
c     guestimate dshot.                                             
C__________________________________________________________________
      if(ncount .gt. 0) then
         dshot=dshotsum/ncount
         write(lerr,*) 'ncount,dshot ',ncount,dshot
      elseif(nshot .eq. 1) then
         dshot=1.
      else
         write(lerr,*) 'cannot find any adjacent live shot records!'
         write(lerr,*) 'impossible to guesstimate dshot'
         write(lerr,*) 'program terminated in routine prepsub'
         call exitfu(4666)
      endif
C__________________________________________________________________
c     check/fill in all topography location arrays.
C___________________________________________________________________
      call interph(xtopo(mintopo),mintopo,maxtopo,
     1             undefined,.true.,.true.)
      call interph(ytopo(mintopo),mintopo,maxtopo,
     1             undefined,.true.,.true.)
      call interph(ztopo(mintopo),mintopo,maxtopo,
     1             undefined,.true.,.true.)
c__________________________________________________________________
c     check/fill in all group location arrays.
c___________________________________________________________________
      call interph(xg(mingroup),mingroup,maxgroup,
     1             undefined,.true.,.true.)            
      call interph(yg(mingroup),mingroup,maxgroup,
     1             undefined,.true.,.true.)            
      call interph(zg(mingroup),mingroup,maxgroup,
     1             undefined,.true.,.true.)            
c__________________________________________________________________
c     check/fill in water bottom estimates.   
c___________________________________________________________________
      minsearch=min(mingroup,mincmp)
      maxsearch=max(maxgroup,maxcmp)
      call interph(zw(minsearch),minsearch,maxsearch,
     1             undefined,.true.,.true.)            
C__________________________________________________________________
c     calculate inline min and max offsets.                   
C__________________________________________________________________
      do 50000 ishot=1,nshot
       xdistmin(ishot)=+1.e+30
       xdistmax(ishot)=-1.e+30
       zdistmin(ishot)=+1.e+30
       zdistmax(ishot)=-1.e+30
       if(nlive(ishot) .gt. 0) then
          do 48000 itrace=1,ntrace
           if(live(itrace,ishot)) then
              xh=xr(itrace,ishot)-xs(ishot)
              xdistmin(ishot)=min(xh,xdistmin(ishot))
              xdistmax(ishot)=max(xh,xdistmax(ishot))
              zh=(zr(itrace,ishot)-zs(ishot))
              zdistmin(ishot)=min(zh,zdistmin(ishot))
              zdistmax(ishot)=max(zh,zdistmax(ishot))
           endif
48000     continue
          zdatamin=min(zs(ishot),zs(ishot)+zdistmin(ishot),
     1                                  zdatamin)
          zdatamax=max(zs(ishot),zs(ishot)+zdistmax(ishot),
     1                                  zdatamax)
          xdatamin=min(xs(ishot),xs(ishot)+xdistmin(ishot),
     1                                  xdatamin)
          xdatamax=max(xs(ishot),xs(ishot)+xdistmax(ishot),
     1                                  xdatamax)
          if(vsp) then
             gdistmin=min(zdistmin(ishot),gdistmin)
             gdistmax=max(zdistmax(ishot),gdistmax)
          else 
             gdistmin=min(xdistmin(ishot),gdistmin)
             gdistmax=max(xdistmax(ishot),gdistmax)
          endif
       else
          write(stderr,*) 'shot ',ishot,' is dead!'
       endif
50000 continue      
c__________________________________________________________________
c     calculate lowest and highest elevation of topographic surface.
c__________________________________________________________________
      do 64000 ix=mintopo,maxtopo
       topomin=min(ztopo(ix),topomin)
       topomax=max(ztopo(ix),topomax)
64000 continue
      do 52000 ishot=1,nshot
       if(nlive(ishot) .eq. 0) then
C__________________________________________________________________
c         intialize values for dead records.                        
C__________________________________________________________________
          xdistmin(ishot)=gdistmin
          xdistmax(ishot)=gdistmax
          xs(ishot)=0.
          ys(ishot)=0.
          zs(ishot)=0.
          call vclr(xr(1,ishot),1,ntrace)
          call vclr(yr(1,ishot),1,ntrace)
          call vclr(zr(1,ishot),1,ntrace)
       endif
52000 continue
C__________________________________________________________________
c     calculate the worst backup xdistance for any out of sequence
c     sources. sources that are not in ascending order will result
c     in increase memory requires to store travel time ray fans
c     and output crp gathers.
C__________________________________________________________________
      xsbackup=0.
      do 62000 ishot=1,nshot-1
       if(nlive(ishot) .gt. 0) then
          do 61000 jshot=ishot+1,nshot
           if(xs(jshot) .lt. xs(ishot) 
     1              .and. nlive(jshot) .gt. 0) then
             shotdist=xs(jshot)-xs(ishot)
             xsbackup=min(xsbackup,xs(jshot)-xs(ishot))
             write(stderr,*) 'shot ',jshot ,' lies ',shotdist,
     1           ' to the left of ',ishot
             write(lerr,*) 'shot ',jshot ,' lies ',shotdist,
     1           ' to the left of ',ishot
           endif
61000     continue
       endif
62000 continue
c
      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
      call timstr(v1,w1)
C__________________________________________________________________
c     write out summary information that will be used FIRST by
c     the prestack migration codes.
C___________________________________________________________________
      write(lugeom,'(7a12)') 'nshot','min RecInd','max RecInd',
     1              'min TopInd','max TopInd','dstation','vsp'
      write(lugeom,'(5i12,f12.6,l12)') nshot,mingroup,
     1                       maxgroup,mintopo,maxtopo,dsta,vsp
      write(lugeom,'(5a12)') 'xdatamin','xdatamax','gdistmin',
     1                       'gdistmax','xsbackup'         
      write(lugeom,'(5f12.1)') xdatamin,xdatamax,gdistmin,gdistmax,
     2                         xsbackup
      write(lugeom,'(7a12)') 'topomin','topomax','xbegin','ybegin',
     1                       'xbeginprime','azim','theta' 
      write(lugeom,'(5f12.1,2f12.6)') topomin,topomax,
     1                        xbegin,ybegin,xbeginprime,azim,theta
      if(vsp) then
         write(lugeom,'(6a12)') 'xs','ys','zs',
     1                  'zdistmin','zdistmax','nlive'
         write(lugeom,'(5f12.1,2i12)') (xs(ishot),ys(ishot),zs(ishot),
     1     zdistmin(ishot),zdistmax(ishot),nlive(ishot),soptnm(ishot),
     2     ishot=1,nshot)
      else
         write(lugeom,'(7a12)') 'xs','ys','zs',
     1                  'xdistmin','xdistmax','nlive','SoPtNm'
         write(lugeom,'(5f12.1,2i12)') (xs(ishot),ys(ishot),zs(ishot),
     1     xdistmin(ishot),xdistmax(ishot),nlive(ishot),soptnm(ishot),
     2                   ishot=1,nshot)
      endif
      write(lugeom,'(4a12)') 'ix','xtopo','ytopo','ztopo'
      write(lugeom,'(i12,3f12.1)')
     1               (ix,xtopo(ix),ytopo(ix),ztopo(ix), 
     2               ix=mintopo,maxtopo)   
      write(lugeom,'(6a12)') 'ig         ','xg','yg',
     1                       'zg (-GrpElv)','zw (-WDepDP)','RecInd'
      write(lugeom,'(i12,4f12.1,i12)')
     1               (ig,xg(ig),yg(ig),zg(ig),zw(ig),lrecind(ig),
     2               ig=mingroup,maxgroup)
C__________________________________________________________________
c      write out detailed information for each shot record.
C__________________________________________________________________
      do 80000 ishot=1,nshot
       write(lugeom,'(2a12,a12)') 'ishot','nlive'
       write(lugeom,'(2i12)') ishot,nlive(ishot)
       write(lugeom,'(2a12,3a12,a12)') 'trace','station',
     1             'xr','yr','zr','live'    
       do 70000 itrace=1,ntrace
        write(lugeom,'(2i12,3f12.1,l12)') 
     1       itrace,recind(itrace,ishot),      
     3       xr(itrace,ishot),yr(itrace,ishot),zr(itrace,ishot),
     4       live(itrace,ishot)
70000  continue
c
80000 continue
      nrec=1
      nsamp=1000
      recunit=1.
      trcunit=dsta
      recoff=0.
      trcoff=xdatamin-dsta  
      nsegments=1
      minsearch=mingroup
      maxsearch=maxgroup
      maxpicks=maxtopo-mintopo+1
      if(wrtopo) then
         smpunit=-dz
         smpoff=zvo+dz
C__________________________________________________________________
c        write out topography info in xsd format.               
C__________________________________________________________________
         write(lutopo,200,err=99993) 'Units ',
     1                 recunit,trcunit,smpunit,
     2                 nrec,ntrace,nsamp,
     3                ' Offset',recoff,trcoff,smpoff,
     4                ' Count  ',nsegments,maxpicks
200      format(a6,f12.3,1x,f12.3,1x,f12.3,1x,i5,1x,i5,1x,i5,
     1          a7,f12.3,1x,f12.3,1x,f12.3,a8,i5,1x,i5)
         iseg=1
         icolor=-44
201      format(a10,i5,a6,a20,a10,i5,a9,i5)
         recno=1.
         npicks=(maxtopo-mintopo+1)
         write(lutopo,201)'Segment = ',iseg,
     1                   ' Name ','topography',
     2                   ' color = ',icolor,        
     3                   ' picks = ',npicks
         do 90100 jtopo=mintopo,maxtopo     
          write(lutopo,102) recno,xtopo(jtopo),-ztopo(jtopo) 
102       format(f12.3,1x,f12.3,1x,f12.3)
90100    continue
      endif
      if(wrwater) then
C__________________________________________________________________
c        write out water bottom info in xsd format.
C__________________________________________________________________
         smpunit=+dz
         smpoff=zvo-dz
         write(luwater,200,err=99993)'Units ',recunit,trcunit,smpunit,
     1                    nrec,ntrace,nsamp,
     2                    ' Offset',recoff,trcoff,smpoff,
     3                    ' Count  ',nsegments,maxpicks
         iseg=1
         icolor=-43
         npicks=ntrace
         write(luwater,201)'Segment = ',iseg,
     1                           ' Name ','topography',
     2                           ' color = ',icolor,
     3                           ' picks = ',npicks
         recno=1.
         do 90202 ig=mingroup,maxgroup
          write(luwater,102) recno,xg(ig),zw(ig)
90202    continue
      endif

c
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
      return
c
99991 write(lerr,*) 'WARNING!'
      write(lerr,*) 'negative indices may have been caused'
     1             //' by indexing RecInd or SrcLoc > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' smaller value after -ming option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99991)
c
99992 write(lerr,*) 'WARNING!'
      write(lerr,*) 'bogus indices may have been caused'
     1             //' by indexing RecInd > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' larger value after -maxg option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99992)
c
99993 write(lerr,*) 'ERROR in writing topographic pick file!'
      write(lerr,*) 'check for write permission'
      call exitfu(99993)
c
99994 write(lerr,*) 'ERROR in writing topographic pick file!'
      write(lerr,*) 'check for write permission'
      call exitfu(99994)
c
      end
