C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdheader(buffer2,buffer4,nshot,ntrace,nlive,
     1                    xs,ys,zs, xr,yr,zr,zwgather,xy_indexed,
     2                    isrcloc,isrptel,recind,live,srcloc,soptnm,
     3                    luin,use_dphind,stacked,ler,lerr,
     4                    xstemp,ystemp,nbytes_hdr,tol,use_SGRDat)
c
      integer   buffer2(*)
      integer   buffer4(*)
c
c
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      real    zwgather(ntrace,nshot)
      logical live(ntrace,nshot)
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer soptnm(nshot)
      integer srcloc(nshot) 
      integer nlive(nshot)
c
      integer ler
      logical use_dphind,stacked,xy_indexed,use_SGRDat
C__________________________________________________________________
c     arrays used to check consistency of indices within a common
c     shot gather.
C__________________________________________________________________
      integer isrcloc(ntrace)
      integer isrptel(ntrace)
      real    xstemp(ntrace),ystemp(ntrace)
c
#include<save_defs.h>
C__________________________________________________________________
c     look up hardware specific trace header indices.
C__________________________________________________________________
      call savelu('SrcLoc',ifmt_SrcLoc,l_srcloc,ln_SrcLoc,TRACEHEADER)
c - changed the location of the overflow for SrcLoc to be in DpPtLn
c - due to new usage for SGRDat to store SEGY data date stamp unless
c - -SGRDat has been explicitly flagged on the command line - 9/22/03
c     call savelu('SGRDat',ifmt_SGRDat,l_sgrdat,ln_SGRDat,TRACEHEADER)
      if (use_SGRDat) then
       call savelu('SGRDat',ifmt_DpPtLn,l_DpPtLn,ln_DpPtLn,TRACEHEADER)
      else
       call savelu('DpPtLn',ifmt_DpPtLn,l_DpPtLn,ln_DpPtLn,TRACEHEADER)
      endif
      call savelu('RecInd',ifmt_RecInd,l_recind,ln_RecInd,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_grpelv,ln_GrpElv,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_stacor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_srptel,ln_SrPtEl,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_shtdep,ln_ShtDep,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
c
      nbad=0
      write(ler,*) 'BEGIN LIST OF TRACES NOT CONSISTENT WITH COMMON'
     1              //' SHOT GATHER:'
      write(ler,'(2a7,6a12)') 'shot','trace',
     1         'xsavg','ysavg','zsavg',
     2         'SrPtXC','SrPtYC','SrPtEl'
      write(lerr,*) 'BEGIN LIST OF TRACES NOT CONSISTENT WITH COMMON'
     1              //' SHOT GATHER:'
      write(lerr,'(2a7,6a12)') 'shot','trace',
     1         'xsavg','ysavg','zsavg',
     2         'SrPtXC','SrPtYC','SrPtEl'
C__________________________________________________________________
c     loop over all the common shot records.
C__________________________________________________________________
      do 40000 ishot=1,nshot
       xs(ishot)=0.
       ys(ishot)=0.
       zs(ishot)=0.
C__________________________________________________________________
c      loop over all the traces.
c      calculate number of live traces for this shot gather.       
C__________________________________________________________________
       nlive(ishot)=0
       isrcloc_live=0
       isrptel_live=0
       xslive=-999999.
       yslive=-999999.
       xssum=0.
       yssum=0.
       zssum=0.
       do 10000 itrace=1,ntrace
        nbytes=nbytes_hdr
        call rtape(luin,buffer2,nbytes)
        call saver2(buffer2 ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istatic,TRACEHEADER)

        if(istatic .eq. 30000) then
           live(itrace,ishot)=.false.
        else
           live(itrace,ishot)=.true.
           nlive(ishot)=nlive(ishot)+1
c
           call saver2(buffer2 ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                 recind(itrace,ishot),TRACEHEADER)
           if(use_dphind) then
              call saver2(buffer2 ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idphind,TRACEHEADER)
              if(stacked) then
c_______________________________________________________________
c                assume coincident source and receiver.
c_______________________________________________________________
                 isrcloc(itrace)=10*idphind
                 recind(itrace,ishot)=idphind
              else
c_______________________________________________________________
c                calculate source location index from depth and
c                receiver indices.
c_______________________________________________________________
                 isrcloc(itrace)=10*(idphind-recind(itrace,ishot))
              endif
           else
              call saver2(buffer2 ,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                    isrcloc(itrace),TRACEHEADER)
              if(isrcloc(itrace) .eq. 32767) then
c_______________________________________________________________
c               'maip' has been altered to put the srcloc into dpptln
c		(changed 9/22/03 from sgrdat to free that spot up)
c                if we exceed the limits of integer*2 word.
c_______________________________________________________________
                 call saver2(buffer2 ,ifmt_DpPtLn,l_DpPtLn, ln_DpPtLn,
     1                       isrcloc(itrace),TRACEHEADER)
              endif
           endif
           isrcloc_live=isrcloc(itrace)
           call saver2(buffer2 ,ifmt_SrPtEl,l_SrPtEl, ln_SrPtEl,
     1                 ival,TRACEHEADER)
           isrptel(itrace) = -ival

           call saver2(buffer2 ,ifmt_GrpElv,l_GrpElv, ln_GrpElv,
     1                 ival,TRACEHEADER)
           zr(itrace,ishot)=-ival
           call saver2(buffer2 ,ifmt_WDepDP,l_WDepDP, ln_WDepDP,
     1                 ival,TRACEHEADER)
           zwgather(itrace,ishot) = ival
           call saver2(buffer2 ,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                 ival,TRACEHEADER)
           xr(itrace,ishot) = ival
           call saver2(buffer2 ,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                 ival,TRACEHEADER)
           yr(itrace,ishot) = ival
           call saver2(buffer2 ,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                 ival,TRACEHEADER)
           xstemp(itrace) = ival
           call saver2(buffer2 ,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                 ival,TRACEHEADER)
           ystemp(itrace) = ival
           call saver2(buffer2 ,ifmt_ShtDep,l_ShtDep, ln_ShtDep,
     1                 ival,TRACEHEADER)
           zsdepth = -ival
           call saver2(buffer2 ,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                 soptnm(ishot),TRACEHEADER)
c__________________________________________________________________
c          keep the header value of the first live trace in the gather
c          in order to check for a common shot gather.
c__________________________________________________________________
           isrcloc_live=isrcloc(itrace)
           isrptel_live=isrptel(itrace)
           xssum=xssum+xstemp(itrace)
           yssum=yssum+ystemp(itrace)
           zssum=zssum+isrptel(itrace)
        endif
10000  continue
       xsavg=xssum/nlive(ishot)
       ysavg=yssum/nlive(ishot)
       zsavg=zssum/nlive(ishot)
       xs(ishot)=xsavg
       ys(ishot)=ysavg
       zs(ishot)=zsavg-zsdepth                           
       srcloc(ishot)=isrcloc_live
c__________________________________________________________________
c      look for consistency.
c__________________________________________________________________
       if(xy_indexed .and. nlive(ishot) .gt. 0) then
c__________________________________________________________________
c         check for common shot x,y,z coordinates.
c__________________________________________________________________
          do 37000 itrace=1,ntrace
           if(live(itrace,ishot)) then
              if(abs(xstemp(itrace)-xsavg) .gt. tol  .or.
     1           abs(ystemp(itrace)-ysavg) .gt. tol  .or.
     1           abs(isrptel(itrace)-zsavg) .gt. tol) then
                 write(ler,'(2i7,5f12.1,i12)') ishot,itrace,
     1                 xsavg,ysavg,zsavg,
     2                 xstemp(itrace),ystemp(itrace),isrptel(itrace)
                 write(lerr,'(2i7,5f12.1,i12)') ishot,itrace,
     1                 xsavg,ysavg,zsavg,
     2                 xstemp(itrace),ystemp(itrace),isrptel(itrace)
                 nbad=nbad+1
                 live(itrace,ishot)=.false.
                 nlive(ishot)=nlive(ishot)-1
              endif
           endif
37000     continue
       else
c__________________________________________________________________
c         check for common source location index and shot elevation.
c__________________________________________________________________
          do 39000 itrace=1,ntrace
           if(live(itrace,ishot)) then
              if(isrcloc(itrace) .ne. isrcloc_live .or.
     1           isrptel(itrace) .ne. isrptel_live) then
                 write(lerr,*) 'error in routine prepsub'
                 write(lerr,*) 'trace header words SrcLoc or SrPtEl '
     1             //'are inconsistent within a common shot gather'
                 write(lerr,*) 'ishot = ',ishot,' itrace = ',itrace
                 write(lerr,*) 'isrcloc_live = ',isrcloc_live
                 write(lerr,*) 'isrptel_live = ',isrptel_live
                 write(lerr,'(3a12)') 'jtrace','isrcloc', 
     1                 'isrptel'
                 do 38000 jtrace=1,ntrace
                  if(live(jtrace,ishot)) then
                     write(lerr,'(3i12)') jtrace,isrcloc(jtrace),
     1                                    isrptel(jtrace)
                  endif
38000            continue
                 write(lerr,*) 'probable cause: data was not a '       
     1                         //'common shot gather!'
                 write(lerr,*) 'kill this trace'                       
                 call exitfu(1666) 
              endif
           endif
39000     continue
       endif
40000 continue       
      write(ler,*) 'END LIST OF TRACES NOT CONSISTENT WITH COMMON'
     1              //' SHOT GATHER:'
      write(ler,*) 'number of bad traces that have been killed = ',
     1               nbad
      write(lerr,*) 'END LIST OF TRACES NOT CONSISTENT WITH COMMON'
     1              //' SHOT GATHER:'
      write(lerr,*) 'number of bad traces that have been killed = ',
     1               nbad
c###################################################################
c     all header information now read into memory.
c###################################################################
      return 
      end
