C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine regindx(xs,ys,zs,xr,yr,zr,xg,yg,zg,zw,
     1                   xtopo,ytopo,ztopo,zwgather,lrecind,
     2                   recind,srcloc,live,nlive,minrecind,maxrecind,
     3                   dsta,nshot,ntrace,stderr,lerr,stacked,
     4                   mingroup,maxgroup,mincmp,maxcmp,
     5                   mintopo,maxtopo,undefined,model)
c
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      real    zwgather(ntrace,nshot)
      logical live(ntrace,nshot)
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer srcloc(nshot)
 
      integer nlive(nshot)
c
      real    xg(minrecind:maxrecind)
      real    yg(minrecind:maxrecind)
      real    zg(minrecind:maxrecind)
      real    xtopo(minrecind:maxrecind)
      real    ytopo(minrecind:maxrecind)
      real    ztopo(minrecind:maxrecind)
      real    zw(minrecind:maxrecind)
      integer lrecind(minrecind:maxrecind)
      logical stacked,model
C__________________________________________________________________
c     regularly indexed surface data, using srcloc and recind header
c     values.
C__________________________________________________________________
      IF(.not. model) THEN
C__________________________________________________________________
c     loop over all the common shot records.
C__________________________________________________________________
      do 40000 ishot=1,nshot
C__________________________________________________________________
c      loop over all the traces.
c      calculate number of live traces for this shot gather.       
C__________________________________________________________________
       do 10000 itrace=1,ntrace
        if(stacked) then
           recind(itrace,ishot)=srcloc(ishot)   
           igx=recind(itrace,ishot)
           xr(itrace,ishot)=igx*dsta-dsta
           yr(itrace,ishot)=0.
           xs(ishot)=igx*dsta-dsta
           ys(ishot)=0.                 
        endif
10000  continue
       xs(ishot)=.1*srcloc(ishot)*dsta-dsta
       ys(ishot)=0.
c__________________________________________________________________
c      look for minimum and maximum source receiver offset.               
c      look for minimum and maximum group elevation/topography
c__________________________________________________________________
       do 20000 itrace=1,ntrace
        if(live(itrace,ishot)) then
           ig=recind(itrace,ishot)             
           if(ig .lt. minrecind) then
              write(lerr,*) 'trace group index (RecInd) = ',ig,
     1                      ' less than minrecind = ',minrecind
              go to 99991
           endif
           if(ig .gt. maxrecind) then
              write(lerr,*) 'trace group index (RecInd) = ',ig
              write(lerr,*) 'greater than dimensioned value'//
     1                      ' maxrecind = ',maxrecind
              go to 99992
           endif
c
           xr(itrace,ishot)=ig*dsta-dsta
           yr(itrace,ishot)=0. 
c
           lrecind(ig)=recind(itrace,ishot)
           xg(ig)=xr(itrace,ishot)
           yg(ig)=yr(itrace,ishot)
           zg(ig)=zr(itrace,ishot)
           offset=xr(itrace,ishot)-xs(ishot)
           icmp=nint(.1*srcloc(ishot)+.5*offset/dsta)                       
           if(icmp .lt. minrecind) then
              write(lerr,*) 'Water depth cmp index icmp = ',icmp,
     1                      ' less than minrecind = ',minrecind
              write(lerr,*) 
     1          'itrace,ishot,xr(itrace,ishot),xs(ishot),dsta',
     2          itrace,ishot,xr(itrace,ishot),xs(ishot),dsta
              call exitfu(666)
           endif
           if(icmp .gt. maxrecind) then
              write(lerr,*) 'Water depth cmp index icmp = ',icmp,
     1                      ' greater than maxrecind = ',maxrecind
              write(lerr,*) 
     1          'itrace,ishot,xr(itrace,ishot),xs(ishot),dsta',
     2          itrace,ishot,xr(itrace,ishot),xs(ishot),dsta
              call exitfu(666)
           endif
           zw(icmp)=zwgather(itrace,ishot)
c
           mincmp=min(icmp,mincmp)
           maxcmp=max(icmp,maxcmp)
           mingroup=min(ig,mingroup)
           maxgroup=max(ig,maxgroup)
        endif
20000  continue
40000 continue      
      ELSEIF(model) THEN
      do 60000 ishot=1,nshot
C___________________________________________________________________
c      For model data we REALLY want to use the SrPtXC and SrPtYC
c      at they exist in the trace headers !!! Of course this means
c      we must know how to index data properly to begin with.
C___________________________________________________________________
c       xs(ishot)=.1*srcloc(ishot)*dsta-dsta
c       ys(ishot)=0.
       do 80000 itrace=1,ntrace
        if(live(itrace,ishot)) then
           ig=recind(itrace,ishot)             
           xg(ig)=xr(itrace,ishot)
           yg(ig)=yr(itrace,ishot)
           zg(ig)=zr(itrace,ishot)
           offset=xr(itrace,ishot)-xs(ishot)
           icmp=nint(.1*srcloc(ishot)+.5*offset/dsta)                       
           zw(icmp)=zwgather(itrace,ishot)
           mincmp=min(icmp,mincmp)
           maxcmp=max(icmp,maxcmp)
           mingroup=min(ig,mingroup)
           maxgroup=max(ig,maxgroup)
        endif
80000  continue
60000 continue      
      ENDIF
C__________________________________________________________________
c     topography well approximated by receiver elevations.           
c     check/fill in the topography array at each group index.       
C___________________________________________________________________
      mintopo=mingroup
      maxtopo=maxgroup
      do 65500 ig=mintopo,maxtopo   
       if(xg(ig) .ne. undefined) then
          xtopo(ig)=xg(ig)
          ytopo(ig)=yg(ig)
          ztopo(ig)=zg(ig)
       endif
65500 continue
c
      return
c
99991 write(lerr,*) 'WARNING!'
      write(lerr,*) 'negative indices may have been caused'
     1             //' by indexing RecInd or SrcLoc > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' smaller value after -ming option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99991)
c
99992 write(lerr,*) 'WARNING!'
      write(lerr,*) 'bogus indices may have been caused'
     1             //' by indexing RecInd > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' larger value after -maxg option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99992)
c
      end
