C***********************************************************************
C                 copyright 2003, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine reproject(xs,ys,zs,xr,yr,zr,live,nlive,
     1                    minshot,maxshot,srcloc,
     2                    xbegin,ybegin,xbeginprime,
     3                    minrecind,maxrecind,dsta,nshot,ntrace,
     4                    vsp,azim,theta,stderr,lerr,undefined)
c
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      logical live(ntrace,nshot)
c
      integer srcloc(nshot)
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)

      integer nlive(nshot)
c
      integer stderr
c
      logical vsp
C__________________________________________________________________
c     reproject the x and y coordinates onto a straight line 
c     whose origin is at the first live shot point.
C___________________________________________________________________
      xbegin=xs(minshot)
      ybegin=ys(minshot)
      xend=xs(maxshot)
      yend=ys(maxshot)
      ishot_index=.1*srcloc(minshot)
      xbeginprime=ishot_index*dsta-dsta
C___________________________________________________________________
c     x axis is assumed to be East.
c     y axis is assumed to be North.
c     the azimuth of the line, azim, is measured clockwise from the
c         North, or y, axis:
c
c         azim=atan2(ylen,xlen)
c     
c     theta is the angle the line makes measured counterclockwise
c         from the East, or x, axis:
c
c         theta=90.-azim
C___________________________________________________________________
      ylen=yend-ybegin
      xlen=xend-xbegin 
      if(xlen .ne. 0. .and. ylen .ne. 0.) then
         thetaends=180./3.1415926*atan2(ylen,xlen)
      else
         thetaends=0.
      endif
      if(azim .eq. undefined) then
         theta=thetaends
      else
         theta=90.-azim 
      endif
      azimends=90.-thetaends
      azim=90.-theta
      radpdeg=3.1415926/180.
      costh=cos(theta*radpdeg)           
      sinth=sin(theta*radpdeg) 
      write(lerr,'(80a1)') ('_',j=1,80)
      write(lerr,*) 'reprojection information:'
      write(lerr,'(80a1)') ('_',j=1,80)
      write(lerr,*) 'x begin  (m or ft)             = ',xbegin
      write(lerr,*) 'y begin  (m or ft)             = ',ybegin
      write(lerr,*) 'x end    (m or ft)             = ',xend  
      write(lerr,*) 'y end    (m or ft)             = ',yend  
      write(lerr,*) 'xlen     (m or ft)             = ',xlen
      write(lerr,*) 'ylen     (m or ft)             = ',ylen  
      write(lerr,*) 'x begin prime  (m or ft)       = ',
     1                  xbeginprime
      write(lerr,*) 'azimuth (clockwize from North) = ',azim
      write(lerr,*) 'azimuth (from end points)      = ',azimends
      write(lerr,*) 'theta (counterclockwise from East) = ',
     1                    theta
      write(lerr,'(80a1)') ('_',j=1,80)

      do 40000 ishot=1,nshot
       if(nlive(ishot) .gt. 0.) then
          xtemp=xs(ishot)-xbegin
          ytemp=ys(ishot)-ybegin
          xs(ishot)=xtemp*costh+ytemp*sinth+xbeginprime 
          ys(ishot)=-xtemp*sinth+ytemp*costh
       else
          xs(ishot)=0.
          ys(ishot)=0.
       endif
40000 continue
      do 70000 ishot=1,nshot 
       do 60000 itrace=1,ntrace
        if(live(itrace,ishot)) then
           xtemp=xr(itrace,ishot)-xbegin
           ytemp=yr(itrace,ishot)-ybegin
           xr(itrace,ishot)=+xtemp*costh+ytemp*sinth+xbeginprime
           yr(itrace,ishot)=-xtemp*sinth+ytemp*costh
        else
           xr(itrace,ishot)=0.
           yr(itrace,ishot)=0.
        endif
60000  continue
70000 continue
c
      return
      end
