/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <localsys.h>

#ifdef CRAY
#define qestm_ QESTM
#endif
#ifdef hpux
#define qestm_ qestm
#endif

#ifndef M_PI
   #define M_PI 3.14159265358979323846 
#endif

/*      qestf: estimate the slope of the spectrum obtained from maximum entropy es
timation.
 *      (       dataLength:     the length of the whole data;
 *              winLength:      the width of the data selecting window;
 *              order:          the order of the AR model;
 *              freqNum:        the number of discrete frequency samples;
 *              fitDataNum:     the number of the frequency samples used
 *                              for slope estimation;
 *              delay:          number of samples immediately following
 *                              the peak of the spectrum used for slope est;
 *              data:           1-d data array;
 *              output:         1-d array of the estimate of the slope.
 *              peakf:          1-d array of the integer peak frequency
 *              peaka:          1-d array of the peak amplitude;
 *      )
 */

int qestm_(int *winLength,int *freqNum,int *fitDataNum,int *dataLength,int *order,int *delay,double *dt,int *nfs,double *data,double *output,double *peakf,double *peaka,double *cut, double *df, int *nfst)
{
    int linearInt(int, int, double *);
    double peakFit(int, double *);
         
    double samplingPeriod = *dt;
    double sscale = *df;

    int i, j, k, n, L;
    int freqMax;
    double fac;
    double arg;
    double ave;
    int N = *nfs;
    int NF= *fitDataNum;
    int nf1 = *nfst;
    double b, sum, rho, maxValue;
    double *r, *aNew, *aOld, *xReal, *xImag, *spectrum, *x1;
    double last_slope;
    double last_peakf;
    int morder = *order;
    int mdelay = *delay;
    int ns = *dataLength - *winLength;

    r=malloc((morder+1)*sizeof(double));
    aNew=malloc((morder+1)*sizeof(double));
    aOld=malloc((morder+1)*sizeof(double));
    xReal=malloc((N+1)*sizeof(double));
    xImag=malloc((N+1)*sizeof(double));
    spectrum=malloc((N+1)*sizeof(double));
    x1=malloc((N+1)*sizeof(double));
    
/*
    fprintf(stderr,"N= %d\n",N);
    fprintf(stderr,"data length= %d\n",*dataLength);
    fprintf(stderr,"freqNum= %d\n",*freqNum);
    fprintf(stderr,"winLength= %d\n",*winLength);
    fprintf(stderr,"fitDataNum= %d\n",*fitDataNum);
    fprintf(stderr,"delay= %d\n",mdelay);
    fprintf(stderr,"order= %d\n",morder);
    fprintf(stderr,"ns= %d\n",ns);
*/


/*    fac = sscale*N*samplingPeriod; */

  fac = 1./(*df);


         
    /* Estimate autocorrelation function */

    for (i=0;i<=morder;i++)
    {   sum=0.0;
        L=*winLength-i;
        for (j=0;j<L;j++)
        {   sum += data[j]*data[j+i];
        }
        r[i]=sum/L;
    }
        
    for (n=0; n <= ns; n++)
    {       
        /* Estimate linear prediction coefficients */
        aNew[0]=1.0;
        aNew[1]=-r[1]/r[0];
        rho=(1-aNew[1]*aNew[1])*r[0];
    
        for (k=2;k<=morder;k++)
        {   b=-r[k];
            for (j=1;j<k;j++)
            {   aOld[j]=aNew[j];
                b -= aOld[j]*r[k-j];
            }
            aNew[k]=b/rho;
            for (j=1;j<k;j++)
            {   aNew[j] = aOld[j]+aNew[k]*aOld[k-j];
            }
            rho=(1-aNew[k]*aNew[k])*rho;
        }
    
        /* Calculate the normalized spectrum */
        for (k=0;k<=N;k++)
        {
            xReal[k]=0.0;
            xImag[k]=0.0;
            for (i=0;i<=morder;i++)
            {
             arg = 2.0*M_PI*((double) k)*((double) i) / *freqNum;
             xReal[k]+=aNew[i]*cos(arg);
             xImag[k]-=aNew[i]*sin(arg);
            }
            spectrum[k]= 1.0/(xReal[k]*xReal[k]+ xImag[k]*xImag[k]);
        }

/*
if ( n > 1 && n < 12 ){
 if ( n%1 == 0 ) {
 for (j=1;j<=N;j++) fprintf(stderr,"%d  %f\n",j,spectrum[j]);
 fprintf(stderr,"\n");
 }
}
*/
        if (nf1 > 0) 
        {
          maxValue=spectrum[nf1];
          freqMax=nf1;
          peakf[n] = freqMax;
          peaka[n] = sqrt (maxValue);
        }
        else
        {
        /* Find the value and the location of the peak */
          maxValue=0.0;
          freqMax=0;
          for (j=0;j<N;j++)
          {   if (maxValue <= spectrum[j])
            {  maxValue=spectrum[j];
               freqMax=j;
               peakf[n]=freqMax;
               peaka[n] = sqrt (maxValue);
            }
          }
        }

        for (j=freqMax+mdelay;j<=N;j++)
          x1[j-freqMax-mdelay]=10*log10(spectrum[j]/maxValue);

        /* output[n]=linearFit(*fitDataNum, x1); */
/*        linearInt(1, N-freqMax+1, x1); */
        NF = *cut * (N-freqMax+1);
        output[n]=peakFit(NF,x1) * fac;

        /* Update the autocorrelation function */
        for (i=0;i<=morder;i++)
        {   L=*winLength-i;
            r[i]=(r[i]*L-data[n]*data[n+i]+data[n+L]*data[n+L+i])/L;
        }
    }

    last_peakf = peakf[*dataLength-*winLength];
    last_slope = output[*dataLength-*winLength];
 
    for (i=*dataLength-*winLength+1; i<*dataLength;i++) {
        output [i] = last_slope;
        peakf  [i] = last_peakf;
        peaka  [i] = 0.0;
    }

}
