C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ValueChange(tri, nsamp, new_vel, 
     :              Index_Constraint,Pick_Constraint,
     :              Null_Constraint,No_Constraint,
     :              replacement_value,
     :              hdrwd1,hdrwd2,hdrwd3,hdrwd4,
     :              iword1,iword2,iword3,rword4,
     :              irs, ire, ns, ne, nsi,
     :              recnum, trcnum, nullval,
     :              Start_End_Constraint,ist,iend )

      implicit none

c     Subroutine to perform a value replacement based on the 
c     given constraint conditions and outputs the 
c     the new time series as NEW_VEL.
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer nsamp, irs, ire, ns, ne, ist, iend, nsi
      integer iword1, iword2, iword3, nullval
      integer recnum,trcnum, itop, ibottom, i

      real tri(nsamp)
      real new_vel(nsamp)
      real rword4, replacement_value

      logical  Index_Constraint, Pick_Constraint
      logical  Null_Constraint, No_Constraint
      logical  Start_End_Constraint

      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6, hdrwd4 * 6
c=============================================================================
c     process data
      
c=============================================================================
 
cmam  if (hdrwd4 is supplied, replace trace value with the value
cmam  in the trace header word ndrwd4.

      if(hdrwd4 .ne. '-99999') then
 
         do i = 1,nsamp

c changed int to nint and added (ist-1) to the iword2 constraint
c as it was missing .... pgag [Oct,2,2003]

            itop = nint ( float ( iword1 ) / float ( nsi) ) + ist 
            ibottom = nint ( float ( iword2 ) / float ( nsi) ) + ist 
c            if(i .ge. nint(iword1/nsi)+(ist-1) .and.
c     :           i .le. nint(iword2/nsi)+(ist-1) .and.
            if(i .ge. itop .and.
     :           i .le. ibottom .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
 
               new_vel(i) = rword4
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif

c=============================================================================
      
      if (Null_Constraint  .and. iword3 .eq. nullval) then
       
         do i = 1, nsamp
            new_vel(i) = tri(i)
         enddo
         go to 999
      endif
c=============================================================================
         
      if(Pick_Constraint .and. Index_Constraint) then
      
         do i = 1,nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi) .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
               
               new_vel(i) = replacement_value
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif

c=============================================================================

      if(Index_Constraint) then

         do i = 1, nsamp

            if(recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne .and.
     :	 i .ge. ist .and. i .le. iend ) then
               new_vel(i) = replacement_value
            else
               new_vel(i) = tri(i)
            endif
          
         enddo
         go to 999
      endif
      
c=============================================================================

      if (No_Constraint) then
            
            do i = 1, nsamp
               new_vel(i) =   replacement_value
            enddo
c=============================================================================

         elseif(Start_End_Constraint) then
            do i = 1, nsamp
               if (i .ge. ist .and. i .le. iend) then
                  new_vel(i) = replacement_value
               else
                  new_vel(i) = tri(i)
               endif
            enddo
          
c=============================================================================         
      elseif(Pick_Constraint) then

         do i = 1, nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi)) then
               new_vel(i) = replacement_value
            else
               new_vel(i)=tri(i)
            endif
         enddo
c=============================================================================

      endif
      
c=============================================================================      
      
 999  return
      end
