C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  rotate Main Routine -----------------------
c     Program Changes:

c      - Initial version 9/96  Richard Crider

c     Program Description:

c      - read in data from two separate datasets, each having the same #
c        of samples per trace.  Read a rotation angle from command line
c        and rotate the 2 datasets to 2 new datasets.
c        rotation is:
c              ax' = ax*cos(theta) + ay*sin(theta)
c              ay' = ay*cos(theta) - ax*sin(theta)

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr1( SZLNHD ), itr2( SZLNHD ),TH,LH
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout1, lbytes, nbytes, obytes
      integer     luin1, luin2, lbytes1, lbytes2, ns, ne, irs, ire 
      integer     argis, ntrco, nreco
      integer     nsampo, JJ, KK, luout2

      real  tri_N1( SZLNHD ), tri_N2( SZLNHD )

      character  name * 6,  ntap1* 255, ntap2 * 255, otap1 * 255
      character  otap2 * 255

      logical  verbos

c declare variables used by this routine

      integer pipe, pipe2, ii
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor1, StaCor2
      integer nsamp2, nsi2, ntrc2, nrec2
 
      real  tri_out ( SZLNHD )

c initialize variables

      data name /'ROTATE'/
      data luin / 1 /
      data luout1  / 2 /
      data lbytes / 0 /
      data nbytes / 0 /
      data  obytes / 0 /
      data verbos/.false./
      data pipe/3/
      data pipe2/4/

c get online help if requested

      LH  = LINEHEADER
      TH  = TRACEHEADER
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help(LER)
          stop
      endif

c open printout file

#include <f77/open.h>

c parse command line parameters

      call cmdln ( ntap1, ntap2, otap1, otap2, angle,verbos)

c if this block is used here, IKP will never work
c      if(ntap1.eq.' '.or.ntap2.eq.' '.or.otap1.eq.' '.or.
c     :     otap2.eq.' ')
c     :     then
c       write(LERR,*)'All data set names must be specified. Fatal!'
c       write(LERR, *)'All data set names must be specified. Fatal!'
c       stop
c      endif

c open -N1 dataset

      call getln( luin1, ntap1, 'r', 0)
      if (luin1 .lt. 0) then
         write(LERR,*)'Cannot open N1 dataset', ntap1
         write(LERR,*)'Check spelling / existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'ROTATE: Cannot open N1 dataset', ntap1
         write(LER,*)'       Check spelling / existence and rerun'
         write(LER,*)'FATAL'
         stop
      endif

c open -N2 dataset and check to see if in IKP, if so open a socket

         if ( ntap2(1:1) .eq. ' ' ) then
             write(LERR,*)'ROTATE assumed to be running inside ikp'
          
c pipe is defined above to be 3 as that is the socket number used for
c the -N2 port in IKP

             call sisfdfit (luin2, pipe)
             ns  = 0
             ne  = 0
             irs = 1
             ire = 0
         else
             call getln( luin2, ntap2, 'r', 0)
         endif

         if(luin2 .lt. 0) then
            write(LERR,*)'Cannot open N2 dataset', ntap2
            write(LERR,*)'Check spelling / existence and rerun'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'ROTATE: Cannot open N2 dataset', ntap2
            write(LER,*)'       Check spelling / existence and rerun'
            write(LER,*)'FATAL'
            stop
         endif

c open output dataset

         call getln( luout1, otap1, 'w', 1)

c     added this part to make the code
c     portable to IKP
c     James M. Gridley USP Team - Tulsa

         if ( otap2(1:1) .eq. ' ' ) then
         
            write(LERR,*)'ROTATE assumed to be running inside ikp'
            
c     pipe is defined above to be 4 as that is the socket number used for
c     the -O2 port in IKP
            
            call sisfdfit (luout2, pipe2)
         else
            call getln( luout2, otap2, 'w', 1)
         endif
         write(LERR,*)'1'

c read the line header from N1 dataset

      lbytes1 = 0
      call rtape ( luin1, itr1, lbytes1 )
      if(lbytes1 .eq. 0) then
         write(LERR,*)'ROTATE: no header read on unit ',ntap1
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         write(LER,*)'ROTATE: no header read on unit ',ntap1
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

c  get global parameters from N1 lineheader

      call saver( itr1, 'NumSmp', nsamp , LINHED )
      call saver( itr1, 'SmpInt', nsi   , LINHED )
      call saver( itr1, 'NumTrc', ntrc  , LINHED )
      call saver( itr1, 'NumRec', nrec  , LINHED )
      call saver( itr1, 'Format', iform , LINHED )
      call saver( itr1, 'UnitSc',unitsc1 , LINHED )

c set up pointers to trace header values to be used in this routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TH)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TH)

c print historical line header from N1 dataset to printout file

      lname =  6
      call hlhprt (itr1, lbytes1, name, lname, LERR)

c read the line header from N2 dataset

      lbytes2 = 0
      call rtape ( luin2, itr2, lbytes2 )

         if ( lbytes2 .eq. 0 ) then
            write(LERR,*)'ROTATE: no header read on unit ',ntap2
            write(LERR,*)'FATAL'
            write(LERR,*)'Check existence of file & rerun'
            write(LER,*)'ROTATE: no header read on unit ',ntap2
            write(LER,*)'FATAL'
            write(LER,*)' '
            stop
         endif

c  get global parameters from N2 lineheader

         call saver( itr2, 'NumSmp', nsamp2 , LINHED )
         call saver( itr2, 'SmpInt', nsi2   , LINHED )
         call saver( itr2, 'NumTrc', ntrc2  , LINHED )
         call saver( itr2, 'NumRec', nrec2  , LINHED )
         call saver( itr2, 'UnitSc',unitsc2 , LINHED )


         if ( ntrc2 .ne. ntrc ) then
               write(LERR,*)' '
               write(LERR,*)'ROTATE: The N2 dataset must have the same '
               write(LERR,*)'       traces / record as the N1 dataset'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'ROTATE: The N2 dataset must have the same '
               write(LER,*)'       traces / record as the N1 dataset'
               write(LER,*)'FATAL'
           stop
         endif

         if ( nsi2 .ne. nsi .or. unitsc1.ne.unitsc2) then
            write(LERR,*)' '
            write(LERR,*)'ROTATE: The N2 dataset must have the same '
            write(LERR,*)'       sample interval as the N1 dataset.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'ROTATE: The N2 dataset must have the same '
            write(LER,*)'       sample interval as the N1 dataset.'
            write(LER,*)'FATAL'
            stop
         endif

         if ( nsamp2 .lt. nsamp ) then
            write(LERR,*)' '
            write(LERR,*)'ROTATE: The N2 dataset must have at least  '
            write(LERR,*)'       the same number of samples as the N1'
            write(LERR,*)'       dataset.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'ROTATE: The N2 dataset must have at least  '
            write(LER,*)'       the same number of samples as the N1'
            write(LER,*)'       dataset.'
            write(LER,*)'FATAL'
            stop
         endif

         if ( nrec2 .lt. nrec ) then
            write(LERR,*)' '
            write(LERR,*)'ROTATE: The N2 dataset must have at least '
            write(LERR,*)'       the same number of records as the '
            write(LERR,*)'       N1 dataset.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'ROTATE: The N2 dataset must have at least '
            write(LER,*)'       the same number of records as the '
            write(LER,*)'       N1 dataset.'
            write(LER,*)'FATAL'
            stop
         endif


      if( nsamp .gt. SZLNHD ) then
         write(LERR,*)'Too many samples in traces -- FATAL'
         write(LERR,*)'window the input data & rerun'
         write(LER,*)'ROTATE: '
         write(LER,*)'Too many samples in traces '
         write(LER,*)'window the input data & rerun'
         write(LER,*)'FATAL'
         stop
      endif

c check default values; update header

      call cmdchk( ns, ne, irs, ire, ntrc, nrec )
 
      ntrco = ne - ns + 1
      call savew( itr1, 'NumTrc', ntrco  , LINHED )

      nreco = ire - irs + 1
      call savew( itr1, 'NumRec', nreco, LINHED )

      nsampo = nsamp
      if(unitsc1.eq.0)then  
       unitsc1=0.001
       call savew(itr1, 'UnitSc', unitsc1,LINHED)
      endif
      call savew( itr1, 'NumSmp', nsampo, LINHED )

      obytes = SZTRHD + SZSMPD * nsampo

      call savhlh( itr1, lbytes1, lbyout )
      call wrtape ( luout1, itr1, lbyout )

      call savhlh (itr2, lbytes2, lbytes2)
      call wrtape ( luout2, itr2, lbytes2)

c print control parameters to printout file

      call verbal( ntap1, ntap2, otap1,otap2, angle,LERR)

c skip to start record in each dataset if required
      irs = 1
      ire = nrec
      ns  = 1
      ne  = ntrc

      call recskp ( 1, irs-1, luin1, ntrc, itr1 )
      call recskp ( 1, irs-1, luin2, ntrc, itr2 )

      theta = angle *3.14159625/180.
      costheta = cos(theta)
      sintheta = sin(theta)

      DO JJ = irs, ire

c skip to start trace if necessary

         if ( ns .gt. 1 ) then
            call trcskp ( JJ, 1, ns-1, luin1, ntrc, itr1 )
            call trcskp ( JJ, 1, ns-1, luin2, ntrc, itr2 )
         endif

         DO KK = ns, ne

c read in N1 trace

            nbytes = 0
            call rtape ( luin1 , itr1, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input DSN 1:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call saver2(itr1,ifmt_StaCor,l_StaCor,ln_StaCor,StaCor1,TH)
            call saver2(itr1,ifmt_RecNum,l_RecNum,ln_RecNum,RecNum,TH)

            if ( StaCor1 .ne. 30000 ) then
               call vmov ( itr1(ITHWP1), 1, tri_N1, 1, nsampo )
            else
               call vclr ( tri_N1, 1, nsampo)
            endif

            nbytes2 = 0
            if(lbytes2 .ne. 0) then
             call rtape  ( luin2 , itr2, nbytes2 )
             if(nbytes2 .eq. 0) then
              write(LERR,*)'End of file on input DSN 2:'
              write(LERR,*)'  rec= ',JJ,'  trace= ',KK
              write(LER ,*)'End of file on input DSN 2:'
              write(LER ,*)'  rec= ',JJ,'  trace= ',KK
              go to 999
             endif

             call vmov (itr2(ITHWP1), 1, tri_N2, 1, nsampo)
            else
             call vclr(tri_N2,1,nsampo)
            endif

            call saver2(itr2,ifmt_StaCor,l_StaCor,ln_StaCor,StaCor2,TH)
            if(StaCor2 .eq. 30000) call vclr(tri_N2,1,nsampo)
 
            if ( verbos .and. KK .eq. ns ) then
               write(LERR,*)'Output Record ',RecNum
            endif

            if (StaCor1.eq.30000 .AND. StaCor2.eq.30000) then
               call savew2(itr1,ifmt_StaCor,l_StaCor,ln_StaCor,30000,TH)
            elseif (StaCor1.eq.30000 .AND. StaCor2.ne.30000) then
              call move ( 1, itr1, itr2, SZTRHD )
            endif

            call vclr (tri_out, 1, nsampo )

            do ii = 1, nsampo
             tri_out(ii) = sintheta*tri_N2(ii) + costheta*tri_N1(ii)
            enddo
            call vmov ( tri_out, 1, itr1(ITHWP1), 1, nsampo )
            call wrtape( luout1, itr1, obytes )
            do ii = 1, nsampo
              tri_out(ii) = costheta*tri_N2(ii) - sintheta*tri_N1(ii)
            enddo
            call vmov ( tri_out, 1, itr1(ITHWP1), 1, nsampo )
            call wrtape( luout2, itr1, obytes )
 
         ENDDO

c skip from current trace to end of record

         if ( ne .lt. ntrc) then
          call trcskp ( JJ, ne+1, ntrc, luin1, ntrc, itr1 )
          call trcskp ( JJ, ne+1, ntrc, luin2, ntrc, itr2 )
         endif

      ENDDO

c normal termination

      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout1)
      call lbclos(luout2)

      write(LERR,*)' processed ',nreco,' records of ',ntrco,' traces'
      write(LERR,*)' Normal Termination'
      write(LER,*)'rotate: Normal Termination'
      stop

 999  continue

c abnormal termination
      
      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout1)
      call lbclos(luout2)

      write(LERR,*)' Abnormal Termination'
      write(LER,*)'rotate: Abnormal Termination'
      stop
      end

      subroutine help(LER)

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for ROTAT: Data rotation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N1[ntap1] -- input data set name 1        (stdin)'
        write(LER,*)'-N2[ntap2] -- input data set name 2         (none)'
        write(LER,*)'-O1[otap1] -- rotation of ntap1   '
        write(LER,*)'-O2[otap2] -- rotation of ntap2   '
        write(LER,*)'-r[angle]  -- rotation angle                (0.0)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      rotate -N1[] -N2[] -O1[] -O2[] -r[] '
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap1 - C*255  input file name
c     ntap2 - C*255  input file name
c     otap1 - C*255  output file name
c     otap2 - C*255  output file name
c     ns   - I      start trace
c     ne   - I      stop trace
c    irs   - I      start record
c    ire   - I      stop end record
c    sum_of_squares    - L      sum of squares
c    panel  -L       panel option
c    verbos - L      verbose output or not
c-----
      subroutine cmdln ( ntap1, ntap2, otap1, otap2,angle,verbos)

c declare variable passed from calling routine

      real         angle
      character    ntap1*(*), ntap2*(*), otap1*(*), otap2*(*)
      integer      argis
      logical      verbos


      call argstr('-N1',ntap1,' ',' ')
      call argstr('-N2',ntap2,' ',' ')
      call argstr('-O1',otap1,' ',' ')
      call argstr('-O2',otap2,' ',' ')
      call argr4('-r',angle,0.0,0.0)

      verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
      
      subroutine verbal ( ntap1, ntap2, otap1, otap2, angle,LERR)
c declare variables passed from calling routine

      real angle

      character ntap1*(*), ntap2*(*), otap1*(*),otap2*(*)


      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      write(LERR,*)' N1 Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ',ntap1( 1:lenth(ntap1) )
      write(LERR,*)' '
      write(LERR,*)' N2 Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ',ntap2( 1:lenth(ntap2) )
      write(LERR,*)' '
      write(LERR,*)' O1 Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ', otap1( 1:lenth(otap1) )
      write(LERR,*)' '
      write(LERR,*)' O2 Dataset '
      write(LERR,*)' '
      write(LERR,*) ' Filename           =  ', otap2( 1:lenth(otap2) )
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' rotation angle        =  ', angle
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      
      return
      end
