C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln ( ntap, ist, iend, ns, ne, irs, ire, blnk, 
     :     verbos, dels, ncomp, idec, rdel, tdel, mbs, rev, otap, 
     :     nullval, stream, nsampi, ntrci, nreci, w_col, wvel, 
     :     SI_units, UnitSc_in, believe, flat, si )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer  ist, iend, ns, ne, irs, ire, ncomp, idec, rdel, tdel
      integer  nsampi, ntrci, nreci

      real dels, nullval, wvel, UnitSc_in, si

      character   ntap*(*), otap*(*)

      logical blnk, verbos, mbs, rev, stream, w_col, SI_units, believe
      logical flat

c declare local variables

      integer argis

c parse command line
 
      flat = (argis('-F') .gt. 0)
      blnk = (argis('-B') .gt. 0)
      call argi4 ( '-b', ncomp ,   1  ,  1    )

      call argi4 ( '-e', iend,   0  ,  0    )

      call argr4 ( '-f', dels ,   0.0  ,  0.0    )

      call argi4 ( '-i', idec ,   1  ,  1    )

      mbs = (argis('-M') .gt. 0)

      call argi4 ( '-nsamp', nsampi ,   0  ,  0    )
      call argi4 ( '-nrec', nreci ,   1  ,  1    )
      call argi4 ( '-ntrc', ntrci ,   1  ,  1    )
      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argr4 ( '-nv', nullval ,   0.  ,  0.    )
      call argr4 ( '-dt', si ,   0.  ,  0.    )
      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )

      call argi4 ( '-rs', irs ,   0  ,  0    )
      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-R0', rdel ,   1  ,  1    )
      rdel = iabs (rdel)

      rev = (argis('-R') .gt. 0)
      if (flat) rev = .true.

      SI_units = ( argis('-SI') .gt. 0 )
      call argi4 ( '-s', ist ,   1  ,  1    )

      believe = (argis('-TmMsFS') .gt. 0)
      call argi4 ( '-T0', tdel ,   1  ,  1    )
      tdel = iabs (tdel)

      call argr4 ( '-UnitSc', UnitSc_in,   0.001  ,  0.001    )
      verbos = ( argis('-V') .gt. 0 )

      call argr4 ( '-w', wvel, 0.0, 0.0)
      w_col = .false.
      if (wvel .ne. 0.0) w_col = .true.

c policeman to detect input on stdin

      stream = .false.
      if (rev .AND. (ntap .eq. ' ') ) then
         stream = .true.
         if (nsampi .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR:'
            write(LERR,*)'For input streamed X-Y data must enter'
            write(LERR,*)'number of samples per trace -nsamp[]'
            write(LER ,*)' '
            write(LER ,*)'SIS_XY:'
            write(LER ,*)' For input streamed X-Y data must enter'
            write(LER ,*)' number of samples per trace -nsamp[]'
            write(LER ,*)'FATAL'
            stop
         endif
      endif
 
      return
      end
