c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c     
      subroutine oversamp(data_old,n_old,d_old,data_new,n_new,d_new,
     *     nsinc,index,rem,w,extend)
c     
      implicit none
c     
      real              pi
      parameter (pi=3.1415926535)
c     
      integer           n_old,n_new,nsinc
      integer           index(n_new)
      real              d_old,d_new
      real              rem(n_new)
      real              data_old(n_old)
      real              data_new(n_new)
      real              w(n_new,-nsinc:nsinc)
      logical           extend
c     
      integer           i,i_here,ishift
      integer           n_new_prev,n_old_prev,nsinc_prev
      real              stdd,x,smpl,value
      real              ratio,ratio_prev
c
      save              n_new_prev,n_old_prev,ratio_prev,nsinc_prev
      data              n_new_prev,n_old_prev/0,0/
      data              ratio_prev,nsinc_prev/0,0/
c
c     no interpolation needed
c
      if (n_old.eq.n_new) then
         do i=1,n_new
            data_new(i)=data_old(i)
         enddo
         return
      endif
c     
c     initialize: compute the indicies and remainders on 1st pass
c     
      ratio=d_new/d_old
      if (n_new.ne.n_new_prev.or.n_old.ne.n_old_prev
     *     .or.ratio.ne.ratio_prev.or.nsinc.ne.nsinc_prev) then
         n_new_prev=n_new
         n_old_prev=n_old
         nsinc_prev=nsinc
c     
         stdd=0.707/(float(nsinc)/4.0)
         do i=1,n_new
            index(i)=1+(i-1)*ratio
            rem(i)=(i-1)*ratio-(index(i)-1)
            if (rem(i).eq.1.0) then
               rem(i)=0.0
               index(i)=index(i)+1
            endif
            if (index(i).ge.n_old) then
               index(i)=n_old
               rem(i)=0.0
            elseif (index(i).lt.1) then
               index(i)=1
               rem(i)=0.0
            endif
            do ishift=-nsinc,nsinc
               x=rem(i)-ishift
               if (x.eq.0.0) then
                  w(i,ishift)=1.0
               else
                  w(i,ishift)=sin(pi*x)/(pi*x)*exp(-(stdd*x)**2)
               endif
            enddo
         enddo
      endif
c     
c     sinc interpolation:
c     
      if (extend) then
         do i=1,n_new
            value=0.0
            do ishift=-nsinc,nsinc
               i_here=index(i)+ishift
               if (i_here.lt.1) then
                  smpl=data_old(1)
               elseif (i_here.gt.n_old) then
                  smpl=data_old(n_old)
               else
                  smpl=data_old(i_here)
               endif
               value=value+w(i,ishift)*smpl
            enddo
            data_new(i)=value
         enddo
      else
         do i=1,n_new
            value=0.0
            do ishift=-nsinc,nsinc
               i_here=index(i)+ishift
               if (i_here.ge.1.and.i_here.le.n_old) then
                  value=value+w(i,ishift)*data_old(i_here)
               endif
            enddo
            data_new(i)=value
         enddo
      endif
c     
      return
      end
