/* ********************************************************************
**               AMOCO PRODUCTION COMPANY PROPRIETARY                **
**                  TO BE MAINTAINED IN CONFIDENCE                   **
**              COPYRIGHT AMOCO PRODUCTION COMPANY, 1992             **
**                                                                   **
**       Program new_draw                                            **
**     coded by R. Crider and D. Boddy,  APC                         **
**                                                                   **
**********************************************************************/
#include "xos.h"
#include "globals.h"
#include <X11/X.h>
#ifdef SUNSYSTEM
#include <sys/types.h>
#include <netinet/in.h>
#include <inttypes.h>
#endif

#define CONVERT2(word) (short)(((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff)
#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))

extern Colormap AppCmap;
static Widget     wb,ws;

XFontStruct    *font1;

Lfont        num_font;

Colormap cmap;
XColor colorcell, rgb_db_def, colorscale, rgb_db_def2, hardware_def;

extern void insamp_();

int
about(x, f1, y)
int x;
int *y;
float *f1;
{
   float half;
   int  ninc, i, j;

   half = *f1 / 2.;
   if(!half)  half = 1.;
   ninc = *y / 1000;
   j = 0;
   for (i=0; i<ninc; i++) {
     j += 1000;
     if (fabs((float)(x - j)) <= half) return(0);
   }
   return(1);
}

void remove_timer()
{
    if(wb) XtUnmanageChild(wb);
}
void display_timerCB(w, client, call)
Widget w;
Widget client;
caddr_t call;
{

        extern Visual *visual;
        extern int depth;

	Arg        args[15];
	XmString   xmstring;
	int n;

	Widget rc;

	static int first=1;

	if (first) {

/*
 * 98.01.19 - Changed DefaultColormap(XtDisplay(client),0) to AppCmap - DR
 */
        cmap = AppCmap;
        first = 0;

        if(visual->class == PseudoColor) {
          XAllocNamedColor(XtDisplay(client), cmap, "red", 
                          &colorscale, &rgb_db_def2);
        }
        else {
          XLookupColor(XtDisplay(client), cmap, "red", 
                          &rgb_db_def2,&colorscale);
          color2pixel(&colorscale,visual,depth);
        }

        xmstring = XmStringCreateLtoR("Percent complete",
                          XmSTRING_DEFAULT_CHARSET);
        n = 0;
        XtSetArg(args[n], XmNdialogTitle, xmstring); n++;
        wb = XmCreateBulletinBoardDialog(client, "anForm",
                      args, n) ;
        XmStringFree (xmstring) ;

        n = 0;
        rc = XmCreateRowColumn(wb, "workarea", args, n);
        XtManageChild(rc);

        n = 0;
        XtSetArg(args[n], XmNtopShadowColor, colorscale.pixel); n++;
        XtSetArg(args[n], XmNhighlightColor, colorscale.pixel); n++;
        XtSetArg(args[n], XmNminimum, 0); n++;
        XtSetArg(args[n], XmNmaximum, 100); n++;
        XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
        XtSetArg(args[n], XmNshowValue, True); n++;
        XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
        XtSetArg(args[n], XmNtraversalOn, True); n++;
        XtSetArg(args[n], XmNscaleWidth, 480); n++;
        XtSetArg(args[n], XmNsensitive, False); n++;
        ws = XmCreateScale(rc, "scale", args, n);
        XtManageChild(ws);

	}
	if (wb) {
		n = 0;
		XtSetArg(args[n], XmNvalue, 0); n++;
		XtSetValues(ws, args, n);
		XmScaleSetValue(ws,0);
		XtManageChild(wb);
		XFlush(XtDisplay(wb));
	}
}
void
draw_it(ierr, sp, toplevel)
  Seisplot *sp;
  int *ierr;
  Widget toplevel;
{
    extern Visual *visual;
    extern int depth;

/*
**   Creates the image to be displayed by creating a 
**   Pixmap (drawable) and drawing the data to it.
*/
    int    n;
    int    incr;
    int    ns, tbias, Lns;
    int    ndraw,initial;
    int    i, j, ma, mb, k, kk;
    int    offset, ipos, ipos1;
    int    jpos;
    int    rec_compare, lenr, g;
    int    rec_no, isec;
    int    nrbox, nlbox, mb_start;
    int    maxtim100;
    int    *nump;
    int    *pnum, *pnum1;
    int    resamp;
    int    pix_len;
    int    addon, pct_prev, pct;
    int    need_wiggle;
    float  fct;
    int    lw, ikk,again;
    float  val, *gain;
    float  sum;

    unsigned int    wide, high;

    float    time, time_offset, dincr;
    float    pix_inch_x=100.;
    float    pix_inch_y=100.;
    float    psint;
    float    xns, xnss;
    float    delx, t1;
    float    temp, tpix, sec;
    float    xtemp;
    float    namp,pamp;
    float    scale, rcale;
    float    *pdata, *pdata1, *pdata2;
    float    *tmp_data, *hold;

    int one=1,lgmax;
    float gmax, gcale;

    char  *image, *imagep, *image_st, *image_adj, *image_back;

    unsigned char  *image_adjc, *imagec, *image_stc, *image_backc;
    unsigned short *image_adjs, *images, *image_sts, *image_backs;
    unsigned int   *image_adjl, *imagel, *image_stl, *image_backl;

    static char    *cchron=NULL;
    static char    sc[2];
    static int first_time=1;
    static int convert=0;

    unsigned short tmps;
    unsigned int   tmpl;

    XPoint     *npoints;

    Arg args[10];

    Drawable   id;
    XImage     *local_image;
    GC         gc;
    XGCValues  gcvals;

    Pixel        the_color;
    Pixel        get_color();

    static Pixel  white, black;

    int byte_order;
    int dpthrast, quantum, ip;
/*******************************************************************/

    if(depth == 8)  {
      dpthrast=sizeof(char);
      quantum=8;
    }
    else if(depth == 15 || depth ==16 )  {
      dpthrast=2*sizeof(char);
      quantum=16;
    }
    else if(depth == 24 || depth ==32 )  {
      dpthrast=4*sizeof(char);
      quantum=32;
    }


    id = sp->window;
    if(sp->display_type == 0) exit(1);

    if (first_time) {
	first_time = 0;
	byte_order = ImageByteOrder(sp->dpy);
	font1 = XLoadQueryFont(sp->dpy, "9x15");
	num_font.width = 9;
	num_font.height = 15;

	cmap = AppCmap;

        if(visual->class == PseudoColor) {
	  XAllocNamedColor(sp->dpy, cmap, "black", 
	      &colorcell, &rgb_db_def);
        }
        else {
	  XLookupColor(sp->dpy, cmap, "black", 
	     &rgb_db_def, &colorcell);
          color2pixel(&colorcell,visual,depth);
        
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   if (byte_order == LSBFirst) convert = 0;
		   else convert = 1;
#endif
#if ( BYTE_ORDER == BIG_ENDIAN )
		   if (byte_order == MSBFirst) convert = 0;
		   else convert = 1;
#endif

        }

        black = BlackPixel(sp->dpy,DefaultScreen(sp->dpy)); 
        white = WhitePixel(sp->dpy,DefaultScreen(sp->dpy));

        if (wb == NULL) display_timerCB(toplevel, toplevel, NULL);

    }

    need_wiggle = 1;
    sp->end_trace = sp->irec_ctr * sp->ntr;

    if ((sp->display_type == 5 || sp->display_type == 7) &&
         sp->file_flag != 1) need_wiggle = 0;

    if(!need_wiggle) {
	fct = 100. / (float)sp->end_trace;
    }
    else {
	fct = 50. / (float)sp->end_trace;
    }

    pct_prev = 0;
    Lns = sp->nss;
    tbias = sp->ts/sp->smpint;

    if (sp->traces_per_inch == 0)
        sp->traces_per_inch = 12;

    if (sp->inches_per_second == 0)
        sp->inches_per_second = 5;

    if(sp->unit_type == ENGLISH) {
      sp->pix_per_trace = (int)(pix_inch_x/sp->traces_per_inch+0.5);
      t1 = (1000. / (float)sp->smpint) / sp->inches_per_second;
    }
    else {
      sp->pix_per_trace = (int)(pix_inch_x/(sp->traces_per_inch*2.54)+0.5);
      t1 = (1000. / (float)sp->smpint) / (sp->inches_per_second/2.54);
    }

    if (sp->pix_per_trace < 1) sp->pix_per_trace = 1;

    sp->can_bias_x = sp->pix_per_trace + 8*num_font.width + 13;

    if (sp->can_bias_x - sp->pix_per_trace/2 
        - sp->pix_per_trace * sp->maxovlp < 0)
        sp->can_bias_x = sp->pix_per_trace/2 
			+ sp->pix_per_trace * sp->maxovlp;

    sp->xorg = sp->can_bias_x;
    sp->can_bias_y = 6* num_font.height;
    sp->can_bias_yb = 24;
    sp->yorg = sp->can_bias_y;

    sp->pix_per_sample = pix_inch_y / t1;
    if (sp->pix_per_sample <= 0.) sp->pix_per_sample = 0.1;

    delx = 1. / sp->pix_per_sample;

    resamp = 0;
    if(delx != 1.00) resamp = 1;

    xns = Lns * sp->pix_per_sample;
    ns = (int)(xns+0.5);

/*JRS be wary of th 4 */
    npoints = (XPoint *)malloc((ns+4)*sizeof(XPoint));
    if(npoints == NULL) exit(-1);

    nump = (int *)malloc((ns+4)*sizeof(int));
    if(nump == NULL) exit(-1);

    if(resamp) {
      initial = 1;
      insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
      initial = 0;
    }

    xnss = (float)Lns;

    sp->pixwidth = sp->irec_ctr * sp->ntr * sp->pix_per_trace 
		+ 2 * sp->can_bias_x;
    if ((sp->pixwidth/8)* 8 != sp->pixwidth) 
            sp->pixwidth = ((int)sp->pixwidth/8 + 1) * 8;

    sp->can_hi = ns + sp->can_bias_y + sp->can_bias_yb;
    if (((int)sp->can_hi/8)* 8 != sp->can_hi)
        sp->can_hi = (((int)sp->can_hi/8) + 2) * 8;

    psint = xnss / xns * sp->smpint;

    if (resamp)
        psint = (float)Lns / (float)ns * (float)sp->smpint;

    psint = (float)((int)(psint * 1000.+0.5)) / 1000.;

    lw = (float)sp->agclw/psint;
    lw = (int)((float)lw*2./2.+0.5)+1;

    if (lw > ns ) lw = ns -1;

    val = 2047. * sp->scalr;

/* *   Create the pixmap for sp */
    nrbox = 0;
    nlbox = 0;
    namp = 0;
    pamp = 0;

    maxtim100 = (sp->te - sp->ts)/100;
    maxtim100 *= 100;

    ndraw = maxtim100/100 + 2;
    if ((sp->ts/100 * 100) == sp->ts) ndraw --;

/* *   find next higher 100 ms greater than sp->ts */
    time_offset = (int)(sp->ts + 100+0.5)/100 * 100;;

/* **  find the difference and thus the offset for first 100 ms time line.  */
    time_offset -= sp->ts;

/* *    in processing samples */
/*    time_offset /= psint;  */
    time_offset /= sp->smpint;

    if(sp->ts/100 * 100 == sp->ts)
      time_offset = 0;
    time_offset *= sp->pix_per_sample;

/* *  this is the offset for the first time line, in pixels */
    dincr = 100./psint*sp->pix_per_sample;
    dincr = 100./sp->smpint * sp->pix_per_sample;

/* *   this is the line draw increment, in pixels */
    rcale = 1;
    if (sp->scalr != 0) rcale = sp->scalr;

    scale = rcale / sp->datamax;

    if (resamp) {
     tmp_data = (float *)calloc(ns, sizeof(float));
     if (tmp_data == NULL) exit(-1);
    }

    cchron = (char *)calloc(10, sizeof(char));
    if(cchron == NULL) exit (-1);

    tpix = (float)(sp->pix_per_trace * sp->maxovlp);

    if (sp->create1) {
     if(sp->pixmap)  XFreePixmap(sp->dpy, sp->pixmap);
     sp->pixmap = XCreatePixmap(sp->dpy, id, sp->pixwidth, 
                        sp->can_hi, depth);
    }

    gcvals.foreground = white;
    gcvals.background = black;
    gc = XCreateGC(sp->dpy,   sp->pixmap , GCForeground|GCBackground,
            &gcvals);

/* *    Fill the rectangle to clear it for drawing */
    if(sp->create1)
    XFillRectangle(sp->dpy, sp->pixmap , gc, 0, 0, sp->pixwidth,
            sp->can_hi);

/* *   Create pixmap for use in the event proc for digitizing and zoom.  */
    
    if(sp->backup)   XFreePixmap(sp->dpy, sp->backup);
    sp->backup = XCreatePixmap(sp->dpy, id, sp->pixwidth, sp->can_hi,depth);
 
    gcvals.foreground = colorcell.pixel;
    gcvals.background = white;
    XChangeGC(sp->dpy, gc, GCForeground | GCBackground, &gcvals);

    the_color = colorcell.pixel;

    if (sp->file_flag == 1) {
	XDrawString(sp->dpy, sp->pixmap, gc, 2, num_font.height+2, 
                "F:", 2);
	XDrawString(sp->dpy, sp->pixmap, gc, 20, num_font.height+2, 
		sp->file, strlen(sp->file));
	XDrawString(sp->dpy, sp->pixmap, gc, 2, num_font.height*2+4, 
		"B:", 2);
	XDrawString(sp->dpy, sp->pixmap, gc, 20, num_font.height*2+4, 
		sp->file2, strlen(sp->file2));
    }
    else
        XDrawString(sp->dpy, sp->pixmap, gc, 2, num_font.height+2, 
                sp->file, strlen(sp->file));

    sp->end_trace = sp->irec_ctr * sp->ntr;
    pdata1 = &(sp->data)[0];
    pdata1 += tbias;

    if (sp->file_flag == 1) {
        pdata2 = &(sp->data2)[0];
        pdata2 += tbias;
    }

    if (sp->display_type != 3 || sp->file_flag == 1) {
      incr =  sp->end_trace * sp->pix_per_trace;

      if (sp->display_type <= 2 && sp->file_flag != 1) 
        incr += (sp->pix_per_trace * sp->maxovlp * sp->display_type);

      image = (char *)malloc(ns*incr*dpthrast);
      if (image == NULL) {
        sprintf(sp->pltmsg,
          "%s\n", "Insufficient memory to draw image.");
        *ierr = 2;
        goto WIGGLE;
      }

      memset(image, white, ns*incr*dpthrast);
    }

    if (sp->file_flag == 1) {
      /* sample by sample color vd */

      if(depth == 8) image_adjc = (unsigned char *)image;
      else if(depth == 15 || depth ==16 ) image_adjs = (unsigned short *)image;
      else if(depth == 24 || depth ==32 ) image_adjl = (unsigned int *)image;

      if(sp->agc && (sp->which == CDP || sp->which == MO)) {
        gain = (float *)calloc(ns, sizeof(float));
        if(gain == NULL) exit (-1);
      }

      if (!resamp) {
        for (i= 0; i<sp->end_trace; i++) {

	   pct = (int)((float)i * fct+0.5);
	   if (pct / 5 * 5 == pct && wb) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	   }

           if (sp->direction == LR) {
             pdata = pdata2;
             pdata2 += sp->nss;
           }
           else
             pdata = pdata2 + (sp->end_trace - (i + 1))*sp->nss;

           again = 0;
           if(sp->agc && (sp->which == CDP || sp->which == MO)) {
             doagc_(&ns, &lw, &val, pdata, gain);
             again = 1;

             for (ikk=0;ikk<ns; ikk++)
               gain[ikk] *= pdata[ikk];
           }

           if(depth == 8) {
             imagec = image_adjc;
             image_adjc += sp->pix_per_trace;
           }
           else if(depth == 15 || depth ==16 ) {
             images = image_adjs;
             image_adjs += sp->pix_per_trace;
           }
           else if(depth == 24 || depth ==32 ) {
             imagel = image_adjl;
             image_adjl += sp->pix_per_trace;
           }


           for (j=0; j < ns; j++) {

              if (again)
                the_color = get_color(gain[j]);
              else
                the_color = get_color(*pdata++);

              for(ip=0; ip< sp->pix_per_trace; ip++) {
                 if(depth == 8)
                   *(imagec+ip)=(unsigned char)the_color;
                 else if(depth == 15 || depth ==16 )
                   *(images+ip)=(unsigned short)the_color;
                 else if(depth == 24 || depth ==32 )
                   *(imagel+ip)=(unsigned int)the_color;
              }

              if(depth == 8) imagec += incr;
              else if(depth == 15 || depth ==16 ) images += incr;
              else if(depth == 24 || depth ==32 ) imagel += incr;
           }
         }
       }
       else {
         for (i=0; i<sp->end_trace; i++) {
            pct = (int)((float)i * fct+0.5);

            if (pct / 5 * 5 == pct) {
              if (pct != pct_prev && wb) {
                XmScaleSetValue(ws, pct);
                XFlush(XtDisplay(wb));
                pct_prev = pct;
	      }
            }

            pdata = tmp_data;
            if (sp->direction == LR) {
              hold = pdata2;
              pdata2 += sp->nss;
            }
            else
              hold = pdata2 + (sp->end_trace - (i + 1))*sp->nss;

            again = 0;
            insamp_(hold, &Lns, pdata, &ns, &delx, &initial);

            if(sp->agc && (sp->which == CDP || sp->which == MO)) {
              doagc_(&ns, &lw, &val, pdata, gain);
              again = 1;
              for (ikk=0;ikk<ns; ikk++)
                gain[ikk] = pdata[ikk]*gain[ikk];
            }

            if(depth == 8) {
              imagec = image_adjc;
              image_adjc += sp->pix_per_trace;
            }
            else if(depth == 15 || depth ==16 ) {
              images = image_adjs;
              image_adjs += sp->pix_per_trace;
            }
            else if(depth == 24 || depth ==32 ) {
              imagel = image_adjl;
              image_adjl += sp->pix_per_trace;
            }


            for (j=0; j < ns; j++) {
              if (again)
                the_color = get_color(gain[j]);
              else
                the_color = get_color(*pdata++);

              for(ip=0; ip< sp->pix_per_trace; ip++) {
                 if(depth == 8)
                   *(imagec+ip)=(unsigned char)the_color;
                 else if(depth == 15 || depth ==16 )
                   *(images+ip)=(unsigned short)the_color;
                 else if(depth == 24 || depth ==32 )
                   *(imagel+ip)=(unsigned int)the_color;
              }

              if(depth == 8) imagec += incr;
              else if(depth == 15 || depth ==16 ) images += incr;
              else if(depth == 24 || depth ==32 ) imagel += incr;

            }
         } /* end for */
        } /* end else */

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, 
                image, incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 0, 0, 
            sp->can_bias_x-(sp->pix_per_trace)/2, sp->can_bias_y,
            incr, ns);

        goto WIGGLE;
    }

    switch (sp->display_type) {
/**************************************************************************/
     case 7:
        /* sample by sample color vd */

       pct_prev = 0;

       if(depth == 8) image_adjc = (unsigned char *)image;
       else if(depth == 15 || depth ==16 ) image_adjs = (unsigned short *)image;
       else if(depth == 24 || depth ==32 ) image_adjl = (unsigned int *)image;

       if(sp->agc && (sp->which == CDP || sp->which == MO)) {
         gain = (float *)calloc(ns, sizeof(float));
         if(gain == NULL) exit(-1);
       }
       if (!resamp) {
	 for (i= 0; i<sp->end_trace; i++) {
	   
	   pct = (int)((float)i * fct+0.5);
	   if (pct / 5 * 5 == pct) {
	     if (pct != pct_prev) {
	       XmScaleSetValue(ws, pct);
	       XFlush(XtDisplay(wb));
	       pct_prev = pct;
	     }
	   }
	   if (sp->direction == LR) {
	     pdata = pdata1;
	     pdata1 += sp->nss;
	   }
	   else
	     pdata = pdata1 + (sp->end_trace - (i + 1))*sp->nss;
	   
	   again = 0;
	   if(sp->agc && (sp->which == CDP || sp->which == MO)) {
	     doagc_(&ns, &lw, &val, pdata, gain);
	     again = 1;
	     for (ikk=0;ikk<ns; ikk++)
	       gain[ikk] = pdata[ikk]*gain[ikk];
	   }

           if(depth == 8) {
             imagec = image_adjc;
             image_adjc += sp->pix_per_trace;
           }
           else if(depth == 15 || depth ==16 ) {
             images = image_adjs;
             image_adjs += sp->pix_per_trace;
           }
           else if(depth == 24 || depth ==32 ) {
             imagel = image_adjl;
             image_adjl += sp->pix_per_trace;
           }


	   for (j=0; j < ns; j++) {
	     if (again)
	       the_color = get_color(gain[j]);
	     else
	       the_color = get_color(*pdata++);

             for(ip=0; ip< sp->pix_per_trace; ip++) {
                if(depth == 8)
                  *(imagec+ip)=(unsigned char)the_color;
                else if(depth == 15 || depth ==16 )
                  *(images+ip)=(unsigned short)the_color;
                else if(depth == 24 || depth ==32 )
                  *(imagel+ip)=(unsigned int)the_color;
             }

             if(depth == 8) imagec += incr;
             else if(depth == 15 || depth ==16 ) images += incr;
             else if(depth == 24 || depth ==32 ) imagel += incr;

	   }
	 }
       }
       else {
	 for (i=0; i<sp->end_trace; i++) {
	   pct = (int)((float)i * fct+0.5);
	   if (pct / 5 * 5 == pct) {
	     if (pct != pct_prev) {
	       XmScaleSetValue(ws, pct);
	       XFlush(XtDisplay(wb));
	       pct_prev = pct;
	     }
	   }
	   pdata = tmp_data;
	   if (sp->direction == LR) {
	     hold = pdata1;
	     pdata1 += sp->nss;
	   }
	   else
	     hold = pdata1 + (sp->end_trace - (i + 1))*sp->nss;
	   
	   again = 0;
	   insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
	   if(sp->agc && (sp->which == CDP || sp->which == MO)) {
	     doagc_(&ns, &lw, &val, pdata, gain);
	     again = 1;
	     for (ikk=0;ikk<ns; ikk++)
	       gain[ikk] = pdata[ikk]*gain[ikk];
	   }

           if(depth == 8) {
             imagec = image_adjc;
             image_adjc += sp->pix_per_trace;
           }
           else if(depth == 15 || depth ==16 ) {
             images = image_adjs;
             image_adjs += sp->pix_per_trace;
           }
           else if(depth == 24 || depth ==32 ) {
             imagel = image_adjl;
             image_adjl += sp->pix_per_trace;
           }

	   for (j=0; j < ns; j++) {
	     if (again)
	       the_color = get_color(gain[j]);
	     else
	       the_color = get_color(*pdata++);

              for(ip=0; ip< sp->pix_per_trace; ip++) {
                 if(depth == 8)
                   *(imagec+ip)=(unsigned char)the_color;
                 else if(depth == 15 || depth ==16 )
                   *(images+ip)=(unsigned short)the_color;
                 else if(depth == 24 || depth ==32 )
                   *(imagel+ip)=(unsigned int)the_color;
              }

              if(depth == 8) imagec += incr;
              else if(depth == 15 || depth ==16 ) images += incr;
              else if(depth == 24 || depth ==32 ) imagel += incr;

	   }
	 }
       }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

       local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
				  incr, ns, quantum, 0);

       XPutImage(sp->dpy, sp->pixmap, gc, local_image, 0, 0, 
		 sp->can_bias_x-(sp->pix_per_trace)/2, sp->can_bias_y,
		 incr, ns);

     break;  /*  End case 7 */

/**************************************************************************/
     case 6:
        /* sample by sample color vd */

        if(depth == 8) image_adjc = (unsigned char *)image;
        else if(depth == 15 || depth ==16 ) image_adjs = (unsigned short *)image;
        else if(depth == 24 || depth ==32 ) image_adjl = (unsigned int *)image;


        if(sp->agc && (sp->which == CDP || sp->which == MO)) {
          gain = (float *)calloc(ns, sizeof(float));
          if(gain == NULL) exit(-1);
        }

        if (!resamp) {
          for (i= 0; i<sp->end_trace; i++) {

	    pct = (int)((float)i * fct+0.5);
	    if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	    }

            if (sp->direction == LR) {
              pdata = pdata1;
              pdata1 += sp->nss;
            }
            else
              pdata = pdata1 + (sp->end_trace - (i + 1))*sp->nss;


            again = 0;
            if(sp->agc && (sp->which == CDP || sp->which == MO)) {
              doagc_(&ns, &lw, &val, pdata, gain);
              again = 1;

              for (ikk=0;ikk<ns; ikk++)
                gain[ikk] = pdata[ikk]*gain[ikk];
            }

            if(depth == 8) {
              imagec = image_adjc;
              image_adjc += sp->pix_per_trace;
            }
            else if(depth == 15 || depth ==16 ) {
              images = image_adjs;
              image_adjs += sp->pix_per_trace;
            }
            else if(depth == 24 || depth ==32 ) {
              imagel = image_adjl;
              image_adjl += sp->pix_per_trace;
            }

            for (j=0; j < ns; j++) {
              if (again )
                the_color = get_color(gain[j]);
              else
                the_color = get_color(*pdata++);

              for(ip=0; ip< sp->pix_per_trace; ip++) {
                 if(depth == 8)
                   *(imagec+ip)=(unsigned char)the_color;
                 else if(depth == 15 || depth ==16 )
                   *(images+ip)=(unsigned short)the_color;
                 else if(depth == 24 || depth ==32 )
                   *(imagel+ip)=(unsigned int)the_color;
              }

              if(depth == 8) imagec += incr;
              else if(depth == 15 || depth ==16 ) images += incr;
              else if(depth == 24 || depth ==32 ) imagel += incr;

            }
          }
        }
        else {
          for (i=0; i<sp->end_trace; i++) {

	    pct = (int)((float)i * fct+0.5);
	    if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	    }

            pdata = tmp_data;

            if (sp->direction == LR) {
              hold = pdata1;
              pdata1 += sp->nss;
            }
            else
              hold = pdata1 + (sp->end_trace - (i + 1))*sp->nss;

            insamp_(hold, &Lns, pdata, &ns, &delx, &initial);

            again = 0;
            if(sp->agc && (sp->which == CDP || sp->which == MO)) {
              doagc_(&ns, &lw, &val, pdata, gain);
              again = 1;

              for (ikk=0;ikk<ns; ikk++)
                gain[ikk] = pdata[ikk]*gain[ikk];
            }

            if(depth == 8) {
              imagec = image_adjc;
              image_adjc += sp->pix_per_trace;
            }
            else if(depth == 15 || depth ==16 ) {
              images = image_adjs;
              image_adjs += sp->pix_per_trace;
            }
            else if(depth == 24 || depth ==32 ) {
              imagel = image_adjl;
              image_adjl += sp->pix_per_trace;
            }


            for (j=0; j < ns; j++) {
              if (again)
                the_color = get_color(gain[j]);
              else
                the_color = get_color(*pdata++);

              for(ip=0; ip< sp->pix_per_trace; ip++) {
                 if(depth == 8)
                   *(imagec+ip)=(unsigned char)the_color;
                 else if(depth == 15 || depth ==16 )
                   *(images+ip)=(unsigned short)the_color;
                 else if(depth == 24 || depth ==32 )
                   *(imagel+ip)=(unsigned int)the_color;
              }

              if(depth == 8) imagec += incr;
              else if(depth == 15 || depth ==16 ) images += incr;
              else if(depth == 24 || depth ==32 ) imagel += incr;

            }
          }
        }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
            incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 0, 0, 
            sp->can_bias_x-(sp->pix_per_trace)/2, sp->can_bias_y,
            incr, ns);

     break;  /*  End case 6 */

/**************************************************************************/
     case 4:
        /* max amp color vd */

        if(depth == 8) image_adjc = (unsigned char *)image;
        else if(depth == 15 || depth ==16 ) image_adjs = (unsigned short *)image;
        else if(depth == 24 || depth ==32 ) image_adjl = (unsigned int *)image;

        if(sp->agc && (sp->which == CDP || sp->which == MO)) {
          gain = (float *)calloc(ns, sizeof(float));
          if (gain == NULL) exit (-1);
        }

        for (i=0; i<sp->end_trace; i++) {
          pct = (int)((float)i * fct+0.5);

	  if (pct / 5 * 5 == pct) {
            if (pct != pct_prev) {
              XmScaleSetValue(ws, pct);
	      XFlush(XtDisplay(wb));
              pct_prev = pct;
            }
          }

          if (resamp) {
            pdata = tmp_data;

            if (sp->direction == LR) {
              hold = pdata1;
              pdata1 += sp->nss;
            }
            else
              hold = pdata1 + (sp->end_trace - (i + 1))*sp->nss;

            insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
          }
          else if (sp->direction == LR) {
            pdata = pdata1;
            pdata1 += sp->nss;
          }
          else
            pdata =  pdata1 + (sp->end_trace - (i + 1))*sp->nss;

          again = 0;

          if(sp->agc && (sp->which == CDP || sp->which == MO)) {
             doagc_(&ns, &lw, &val, pdata, gain);
             again = 1;
             for (ikk=0;ikk<ns; ikk++)
              gain[ikk] = pdata[ikk]*gain[ikk];
          }

          mb = sp->can_bias_y-1;
          mb_start = sp->can_bias_y;

          if(depth == 8) {
            imagec = image_adjc;
            image_adjc += sp->pix_per_trace;
            image_stc = imagec;
          }
          else if(depth == 15 || depth ==16 ) {
            images = image_adjs;
            image_adjs += sp->pix_per_trace;
            image_sts = images;
          }
          else if(depth == 24 || depth ==32 ) {
            imagel = image_adjl;
            image_adjl += sp->pix_per_trace;
            image_stl = imagel;
          }

          for (j=0; j < ns; j++) {
            if(again)
              xtemp = gain[j];
            else
              xtemp = *pdata++;

            mb++;

            if (xtemp < 0.) {

              if (nrbox > 0) {
                the_color = get_color( pamp);

                for (kk=mb_start; kk<mb; kk++) {

                  for(ip=0; ip< sp->pix_per_trace; ip++) {
                     if(depth == 8)
                       *(image_stc+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 )
                       *(image_sts+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 )
                       *(image_stl+ip)=(unsigned int)the_color;
                  }

                  if(depth == 8) image_stc += incr;
                  else if(depth == 15 || depth ==16 ) image_sts += incr;
                  else if(depth == 24 || depth ==32 ) image_stl += incr;

                }

                nrbox = 0;
                pamp = 0;
                mb_start = mb;

                if(depth == 8) image_stc = imagec;
                else if(depth == 15 || depth ==16 ) image_sts = images;
                else if(depth == 24 || depth ==32 ) image_stl = imagel;
              }

              if (xtemp < namp) namp = xtemp;
              nlbox++;
            }
            else if (xtemp > 0.) {
              if (nlbox > 0) {
                the_color = get_color( namp);

                for (kk=mb_start; kk<mb; kk++) {

                  for(ip=0; ip< sp->pix_per_trace; ip++) {
                     if(depth == 8)
                       *(image_stc+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 )
                       *(image_sts+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 )
                       *(image_stl+ip)=(unsigned int)the_color;
                  }

                  if(depth == 8) image_stc += incr;
                  else if(depth == 15 || depth ==16 ) image_sts += incr;
                  else if(depth == 24 || depth ==32 ) image_stl += incr;

                }

                namp = 0;
                nlbox = 0;
                mb_start = mb;

                if(depth == 8) image_stc = imagec;
                else if(depth == 15 || depth ==16 ) image_sts = images;
                else if(depth == 24 || depth ==32 ) image_stl = imagel;
              }

              if (xtemp > pamp) pamp = xtemp;
              nrbox ++;
            }
            else {
              if (nrbox > 0) {
                the_color = get_color( pamp);

                for (kk=mb_start; kk<mb; kk++) {

                  for(ip=0; ip< sp->pix_per_trace; ip++) {
                     if(depth == 8)
                       *(image_stc+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 )
                       *(image_sts+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 )
                       *(image_stl+ip)=(unsigned int)the_color;
                  }

                  if(depth == 8) image_stc += incr;
                  else if(depth == 15 || depth ==16 ) image_sts += incr;
                  else if(depth == 24 || depth ==32 ) image_stl += incr;

                }

                nrbox = 0;
                pamp = 0;
              }
              else if (nlbox > 0) {
                the_color = get_color( namp);

                for (kk=mb_start; kk<mb; kk++) {

                  for(ip=0; ip< sp->pix_per_trace; ip++) {
                     if(depth == 8)
                       *(image_stc+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 )
                       *(image_sts+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 )
                       *(image_stl+ip)=(unsigned int)the_color;
                  }

                  if(depth == 8) image_stc += incr;
                  else if(depth == 15 || depth ==16 ) image_sts += incr;
                  else if(depth == 24 || depth ==32 ) image_stl += incr;
                }

                namp = 0;
                nlbox = 0;
              }

              mb_start = mb + 1;

              if(depth == 8) image_stc = imagec+incr;
              else if(depth == 15 || depth ==16 ) image_sts = images+incr;
              else if(depth == 24 || depth ==32 ) image_stl = imagel+incr;

            }
            if(depth == 8) imagec+=incr;
            else if(depth == 15 || depth ==16 ) images+=incr;
            else if(depth == 24 || depth ==32 ) imagel+=incr;
          }

          if (nlbox > 0) {
            the_color = get_color( namp);

            for (kk=mb_start; kk<mb; kk++) {

               for(ip=0; ip< sp->pix_per_trace; ip++) {
                  if(depth == 8)
                    *(image_stc+ip)=(unsigned char)the_color;
                  else if(depth == 15 || depth ==16 )
                    *(image_sts+ip)=(unsigned short)the_color;
                  else if(depth == 24 || depth ==32 )
                    *(image_stl+ip)=(unsigned int)the_color;
               }

               if(depth == 8) image_stc += incr;
               else if(depth == 15 || depth ==16 ) image_sts += incr;
               else if(depth == 24 || depth ==32 ) image_stl += incr;

            }
            nlbox = 0;
          }
          else if (nrbox > 0) {
            the_color = get_color( pamp);

            for (kk=mb_start; kk<mb; kk++) {

               for(ip=0; ip< sp->pix_per_trace; ip++) {
                  if(depth == 8)
                    *(image_stc+ip)=(unsigned char)the_color;
                  else if(depth == 15 || depth ==16 )
                    *(image_sts+ip)=(unsigned short)the_color;
                  else if(depth == 24 || depth ==32 )
                    *(image_stl+ip)=(unsigned int)the_color;
               }

               if(depth == 8) image_stc += incr;
               else if(depth == 15 || depth ==16 ) image_sts += incr;
               else if(depth == 24 || depth ==32 ) image_stl += incr;

            }
            nrbox = 0;
          }
        }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
            incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 
            0, 0, sp->can_bias_x- sp->pix_per_trace/2, 
            sp->can_bias_y, incr, ns);

        break;    /*  End case 4  */

/**************************************************************************/
     case 5:
        /* max amp color vd */

        if(depth == 8) image_adjc = (unsigned char *)image;
        else if(depth == 15 || depth ==16 ) image_adjs = (unsigned short *)image;
        else if(depth == 24 || depth ==32 ) image_adjl = (unsigned int *)image;

        if(sp->agc && (sp->which == CDP || sp->which == MO)) {
          gain = (float *)calloc(ns, sizeof(float));
          if(gain == NULL) exit (-1);
        }

        for (i=0; i<sp->end_trace; i++) {
	   pct = (int)((float)i * fct+0.5);

	   if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	   }

           if (resamp) {
             pdata = tmp_data;
             if (sp->direction == LR) {
               hold = pdata1;
               pdata1 += sp->nss;
             }
             else
               hold = pdata1 + (sp->end_trace - (i + 1))*sp->nss;

             insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
           }
           else if (sp->direction == LR) {
             pdata = pdata1;
             pdata1 += sp->nss;
           }
           else
             pdata =  pdata1 + (sp->end_trace - (i + 1))*sp->nss;

           again = 0;

           if(sp->agc && (sp->which == CDP || sp->which == MO)) {
             doagc_(&ns, &lw, &val, pdata, gain);
             again = 1;
             for (ikk=0;ikk<ns; ikk++)
              gain[ikk] = pdata[ikk]*gain[ikk];
           }

           mb = sp->can_bias_y-1;
           mb_start = sp->can_bias_y;

           if(depth == 8) {
             imagec = image_adjc;
             image_adjc += sp->pix_per_trace;
             image_stc = imagec;
           }
           else if(depth == 15 || depth ==16 ) {
             images = image_adjs;
             image_adjs += sp->pix_per_trace;
             image_sts = images;
           }
           else if(depth == 24 || depth ==32 ) {
             imagel = image_adjl;
             image_adjl += sp->pix_per_trace;
             image_stl = imagel;
           }

           for (j=0; j < ns; j++) {
              if (again)
                xtemp = gain[j];
              else
                xtemp = *pdata++;

              mb++;

              if (xtemp < 0.) {
                if (nrbox > 0) {
                  the_color = get_color( pamp);

                  for (kk=mb_start; kk<mb; kk++) {

                     for(ip=0; ip< sp->pix_per_trace; ip++) {
                        if(depth == 8)
                          *(image_stc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_sts+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_stl+ip)=(unsigned int)the_color;
                     }

                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;

                  }
                  nrbox = 0;
                  pamp = 0;
                  mb_start = mb;

                  if(depth == 8) image_stc = imagec;
                  else if(depth == 15 || depth ==16 ) image_sts = images;
                  else if(depth == 24 || depth ==32 ) image_stl = imagel;
                }
                if (xtemp < namp) namp = xtemp;
                nlbox++;
              }
              else if (xtemp > 0.) {
                if (nlbox > 0) {
                  the_color = get_color( namp);

                  for (kk=mb_start; kk<mb; kk++) {

                     for(ip=0; ip< sp->pix_per_trace; ip++) {
                        if(depth == 8)
                          *(image_stc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_sts+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_stl+ip)=(unsigned int)the_color;
                     }
   
                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;
                  }

                  namp = 0;
                  nlbox = 0;
                  mb_start = mb;

                  if(depth == 8) image_stc = imagec;
                  else if(depth == 15 || depth ==16 ) image_sts = images;
                  else if(depth == 24 || depth ==32 ) image_stl = imagel;
                }
                if (xtemp > pamp) pamp = xtemp;
                nrbox ++;
              }
              else {
                if (nrbox > 0) {
                  the_color = get_color( pamp);

                  for (kk=mb_start; kk<mb; kk++) {

                     for(ip=0; ip< sp->pix_per_trace; ip++) {
                        if(depth == 8)
                          *(image_stc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_sts+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_stl+ip)=(unsigned int)the_color;
                     }
   
                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;
                  }
                  nrbox = 0;
                  pamp = 0;
                }
                else if (nlbox > 0) {
                  the_color = get_color( namp);

                  for (kk=mb_start; kk<mb; kk++) {

                     for(ip=0; ip< sp->pix_per_trace; ip++) {
                        if(depth == 8)
                          *(image_stc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_sts+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_stl+ip)=(unsigned int)the_color;
                     }
   
                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;
                  }
                  namp = 0;
                  nlbox = 0;
                }
                mb_start = mb + 1;

                if(depth == 8) image_stc = imagec+incr;
                else if(depth == 15 || depth ==16 ) image_sts = images+incr;
                else if(depth == 24 || depth ==32 ) image_stl = imagel+incr;
              }
              if(depth == 8) imagec+=incr;
              else if(depth == 15 || depth ==16 ) images+=incr;
              else if(depth == 24 || depth ==32 ) imagel+=incr;

            }

            if (nlbox > 0) {
              the_color = get_color( namp);
              for (kk=mb_start; kk<mb; kk++) {

                 for(ip=0; ip< sp->pix_per_trace; ip++) {
                    if(depth == 8)
                      *(image_stc+ip)=(unsigned char)the_color;
                    else if(depth == 15 || depth ==16 )
                      *(image_sts+ip)=(unsigned short)the_color;
                    else if(depth == 24 || depth ==32 )
                      *(image_stl+ip)=(unsigned int)the_color;
                 }
  
                 if(depth == 8) image_stc += incr;
                 else if(depth == 15 || depth ==16 ) image_sts += incr;
                 else if(depth == 24 || depth ==32 ) image_stl += incr;

              }
              nlbox = 0;
            }
            else if (nrbox > 0) {
              the_color = get_color( pamp);
              for (kk=mb_start; kk<mb; kk++) {

                 for(ip=0; ip< sp->pix_per_trace; ip++) {
                    if(depth == 8)
                      *(image_stc+ip)=(unsigned char)the_color;
                    else if(depth == 15 || depth ==16 )
                      *(image_sts+ip)=(unsigned short)the_color;
                    else if(depth == 24 || depth ==32 )
                      *(image_stl+ip)=(unsigned int)the_color;
                 }
  
                 if(depth == 8) image_stc += incr;
                 else if(depth == 15 || depth ==16 ) image_sts += incr;
                 else if(depth == 24 || depth ==32 ) image_stl += incr;

              }
              nrbox = 0;
            }
        }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
            incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 
            0, 0, sp->can_bias_x- sp->pix_per_trace/2, 
            sp->can_bias_y, incr, ns);

        break;    /*  End case 5 */

/**************************************************************************/
        case 1:
        /* std pos fill va */

        if(depth == 8) 
          image_adjc = (unsigned char *)(image+((int)(sp->pix_per_trace/2+0.5)*dpthrast));
        else if(depth == 15 || depth ==16 ) 
          image_adjs = (unsigned short *)(image+((int)(sp->pix_per_trace/2+0.5)*dpthrast));
        else if(depth == 24 || depth ==32 )
          image_adjl = (unsigned int *)(image+((int)(sp->pix_per_trace/2+0.5)*dpthrast));

        if(sp->agc && (sp->which == CDP || sp->which == MO)) {
          gain = (float *)calloc(ns, sizeof(float));
          if(gain == NULL) exit(-1);
        }

        if (!resamp) {
          for (i=0; i<sp->end_trace; i++) {
 	     pct = (int)((float)i * fct+0.5);

	     if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	     }

             if (sp->direction == LR) {
               pdata = pdata1;
               pdata1 += sp->nss;
             }
             else 
               pdata = pdata1 + (sp->end_trace - (i+1))*sp->nss;

             again = 0;

             if(sp->agc && (sp->which == CDP || sp->which == MO)) {
               doagc_(&ns, &lw, &val, pdata, gain);
               again = 1;

               for (ikk=0;ikk<ns; ikk++)
                  gain[ikk] *= pdata[ikk];

             }

/*....cmam..3-29-95..need this to do agc on data that is not
		scaled normally, i.e., raw 3D data, but it
		works for all data -- should have been this way
		originally to work on all data....*/

             if(again) {
	       maxv_(gain, &one, &gmax, &lgmax, &ns) ;
	       gcale = rcale/gmax;
             }

             if(depth == 8) {
               imagec = image_adjc;
               image_adjc += sp->pix_per_trace;
             }
             else if(depth == 15 || depth ==16 ) {
               images = image_adjs;
               image_adjs += sp->pix_per_trace;
             }
             else if(depth == 24 || depth ==32 ) {
               imagel = image_adjl;
               image_adjl += sp->pix_per_trace;
             }

             for (j=0; j < ns; j++) {
                if (again)
                  temp =  gain[j];
                else
                  temp =  *pdata++;

/*....previously set:      scale = rcale / sp->datamax;.......*/
/*....cmam...here we scale by the real data maximum to get a value
		between 0 and 1 to draw the black fill on positive
		loops of the wiggle traces...*/

                if (temp > 0) {
                  if(again)
		    temp *= gcale;
	          else
                    temp *= scale;

                  if (temp > 1.) temp = 1.;

                  for(ip=0; ip< ((int)(temp*tpix+0.5)+1); ip++) {
                     if(depth == 8) 
                       *(imagec+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 ) 
                       *(images+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 ) 
                       *(imagel+ip)=(unsigned int)the_color;
                  }
                }
                if(depth == 8) imagec += incr;
                else if(depth == 15 || depth ==16 ) images += incr;
                else if(depth == 24 || depth ==32 ) imagel += incr;
             }
          }
        }
        else {
          for (i=0; i<sp->end_trace; i++) {

	     pct = (int)((float)i * fct+0.5);
	     if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	     }

             pdata = tmp_data;
             if (sp->direction == LR) {
               hold = pdata1;
               pdata1 += sp->nss;
             }
             else
               hold = pdata1 + (sp->end_trace - (i+1))*sp->nss;

             insamp_(hold, &Lns, pdata, &ns, &delx, &initial);

             again = 0;

             if(sp->agc && (sp->which == CDP || sp->which == MO)) {
               doagc_(&ns, &lw, &val, pdata, gain);
               again = 1;
               for (ikk=0;ikk<ns; ikk++)
                  gain[ikk] *= pdata[ikk];
             }

/*....cmam..3-29-95..need this to do agc on data that is not
                scaled normally, i.e., raw 3D data, but it
                works for all data -- should have been this way
                originally to work on all data....*/

             if(again) {
               maxv_(gain, &one, &gmax, &lgmax, &ns) ;
               gcale = rcale/gmax;
             }

             if(depth == 8) {
               imagec = image_adjc;
               image_adjc += sp->pix_per_trace;
             }
             else if(depth == 15 || depth ==16 ) {
               images = image_adjs;
               image_adjs += sp->pix_per_trace;
             }
             else if(depth == 24 || depth ==32 ) {
               imagel = image_adjl;
               image_adjl += sp->pix_per_trace;
             }

             for (j=0; j < ns; j++) {
                if (again)
                  temp =  gain[j];
                else
                  temp =  *pdata++;

/*....cmam...here we scale by the real data maximum to get a value
                between 0 and 1 to draw the black fill on positive
                loops of the wiggle traces...*/

                if (temp > 0) {
                  if(again)
                    temp *= gcale;
                  else
                    temp *= scale;

                  if (temp > 1.) temp = 1.;

                  for(ip=0; ip<((int)(temp*tpix+0.5)+1); ip++) {
                     if(depth == 8) 
                       *(imagec+ip)=(unsigned char)the_color;
                     else if(depth == 15 || depth ==16 ) 
                       *(images+ip)=(unsigned short)the_color;
                     else if(depth == 24 || depth ==32 ) 
                       *(imagel+ip)=(unsigned int)the_color;
                  }
                }
                if(depth == 8) imagec += incr;
                else if(depth == 15 || depth ==16 ) images += incr;
                else if(depth == 24 || depth ==32 ) imagel += incr;
             }
          }
        }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
            incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 
            0, 0, sp->can_bias_x-(sp->pix_per_trace)/2, 
            sp->can_bias_y, incr, ns);

      break;    /*  End case 1  */

/**************************************************************************/
       
      case 2:
        /* max amp color va */

        pnum = &nump[0];
        pnum1 = pnum;

        if(depth == 8)
          image_adjc = (unsigned char*)(image + 
            ((int)(((sp->pix_per_trace/2)+sp->pix_per_trace*sp->maxovlp)*dpthrast)));
        else if(depth == 15 || depth ==16 )
          image_adjs = (unsigned short*)(image + 
            ((int)(((sp->pix_per_trace/2)+sp->pix_per_trace*sp->maxovlp)*dpthrast)));
        else if(depth == 24 || depth ==32 )
          image_adjl = (unsigned int*)(image + 
            ((int)(((sp->pix_per_trace/2)+sp->pix_per_trace*sp->maxovlp)*dpthrast)));


        if(sp->agc && (sp->which == CDP || sp->which == MO)) {
          gain = (float *)calloc(ns, sizeof(float));
          if(gain == NULL) exit(-1);
        }

        for (i=0; i<sp->end_trace; i++) {

	   pct = (int)((float)i * fct+0.5);
	   if (pct / 5 * 5 == pct) {
		if (pct != pct_prev) {
			XmScaleSetValue(ws, pct);
			XFlush(XtDisplay(wb));
			pct_prev = pct;
		}
	   }

           if (resamp) {
             pdata = tmp_data;
             if (sp->direction == LR) {
               hold = pdata1;
               pdata1 += sp->nss;
             }
             else
               hold = pdata1 + (sp->end_trace - (i+1))*sp->nss;

             insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
           }
           else if (sp->direction == LR) {
             pdata = pdata1;
             pdata1 += sp->nss;
           }
           else
             pdata = pdata1 + (sp->end_trace - (i+1))*sp->nss;

           again = 0;

           if(sp->agc && (sp->which == CDP || sp->which == MO)) {
             again=1;
             doagc_(&ns, &lw, &val, pdata, gain);
             for (ikk=0;ikk<ns; ikk++)
                gain[ikk] = pdata[ikk]*gain[ikk];
           }

           mb = sp->can_bias_y - 1;
           mb_start = sp->can_bias_y;

           if(depth == 8) {
             imagec = image_adjc;
             image_adjc += sp->pix_per_trace;
             image_stc = imagec;
           }
           else if(depth == 15 || depth ==16 ) {
             images = image_adjs;
             image_adjs += sp->pix_per_trace;
             image_sts = images;
           }
           else if(depth == 24 || depth ==32 ) {
             imagel = image_adjl;
             image_adjl += sp->pix_per_trace;
             image_stl = imagel;
           }

           pnum = pnum1;

           for (j=0; j < ns; j++) {
              if (again )
                xtemp = gain[j];
              else
                xtemp = *pdata++;

              temp = xtemp * scale;
              mb++;

              if (temp <= 0.) {
                if (nrbox > 0) {
                  the_color = get_color( pamp);

                  pnum = pnum1;
                  for (kk=mb_start; kk<mb; kk++) {

                     for(ip=0; ip< *pnum++; ip++) {
                        if(depth == 8)
                          *(image_stc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_sts+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_stl+ip)=(unsigned int)the_color;
                     }

                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;

                  }
                  nrbox = 0;
                  pamp = 0;
                  mb_start = mb;

                  if(depth == 8) image_stc = imagec;
                  else if(depth == 15 || depth ==16 ) image_sts = images;
                  else if(depth == 24 || depth ==32 ) image_stl = imagel;

                  pnum = pnum1;
                }

                if (temp < -1.) temp = -1;
                *pnum++ = 1 -(int)(temp * tpix);
                if (xtemp < namp) namp = xtemp;
                nlbox++;
              }
              else {
                if (nlbox > 0) {
                  the_color = get_color( namp);

                  pnum = pnum1;
                  for (kk=mb_start; kk<mb; kk++) {

                     if(depth == 8) image_backc =image_stc-(*pnum-1);
                     else if(depth == 15 || depth ==16 ) image_backs=image_sts-(*pnum-1); 
                     else if(depth == 24 || depth ==32 ) image_backl=image_stl-(*pnum-1);

                     for(ip=0; ip< *pnum++; ip++) {
                        if(depth == 8)
                          *(image_backc+ip)=(unsigned char)the_color;
                        else if(depth == 15 || depth ==16 )
                          *(image_backs+ip)=(unsigned short)the_color;
                        else if(depth == 24 || depth ==32 )
                          *(image_backl+ip)=(unsigned int)the_color;
                     }

                     if(depth == 8) image_stc += incr;
                     else if(depth == 15 || depth ==16 ) image_sts += incr;
                     else if(depth == 24 || depth ==32 ) image_stl += incr;

                  }
                  nlbox = 0;
                  namp = 0;
                  mb_start = mb;

                  if(depth == 8) image_stc = imagec;
                  else if(depth == 15 || depth ==16 ) image_sts = images;
                  else if(depth == 24 || depth ==32 ) image_stl = imagel;

                  pnum = pnum1;
                }

                if (temp > 1.) temp = 1.;
                *pnum++ = (int)(temp * tpix+0.5) + 1;
                if (xtemp > pamp) pamp = xtemp;
                nrbox ++;
              }
              if(depth == 8) image_stc += incr;
              else if(depth == 15 || depth ==16 ) image_sts += incr;
              else if(depth == 24 || depth ==32 ) image_stl += incr;
           }

           if (nlbox > 0) {
             the_color = get_color( namp);
             pnum = pnum1;

             for (kk=mb_start; kk<mb; kk++) {

                if(depth == 8) image_backc =image_stc-(*pnum-1);
                else if(depth == 15 || depth ==16 ) image_backs=image_sts-(*pnum-1); 
                else if(depth == 24 || depth ==32 ) image_backl=image_stl-(*pnum-1);

                for(ip=0; ip< *pnum++; ip++) {
                   if(depth == 8)
                     *(image_backc+ip)=(unsigned char)the_color;
                   else if(depth == 15 || depth ==16 )
                     *(image_backs+ip)=(unsigned short)the_color;
                   else if(depth == 24 || depth ==32 )
                     *(image_backl+ip)=(unsigned int)the_color;
                }

                if(depth == 8) image_stc += incr;
                else if(depth == 15 || depth ==16 ) image_sts += incr;
                else if(depth == 24 || depth ==32 ) image_stl += incr;
             }
             nlbox = 0;
           }
           else if (nrbox > 0) {
             the_color = get_color( pamp);
             pnum = pnum1;

             for (kk=mb_start; kk<mb; kk++) {

                for(ip=0; ip< *pnum++; ip++) {
                   if(depth == 8)
                     *(image_stc+ip)=(unsigned char)the_color;
                   else if(depth == 15 || depth ==16 )
                     *(image_sts+ip)=(unsigned short)the_color;
                   else if(depth == 24 || depth ==32 )
                     *(image_stl+ip)=(unsigned int)the_color;
                }

                if(depth == 8) image_stc += incr;
                else if(depth == 15 || depth ==16 ) image_sts += incr;
                else if(depth == 24 || depth ==32 ) image_stl += incr;
 
             }
             nrbox = 0;
           }
        }

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    images = (unsigned short *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmps = (unsigned short) CONVERT2(*(images+i));
	      *(images+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    imagel = (unsigned int *)image;
	    for (i=0; i<ns*incr; i++) {
	      tmpl = (unsigned int) CONVERT4(*(imagel+i));
	      *(imagel+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(sp->dpy, visual, depth, ZPixmap, 0, image,
            incr, ns, quantum, 0);

        XPutImage(sp->dpy, sp->pixmap, gc, local_image, 
            0, 0,
            sp->can_bias_x-(sp->pix_per_trace)/2 - sp->pix_per_trace * sp->maxovlp, 
            sp->can_bias_y, incr, ns);
      
      break;   /*  End case 2  */

/**************************************************************************/
     case 3:
      break;

/**************************************************************************/
     default:
         fprintf(stderr, "Unknown display type %d\n",sp->display_type);
         return;
    }
/* end of switch */

    WIGGLE:

    memset (&sc[1], '\0', 1);

    rec_no = 0;
    rec_compare = sp->ntr;

    if (sp->ntr == 1) rec_compare = 5;
    if (sp->traces_per_inch > 48) rec_compare = 10;

    for (i=0; i<sp->end_trace; i+=sp->ntr) {
       sprintf(cchron, "%d", sp->irec_buf[rec_no]);

       lenr = strlen(cchron);
       mb = 5 * num_font.height - ((lenr-1) * num_font.height);

       if (sp->direction == LR)
         ipos = i * sp->pix_per_trace + sp->can_bias_x;
       else
         ipos = sp->pixwidth - sp->can_bias_x - 
                2 * (sp->pix_per_trace) - i * sp->pix_per_trace;

       for (g = 0; g < lenr; g++) {
          strncpy(sc, cchron + g, 1);
          XDrawString(sp->dpy, sp->pixmap, gc, ipos, mb, sc, strlen(sc));
          mb += num_font.height;
       }
       rec_no++;
    }

    if(need_wiggle) {
      pdata1 = &(sp->data)[0];
      pdata1 += tbias;
      ipos = (sp->can_bias_x) - (sp->pix_per_trace);

      gcvals.line_width = sp->linew;
      XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);

      if (sp->display_type == 3 && sp->file_flag != 1) {
		fct = 100. / (float)sp->end_trace;
		addon = 0;
      }
      else {
		fct = 50. / (float)sp->end_trace;
		addon = 50;
      }

      pct_prev=0;
      for (i=0; i<sp->end_trace; i++) {
	 pct = (int)((float)i * fct+0.5);

         if(pct > 100)pct = 100;

	 if (pct / 5 * 5 == pct) {
		pct += addon;
		if (pct != pct_prev && wb) {
			XmScaleSetValue(ws, pct);
			pct_prev = pct;
		}
	 }

         if (resamp) {
           pdata = tmp_data;
           if (sp->direction == LR) {
             hold = pdata1;
             pdata1 += sp->nss;
           }
           else
             hold = pdata1 + (sp->end_trace - (i+1))*sp->nss;
           insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
         }
         else if (sp->direction == LR) {
           pdata = pdata1;
           pdata1 += sp->nss;
         }
         else
           pdata = pdata1 + (sp->end_trace - (i+1))*sp->nss;

         ipos += (sp->pix_per_trace);
         mb = sp->can_bias_y;
 
         again = 0;

         if(sp->agc && (sp->which == CDP || sp->which == MO)) {
           doagc_(&ns, &lw, &val, pdata, gain);
           again = 1;

           for (ikk=0;ikk<ns; ikk++)
             gain[ikk] *= pdata[ikk];
         }

/*....cmam..3-29-95..need this to do agc on data that is not
                scaled normally, i.e., raw 3D data, but it
                works for all data -- should have been this way
                originally to work on all data....*/

         if(again) {
           maxv_(gain, &one, &gmax, &lgmax, &ns) ;
           /*gcale = rcale/gmax;*/

	   if(gmax == 0.0) {
	       gcale = 0.0;
	   } 
           else {
	     gcale = rcale/gmax;
	   }
         }

         /* only need to draw the wiggle */
         for (j=0; j < ns; j++){
           if (again)
             temp = gain[j] * gcale;
             /*temp = gain[j] * scale;*/
           else
             temp = *pdata++ * scale;

             if (temp > 1.) temp = 1.;
             else if (temp < -1.) temp = -1;

             npoints[j].x = (int)(temp * tpix+0.5) + ipos;
             npoints[j].y = mb++;
         }

         XDrawLines(sp->dpy, sp->pixmap, gc, 
                         npoints, ns, CoordModeOrigin);
      }
      XmScaleSetValue(ws, 100);
      XFlush(XtDisplay(wb));
    }

    gcvals.line_width = 0;
    XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);

    the_color = colorcell.pixel;
    XSetForeground(sp->dpy, gc, the_color);

    ipos1 = sp->can_bias_x - (sp->pix_per_trace);
    ipos  = sp->can_bias_x + sp->end_trace * sp->pix_per_trace;

    /* draw timing lines */

    ma = (sp->can_bias_y);
    mb = (sp->can_bias_y) + dincr * ndraw;

    if (mb > sp->can_hi -(sp->can_bias_yb)) mb = sp->can_hi-(sp->can_bias_yb);

    gcvals.line_width = 2;

    XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);

/* **  Draw the vertical lines */
    XDrawLine(sp->dpy, sp->pixmap, gc, ipos1, ma, ipos1, mb);;
    XDrawLine(sp->dpy, sp->pixmap, gc, ipos , ma, ipos, mb);

    gcvals.line_width = 0;
    XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);

    time = (int)sp->ts/100;
    if ((sp->ts/100*100) == sp->ts ) time --;

    time /= 10.;
    for (i=0; i<ndraw; i++) {
       mb = time_offset + i*dincr;
       mb += sp->can_bias_y;
       if (mb > sp->can_hi-(sp->can_bias_yb)) break;

       XDrawLine(sp->dpy, sp->pixmap, gc, ipos1-11, mb, ipos1, mb);
       XDrawLine(sp->dpy, sp->pixmap, gc, ipos, mb, ipos + 11, mb);

       sec = (float)(i+1) / 10.;
       sec += time;
       sprintf(cchron,"%5.3f", sec); 

       k = mb + num_font.height/3;
       XDrawString(sp->dpy, sp->pixmap, gc, ipos + 14, k,
                  cchron, strlen(cchron));

       jpos = (ipos1 - 13) - strlen(cchron) * num_font.width;
       if (jpos < 0) jpos = 0;
       XDrawString(sp->dpy, sp->pixmap, gc, jpos, k, cchron, strlen(cchron));

       isec = (int)(sec * 1000.+0.5);

       if(!about(isec, &psint, &isec) || isec == 0) {
         gcvals.line_width = 3;
         XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);
         XDrawLine(sp->dpy, sp->pixmap, gc, ipos,
                 mb, (sp->can_bias_x - sp->pix_per_trace), mb);
         gcvals.line_width = 0;
              XChangeGC(sp->dpy, gc, GCLineWidth, &gcvals);
       }
       else {
         gcvals.line_width = 1;
         gcvals.line_style = LineOnOffDash;
         XChangeGC(sp->dpy, gc, GCLineWidth|GCLineStyle, &gcvals);
         XDrawLine(sp->dpy, sp->pixmap, gc, ipos,
                         mb, (sp->can_bias_x - sp->pix_per_trace), mb);

         gcvals.line_style = LineSolid;
         gcvals.line_width = 0;
         XChangeGC(sp->dpy, gc, GCLineWidth|GCLineStyle, &gcvals);
       }
    }

    XCopyArea(sp->dpy, sp->pixmap, sp->backup,  gc, 
        0, 0, sp->pixwidth, sp->can_hi, 0, 0);

    XFreeGC(sp->dpy, gc);
    if (sp->display_type != 3 && image != NULL) {
      free(image);
      image = NULL;
    }

    if (resamp) {
      if (tmp_data != NULL) {
        free(tmp_data);
        tmp_data = NULL;
      }
    }

    initial = 2;
    if(delx != 1.0) {
       insamp_(hold, &Lns, pdata, &ns, &delx, &initial);
    }

    if(wb) XtUnmanageChild(wb);

    free(cchron);
    free(nump);
    free(npoints);

    if(sp->agc && sp->display_type == 1 && (sp->which == CDP || sp->which == MO))
      free(gain);
}
