/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xos.h"
#include "globals.h"
/*....do not need this---now in xos.h....mam...*/
/* #include <malloc.h> */
/*..............9-26-94........................*/
/*
** Read an SIS dataset into memory at seisplot structure data pointer
*/
#ifdef hpux
#define vmov_ vmov
#define imaxv_ imaxv
#define iminv_ iminv
#endif
#ifdef CRAY
#define vmov_ VMOV
#define imaxv_ IMAXV
#define iminv_ IMINV
#endif

int get_data(sp)
Seisplot *sp ;
{
   extern void update_message() ;

   int   i, j, k, luin, nbytes, nread=0 ;
   int  tp;
   int   irec, itrc, iround ;
/*.....mam....9-26-94...for std pick file output....*/
	int ktrc, kvel;
	int kread;
/*..................................................*/
   int   nwords, one=1, count ;
   int   lineheader[6000] ;
   int   iread, lcmax, lcmin ;
   int   istat, izero;
   int   nr,slow;
    int ikk;

   float   *ifp, *rtr, sum, osum ;
   float   cmax, cmin, max, min ;
   float   vv1, vv2, zero;

   Arg args[2];

   char    string[255] ;

   XtSetSensitive (apmo_button, False) ;
   done_moveout = 0;
   izero = 0;  zero = 0.0;
   C_LBOPEN(&luin, sp->file, "r");
   if (luin == -1) {
      sprintf(string, "Could not open sis file: %s", sp->file);
      update_message (string) ;
      return (nread) ;
   }

   nbytes = 0;
   C_RTAPE(luin, lineheader, &nbytes);
   if (nbytes == 0) {
      printf(string, "Error reading input line header");
      update_message (string) ;
      C_LBCLOS(luin) ;
      return (nread) ;
   }

   C_SAVER(lineheader, "NumSmp", &(sp->nss), LINHED);
   C_SAVER(lineheader, "NumTrc", &(sp->ntr), LINHED);
   C_SAVER(lineheader, "SmpInt", &(sp->smpint), LINHED);
   C_SAVER(lineheader, "NumRec", &nr, LINHED);

   if (sp->which == TP) {
      /* special stuff that VSGEN and OPST use */
      C_SAVER(lineheader, "MnLnIn", &smode, LINHED) ;
      smode = abs(smode);
      if (smode == 0 || smode == 4) {
         C_SAVER(lineheader, "ILClIn", &vv1, LINHED) ;
         C_SAVER(lineheader, "CLClIn", &vv2, LINHED) ;
         v0 = vv1;
         vinc = vv2;
      }
      else if (smode == 1) {
         C_SAVER(lineheader, "ILClIn", &vv1, LINHED) ;
         C_SAVER(lineheader, "CLClIn", &vv2, LINHED) ;
         s0 = vv1;
         dels = vv2;
      }
      else  if (smode == 2) {
         C_SAVER(lineheader, "MutVel", &v1,   LINHED) ;
         v1 = fabs(v1);
         v1 *= 0.001 ;
      }
      else {
         C_SAVER(lineheader, "MxLnIn", &tofe, LINHED);
         tofe = sp->smpint;
      }
   }

   sp->ntrace = (sp->end_rec - sp->st_rec + 1)*sp->ntr;

   rtr = (float *) malloc ((sp->nss+ITRWRD) * sizeof(float)) ;
   if (rtr == NULL ) {
      sprintf(string,
              "Could not allocate enough memory for temp trace buffer");
      update_message (string) ;
      C_LBCLOS(luin);
      return (0) ;
   }

   nwords = sp->ntrace * sp->nss;
   if (sp->data)
    free(sp->data);
   sp->data = (float *) malloc(nwords * sizeof(float));
   if (sp->data == NULL ) {
      sprintf(string,
              "Could not allocate enough memory for %s",sp->file);
      update_message (string) ;
      free (rtr) ;
      C_LBCLOS(luin);
      return (0) ;
   }

   if (sp->which == CDP) {
      nwords = sp->ntrace * sp->nss;
      if(seisplot[MO].data) free(seisplot[MO].data);
      seisplot[MO].data=(float *)malloc(nwords*sizeof(float));
      if (seisplot[MO].data == NULL ) {
         sprintf(string,
      "Could not allocate enough memory for moveout correction. \nThe option will be disabled");
         update_message (string) ;
         allow_moveout = False;
      }
      if (sp->xoffset)
         free(sp->xoffset);
      sp->xoffset =(int *) malloc(sp->ntrace * sizeof(int)) ;
      if(sp->xoffset == NULL) exit(-1);
      if (sp->slowbuf) 
         free(sp->slowbuf);
      sp->slowbuf =(float *)malloc(sp->ntrace * sizeof(float));
      if(sp->slowbuf == NULL) exit(-1);
   }
   else if (smode == 0 || smode == 1 || smode == 4) {
       if (sp->vbuf) 
           free(sp->vbuf);
       sp->vbuf = (int *)malloc(sp->ntr*sizeof(int));
      if(sp->vbuf == NULL) exit(-1);
   }
   else if (smode == 2 || smode == 3) {
      /* when smode 2, tpbuf is a tp value */
      /* when smode 3, tpbuf is a velocity value */
      if (sp->tpbuf)
         free(sp->tpbuf);
      sp->tpbuf = (int *) malloc(sp->ntr*sizeof(int)) ;
      if(sp->tpbuf == NULL) exit(-1);
   }

    
/*.........mam........9-26-94....for std pick file output.....*/
	if(sp->which == TP) {
		kread = 1;
	}
	else
		kread = 0;
/*............................................................*/
   iread = 0;
   ifp = sp->data ;
   while(!iread) {
      nbytes = 0;
      C_RTAPE(luin, rtr, &nbytes);
      if(!nbytes) {
         sprintf(string, "Could not find start record %d", sp->rec_st);
         update_message (string) ;
         C_LBCLOS(luin);
         free (rtr) ;
         return (nread) ;
      }
      C_SAVER(rtr,"RecNum", &irec, TRCHED);
      if (irec == sp->rec_st)
         iread = 1;
      else if (irec > sp->rec_st) {
         sprintf(string, "First record %d greater than start record %d",
                         irec, sp->rec_st);
         update_message (string) ;
         C_LBCLOS(luin);
         free (rtr) ;
         return (nread) ;
      } 
   }

   osum = 0;
   cmax = -1.0e22;
   max = -1.0e22;
   cmin =  1.0e23;
   min =  1.0e23;
   k = 0;

   for (j = 0; j < sp->ntrace; j++) {
      if(!iread) {
         nbytes = 0;
         C_RTAPE(luin, rtr, &nbytes);
      }
      iread = 0;
      if(nbytes == 0) {
       sprintf(string,"Read error after Record: %d Trace: %d",irec,itrc);
       update_message (string) ;
       C_LBCLOS(luin);
       free(rtr) ;
       return (nread) ;
      }

      C_SAVER(rtr,"TrcNum", &itrc, TRCHED);
      if (itrc == 1 || !(j % sp->ntr)) {
         C_SAVER(rtr,"RecNum", &irec, TRCHED);
         k++;
      }

/*......mam.......9-26-94.....for std pick file output........*/
        if(kread) {
               /*  C_SAVER(rtr,"TrcNum", &ktrc, TRCHED); */
                C_SAVER(rtr,"DstSgn", &kvel, TRCHED);
                C_SAVER(rtr,"RecNum", &irec, TRCHED);
                if(kread == 1) {
                  sp->recunit = 1.;
                  sp->trcunit = 1.;
                  sp->smpunit = (float)sp->smpint;
                  sp->recoff = (float)(irec - 1);
                  sp->trcoff = (float)(kvel - 1);
                  sp->smpoff = -(sp->smpunit);
		  kread = 2;
                }
                else if (kread == 2) {
                  sp->trcunit = kvel +1 - (sp->trcoff);
                  kread = 0;
                }
        }
/*............................................................*/

      if (sp->which == CDP) {
         C_SAVER(rtr,"DstUsg", &slow, TRCHED) ;
         (sp->slowbuf)[j] = (float)slow*.0000001;
         C_SAVER(rtr,"DstSgn", &((sp->xoffset)[j]), TRCHED) ;
         (sp->xoffset)[j] = ((sp->xoffset)[j]>=0) ?
                               (sp->xoffset)[j] : -((sp->xoffset)[j]) ;
         /* (sp->xoffset)[j] = (slow>=0) ?
                               slow : -(slow) ; */
      }
      else if (sp->which == TP && irec == sp->rec_st &&
               (smode == 0 || smode == 1 || smode == 4)) {
          C_SAVER(rtr,"DstSgn", &((sp->vbuf)[j]), TRCHED);
      }
      else if (sp->which == TP && irec == sp->rec_st &&
                             (smode == 2 || smode == 3)) {
         C_SAVER(rtr,"RcPtXC", &tp, TRCHED) ;
         sp->tpbuf[j] = (int)tp;
      }

      C_SAVER(rtr,"StaCor", &istat, TRCHED);
      if (istat < 30000)
      vmov_(rtr+ITRWRD, &one, ifp, &one, &(sp->nss)) ;
      else
       vmov_(&zero, &izero, ifp, &one, &(sp->nss));
      maxv_(ifp, &one, &cmax, &lcmax, &(sp->nss)) ;
      minv_(ifp, &one, &cmin, &lcmin, &(sp->nss)) ;
      if (cmax > max) max = cmax ;
      if (cmin < min) min = cmin ;
      svemg_(ifp, &one, &sum, &(sp->nss)) ;
      sum = sum/sp->nss ;
      if (sum > osum) osum = sum ;

      nread++ ;
      ifp += sp->nss ;
   }
   sp->irec_ctr = k;

   C_LBCLOS(luin);
   free (rtr) ;

   sp->avg_abs = osum ;
   sp->datamin = min ;
   sp->datamax = max ;

   return (nread) ;
}
/*
** Draw a string centered in the odometer drawing area, Note ---->
** a drawing area seems to be faster than a label widget for this purpose
*/

void update_odometer (string)
char *string ;
{
   Arg args[2] ;
   Dimension width, height ;
   int x, y ;

   /* assumes 9x15 font is loaded in gc_odometer.font */
   XtSetArg (args[0], XmNwidth, &width) ;
   XtSetArg (args[1], XmNheight, &height) ;
   XtGetValues ( odometer, args, 2) ;
   /*x = (width - (9 * strlen(string))) / 2 ;
   y = height - ((height - 11) / 2) ;*/
/*...warning : use explicit cast...*/
   x = ((int)width - (9 * strlen(string))) / 2 ;
   y = (int)height - (((int)height - 11) / 2) ;
   XClearWindow (display, XtWindow(odometer)) ;
   XDrawString (display, XtWindow(odometer), gc_odometer,
               x, y, string, strlen(string)) ;
}
/*
** Pass a string to the message widget for display
*/

void update_message (string)
char *string ;
{
   Arg args[1] ;
   XmString xmstring ;

   xmstring = XmStringCreateLtoR (string, XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[0], XmNlabelString, xmstring) ;
   XtSetValues (message, args, 1) ;
   XmUpdateDisplay (message) ;
   XmStringFree (xmstring) ;
}
/*
** Restore default message based of digitizing mode
*/

void clear_message ()
{
   extern void update_message () ;

   if (digmode == NEW)
      update_message ("Button  1: Pick   2: Undo   3: Accept") ;
   else if (digmode == EDIT)
      update_message ("Button  1: Add Pick  2: Delete Pick") ;
   else if (digmode == MOVE)
      update_message ("Button  1:Grab   2: Cancel   3: Pick") ;
}

/*
** Restore default message after incompatible pik format message
*/
 
XtCallbackProc clear_pik_msgCB(w, flag, call)
Widget w;
int  *flag;
caddr_t call;
{
   extern void clear_message () ;
 
      clear_message() ;
}

/*
** Change the value resource in a text widget
*/

void update_text (w, string)
Widget w ;
String string ;
{
   Arg args[1] ;
   XtSetArg (args[0], XmNvalue, string) ;
   XtSetValues (w, args, 1) ;
}
/*
** Free a single Digrec structure and its associated
** linear-linked-list of Digits structures
*/

void free_digrec (head)
Digrec *head ;
{
   extern void free_digits() ;

   if (head) {
      if(head->digits) {
	free_digits (head->digits) ;
      }
      free (head) ;
   }
}
/*
** Free a single Velrec structure and its associated
** linear-linked-list of Velits structures
*/

void free_velrec (head)
Velrec *head ;
{
   extern void free_velits() ;

   if (head) {
      if(head->next) {
	free_velits (head->velits) ;
      }
      free (head) ;
   }
}
/*
** Recursive algorithm to free a linear-linked-list of Digrec structures
** and their associated linear-linked-list of Digits structures
*/

void free_all_digrec (head)
Digrec *head ;
{
   extern void free_digrec() ;

   if (head) {
      if(head->next) {
	free_all_digrec (head->next) ;
       }
      free_digrec (head) ;
   }
}
/*
** Recursive algorithm to free a linear-linked-list of Velrec
** structures and their associated linear-linked-list of Velits 
** structures
*/

void free_all_velrec (head)
Velrec *head ;
{
   extern void free_velrec() ;

   if (head) {
      if(head->next) {
	free_all_velrec (head->next) ;
      }
      free_velrec (head) ;
   }
}
/*
** Recursive algorithm to free a linear-linked-list of Digits structures
*/

void free_digits (head)
Digits *head ;
{
   if (head) {
      if(head->next) {
	free_digits (head->next) ;
      }
      free (head) ;
   }
}
/*
** Recursive algorithm to free a linear-linked-list of Velits 
** structures
*/

void free_velits (head)
Velits *head ;
{
   if (head) {
      if(head->next) {
	free_velits (head->next) ;
      }
      free (head) ;
   }
}
/*
** Manage the pick file selection box contingent upon read/write mode setting
*/

XtCallbackProc manage_pickbbCB(w, flag, call)
Widget w;
int  *flag;
caddr_t call;
{
   if (*flag)
      XtManageChild (pickbb) ;
}
/*
** Set Global variable for pick read/write mode
*/

XtCallbackProc set_pick_flagCB(w, client, call)
Widget w;
int  client;
caddr_t call;
{
   rw_picks = client ;
}
/*
** Enable sequencing of callbacks via arm_falseCB and active_trueCB
*/

XtCallbackProc arm_falseCB(w, flag, call)
Widget w;
int  *flag;
caddr_t call;
{
   *flag = FALSE ;
}
/*
** Enable sequencing of callbacks via arm_falseCB and active_trueCB
*/

XtCallbackProc active_trueCB(w, flag, call)
Widget w;
int  *flag;
caddr_t call;
{
   *flag = TRUE ;
}
/*
** Convert y coordinate to seismic data sample number
*/

int converty(sp, y)
Seisplot *sp ;
int  y;
{
   return ((int)((float)y-(float)sp->yorg)/sp->pix_per_sample);
}
/*
** Convert x coordinate to seismic record and trace number
*/

void convertx(sp, x, rec, tr)
Seisplot *sp ;
int  x, *rec, *tr;
{
   int val1, val2, val3;

   x -= sp->xorg;
   val1 = x /sp->pix_per_trace + 1;
   if (val1 == 0) val1 = 1;
   val2 = val1 % sp->ntr;
   if (val2 == 0) val2 = sp->ntr;
   val3 = val1/sp->ntr + 1;
   if(val2 == sp->ntr) val3 -= 1;
   val3 = val3-1 + sp->st_rec;

   (*rec) = val3;
   (*tr)  = val2;
}
/*
** Convert xy coordinate to record and trace number, sample number, and time
*/

void xy2rts(sp, x, y, rec, trc, ntrcs, time, isamp, rsamp)
Seisplot *sp ;
int  x, y, *rec, *trc, *ntrcs, *time, *isamp, *rsamp;
{
   extern void convertx() ;
   extern int  converty() ;

   convertx(sp, x, rec, trc);
   *ntrcs = (*rec - sp->st_rec) * sp->ntr + *trc;
   *rsamp = converty(sp, y);
   *isamp = *rsamp * sp->pix_per_sample ;
   *time = *rsamp * sp->smpint;
}
/*
** Restore backup seismic picture to area encompassing NMO hyperbola
*/

void clear_hyperbola(sp)
Seisplot *sp ;  /* CDP */
{
   int         xmin, xmax, ymin, ymax, el, stride=2 ;

   if (sp->hyperbola) {
      imaxv_(sp->hyperbola, &stride, &xmax, &el, &(sp->ntr));
      iminv_(sp->hyperbola, &stride, &xmin, &el, &(sp->ntr));
      imaxv_((sp->hyperbola)+1, &stride, &ymax, &el, &(sp->ntr));
      iminv_((sp->hyperbola)+1, &stride, &ymin, &el, &(sp->ntr));
      XCopyArea (display, sp->pixmap, sp->window, gc,
                 xmin, ymin, xmax-xmin+1, ymax-ymin+1, xmin, ymin) ;
      free((char *) sp->hyperbola) ;
      sp->hyperbola = NULL ;
   }
}
/*
** XOR a line into the given window
*/

void rubber_band_man (window, x1, y1, x2, y2)
Window  window ;
int     x1, y1, x2, y2 ;
{
   XDrawLine (display, window, gc_rubber, x1, y1, x2, y2) ;
}
/*
** Set odometer key
*/

XtCallbackProc set_pick_formatCB(w, flag, call)
Widget w;
int  flag;
caddr_t call;
{
       pick_format = flag;
}

/*
**  Write nvel time, velocity pairs for record rec to
**  fout in TDFN format
*/
void
wr_tdfn (vel, time, nvel, rec, fout)
float *vel;
int *time, nvel, rec;
FILE *fout;
{
    float *v;
    int i, j, k, *t;
    int rm, nst, ndo, end, first;
    char *card, *label, string[255];

    card = (char *)calloc(81, sizeof(char));
    label = (char *)calloc(15, sizeof(char));

    v = vel;  t = time;
    ndo = nvel/7; rm = nvel - ndo*7;
    if (ndo > 9 || (ndo >= 9 && rm > 0)) {
       sprintf(string,
       "Can't handle %d v/t pairs in TDFN format\nSkipping record %d",
         nvel, rec);
         update_message (string) ;
         return;
    }
    if (ndo > 0 ) {
        nst = -7; j = 0;
        for (i = 0; i < ndo; i++) {
            memset(card, ' ', 80);
            j++;
            sprintf(label,"%dTDFN", j);
            memcpy(card, label, 5);
            if (rm == 0 && i == ndo - 1)
              sprintf(card,"9TDFN");
            nst += 7;
            end = nst + 6; first = -4;
            for (k = nst; k <= end; k++) {
                sprintf(label,"%4d%5d", t[k], (int)(vel[k] + .5));
                first = first + 9;
                memcpy(card+first, label, 9);
            }
            sprintf(label,"       %5d", rec);
            memcpy(card+68,label,12);
            memset(card+80, '\0', 1);
            fprintf(fout,"%s\n", card);
        }
    }
    if(rm > 0) {
        memset(card, ' ', 80);
        nst = nvel - rm; j = 0;  first = -4;
        sprintf(card,"9TDFN");
        for (k = nst; k < nvel; k ++) {
            sprintf(label,"%4d%5d", t[k], (int)(v[k] + .5));
            first += 9;
            memcpy(card+first, label, 9);
        }
        sprintf(label,"       %5d", rec);
        memcpy(card+68,label,12);
        memset(card+80, '\0', 1);
        fprintf(fout, "%s\n", card);
    }
    free(label);
    free(card);
}
/*
**  Write nvel time, velocity pairs for record rec to
**  fout in vi3d format
*/
void
wr_vi3d (vel, time, nvel, rec, fout, li, di)
/*..wr_vi3d (vel, time, nvel, rec, fout)..*/
float *vel;
int *time, nvel, rec;
FILE *fout;
int li, di;
{
    float *v;
    int i, j, k, *t;
    int rm, nst, ndo, end, first;
    char *card, *label, string[255];
 
    card = (char *)calloc(81, sizeof(char));
    label = (char *)calloc(15, sizeof(char));
 
    v = vel;  t = time;
    ndo = nvel/7; rm = nvel - ndo*7;
    if (ndo > 9 || (ndo >= 9 && rm > 0)) {
       sprintf(string,
       "Can't handle %d v/t pairs in TDFN format\nSkipping record %d",
         nvel, rec);
         update_message (string) ;
         return;
    }

/*..cmam...write the 0TDFN card out..*/
            memset(card, ' ', 80);
            sprintf(label,"0TDFN");
            memcpy(card, label, 5);
            nst += 5;
            sprintf(label,"%5d%5d", li, di);
            memcpy(card+5, label, 10);
            memset(card+80, '\0', 1);
            fprintf(fout,"%s\n", card);
/*....rest is like for regular TDFN format...*/

    if (ndo > 0 ) {
        nst = -7; j = 0;
        for (i = 0; i < ndo; i++) {
            memset(card, ' ', 80);
            j++;
            sprintf(label,"%dTDFN", j);
            memcpy(card, label, 5);
            if (rm == 0 && i == ndo - 1)
              sprintf(card,"9TDFN");
            nst += 7;
            end = nst + 6; first = -4;
            for (k = nst; k <= end; k++) {
                sprintf(label,"%4d%5d", t[k], (int)(vel[k] + .5));
                first = first + 9;
                memcpy(card+first, label, 9);
            }
            sprintf(label,"       %5d", rec);
            memcpy(card+68,label,12);
            memset(card+80, '\0', 1);
            fprintf(fout,"%s\n", card);
        }
    }
    if(rm > 0) {
        memset(card, ' ', 80);
        nst = nvel - rm; j = 0;  first = -4;
        sprintf(card,"9TDFN");
        for (k = nst; k < nvel; k ++) {
            sprintf(label,"%4d%5d", t[k], (int)(v[k] + .5));
            first += 9;
            memcpy(card+first, label, 9);
        }
        sprintf(label,"       %5d", rec);
        memcpy(card+68,label,12);
        memset(card+80, '\0', 1);
        fprintf(fout, "%s\n", card);
    }
    free(label);
    free(card);
}
void
wr_handvel (vel, time, nvel, rec, fout)
float *vel;
int *time, nvel, rec;
FILE *fout;
{

    float tc, vc;
    int i, k, cv;
    int rm, nst, ndo, end, first;
    char *card, *label;
    static int ipass=0;

    card = (char *)calloc(82, sizeof(char));
    label = (char *)calloc(80, sizeof(char));
    memset(card, ' ',80);
    if(ipass == 0) {
       memcpy(card,"*CALL   DEFINE  CDP     ", 24);
       sprintf(label,"VELDEFN         LINENAME");
       memcpy(card+40, label, 24);
       memset(card+80, '\n', 1);
       fprintf(fout, "%s", card);
     }
     ipass ++;
     ndo = nvel/4; rm = nvel - ndo*4;
     if (ndo > 0 ) {
        memset(card,' ',80);
        sprintf(label,"HANDVEL %8d", rec);
        memcpy(card, label, 16);
        memset(card+80, '\n', 1);
        fprintf(fout, "%s", card);
        nst = -4;
        for (i = 0; i < ndo; i++) {
            nst += 4;
            end = nst + 4; first = -16;
            for (k = nst; k < end; k++) {
                cv = (int)(vel[k] + .5);
                tc = (float)time[k];  vc = cv;
                sprintf(label,"%8.1f%8.1f", tc, vc );
                first = first + 16;
                memcpy(card+first, label, 16);
            }
            memset(card+80, '\n', 1);
            fprintf(fout, "%s", card);
        }
    }
    if(rm > 0) {
        memset(card, ' ', 80);
        nst = nvel - rm; first = -16;
        for (k = nst; k < nvel; k ++) {
            cv = (int)(vel[k] + .5);
            tc = (float)time[k];  vc = cv;
            sprintf(label,"%8.1f%8.1f", tc, vc);
            first += 16;
            memcpy(card+first, label, 16);
        }
        memset(card+80, '\n', 1);
        fprintf(fout, "%s", card);
    }
    free(card);
    free(label);
}
void
wr_tvpairs (vel, time, nvel, rec, fout)
float *vel;
int *time, nvel, rec;
FILE *fout;
{
   float *v;
   int *t, i, cv;

   t = time; v = vel;
   for (i=0; i < nvel; i++) {
     cv = (int)((*v) + .5);
     fprintf(fout,"%d, %d, %d\n", *t, cv, rec);
     v ++; t++;
   }
  
   fprintf(fout,"-1, 0, %d\n",rec);
   /*  ...left out the record to put in the tail...
	fprintf(fout,"-1, 0, %d\n");.............*/
   /*  fprintf(fout,"-1           \n");  */

}
/*
**  Check the type of pick file read.  If the file is..
**    Standard (XSD-like)   -  return 0
**    DISCO HANDVEL format  -  return 1
**    TDFN                  -  return 2
**    T/V/Record triplets   -  return 3
@@    vi3d (0TDFN + 1-nTDFN)-  return 5
**    Unknown               -  return -1
*/
int 
ascertain(s)
char *s;
{
	int k, iret = 0;
    int i, l;
    char *s1, *s2, *s3, *s4, *s5, *s6, *s7, *s8;
    
    s1 = (char *)calloc(15, sizeof(char));
    s2 = (char *)calloc(15, sizeof(char));
    s3 = (char *)calloc(15, sizeof(char));
    s4 = (char *)calloc(15, sizeof(char));
    s5 = (char *)calloc(15, sizeof(char));
    s6 = (char *)calloc(15, sizeof(char));
    s7 = (char *)calloc(15, sizeof(char));
    s8 = (char *)calloc(15, sizeof(char));
    if(strlen(s) > 90) {
     sscanf(s,"%s %s %s %s %s %s %s %s",s1,s2,s3,s4,s5,s6,s7,s8);
      if(!strncmp(s8,"Offset",6)) {
       /* return (4); */
	iret = 4;
	goto RETRN;
      }
      else {
       /* return (-1); */
	iret = -1;
	goto RETRN;
      }
    }
    if(!strncmp(s,"Units",5)) {
	/* return(0); */
	iret = 0;
	goto RETRN;
    }
    if(!strncmp(s,"*C",   2)) {
	/* return(1); */
	iret = 1;
	goto RETRN;
    }
/*.cmam..3-36-96...to allow vi3d format also..*/
    /*if(!strncmp(s+1,"TDFN",4))return(2);*/

    if(!strncmp(s+1,"TDFN",4)) {
	if(!strncmp(s,"0",1)) {
		/* return(5); */
		iret = 5;
		goto RETRN;
	}
	else {
		/* return(2); */
		iret = 2;
		goto RETRN;
	}
    }
/*............................................*/

/*...look for comma separating t/v/r entries..*/
    l = strlen(s);
    for (i=0;i<l;i++)
     if(!strncmp(s+i,",",1)) {
	/* return(3); */
	iret = 3;
	goto RETRN;
     }
/*..allow for t/v/r format without commas separating entries..*/
/* look for nonblank 1 */
    for (i=0; i<l; i++) 
	if(strncmp(s+i, " ", 1)) goto NBLNK1;
	iret = -1;
	goto RETRN;

NBLNK1:	/* look for first blanks */
    k = i;
    for (i=k; i<l; i++)
	if(!strncmp(s+i, " ", 1)) goto BLNK1;
    iret = -1;
    goto RETRN;

BLNK1: /* look for nonblank 2 */
    k = i;
    for (i=0; i<l; i++) 
        if(strncmp(s+i, " ", 1)) goto NBLNK2;
        iret = -1;
        goto RETRN;
NBLNK2: /* look for first blanks */
    k = i;
    for (i=k; i<l; i++)
        if(!strncmp(s+i, " ", 1)) goto BLNK2;
    iret = -1;
    goto RETRN;

BLNK2: /* look for nonblank 3 */
    k = i;
    for (i=0; i<l; i++) 
        if(strncmp(s+i, " ", 1)) goto OK;
        iret = -1;
        goto RETRN;

OK: /* found 3 data values separated by blanks */
    iret = 6;
    
RETRN:
    free(s1);
    free(s2);
    free(s3);
    free(s4);
    free(s5);
    free(s6);
    free(s7);
    free(s8);
    /* return (-1); */
    return (iret);
}
