/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

XtCallbackProc XuNo_More_Help(), XuHelper();
void build_message();
static Widget CreateHelpWindow();
static Widget text=(Widget)NULL, Help_Window=(Widget)NULL;
static Widget selectionBox = (Widget)NULL;


static char *filename;    
static char *help_path;      
static char **version;         
static char **listitems;        
static int  nlistitems;
static Widget Top_Level_Shell = NULL;
static char *Whats_Next_Filename = "NULL";


static char *help_mess[] = {
                    "           ",
                    "Help  {General/Context}:",
                    "  will allow you to browse",
                    "  the menus and/or select a item",
                    "  for more detailed information.",
                    "           ",
                    "How To Use:",
                    "  depress the {Help key} while the",
                    "  cursor is positioned on the object",
                    "  you need help with.",
                    "           ",
                    "Help Index:",
                    "  will display an index of all available",
                    "  help topics for this program version.",
                    "           ",
                    "Version Help:",
                    "  will display the current version",
                    "  of this program and any notes",
                    "  reguarding this version's usage.",
                    "           ",
                    "Keys:",
                    "  will display information about ",
                    "  special KEY usage.",
                    "           ",
                    "Tutorial:",
                    "  will display application tutorial.",
                    "           ",
                    "Windows:",
                    "  will display information about window usage.",
                    "           ",
                  ""};   /* note null string terminatior  */


static XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;


/*   User calls   */

/***********************************************************************/

void XuSet_Help_Shell(w)  /* give help system a parent  */
Widget   w;
{
    Top_Level_Shell = w;
}


void XuSet_Help_Path(path)   /*  set directory path to help test files */
char *path;
{
    help_path = path;
}



void XuSet_Help_Index(list, nlist)   /* set labels and filenames for index */
char **list; /* list of label filename pairs  for list widget */
int  nlist;  /* count of pairs in list   */
{
    listitems = list;
    nlistitems = nlist;
}



void XuSet_Help_Version(verson)  /* set Version text for popup  */
char **verson;
{
    version = verson;
}



void XuSet_Help_Whats_Next(filename)   /* set current traveling help filename */
char *filename;
{
    Whats_Next_Filename = filename;
}



void XuSet_Help(w, filename)   /* add a HELP callback to a widget   */
Widget w;
char *filename;
{
    XtRemoveAllCallbacks(w, XmNhelpCallback );
    XtAddCallback(w, XmNhelpCallback, (XtCallbackProc)XuHelper, filename );
}


/***********************************************************************/


#include <stdarg.h>
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif
#define new_node(type)    ((type *) malloc( sizeof( type ) ))
typedef struct linklist {
   char              *s;
   struct linklist   *next;
} Linklist, *Linklistptr;

static char *concat( char *s1, ... )
{
   va_list       args;
   Linklistptr   firstlink = NULL, link, nextlink;
   char          *s;
   int           sum = 0;


   if (s1 != NULL) {

     va_start( args, s1 );
     s = s1;
     link = firstlink = new_node( Linklist );
     link->s = s;
     link->next = NULL;
     sum += strlen( s );

     while ( (s = va_arg( args, char * )) )  {
       link->next = new_node( Linklist );  /* attach previous link */
       link = link->next;
       link->s = s;
       link->next = NULL;
       sum += strlen( s );
       }
     }

   if( sum > 0 )  {
      s = (char *) calloc( 1, sum + 1 );  /* zero fill new string space */

      for( link = firstlink;  link;  link = nextlink )  {
         (void) strcat( s, link->s );
         nextlink = link->next;
         (void) free( link );  /* chuck this link node */
      }
   } else
      return( (char *)'\0' );

   va_end( args );

   return( s );
}


static XmString str_array_to_xmstr(cs, n)
         char    *cs[];
         int     n;
{
    XmString     xmstr;
    int          i;


    if(n <= 0)
       return (XmStringCreate("",XmSTRING_DEFAULT_CHARSET));

    xmstr = (XmString)NULL;

    for (i=0; i < n; i++)   {
       if (i>0)
          xmstr = XmStringConcat(xmstr, XmStringSeparatorCreate());

       xmstr = XmStringConcat(xmstr,
                              XmStringCreate(cs[i], XmSTRING_DEFAULT_CHARSET));
    }

     return (xmstr);
}



static XmStringTable create_string_table( count, list ) 
        int             count;
        char            *list[];
{
	XmStringTable	string_table;
	unsigned	i, j;

	string_table = (XmStringTable)XtMalloc( (count+1)*sizeof( XmString ) );

	for( i = 0, j=0;  i < count;  i++ ) {
             string_table[j] = XmStringCreateLtoR( list[i*2], XmSTRING_DEFAULT_CHARSET);
             j++;
        }
	string_table[count] = (XmString)0;
	return( string_table );
}



static void free_string_table( table )
	XmStringTable	table;
{
	unsigned	i;
	for( i = 0;  table[i] != 0;  i++ )
		XmStringFree( table[i] );
	XtFree( (char *)table );
}




/*-------------------------------------------------------------
**      OpenFile
**              Open the present file.  Returns 0 if file
**                   exists and open is sucessful.
*/
static
int OpenFile()
{
   struct stat statbuf;         /* Information on a file. */
   int file_length;             /* Length of file.        */
   unsigned char * file_string; /* Contents of file.      */
   char  *mess;
   FILE *fp = NULL;             /* Pointer to open file   */


   if ((fp = fopen(filename, "r")) == NULL) {
        mess = concat("Help file ",filename," not located",NULL);
        build_message(Top_Level_Shell, mess);
        XtFree(mess);
        return(1);
  }

   if (stat(filename, &statbuf) == 0)
         file_length = statbuf.st_size;
   else
         file_length = 3000; /* arbitrary file length */

   /* read the file string */
   file_string = (unsigned char *) XtMalloc((unsigned)file_length+1);
   fread(file_string, sizeof(char), file_length, fp);
   file_string[file_length] = NULL;

   /* close up the file */
   if (fclose(fp) != (int)NULL)
	fprintf(stderr, "Warning: unable to close file.\n");

   /* added the file string to the text widget */
   if(text)XmTextSetString(text, file_string);
   XtFree((char *)file_string);

   return(0);
}




XtCallbackProc
Dismiss_Button(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        XtDestroyWidget(XtParent(w));
}






XtCallbackProc
Selection_Dismiss_Button(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
         XtDestroyWidget(XtParent(w));
         selectionBox = (Widget)NULL;
}





void
build_message(w, mess)
Widget  w;
char  *mess;
{
    Widget      mess_dialog;
    Arg         args[20];
    int         argcnt, i;
    XmString    xmstr[2];

    argcnt = 0;
    xmstr[1]=XmStringCreateLtoR(mess , XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;
    XtSetArg(args[argcnt], XmNokLabelString,
                           (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;

    mess_dialog = XmCreateMessageDialog(w, "Message", args, argcnt);

    XtUnmanageChild(XmMessageBoxGetChild (mess_dialog, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild (mess_dialog, XmDIALOG_HELP_BUTTON));
    XtAddCallback(mess_dialog, XmNokCallback,
	(XtCallbackProc)Dismiss_Button, NULL);
    XtAddCallback(mess_dialog, XmNhelpCallback,
	(XtCallbackProc) XuNo_More_Help, NULL);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtManageChild(mess_dialog);
}




XtCallbackProc
sel_callback(w, client, call)
Widget w;
XtPointer client;
XmSelectionBoxCallbackStruct  *call;
{
char *test;
int i;
Boolean found;

        XmAnyCallbackStruct *acs=(XmAnyCallbackStruct*)call;
        XmStringGetLtoR (call->value, XmSTRING_DEFAULT_CHARSET, &test);
        Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );
        filename = concat(help_path,"/",NULL);
        if(strcmp(test,"Whats_Next")== 0)
                 filename = concat(filename, Whats_Next_Filename, NULL);
           else {
                 i = 0; found = False;
                 while(listitems[i][0] != (char)NULL){
                       if(strcmp(test,&listitems[i][0]) == 0) { 
                          filename = concat(filename, &listitems[i+1][0], NULL);
                          found = True;
                          break;}
                 i+=2;}
                 if(!found)filename = concat(filename, test, NULL);
                 }
        XtFree(test);
        if(OpenFile()==0) XtManageChild(Help_Window);
                    else  {
                           XtDestroyWidget(Help_Window);  
                           Help_Window = NULL;
                           text = NULL;
                          }
}




XtCallbackProc
Help_Dismiss(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        if(XtParent(w) != NULL){
            XtUnmanageChild(XtParent(w));
            XtDestroyWidget(XtParent(w));
            Help_Window = NULL;
            text = NULL;
        }
}



XtCallbackProc
XuNo_More_Help(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
   char *message = {"Sorry no more HELP available."};
   build_message(w, message);
}





/*  create help window  */

static Widget
CreateHelpWindow(parent)
Widget parent;
{
    Arg    	args[12];
    int    	argcnt;
    Widget 	retval,form,frame;
    XmString	xmstr[1];
    Widget	pushButton;

    argcnt = 0;
    retval = form = (Widget)XmCreateFormDialog(parent,"Help Information",args,argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT);  argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)80); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)24); argcnt++;
/*
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAUTOMATIC);  argcnt++;
    XtSetArg(args[argcnt], XmNscrollBarDisplayPolicy, XmAS_NEEDED);  argcnt++;
*/
    text =(Widget)XmCreateScrolledText(form,"",args,argcnt);

    XtManageChild(text);

    argcnt = 0;
    XtSetArg(args[argcnt],XmNbottomAttachment,XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt],XmNtopAttachment,XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt],XmNtopWidget,text); argcnt++;
    XtSetArg(args[argcnt],XmNleftAttachment,XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt],XmNrightAttachment,XmATTACH_FORM); argcnt++;
    pushButton = (Widget)XmCreatePushButton(form,"Dismiss",args,argcnt);
    XtAddCallback(pushButton, XmNactivateCallback,
	(XtCallbackProc)Help_Dismiss, NULL);
    XtAddCallback(text, XmNhelpCallback,
	(XtCallbackProc)XuNo_More_Help, NULL );
    XtAddCallback(pushButton, XmNhelpCallback,
	(XtCallbackProc)XuNo_More_Help, NULL );

    XtManageChild(pushButton);

    return( retval );
}




XtCallbackProc
XuHelp_On_Help(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    Widget      ver;
    Arg         args[2];
    int         argcnt, i;
    XmString    xmstr[2];

    argcnt = 0;
    XtSetArg(args[argcnt], XmNokLabelString,
                           (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;
    for(i=0; help_mess[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr(help_mess, i);
    XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;

    ver = XmCreateMessageDialog(Top_Level_Shell, "Help Facility", args, argcnt);

    XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_HELP_BUTTON));
    XtAddCallback(ver, XmNokCallback, (XtCallbackProc)Dismiss_Button, NULL);
    XtAddCallback(ver, XmNhelpCallback, (XtCallbackProc)XuNo_More_Help, NULL );
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtManageChild(ver);
}





XtCallbackProc
XuHelp_Index(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    Arg         args[12];
    int         argcnt;
    XmString    xmstr[3];
    XmString    *xmstrTable[125];


    if(selectionBox == (Widget)NULL){

    argcnt = 0;
    XtSetArg(args[argcnt], XmNlistLabelString, (xmstr[0]=XmStringCreateLtoR(
                "Help Index",
                 XmSTRING_DEFAULT_CHARSET))); argcnt++;

   XtSetArg(args[argcnt], XmNlistItems,
                (xmstrTable[0]=create_string_table(nlistitems, listitems))); argcnt++;

    XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
    XtSetArg(args[argcnt], XmNlistItemCount, (int)nlistitems); argcnt++;
    XtSetArg(args[argcnt], XmNlistVisibleItemCount, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNdialogType, XmDIALOG_SELECTION); argcnt++;
    XtSetArg(args[argcnt], XmNtextString, (xmstr[1]=XmStringCreateLtoR(
                "Whats_Next",XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNcancelLabelString, (xmstr[2]=XmStringCreateLtoR(
                "Dismiss",XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 220); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 524); argcnt++;
    selectionBox = (Widget)XmCreateSelectionDialog(w, "Help Topic Index",
                                                   args, argcnt);
    XtUnmanageChild((Widget)
	XmSelectionBoxGetChild (selectionBox, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild((Widget)
	XmSelectionBoxGetChild (selectionBox, XmDIALOG_APPLY_BUTTON));
    XtAddCallback(selectionBox, XmNokCallback,
	(XtCallbackProc)sel_callback, NULL);
    XtAddCallback(selectionBox, XmNhelpCallback,
	(XtCallbackProc)XuNo_More_Help, NULL );
    XtAddCallback(selectionBox, XmNcancelCallback,
	(XtCallbackProc)Selection_Dismiss_Button, NULL );

    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );
    XmStringFree( xmstr[2] );
    free_string_table( xmstrTable[0] );

    XtManageChild(selectionBox);

    }

}




XtCallbackProc
XuHelper (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );
        filename = concat(help_path,"/",client,NULL);
        if(OpenFile()==0) XtManageChild(Help_Window);  
                    else  {
                           XtDestroyWidget(Help_Window);
                           Help_Window = NULL;
                           text = NULL;
                          }

}

void
XuDisplay_HelpFile (filnam)
char *filnam;
{
        Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );
        filename = filnam;
        if(OpenFile()==0) XtManageChild(Help_Window);
                    else  {
                           XtDestroyWidget(Help_Window);
                           Help_Window = NULL;
                           text = NULL;
                          }

}


void
XuDisplay_HelpText (helpinfo)
unsigned char *helpinfo;
{
        Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );
        if(text){
                 XmTextSetString(text, helpinfo);
                 XtManageChild(Help_Window);
                }
}




XtCallbackProc
XuHelp_On_Context(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
Widget  This_Widget;
extern Widget  Top_Level_Shell;

    This_Widget = (Widget)NULL;

    This_Widget = XmTrackingLocate(Top_Level_Shell,
                    XCreateFontCursor(XtDisplay(Top_Level_Shell), XC_question_arrow), False);

/*
fprintf(stderr,"Widget selected was %s (%08x)\n",XtName(This_Widget),This_Widget);
*/
    while ( (This_Widget != NULL) &&
     (XtHasCallbacks(This_Widget, XmNhelpCallback) != XtCallbackHasSome)) {
	This_Widget = XtParent(This_Widget);
/*
	if ((debug_mode != 0) && (This_Widget != NULL)) {
	  fprintf(stderr,"checking widget ancestor %s (%08x)\n",
		XtName(This_Widget),This_Widget);
	  }
*/
	}

    if(This_Widget != NULL)XtCallCallbacks(This_Widget, XmNhelpCallback, NULL);
}




XtCallbackProc
XuHelp_On_Version(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    Widget      ver;
    Arg         args[20];
    int         argcnt, i;
    XmString    xmstr[2];

    argcnt = 0;

    for(i=0; version[i][0]  !=  '\0'; i++);
    xmstr[1]  = str_array_to_xmstr(version, i);
    XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;

    XtSetArg(args[argcnt], XmNokLabelString,
                           (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;

    ver = XmCreateMessageDialog(Top_Level_Shell, "Version", args, argcnt);

    XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_HELP_BUTTON));
    XtAddCallback(ver, XmNokCallback, (XtCallbackProc)Dismiss_Button, NULL);
    XtAddCallback(ver, XmNhelpCallback, (XtCallbackProc)XuNo_More_Help, NULL);

    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtManageChild(ver);

}
